/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.asm;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.EnumSet;
import java.util.function.Consumer;
import jdk.graal.compiler.asm.AbstractAddress;
import jdk.graal.compiler.asm.Buffer;
import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.site.Infopoint;

public abstract class Assembler<T extends Enum<T>> {
    private final TargetDescription target;
    Label labelsWithPatches;
    private final Buffer codeBuffer;
    protected Consumer<CodeAnnotation> codePatchingAnnotationConsumer;
    private final EnumSet<T> features;
    private final ArrayDeque<EnumSet<T>> featuresStack;
    private static final String NEWLINE = System.lineSeparator();

    public Assembler(TargetDescription target, EnumSet<T> features) {
        this.target = target;
        this.codeBuffer = new Buffer(target.arch.getByteOrder());
        this.features = features;
        this.featuresStack = new ArrayDeque(1);
    }

    public final EnumSet<T> getFeatures() {
        return this.features;
    }

    public void addFeatures(EnumSet<T> newFeatures) {
        EnumSet<T> added = EnumSet.copyOf(newFeatures);
        added.removeIf(feature -> !this.getFeatures().add(feature));
        this.featuresStack.push(added);
    }

    public void removeFeatures() {
        GraalError.guarantee(!this.featuresStack.isEmpty(), "cannot remove features since no features have been added");
        this.getFeatures().removeAll((Collection)this.featuresStack.pop());
    }

    public boolean isCurrentRegionFeature(T feature) {
        if (this.featuresStack.isEmpty()) {
            return false;
        }
        return this.featuresStack.peek().contains(feature);
    }

    public void setCodePatchingAnnotationConsumer(Consumer<CodeAnnotation> codeAnnotationConsumer) {
        assert (this.codePatchingAnnotationConsumer == null) : "overwriting existing value";
        this.codePatchingAnnotationConsumer = codeAnnotationConsumer;
    }

    public int position() {
        return this.codeBuffer.position();
    }

    public final void emitByte(int x) {
        this.codeBuffer.emitByte(x);
    }

    public final void emitShort(int x) {
        this.codeBuffer.emitShort(x);
    }

    public final void emitInt(int x) {
        this.codeBuffer.emitInt(x);
    }

    public final void emitLong(long x) {
        this.codeBuffer.emitLong(x);
    }

    public final void emitByte(int b, int pos) {
        this.codeBuffer.emitByte(b, pos);
    }

    public final void emitShort(int b, int pos) {
        this.codeBuffer.emitShort(b, pos);
    }

    public final void emitInt(int b, int pos) {
        this.codeBuffer.emitInt(b, pos);
    }

    public final void emitLong(long b, int pos) {
        this.codeBuffer.emitLong(b, pos);
    }

    public final int getByte(int pos) {
        return this.codeBuffer.getByte(pos);
    }

    public final int getShort(int pos) {
        return this.codeBuffer.getShort(pos);
    }

    public final int getInt(int pos) {
        return this.codeBuffer.getInt(pos);
    }

    public final void emitString(String x) {
        this.emitString0("\t");
        this.emitString0(x);
        this.emitString0(NEWLINE);
    }

    public final void emitString0(String x) {
        this.codeBuffer.emitBytes(x.getBytes(), 0, x.length());
    }

    public void emitString(String s, int pos) {
        this.codeBuffer.emitBytes(s.getBytes(), pos);
    }

    public byte[] close(boolean trimmedCopy) {
        this.checkAndClearLabelsWithPatches();
        return this.codeBuffer.close(trimmedCopy);
    }

    public byte[] copy(int start, int end) {
        return this.codeBuffer.copyData(start, end);
    }

    private void checkAndClearLabelsWithPatches() throws InternalError {
        Label label = this.labelsWithPatches;
        while (label != null) {
            if (label.patchPositions != null) {
                throw new GraalError("Label used by instructions at following offsets has not been bound: %s", label.patchPositions);
            }
            Label next = label.nextWithPatches;
            label.nextWithPatches = null;
            label = next;
        }
        this.labelsWithPatches = null;
    }

    public void bind(Label l) {
        assert (!l.isBound()) : "can bind label only once";
        l.bind(this.position(), this);
    }

    public abstract void align(int var1);

    public abstract void halt();

    public abstract void jmp(Label var1);

    protected abstract void patchJumpTarget(int var1, int var2);

    public abstract AbstractAddress makeAddress(int var1, Register var2, int var3);

    public abstract AbstractAddress getPlaceholder(int var1);

    public abstract void ensureUniquePC();

    public void maybeEmitIndirectTargetMarker() {
    }

    public void maybeEmitIndirectTargetMarker(CompilationResultBuilder crb, Label label) {
    }

    public void postCallNop(Infopoint infopoint) {
        this.ensureUniquePC();
    }

    public void reset() {
        this.labelsWithPatches = null;
        this.codeBuffer.reset();
    }

    public boolean isTargetMP() {
        return this.target.isMP;
    }

    public int getReturnAddressSize() {
        return this.target.arch.getReturnAddressSize();
    }

    public int getMachineCodeCallDisplacementOffset() {
        return this.target.arch.getMachineCodeCallDisplacementOffset();
    }

    public boolean inlineObjects() {
        return this.target.inlineObjects;
    }

    public static abstract class CodeAnnotation {
    }
}

