/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.asm.aarch64;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jdk.graal.compiler.asm.aarch64.AArch64Address;
import jdk.graal.compiler.asm.aarch64.AArch64Assembler;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.Stride;
import jdk.graal.compiler.debug.GraalError;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.meta.PlatformKind;

public abstract class AArch64ASIMDAssembler {
    private static final int UBit = 0x20000000;
    private static final int ReplicateFlag = 0x200000;
    private final AArch64Assembler asm;
    private static final int ASIMDSizeOffset = 22;
    private static final int elemSize00 = 0;
    private static final int elemSize01 = 0x400000;
    private static final int elemSize10 = 0x800000;
    private static final int elemSize11 = 0xC00000;

    protected AArch64ASIMDAssembler(AArch64Assembler asm) {
        this.asm = asm;
    }

    protected void emitInt(int x) {
        this.asm.emitInt(x);
    }

    private static boolean usesMultipleLanes(ASIMDSize size, ElementSize eSize) {
        return size != ASIMDSize.HalfReg || eSize != ElementSize.DoubleWord;
    }

    private static boolean assertConsecutiveSIMDRegisters(Register ... regs) {
        int numRegs = AArch64.simdRegisters.size();
        assert (regs[0].getRegisterCategory().equals((Object)AArch64.SIMD)) : regs;
        for (int i = 1; i < regs.length; ++i) {
            assert (regs[i].getRegisterCategory().equals((Object)AArch64.SIMD)) : String.valueOf(regs) + " " + i;
            assert ((regs[i - 1].encoding + 1) % numRegs == regs[i].encoding) : "registers must be consecutive";
        }
        return true;
    }

    private static int elemSizeXX(ElementSize eSize) {
        return eSize.encoding << 22;
    }

    private static int elemSize1X(ElementSize eSize) {
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord) : eSize;
        return (2 | (eSize == ElementSize.DoubleWord ? 1 : 0)) << 22;
    }

    private static int elemSize0X(ElementSize eSize) {
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord) : eSize;
        return (eSize == ElementSize.DoubleWord ? 1 : 0) << 22;
    }

    private static int qBit(boolean isSet) {
        return (isSet ? 1 : 0) << 30;
    }

    private static int qBit(ASIMDSize size) {
        return (size == ASIMDSize.FullReg ? 1 : 0) << 30;
    }

    private static int singleStructureElemSizeEncoding(ASIMDInstruction instr, ElementSize eSize) {
        return (switch (instr.ordinal()) {
            case 12, 13 -> eSize.encoding;
            default -> throw GraalError.shouldNotReachHereUnexpectedValue((Object)instr);
        }) << 10;
    }

    private static int encodeStructureAddress(ASIMDInstruction instr, ASIMDSize size, ElementSize eSize, AArch64Address address) {
        int postIndexEncoding;
        return postIndexEncoding | (switch (address.getAddressingMode()) {
            case AArch64Address.AddressingMode.BASE_REGISTER_ONLY -> {
                postIndexEncoding = 0;
                yield 0;
            }
            case AArch64Address.AddressingMode.REGISTER_STRUCTURE_POST_INDEXED -> {
                postIndexEncoding = 0x800000;
                Register offset = address.getOffset();
                if (!$assertionsDisabled && offset.equals((Object)AArch64.zr)) {
                    throw new AssertionError(offset);
                }
                yield AArch64Assembler.rs2(offset);
            }
            case AArch64Address.AddressingMode.IMMEDIATE_STRUCTURE_POST_INDEXED -> {
                postIndexEncoding = 0x800000;
                Register offset = address.getOffset();
                if (!$assertionsDisabled && !offset.equals((Object)AArch64.zr)) {
                    throw new AssertionError(offset);
                }
                if (!$assertionsDisabled && address.getImmediateRaw() != AArch64Address.determineStructureImmediateValue(instr, size, eSize)) {
                    throw new AssertionError((Object)(String.valueOf(address) + " " + String.valueOf((Object)instr) + " " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize)));
                }
                yield AArch64Assembler.rs2(offset);
            }
            default -> throw GraalError.shouldNotReachHereUnexpectedValue((Object)address.getAddressingMode());
        }) | AArch64Assembler.rn(address.getBase());
    }

    private void loadStoreMultipleStructures(ASIMDInstruction instr, ASIMDSize size, ElementSize eSize, Register value, AArch64Address address) {
        int baseEncoding = 0xC000000;
        int eSizeEncoding = eSize.encoding << 10;
        int addressEncoding = AArch64ASIMDAssembler.encodeStructureAddress(instr, size, eSize, address);
        this.emitInt(instr.encoding | baseEncoding | AArch64ASIMDAssembler.qBit(size) | eSizeEncoding | addressEncoding | AArch64Assembler.rd(value));
    }

    private void loadStoreSingleStructure(ASIMDInstruction instr, ASIMDSize size, ElementSize eSize, Register value, AArch64Address address) {
        int baseEncoding = 0xD000000;
        int eSizeEncoding = AArch64ASIMDAssembler.singleStructureElemSizeEncoding(instr, eSize);
        int addressEncoding = AArch64ASIMDAssembler.encodeStructureAddress(instr, size, eSize, address);
        this.emitInt(instr.encoding | baseEncoding | AArch64ASIMDAssembler.qBit(size) | eSizeEncoding | addressEncoding | AArch64Assembler.rd(value));
    }

    private void cryptographicAES(ASIMDInstruction instr, Register dst, Register src) {
        int baseEncoding = 1311246336;
        this.emitInt(instr.encoding | baseEncoding | 0 | AArch64Assembler.rd(dst) | AArch64Assembler.rn(src));
    }

    private void cryptographicThreeSHA(ASIMDInstruction instr, Register dst, Register src1, Register src2) {
        int baseEncoding = 0x5E000000;
        this.emitInt(instr.encoding | baseEncoding | 0 | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src1) | AArch64Assembler.rs2(src2));
    }

    private void cryptographicTwoSHA(ASIMDInstruction instr, Register dst, Register src) {
        int baseEncoding = 1579681792;
        this.emitInt(instr.encoding | baseEncoding | 0 | AArch64Assembler.rd(dst) | AArch64Assembler.rn(src));
    }

    private void cryptographicThreeSHA512(ASIMDInstruction instr, Register dst, Register src1, Register src2) {
        int baseEncoding = -832536576;
        this.emitInt(instr.encoding | baseEncoding | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src1) | AArch64Assembler.rs2(src2));
    }

    private void cryptographicTwoSHA512(ASIMDInstruction instr, Register dst, Register src) {
        int baseEncoding = -826245120;
        this.emitInt(instr.encoding | baseEncoding | AArch64Assembler.rd(dst) | AArch64Assembler.rn(src));
    }

    private void cryptographicFour(ASIMDInstruction instr, Register dst, Register src1, Register src2, Register src3) {
        int baseEncoding = -838860800;
        this.emitInt(instr.encoding | baseEncoding | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src1) | AArch64Assembler.rs2(src2) | AArch64Assembler.rs3(src3));
    }

    private void scalarThreeSameEncoding(ASIMDInstruction instr, int eSizeEncoding, Register dst, Register src1, Register src2) {
        int baseEncoding = 1579156480;
        this.emitInt(instr.encoding | baseEncoding | eSizeEncoding | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src1) | AArch64Assembler.rs2(src2));
    }

    private void scalarShiftByImmEncoding(ASIMDInstruction instr, int imm7, Register dst, Register src) {
        assert ((imm7 & 0x7F) == imm7) : imm7;
        assert ((imm7 & 0x7F) != 0) : imm7;
        assert ((imm7 & 7) != imm7) : imm7;
        int baseEncoding = 1593836544;
        this.emitInt(instr.encoding | baseEncoding | imm7 << 16 | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src));
    }

    private void tableLookupEncoding(ASIMDInstruction instr, ASIMDSize size, int numTableRegs, Register dst, Register src1, Register src2) {
        int baseEncoding = 0xE000000;
        assert (numTableRegs >= 1 && numTableRegs <= 4) : numTableRegs;
        int numTableRegsEncoding = numTableRegs - 1 << 13;
        this.emitInt(instr.encoding | baseEncoding | AArch64ASIMDAssembler.qBit(size) | numTableRegsEncoding | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src1) | AArch64Assembler.rs2(src2));
    }

    private void permuteEncoding(ASIMDInstruction instr, ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        int baseEncoding = 0xE000800;
        this.emitInt(instr.encoding | baseEncoding | AArch64ASIMDAssembler.qBit(size) | AArch64ASIMDAssembler.elemSizeXX(eSize) | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src1) | AArch64Assembler.rs2(src2));
    }

    private void copyEncoding(ASIMDInstruction instr, boolean setQBit, ElementSize eSize, Register dst, Register src, int index) {
        this.copyEncoding(instr, 0, setQBit, eSize, dst, src, index);
    }

    private void copyEncoding(ASIMDInstruction instr, int extraEncoding, boolean setQBit, ElementSize eSize, Register dst, Register src, int index) {
        assert (index >= 0) : index;
        assert (index < ASIMDSize.FullReg.bytes() / eSize.bytes()) : "index=" + index + " " + String.valueOf((Object)eSize);
        int baseEncoding = 0xE000400;
        int imm5Encoding = (index * 2 * eSize.bytes() | eSize.bytes()) << 16;
        this.emitInt(instr.encoding | extraEncoding | baseEncoding | AArch64ASIMDAssembler.qBit(setQBit) | imm5Encoding | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src));
    }

    private void twoRegMiscEncoding(ASIMDInstruction instr, ASIMDSize size, int eSizeEncoding, Register dst, Register src) {
        this.twoRegMiscEncoding(instr, size == ASIMDSize.FullReg, eSizeEncoding, dst, src);
    }

    private void twoRegMiscEncoding(ASIMDInstruction instr, boolean setQBit, int eSizeEncoding, Register dst, Register src) {
        int baseEncoding = 236980224;
        this.emitInt(instr.encoding | baseEncoding | AArch64ASIMDAssembler.qBit(setQBit) | eSizeEncoding | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src));
    }

    private void acrossLanesEncoding(ASIMDInstruction instr, ASIMDSize size, int eSizeEncoding, Register dst, Register src) {
        int baseEncoding = 238028800;
        this.emitInt(instr.encoding | baseEncoding | AArch64ASIMDAssembler.qBit(size) | eSizeEncoding | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src));
    }

    private void threeDifferentEncoding(ASIMDInstruction instr, boolean setQBit, int eSizeEncoding, Register dst, Register src1, Register src2) {
        int baseEncoding = 0xE200000;
        this.emitInt(instr.encoding | baseEncoding | AArch64ASIMDAssembler.qBit(setQBit) | eSizeEncoding | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src1) | AArch64Assembler.rs2(src2));
    }

    private void threeSameEncoding(ASIMDInstruction instr, ASIMDSize size, int eSizeEncoding, Register dst, Register src1, Register src2) {
        int baseEncoding = 236979200;
        this.emitInt(instr.encoding | baseEncoding | AArch64ASIMDAssembler.qBit(size) | eSizeEncoding | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src1) | AArch64Assembler.rs2(src2));
    }

    private void modifiedImmEncoding(ImmediateOp op, ASIMDSize size, Register dst, long imm) {
        int baseEncoding = 0xF000400;
        int immEncoding = ASIMDImmediateTable.getEncoding(imm, op);
        this.emitInt(baseEncoding | AArch64ASIMDAssembler.qBit(size) | immEncoding | AArch64Assembler.rd(dst));
    }

    private void shiftByImmEncoding(ASIMDInstruction instr, ASIMDSize size, int imm7, Register dst, Register src) {
        this.shiftByImmEncoding(instr, size == ASIMDSize.FullReg, imm7, dst, src);
    }

    private void shiftByImmEncoding(ASIMDInstruction instr, boolean setQBit, int imm7, Register dst, Register src) {
        assert ((imm7 & 0x7F) == imm7) : imm7;
        assert ((imm7 & 0x7F) != 0) : imm7;
        assert ((imm7 & 7) != imm7) : imm7;
        int baseEncoding = 0xF000400;
        this.emitInt(instr.encoding | baseEncoding | AArch64ASIMDAssembler.qBit(setQBit) | imm7 << 16 | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src));
    }

    public void absVV(ASIMDSize size, ElementSize eSize, Register dst, Register src) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        this.twoRegMiscEncoding(ASIMDInstruction.ABS, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src);
    }

    public void addSSS(ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        assert (eSize == ElementSize.DoubleWord) : eSize;
        this.scalarThreeSameEncoding(ASIMDInstruction.ADD, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void addVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        this.threeSameEncoding(ASIMDInstruction.ADD, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void addpVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        this.threeSameEncoding(ASIMDInstruction.ADDP, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void addvSV(ASIMDSize size, ElementSize elementSize, Register dst, Register src) {
        assert (size != ASIMDSize.HalfReg || elementSize != ElementSize.Word) : "Invalid size and lane combination for addv";
        assert (elementSize != ElementSize.DoubleWord) : "Invalid lane width for addv";
        this.acrossLanesEncoding(ASIMDInstruction.ADDV, size, AArch64ASIMDAssembler.elemSizeXX(elementSize), dst, src);
    }

    public void aesd(Register dst, Register src) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        this.cryptographicAES(ASIMDInstruction.AESD, dst, src);
    }

    public void aese(Register dst, Register src) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        this.cryptographicAES(ASIMDInstruction.AESE, dst, src);
    }

    public void aesimc(Register dst, Register src) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        this.cryptographicAES(ASIMDInstruction.AESIMC, dst, src);
    }

    public void aesmc(Register dst, Register src) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        this.cryptographicAES(ASIMDInstruction.AESMC, dst, src);
    }

    public void andVVV(ASIMDSize size, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        this.threeSameEncoding(ASIMDInstruction.AND, size, 0, dst, src1, src2);
    }

    public void bcaxVVVV(Register dst, Register src1, Register src2, Register src3) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        assert (src3.getRegisterCategory().equals((Object)AArch64.SIMD)) : src3;
        this.cryptographicFour(ASIMDInstruction.BCAX, dst, src1, src2, src3);
    }

    public void bicVI(ASIMDSize size, Register dst, long imm) {
        this.modifiedImmEncoding(ImmediateOp.BIC, size, dst, imm);
    }

    public void bicVVV(ASIMDSize size, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        this.threeSameEncoding(ASIMDInstruction.BIC, size, 0x400000, dst, src1, src2);
    }

    public void bifVVV(ASIMDSize size, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        this.threeSameEncoding(ASIMDInstruction.BIF, size, 0xC00000, dst, src1, src2);
    }

    public void bitVVV(ASIMDSize size, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        this.threeSameEncoding(ASIMDInstruction.BIT, size, 0x800000, dst, src1, src2);
    }

    public void bslVVV(ASIMDSize size, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        this.threeSameEncoding(ASIMDInstruction.BSL, size, 0x400000, dst, src1, src2);
    }

    public void cmeqVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        this.threeSameEncoding(ASIMDInstruction.CMEQ, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void cmeqZeroVV(ASIMDSize size, ElementSize eSize, Register dst, Register src) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        this.twoRegMiscEncoding(ASIMDInstruction.CMEQ_ZERO, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src);
    }

    public void cmgeVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        this.threeSameEncoding(ASIMDInstruction.CMGE, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void cmgeZeroVV(ASIMDSize size, ElementSize eSize, Register dst, Register src) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        this.twoRegMiscEncoding(ASIMDInstruction.CMGE_ZERO, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src);
    }

    public void cmgtVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        this.threeSameEncoding(ASIMDInstruction.CMGT, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void cmgtZeroVV(ASIMDSize size, ElementSize eSize, Register dst, Register src) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        this.twoRegMiscEncoding(ASIMDInstruction.CMGT_ZERO, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src);
    }

    public void cmhiVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        this.threeSameEncoding(ASIMDInstruction.CMHI, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void cmhsVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        this.threeSameEncoding(ASIMDInstruction.CMHS, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void cmleZeroVV(ASIMDSize size, ElementSize eSize, Register dst, Register src) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        this.twoRegMiscEncoding(ASIMDInstruction.CMLE_ZERO, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src);
    }

    public void cmltZeroVV(ASIMDSize size, ElementSize eSize, Register dst, Register src) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        this.twoRegMiscEncoding(ASIMDInstruction.CMLT_ZERO, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src);
    }

    public void cmtstVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        this.threeSameEncoding(ASIMDInstruction.CMTST, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void cntVV(ASIMDSize size, Register dst, Register src) {
        this.twoRegMiscEncoding(ASIMDInstruction.CNT, size, 0, dst, src);
    }

    public void dupSX(ElementSize eSize, Register dst, Register src, int index) {
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (index >= 0 && index < ASIMDSize.FullReg.bytes() / eSize.bytes()) : index + " " + String.valueOf((Object)eSize);
        int baseEncoding = 1577059328;
        int imm5Encoding = (index * 2 * eSize.bytes() | eSize.bytes()) << 16;
        this.emitInt(ASIMDInstruction.DUPELEM.encoding | baseEncoding | imm5Encoding | AArch64Assembler.rd(dst) | AArch64Assembler.rn(src));
    }

    public void dupVX(ASIMDSize dstSize, ElementSize eSize, Register dst, Register src, int index) {
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        this.copyEncoding(ASIMDInstruction.DUPELEM, dstSize == ASIMDSize.FullReg, eSize, dst, src, index);
    }

    public void dupVG(ASIMDSize dstSize, ElementSize eSize, Register dst, Register src) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(dstSize, eSize)) : String.valueOf((Object)dstSize) + " " + String.valueOf((Object)eSize);
        assert (src.getRegisterCategory().equals((Object)AArch64.CPU)) : src;
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        this.copyEncoding(ASIMDInstruction.DUPGEN, dstSize == ASIMDSize.FullReg, eSize, dst, src, 0);
    }

    public void eorVVV(ASIMDSize size, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        this.threeSameEncoding(ASIMDInstruction.EOR, size, 0, dst, src1, src2);
    }

    public void eor3VVVV(Register dst, Register src1, Register src2, Register src3) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        assert (src3.getRegisterCategory().equals((Object)AArch64.SIMD)) : src3;
        this.cryptographicFour(ASIMDInstruction.EOR3, dst, src1, src2, src3);
    }

    public void extVVV(ASIMDSize size, Register dst, Register src1, Register src2, int src1LowIdx) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        assert (src1LowIdx >= 0 && src1LowIdx < size.bytes()) : src1LowIdx + " " + String.valueOf((Object)size);
        int baseEncoding = 0x2E000000;
        this.emitInt(ASIMDInstruction.EXT.encoding | baseEncoding | AArch64ASIMDAssembler.qBit(size) | src1LowIdx << 11 | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src1) | AArch64Assembler.rs2(src2));
    }

    public void fabsVV(ASIMDSize size, ElementSize eSize, Register dst, Register src) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord) : eSize;
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        this.twoRegMiscEncoding(ASIMDInstruction.FABS, size, AArch64ASIMDAssembler.elemSize1X(eSize), dst, src);
    }

    public void facgeVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord) : eSize;
        this.threeSameEncoding(ASIMDInstruction.FACGE, size, AArch64ASIMDAssembler.elemSize0X(eSize), dst, src1, src2);
    }

    public void facgtVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord) : eSize;
        this.threeSameEncoding(ASIMDInstruction.FACGT, size, AArch64ASIMDAssembler.elemSize1X(eSize), dst, src1, src2);
    }

    public void facgtSSS(ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord) : eSize;
        this.scalarThreeSameEncoding(ASIMDInstruction.FACGT, AArch64ASIMDAssembler.elemSize1X(eSize), dst, src1, src2);
    }

    public void faddVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord) : eSize;
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        this.threeSameEncoding(ASIMDInstruction.FADD, size, AArch64ASIMDAssembler.elemSize0X(eSize), dst, src1, src2);
    }

    public void fcmeqVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord) : eSize;
        this.threeSameEncoding(ASIMDInstruction.FCMEQ, size, AArch64ASIMDAssembler.elemSize0X(eSize), dst, src1, src2);
    }

    public void fcmeqZeroVV(ASIMDSize size, ElementSize eSize, Register dst, Register src) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord) : eSize;
        this.twoRegMiscEncoding(ASIMDInstruction.FCMEQ_ZERO, size, AArch64ASIMDAssembler.elemSize1X(eSize), dst, src);
    }

    public void fcmgeVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord) : eSize;
        this.threeSameEncoding(ASIMDInstruction.FCMGE, size, AArch64ASIMDAssembler.elemSize0X(eSize), dst, src1, src2);
    }

    public void fcmgeZeroVV(ASIMDSize size, ElementSize eSize, Register dst, Register src) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord) : eSize;
        this.twoRegMiscEncoding(ASIMDInstruction.FCMGE_ZERO, size, AArch64ASIMDAssembler.elemSize1X(eSize), dst, src);
    }

    public void fcmgtVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord) : eSize;
        this.threeSameEncoding(ASIMDInstruction.FCMGT, size, AArch64ASIMDAssembler.elemSize1X(eSize), dst, src1, src2);
    }

    public void fcmgtZeroVV(ASIMDSize size, ElementSize eSize, Register dst, Register src) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord) : eSize;
        this.twoRegMiscEncoding(ASIMDInstruction.FCMGT_ZERO, size, AArch64ASIMDAssembler.elemSize1X(eSize), dst, src);
    }

    public void fcmleZeroVV(ASIMDSize size, ElementSize eSize, Register dst, Register src) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord) : eSize;
        this.twoRegMiscEncoding(ASIMDInstruction.FCMLE_ZERO, size, AArch64ASIMDAssembler.elemSize1X(eSize), dst, src);
    }

    public void fcmltZeroVV(ASIMDSize size, ElementSize eSize, Register dst, Register src) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord) : eSize;
        this.twoRegMiscEncoding(ASIMDInstruction.FCMLT_ZERO, size, AArch64ASIMDAssembler.elemSize1X(eSize), dst, src);
    }

    public void fcvtlVV(ElementSize srcESize, Register dst, Register src) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        assert (srcESize == ElementSize.HalfWord || srcESize == ElementSize.Word) : srcESize;
        this.twoRegMiscEncoding(ASIMDInstruction.FCVTL, false, AArch64ASIMDAssembler.elemSize0X(srcESize), dst, src);
    }

    public void fcvtnVV(ElementSize srcESize, Register dst, Register src) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        assert (srcESize == ElementSize.Word || srcESize == ElementSize.DoubleWord) : srcESize;
        this.twoRegMiscEncoding(ASIMDInstruction.FCVTN, false, AArch64ASIMDAssembler.elemSize0X(srcESize), dst, src);
    }

    public void fcvtzsVV(ASIMDSize size, ElementSize eSize, Register dst, Register src) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord) : eSize;
        this.twoRegMiscEncoding(ASIMDInstruction.FCVTZS, size, AArch64ASIMDAssembler.elemSize1X(eSize), dst, src);
    }

    public void fdivVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord) : eSize;
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        this.threeSameEncoding(ASIMDInstruction.FDIV, size, AArch64ASIMDAssembler.elemSize0X(eSize), dst, src1, src2);
    }

    public void fmaxVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord) : eSize;
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        this.threeSameEncoding(ASIMDInstruction.FMAX, size, AArch64ASIMDAssembler.elemSize0X(eSize), dst, src1, src2);
    }

    public void fminVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord) : eSize;
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        this.threeSameEncoding(ASIMDInstruction.FMIN, size, AArch64ASIMDAssembler.elemSize1X(eSize), dst, src1, src2);
    }

    public void fmlaVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord) : eSize;
        this.threeSameEncoding(ASIMDInstruction.FMLA, size, AArch64ASIMDAssembler.elemSize0X(eSize), dst, src1, src2);
    }

    public void fmlsVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord) : eSize;
        this.threeSameEncoding(ASIMDInstruction.FMLS, size, AArch64ASIMDAssembler.elemSize1X(eSize), dst, src1, src2);
    }

    public void fmovVI(ASIMDSize size, ElementSize eSize, Register dst, long imm64) {
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord) : eSize;
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        ImmediateOp op = eSize == ElementSize.DoubleWord ? ImmediateOp.FMOVDP : ImmediateOp.FMOVSP;
        this.modifiedImmEncoding(op, size, dst, imm64);
    }

    public void fmulVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord) : eSize;
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        this.threeSameEncoding(ASIMDInstruction.FMUL, size, AArch64ASIMDAssembler.elemSize0X(eSize), dst, src1, src2);
    }

    public void fnegVV(ASIMDSize size, ElementSize eSize, Register dst, Register src) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord) : eSize;
        this.twoRegMiscEncoding(ASIMDInstruction.FNEG, size, AArch64ASIMDAssembler.elemSize1X(eSize), dst, src);
    }

    public void fsqrtVV(ASIMDSize size, ElementSize eSize, Register dst, Register src) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord) : eSize;
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        this.twoRegMiscEncoding(ASIMDInstruction.FSQRT, size, AArch64ASIMDAssembler.elemSize1X(eSize), dst, src);
    }

    public void fsubVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord) : eSize;
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        this.threeSameEncoding(ASIMDInstruction.FSUB, size, AArch64ASIMDAssembler.elemSize1X(eSize), dst, src1, src2);
    }

    public void insXX(ElementSize eSize, Register dst, int dstIdx, Register src, int srcIdx) {
        assert (dstIdx >= 0 && dstIdx < ASIMDSize.FullReg.bytes() / eSize.bytes()) : dstIdx + " " + String.valueOf((Object)eSize);
        assert (srcIdx >= 0 && srcIdx < ASIMDSize.FullReg.bytes() / eSize.bytes()) : srcIdx + " " + String.valueOf((Object)eSize);
        int srcIdxEncoding = srcIdx * eSize.bytes() << 11;
        this.copyEncoding(ASIMDInstruction.INSELEM, srcIdxEncoding, true, eSize, dst, src, dstIdx);
    }

    public void insXG(ElementSize eSize, Register dst, int index, Register src) {
        this.copyEncoding(ASIMDInstruction.INSGEN, true, eSize, dst, src, index);
    }

    public void ld1MultipleV(ASIMDSize size, ElementSize eSize, Register dst, AArch64Address addr) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        this.loadStoreMultipleStructures(ASIMDInstruction.LD1_MULTIPLE_1R, size, eSize, dst, addr);
    }

    public void ld1MultipleVV(ASIMDSize size, ElementSize eSize, Register dst1, Register dst2, AArch64Address addr) {
        assert (AArch64ASIMDAssembler.assertConsecutiveSIMDRegisters(dst1, dst2));
        this.loadStoreMultipleStructures(ASIMDInstruction.LD1_MULTIPLE_2R, size, eSize, dst1, addr);
    }

    public void ld1MultipleVVV(ASIMDSize size, ElementSize eSize, Register dst1, Register dst2, Register dst3, AArch64Address addr) {
        assert (AArch64ASIMDAssembler.assertConsecutiveSIMDRegisters(dst1, dst2, dst3));
        this.loadStoreMultipleStructures(ASIMDInstruction.LD1_MULTIPLE_3R, size, eSize, dst1, addr);
    }

    public void ld1MultipleVVVV(ASIMDSize size, ElementSize eSize, Register dst1, Register dst2, Register dst3, Register dst4, AArch64Address addr) {
        assert (AArch64ASIMDAssembler.assertConsecutiveSIMDRegisters(dst1, dst2, dst3, dst4));
        this.loadStoreMultipleStructures(ASIMDInstruction.LD1_MULTIPLE_4R, size, eSize, dst1, addr);
    }

    public void ld1rV(ASIMDSize size, ElementSize eSize, Register dst, AArch64Address addr) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        this.loadStoreSingleStructure(ASIMDInstruction.LD1R, size, eSize, dst, addr);
    }

    public void ld2MultipleVV(ASIMDSize size, ElementSize eSize, Register dst1, Register dst2, AArch64Address addr) {
        assert (AArch64ASIMDAssembler.assertConsecutiveSIMDRegisters(dst1, dst2));
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        this.loadStoreMultipleStructures(ASIMDInstruction.LD2_MULTIPLE_2R, size, eSize, dst1, addr);
    }

    public void ld4MultipleVVVV(ASIMDSize size, ElementSize eSize, Register dst1, Register dst2, Register dst3, Register dst4, AArch64Address addr) {
        assert (AArch64ASIMDAssembler.assertConsecutiveSIMDRegisters(dst1, dst2, dst3, dst4));
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        this.loadStoreMultipleStructures(ASIMDInstruction.LD4_MULTIPLE_4R, size, eSize, dst1, addr);
    }

    public void ld4rVVVV(ASIMDSize size, ElementSize eSize, Register dst1, Register dst2, Register dst3, Register dst4, AArch64Address addr) {
        assert (AArch64ASIMDAssembler.assertConsecutiveSIMDRegisters(dst1, dst2, dst3, dst4));
        this.loadStoreSingleStructure(ASIMDInstruction.LD4R, size, eSize, dst1, addr);
    }

    public void mlaVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        assert (eSize != ElementSize.DoubleWord) : eSize;
        this.threeSameEncoding(ASIMDInstruction.MLA, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void mlsVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        assert (eSize != ElementSize.DoubleWord) : eSize;
        this.threeSameEncoding(ASIMDInstruction.MLS, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void moviVI(ASIMDSize size, Register dst, long imm) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        this.modifiedImmEncoding(ImmediateOp.MOVI, size, dst, imm);
    }

    public void mulVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        assert (eSize != ElementSize.DoubleWord) : eSize;
        this.threeSameEncoding(ASIMDInstruction.MUL, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void mvniVI(ASIMDSize size, Register dst, long imm) {
        this.modifiedImmEncoding(ImmediateOp.MVNI, size, dst, imm);
    }

    public void negVV(ASIMDSize size, ElementSize eSize, Register dst, Register src) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        this.twoRegMiscEncoding(ASIMDInstruction.NEG, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src);
    }

    public void notVV(ASIMDSize size, Register dst, Register src) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        this.twoRegMiscEncoding(ASIMDInstruction.NOT, size, 0, dst, src);
    }

    public void ornVVV(ASIMDSize size, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        this.threeSameEncoding(ASIMDInstruction.ORN, size, 0xC00000, dst, src1, src2);
    }

    public void orrVI(ASIMDSize size, Register dst, long imm) {
        this.modifiedImmEncoding(ImmediateOp.ORR, size, dst, imm);
    }

    public void orrVVV(ASIMDSize size, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        this.threeSameEncoding(ASIMDInstruction.ORR, size, 0x800000, dst, src1, src2);
    }

    public void pmullVVV(ElementSize srcESize, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        assert (srcESize == ElementSize.Byte || srcESize == ElementSize.DoubleWord) : srcESize;
        this.threeDifferentEncoding(ASIMDInstruction.PMULL, false, AArch64ASIMDAssembler.elemSizeXX(srcESize), dst, src1, src2);
    }

    public void pmull2VVV(ElementSize srcESize, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        assert (srcESize == ElementSize.Byte || srcESize == ElementSize.DoubleWord) : srcESize;
        this.threeDifferentEncoding(ASIMDInstruction.PMULL, true, AArch64ASIMDAssembler.elemSizeXX(srcESize), dst, src1, src2);
    }

    public void rax1VVV(Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        this.cryptographicThreeSHA512(ASIMDInstruction.RAX1, dst, src1, src2);
    }

    public void rbitVV(ASIMDSize size, Register dst, Register src) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        this.twoRegMiscEncoding(ASIMDInstruction.RBIT, size, 0x400000, dst, src);
    }

    public void rev16VV(ASIMDSize size, Register dst, Register src) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        this.twoRegMiscEncoding(ASIMDInstruction.REV16, size, 0, dst, src);
    }

    public void rev32VV(ASIMDSize size, ElementSize revGranularity, Register dst, Register src) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        assert (revGranularity == ElementSize.Byte || revGranularity == ElementSize.HalfWord) : revGranularity;
        this.twoRegMiscEncoding(ASIMDInstruction.REV32, size, AArch64ASIMDAssembler.elemSizeXX(revGranularity), dst, src);
    }

    public void rev64VV(ASIMDSize size, ElementSize revGranularity, Register dst, Register src) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        assert (revGranularity != ElementSize.DoubleWord) : revGranularity;
        this.twoRegMiscEncoding(ASIMDInstruction.REV64, size, AArch64ASIMDAssembler.elemSizeXX(revGranularity), dst, src);
    }

    public void saddlvSV(ASIMDSize size, ElementSize elementSize, Register dst, Register src) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        assert (size != ASIMDSize.HalfReg || elementSize != ElementSize.Word) : "Invalid size and lane combination for saddlv";
        assert (elementSize != ElementSize.DoubleWord) : "Invalid lane width for saddlv";
        this.acrossLanesEncoding(ASIMDInstruction.SADDLV, size, AArch64ASIMDAssembler.elemSizeXX(elementSize), dst, src);
    }

    public void scvtfVV(ASIMDSize size, ElementSize eSize, Register dst, Register src) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord) : eSize;
        this.twoRegMiscEncoding(ASIMDInstruction.SCVTF, size, AArch64ASIMDAssembler.elemSize0X(eSize), dst, src);
    }

    public void sha1c(Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        this.cryptographicThreeSHA(ASIMDInstruction.SHA1C, dst, src1, src2);
    }

    public void sha1h(Register dst, Register src) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        this.cryptographicTwoSHA(ASIMDInstruction.SHA1H, dst, src);
    }

    public void sha1m(Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        this.cryptographicThreeSHA(ASIMDInstruction.SHA1M, dst, src1, src2);
    }

    public void sha1p(Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        this.cryptographicThreeSHA(ASIMDInstruction.SHA1P, dst, src1, src2);
    }

    public void sha1su0(Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        this.cryptographicThreeSHA(ASIMDInstruction.SHA1SU0, dst, src1, src2);
    }

    public void sha1su1(Register dst, Register src) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        this.cryptographicTwoSHA(ASIMDInstruction.SHA1SU1, dst, src);
    }

    public void sha256h2(Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        this.cryptographicThreeSHA(ASIMDInstruction.SHA256H2, dst, src1, src2);
    }

    public void sha256h(Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        this.cryptographicThreeSHA(ASIMDInstruction.SHA256H, dst, src1, src2);
    }

    public void sha256su0(Register dst, Register src) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        this.cryptographicTwoSHA(ASIMDInstruction.SHA256SU0, dst, src);
    }

    public void sha256su1(Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        this.cryptographicThreeSHA(ASIMDInstruction.SHA256SU1, dst, src1, src2);
    }

    public void sha512h(Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        this.cryptographicThreeSHA512(ASIMDInstruction.SHA512H, dst, src1, src2);
    }

    public void sha512h2(Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        this.cryptographicThreeSHA512(ASIMDInstruction.SHA512H2, dst, src1, src2);
    }

    public void sha512su0(Register dst, Register src) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        this.cryptographicTwoSHA512(ASIMDInstruction.SHA512SU0, dst, src);
    }

    public void sha512su1(Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        this.cryptographicThreeSHA512(ASIMDInstruction.SHA512SU1, dst, src1, src2);
    }

    public void shlVVI(ASIMDSize size, ElementSize eSize, Register dst, Register src, int shiftAmt) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        assert (shiftAmt >= 0 && shiftAmt < eSize.nbits) : shiftAmt + " " + String.valueOf((Object)eSize);
        int imm7 = eSize.nbits + shiftAmt;
        this.shiftByImmEncoding(ASIMDInstruction.SHL, size, imm7, dst, src);
    }

    public void smaxVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        assert (eSize != ElementSize.DoubleWord) : "Invalid lane width for smax";
        this.threeSameEncoding(ASIMDInstruction.SMAX, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void sminVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        assert (eSize != ElementSize.DoubleWord) : "Invalid lane width for smin";
        this.threeSameEncoding(ASIMDInstruction.SMIN, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void sminpVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        assert (eSize != ElementSize.DoubleWord) : "Invalid lane width for sminp";
        this.threeSameEncoding(ASIMDInstruction.SMINP, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void smlalVVV(ElementSize srcESize, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        assert (srcESize != ElementSize.DoubleWord) : srcESize;
        this.threeDifferentEncoding(ASIMDInstruction.SMLAL, false, AArch64ASIMDAssembler.elemSizeXX(srcESize), dst, src1, src2);
    }

    public void smlslVVV(ElementSize srcESize, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        assert (srcESize != ElementSize.DoubleWord) : srcESize;
        this.threeDifferentEncoding(ASIMDInstruction.SMLSL, false, AArch64ASIMDAssembler.elemSizeXX(srcESize), dst, src1, src2);
    }

    public void smovGX(ElementSize dstESize, ElementSize srcESize, Register dst, Register src, int index) {
        assert (srcESize != ElementSize.DoubleWord) : srcESize;
        assert (dstESize == ElementSize.Word || dstESize == ElementSize.DoubleWord) : dstESize;
        assert (srcESize.nbits < dstESize.nbits) : "the target size must be larger than the source size";
        assert (dst.getRegisterCategory().equals((Object)AArch64.CPU)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        this.copyEncoding(ASIMDInstruction.SMOV, dstESize == ElementSize.DoubleWord, srcESize, dst, src, index);
    }

    public void sshlVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        this.threeSameEncoding(ASIMDInstruction.SSHL, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void sshllVVI(ElementSize srcESize, Register dst, Register src, int shiftAmt) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        assert (srcESize != ElementSize.DoubleWord) : srcESize;
        assert (shiftAmt >= 0 && shiftAmt < srcESize.nbits) : shiftAmt + " " + String.valueOf((Object)srcESize);
        int imm7 = srcESize.nbits + shiftAmt;
        this.shiftByImmEncoding(ASIMDInstruction.SSHLL, false, imm7, dst, src);
    }

    public void sshll2VVI(ElementSize srcESize, Register dst, Register src, int shiftAmt) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        assert (srcESize != ElementSize.DoubleWord) : srcESize;
        assert (shiftAmt >= 0 && shiftAmt < srcESize.nbits) : shiftAmt + " " + String.valueOf((Object)srcESize);
        int imm7 = srcESize.nbits + shiftAmt;
        this.shiftByImmEncoding(ASIMDInstruction.SSHLL, true, imm7, dst, src);
    }

    public void sshrVVI(ASIMDSize size, ElementSize eSize, Register dst, Register src, int shiftAmt) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        assert (shiftAmt > 0 && shiftAmt <= eSize.nbits) : shiftAmt + " " + String.valueOf((Object)eSize);
        int imm7 = eSize.nbits * 2 - shiftAmt;
        this.shiftByImmEncoding(ASIMDInstruction.SSHR, size, imm7, dst, src);
    }

    public void ssublVVV(ElementSize srcESize, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        assert (srcESize != ElementSize.DoubleWord) : srcESize;
        this.threeDifferentEncoding(ASIMDInstruction.SSUBL, false, AArch64ASIMDAssembler.elemSizeXX(srcESize), dst, src1, src2);
    }

    public void ssubl2VVV(ElementSize srcESize, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        assert (srcESize != ElementSize.DoubleWord) : srcESize;
        this.threeDifferentEncoding(ASIMDInstruction.SSUBL, true, AArch64ASIMDAssembler.elemSizeXX(srcESize), dst, src1, src2);
    }

    public void st1MultipleV(ASIMDSize size, ElementSize eSize, Register src, AArch64Address addr) {
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        this.loadStoreMultipleStructures(ASIMDInstruction.ST1_MULTIPLE_1R, size, eSize, src, addr);
    }

    public void st1MultipleVV(ASIMDSize size, ElementSize eSize, Register src1, Register src2, AArch64Address addr) {
        assert (AArch64ASIMDAssembler.assertConsecutiveSIMDRegisters(src1, src2));
        this.loadStoreMultipleStructures(ASIMDInstruction.ST1_MULTIPLE_2R, size, eSize, src1, addr);
    }

    public void st1MultipleVVV(ASIMDSize size, ElementSize eSize, Register src1, Register src2, Register src3, AArch64Address addr) {
        assert (AArch64ASIMDAssembler.assertConsecutiveSIMDRegisters(src1, src2, src3));
        this.loadStoreMultipleStructures(ASIMDInstruction.ST1_MULTIPLE_3R, size, eSize, src1, addr);
    }

    public void st1MultipleVVVV(ASIMDSize size, ElementSize eSize, Register src1, Register src2, Register src3, Register src4, AArch64Address addr) {
        assert (AArch64ASIMDAssembler.assertConsecutiveSIMDRegisters(src1, src2, src3, src4));
        this.loadStoreMultipleStructures(ASIMDInstruction.ST1_MULTIPLE_4R, size, eSize, src1, addr);
    }

    public void st2MultipleVV(ASIMDSize size, ElementSize eSize, Register src1, Register src2, AArch64Address addr) {
        assert (AArch64ASIMDAssembler.assertConsecutiveSIMDRegisters(src1, src2));
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        this.loadStoreMultipleStructures(ASIMDInstruction.ST2_MULTIPLE_2R, size, eSize, src1, addr);
    }

    public void st4MultipleVVVV(ASIMDSize size, ElementSize eSize, Register src1, Register src2, Register src3, Register src4, AArch64Address addr) {
        assert (AArch64ASIMDAssembler.assertConsecutiveSIMDRegisters(src1, src2, src3, src4));
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        this.loadStoreMultipleStructures(ASIMDInstruction.ST4_MULTIPLE_4R, size, eSize, src1, addr);
    }

    public void subSSS(ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        assert (eSize == ElementSize.DoubleWord) : eSize;
        this.scalarThreeSameEncoding(ASIMDInstruction.SUB, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void subVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        this.threeSameEncoding(ASIMDInstruction.SUB, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void tblVVV(ASIMDSize size, Register dst, Register table, Register index) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (table.getRegisterCategory().equals((Object)AArch64.SIMD)) : table;
        assert (index.getRegisterCategory().equals((Object)AArch64.SIMD)) : index;
        this.tableLookupEncoding(ASIMDInstruction.TBL, size, 1, dst, table, index);
    }

    public void tblVVVV(ASIMDSize size, Register dst, Register table1, Register table2, Register index) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (AArch64ASIMDAssembler.assertConsecutiveSIMDRegisters(table1, table2));
        assert (index.getRegisterCategory().equals((Object)AArch64.SIMD)) : index;
        this.tableLookupEncoding(ASIMDInstruction.TBL, size, 2, dst, table1, index);
    }

    public void tbxVVV(ASIMDSize size, Register dst, Register table, Register index) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (table.getRegisterCategory().equals((Object)AArch64.SIMD)) : table;
        assert (index.getRegisterCategory().equals((Object)AArch64.SIMD)) : index;
        this.tableLookupEncoding(ASIMDInstruction.TBX, size, 1, dst, table, index);
    }

    public void trn1VVV(ASIMDSize dstSize, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        assert (AArch64ASIMDAssembler.usesMultipleLanes(dstSize, eSize)) : String.valueOf((Object)dstSize) + " " + String.valueOf((Object)eSize);
        this.permuteEncoding(ASIMDInstruction.TRN1, dstSize, eSize, dst, src1, src2);
    }

    public void trn2VVV(ASIMDSize dstSize, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        assert (AArch64ASIMDAssembler.usesMultipleLanes(dstSize, eSize)) : String.valueOf((Object)dstSize) + " " + String.valueOf((Object)eSize);
        this.permuteEncoding(ASIMDInstruction.TRN2, dstSize, eSize, dst, src1, src2);
    }

    public void uaddlvSV(ASIMDSize size, ElementSize elementSize, Register dst, Register src) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        assert (size != ASIMDSize.HalfReg || elementSize != ElementSize.Word) : "Invalid size and lane combination for uaddlv";
        assert (elementSize != ElementSize.DoubleWord) : "Invalid lane width for uaddlv " + String.valueOf((Object)elementSize);
        this.acrossLanesEncoding(ASIMDInstruction.UADDLV, size, AArch64ASIMDAssembler.elemSizeXX(elementSize), dst, src);
    }

    public void umaxVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        assert (eSize != ElementSize.DoubleWord) : "Invalid lane width for umax " + String.valueOf((Object)eSize);
        this.threeSameEncoding(ASIMDInstruction.UMAX, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void umaxpVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        assert (eSize != ElementSize.DoubleWord) : "Invalid lane width for umaxp";
        this.threeSameEncoding(ASIMDInstruction.UMAXP, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void umaxvSV(ASIMDSize size, ElementSize elementSize, Register dst, Register src) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        assert (size != ASIMDSize.HalfReg || elementSize != ElementSize.Word) : "Invalid size and lane combination for umaxv";
        assert (elementSize != ElementSize.DoubleWord) : "Invalid lane width for umaxv";
        this.acrossLanesEncoding(ASIMDInstruction.UMAXV, size, AArch64ASIMDAssembler.elemSizeXX(elementSize), dst, src);
    }

    public void uminVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        assert (eSize != ElementSize.DoubleWord) : "Invalid lane width for umin";
        this.threeSameEncoding(ASIMDInstruction.UMIN, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void uminpVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        assert (eSize != ElementSize.DoubleWord) : "Invalid lane width for uminp";
        this.threeSameEncoding(ASIMDInstruction.UMINP, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void uminvSV(ASIMDSize size, ElementSize elementSize, Register dst, Register src) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        assert (size != ASIMDSize.HalfReg || elementSize != ElementSize.Word) : "Invalid size and lane combination for uminv";
        assert (elementSize != ElementSize.DoubleWord) : "Invalid lane width for uminv";
        this.acrossLanesEncoding(ASIMDInstruction.UMINV, size, AArch64ASIMDAssembler.elemSizeXX(elementSize), dst, src);
    }

    public void umlalVVV(ElementSize srcESize, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        assert (srcESize != ElementSize.DoubleWord) : srcESize;
        this.threeDifferentEncoding(ASIMDInstruction.UMLAL, false, AArch64ASIMDAssembler.elemSizeXX(srcESize), dst, src1, src2);
    }

    public void umlslVVV(ElementSize srcESize, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        assert (srcESize != ElementSize.DoubleWord) : srcESize;
        this.threeDifferentEncoding(ASIMDInstruction.UMLSL, false, AArch64ASIMDAssembler.elemSizeXX(srcESize), dst, src1, src2);
    }

    public void umovGX(ElementSize eSize, Register dst, Register src, int index) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.CPU)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        this.copyEncoding(ASIMDInstruction.UMOV, eSize == ElementSize.DoubleWord, eSize, dst, src, index);
    }

    public void ushlVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        this.threeSameEncoding(ASIMDInstruction.USHL, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void ushllVVI(ElementSize srcESize, Register dst, Register src, int shiftAmt) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        assert (srcESize != ElementSize.DoubleWord) : srcESize;
        assert (shiftAmt >= 0 && shiftAmt < srcESize.nbits) : shiftAmt + " " + String.valueOf((Object)srcESize);
        int imm7 = srcESize.nbits + shiftAmt;
        this.shiftByImmEncoding(ASIMDInstruction.USHLL, false, imm7, dst, src);
    }

    public void ushll2VVI(ElementSize srcESize, Register dst, Register src, int shiftAmt) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        assert (srcESize != ElementSize.DoubleWord) : srcESize;
        assert (shiftAmt >= 0 && shiftAmt < srcESize.nbits) : shiftAmt + " " + String.valueOf((Object)srcESize);
        int imm7 = srcESize.nbits + shiftAmt;
        this.shiftByImmEncoding(ASIMDInstruction.USHLL, true, imm7, dst, src);
    }

    public void ushrSSI(ElementSize eSize, Register dst, Register src, int shiftAmt) {
        assert (eSize == ElementSize.DoubleWord) : eSize;
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        assert (shiftAmt > 0 && shiftAmt <= eSize.nbits) : shiftAmt + " " + String.valueOf((Object)eSize);
        int imm7 = eSize.nbits * 2 - shiftAmt;
        this.scalarShiftByImmEncoding(ASIMDInstruction.USHR, imm7, dst, src);
    }

    public void ushrVVI(ASIMDSize size, ElementSize eSize, Register dst, Register src, int shiftAmt) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        assert (shiftAmt > 0 && shiftAmt <= eSize.nbits) : shiftAmt + " " + String.valueOf((Object)eSize);
        int imm7 = eSize.nbits * 2 - shiftAmt;
        this.shiftByImmEncoding(ASIMDInstruction.USHR, size, imm7, dst, src);
    }

    public void usraVVI(ASIMDSize size, ElementSize eSize, Register dst, Register src, int shiftAmt) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize)) : "Must use multiple lanes " + String.valueOf((Object)size) + " " + String.valueOf((Object)eSize);
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        assert (shiftAmt > 0 && shiftAmt <= eSize.nbits) : shiftAmt + " " + String.valueOf((Object)eSize);
        int imm7 = eSize.nbits * 2 - shiftAmt;
        this.shiftByImmEncoding(ASIMDInstruction.USRA, size, imm7, dst, src);
    }

    public void usublVVV(ElementSize srcESize, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        assert (srcESize != ElementSize.DoubleWord) : srcESize;
        this.threeDifferentEncoding(ASIMDInstruction.USUBL, false, AArch64ASIMDAssembler.elemSizeXX(srcESize), dst, src1, src2);
    }

    public void usubl2VVV(ElementSize srcESize, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        assert (srcESize != ElementSize.DoubleWord) : srcESize;
        this.threeDifferentEncoding(ASIMDInstruction.USUBL, true, AArch64ASIMDAssembler.elemSizeXX(srcESize), dst, src1, src2);
    }

    public void uzp1VVV(ASIMDSize dstSize, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        assert (AArch64ASIMDAssembler.usesMultipleLanes(dstSize, eSize)) : String.valueOf((Object)dstSize) + " " + String.valueOf((Object)eSize);
        this.permuteEncoding(ASIMDInstruction.UZP1, dstSize, eSize, dst, src1, src2);
    }

    public void uzp2VVV(ASIMDSize dstSize, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        assert (AArch64ASIMDAssembler.usesMultipleLanes(dstSize, eSize)) : String.valueOf((Object)dstSize) + " " + String.valueOf((Object)eSize);
        this.permuteEncoding(ASIMDInstruction.UZP2, dstSize, eSize, dst, src1, src2);
    }

    public void xarVVVI(Register dst, Register src1, Register src2, int imm6) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        assert (NumUtil.isUnsignedNbit(6, imm6)) : imm6;
        int baseEncoding = -830472192;
        this.emitInt(baseEncoding | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src1) | AArch64Assembler.rs2(src2) | imm6 << 10);
    }

    public void xtnVV(ElementSize dstESize, Register dst, Register src) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        assert (dstESize != ElementSize.DoubleWord) : dstESize;
        this.twoRegMiscEncoding(ASIMDInstruction.XTN, false, AArch64ASIMDAssembler.elemSizeXX(dstESize), dst, src);
    }

    public void xtn2VV(ElementSize dstESize, Register dst, Register src) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD)) : src;
        assert (dstESize != ElementSize.DoubleWord) : dstESize;
        this.twoRegMiscEncoding(ASIMDInstruction.XTN, true, AArch64ASIMDAssembler.elemSizeXX(dstESize), dst, src);
    }

    public void zip1VVV(ASIMDSize dstSize, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        assert (AArch64ASIMDAssembler.usesMultipleLanes(dstSize, eSize)) : String.valueOf((Object)dstSize) + " " + String.valueOf((Object)eSize);
        this.permuteEncoding(ASIMDInstruction.ZIP1, dstSize, eSize, dst, src1, src2);
    }

    public void zip2VVV(ASIMDSize dstSize, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD)) : dst;
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD)) : src1;
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD)) : src2;
        assert (AArch64ASIMDAssembler.usesMultipleLanes(dstSize, eSize)) : String.valueOf((Object)dstSize) + " " + String.valueOf((Object)eSize);
        this.permuteEncoding(ASIMDInstruction.ZIP2, dstSize, eSize, dst, src1, src2);
    }

    public static final class ASIMDSize
    extends Enum<ASIMDSize> {
        public static final /* enum */ ASIMDSize HalfReg = new ASIMDSize(64);
        public static final /* enum */ ASIMDSize FullReg = new ASIMDSize(128);
        private final int nbits;
        private static final /* synthetic */ ASIMDSize[] $VALUES;

        public static ASIMDSize[] values() {
            return (ASIMDSize[])$VALUES.clone();
        }

        public static ASIMDSize valueOf(String name) {
            return Enum.valueOf(ASIMDSize.class, name);
        }

        private ASIMDSize(int nbits) {
            this.nbits = nbits;
        }

        public int bits() {
            return this.nbits;
        }

        public int bytes() {
            return this.nbits / 8;
        }

        public static ASIMDSize fromVectorKind(PlatformKind kind) {
            assert (kind instanceof AArch64Kind) : kind;
            assert (kind.getVectorLength() > 1) : kind;
            int bitSize = kind.getSizeInBytes() * 8;
            assert (bitSize == 32 || bitSize == 64 || bitSize == 128) : bitSize;
            return bitSize == 128 ? FullReg : HalfReg;
        }

        private static /* synthetic */ ASIMDSize[] $values() {
            return new ASIMDSize[]{HalfReg, FullReg};
        }

        static {
            $VALUES = ASIMDSize.$values();
        }
    }

    public static enum ElementSize {
        Byte(0, 8),
        HalfWord(1, 16),
        Word(2, 32),
        DoubleWord(3, 64);

        private final int encoding;
        private final int nbits;

        private ElementSize(int encoding, int nbits) {
            this.encoding = encoding;
            this.nbits = nbits;
        }

        public int bits() {
            return this.nbits;
        }

        public int bytes() {
            return this.nbits / 8;
        }

        public static ElementSize fromKind(PlatformKind kind) {
            switch (((AArch64Kind)kind).getScalar()) {
                case BYTE: {
                    return Byte;
                }
                case WORD: {
                    return HalfWord;
                }
                case DWORD: 
                case SINGLE: {
                    return Word;
                }
                case QWORD: 
                case DOUBLE: {
                    return DoubleWord;
                }
            }
            throw GraalError.shouldNotReachHereUnexpectedValue(((AArch64Kind)kind).getScalar());
        }

        public static ElementSize fromSize(int size) {
            switch (size) {
                case 8: {
                    return Byte;
                }
                case 16: {
                    return HalfWord;
                }
                case 32: {
                    return Word;
                }
                case 64: {
                    return DoubleWord;
                }
            }
            throw GraalError.shouldNotReachHere("Invalid ASIMD element size.");
        }

        public static ElementSize fromStride(Stride stride) {
            switch (stride) {
                case S1: {
                    return Byte;
                }
                case S2: {
                    return HalfWord;
                }
                case S4: {
                    return Word;
                }
                case S8: {
                    return DoubleWord;
                }
            }
            throw GraalError.shouldNotReachHereUnexpectedValue((Object)stride);
        }

        public ElementSize expand() {
            return ElementSize.fromSize(this.nbits * 2);
        }

        public ElementSize narrow() {
            return ElementSize.fromSize(this.nbits / 2);
        }
    }

    public static enum ASIMDInstruction {
        ST4_MULTIPLE_4R(0),
        ST1_MULTIPLE_4R(8192),
        ST1_MULTIPLE_3R(24576),
        ST1_MULTIPLE_1R(28672),
        ST2_MULTIPLE_2R(32768),
        ST1_MULTIPLE_2R(40960),
        LD4_MULTIPLE_4R(0x400000),
        LD1_MULTIPLE_4R(0x402000),
        LD1_MULTIPLE_3R(0x406000),
        LD1_MULTIPLE_1R(0x407000),
        LD2_MULTIPLE_2R(0x408000),
        LD1_MULTIPLE_2R(0x40A000),
        LD1R(0x40C000),
        LD4R(0x60E000),
        AESE(16384),
        AESD(20480),
        AESMC(24576),
        AESIMC(28672),
        SHA1C(0),
        SHA1P(4096),
        SHA1M(8192),
        SHA1SU0(12288),
        SHA256H(16384),
        SHA256H2(20480),
        SHA256SU1(24576),
        SHA1H(0),
        SHA1SU1(4096),
        SHA256SU0(8192),
        SHA512H(0),
        SHA512H2(1024),
        SHA512SU1(2048),
        RAX1(3072),
        SHA512SU0(0),
        EOR3(0),
        BCAX(0x200000),
        TBL(0),
        TBX(4096),
        UZP1(4096),
        TRN1(8192),
        ZIP1(12288),
        UZP2(20480),
        TRN2(24576),
        ZIP2(28672),
        EXT(0),
        DUPELEM(0),
        DUPGEN(2048),
        INSGEN(6144),
        SMOV(10240),
        UMOV(14336),
        INSELEM(0x20000000),
        REV64(0),
        REV16(4096),
        CNT(20480),
        CMGT_ZERO(32768),
        CMEQ_ZERO(36864),
        CMLT_ZERO(40960),
        ABS(45056),
        XTN(73728),
        FCVTN(90112),
        FCVTL(94208),
        SCVTF(118784),
        FCMGT_ZERO(49152),
        FCMEQ_ZERO(53248),
        FCMLT_ZERO(57344),
        FABS(61440),
        FCVTZS(110592),
        REV32(0x20000000),
        CMGE_ZERO(0x20008000),
        CMLE_ZERO(0x20009000),
        NEG(0x2000B000),
        NOT(0x20005000),
        RBIT(0x20005000),
        FCMGE_ZERO(0x2000C000),
        FCMLE_ZERO(0x2000D000),
        FNEG(0x2000F000),
        FSQRT(536997888),
        SADDLV(12288),
        ADDV(110592),
        UADDLV(0x20003000),
        UMAXV(0x2000A000),
        UMINV(536977408),
        SSUBL(8192),
        SMLAL(32768),
        SMLSL(40960),
        PMULL(57344),
        USUBL(0x20002000),
        UMLAL(0x20008000),
        UMLSL(0x2000A000),
        CMGT(12288),
        CMGE(14336),
        SSHL(16384),
        SMAX(24576),
        SMIN(26624),
        SMINP(43008),
        ADD(32768),
        CMTST(34816),
        MLA(36864),
        MUL(38912),
        ADDP(47104),
        FMLA(51200),
        FADD(53248),
        FCMEQ(57344),
        FMAX(61440),
        AND(6144),
        BIC(6144),
        FMLS(51200),
        FSUB(53248),
        FMIN(61440),
        ORR(6144),
        ORN(6144),
        CMHI(0x20003000),
        CMHS(536885248),
        USHL(0x20004000),
        UMAX(0x20006000),
        UMAXP(0x2000A000),
        UMIN(536897536),
        UMINP(536913920),
        SUB(0x20008000),
        CMEQ(0x20008800),
        MLS(0x20009000),
        FMUL(536926208),
        FCMGE(0x2000E000),
        FACGE(536930304),
        FDIV(536934400),
        EOR(536877056),
        BSL(536877056),
        BIT(536877056),
        BIF(536877056),
        FCMGT(0x2000E000),
        FACGT(536930304),
        SSHR(0),
        SHL(20480),
        SSHLL(40960),
        USHR(0x20000000),
        USRA(0x20001000),
        USHLL(0x2000A000);

        public final int encoding;

        private ASIMDInstruction(int encoding) {
            this.encoding = encoding;
        }
    }

    public static class ASIMDImmediateTable {
        private static final int ImmediateOpOffset = 29;
        private static final int ImmediateCmodeOffset = 12;
        private static final int ImmediateABCOffset = 16;
        private static final int ImmediateDEFGHOffset = 5;
        public static final ImmediateEncodings[] IMMEDIATE_TABLE = ASIMDImmediateTable.buildImmediateTable();

        public static boolean isEncodable(long imm, ImmediateOp op) {
            int pos = Arrays.binarySearch(IMMEDIATE_TABLE, ImmediateEncodings.createRepresentativeEncoding(imm));
            if (pos < 0) {
                return false;
            }
            ImmediateEncodings immediate = IMMEDIATE_TABLE[pos];
            for (byte cmodeOpEncoding : ImmediateOp.getCmodeOpEncodings(op)) {
                if (!immediate.validEncoding[cmodeOpEncoding]) continue;
                return true;
            }
            return false;
        }

        public static int getEncoding(long imm, ImmediateOp op) {
            assert (ASIMDImmediateTable.isEncodable(imm, op));
            int pos = Arrays.binarySearch(IMMEDIATE_TABLE, ImmediateEncodings.createRepresentativeEncoding(imm));
            ImmediateEncodings immediate = IMMEDIATE_TABLE[pos];
            for (byte cmodeOpEncoding : ImmediateOp.getCmodeOpEncodings(op)) {
                if (!immediate.validEncoding[cmodeOpEncoding]) continue;
                int imm8Encoding = ASIMDImmediateTable.getImm8Encoding(immediate.imm8[cmodeOpEncoding]);
                int opBit = cmodeOpEncoding & 1;
                int cmodeBits = cmodeOpEncoding >> 1 & 0xF;
                return imm8Encoding | opBit << 29 | cmodeBits << 12;
            }
            throw GraalError.shouldNotReachHere("Unable to encode immediate");
        }

        private static int getImm8Encoding(byte imm8) {
            int encoding = (imm8 >>> 5 & 7) << 16 | (imm8 & 0x1F) << 5;
            return encoding;
        }

        private static long[] asBitArray(long imm8) {
            long[] bitArray = new long[8];
            long remaining = imm8;
            for (int i = 0; i < 8; ++i) {
                bitArray[i] = remaining & 1L;
                remaining >>= 1;
            }
            return bitArray;
        }

        private static int getCmodeOpEncoding(int cmodeBits3to1, int cmodeBit0, int op) {
            int encoding = cmodeBits3to1 << 2 | cmodeBit0 << 1 | op;
            return encoding;
        }

        private static long replicateBit(long bit, int repeatNum) {
            if (bit == 0L) {
                return 0L;
            }
            assert (bit == 1L) : bit;
            return (1L << repeatNum) - 1L;
        }

        private static long notBit(long bit) {
            if (bit == 0L) {
                return 1L;
            }
            assert (bit == 1L) : bit;
            return 0L;
        }

        private static void registerImmediate(Map<Long, ImmediateEncodings> immediateMap, long imm64, long imm8, int cmodeBits3to1, BitValues cmodeBit0, BitValues op) {
            immediateMap.compute(imm64, (k, v) -> v == null ? new ImmediateEncodings((long)k, (byte)imm8, cmodeBits3to1, cmodeBit0, op) : v.addEncoding(imm64, (byte)imm8, cmodeBits3to1, cmodeBit0, op));
        }

        private static ImmediateEncodings[] buildImmediateTable() {
            HashMap<Long, ImmediateEncodings> immediateMap = new HashMap<Long, ImmediateEncodings>();
            for (long imm8 = 0L; imm8 < 256L; ++imm8) {
                long imm64 = imm8 << 32 | imm8;
                ASIMDImmediateTable.registerImmediate(immediateMap, imm64, imm8, 0, BitValues.ANY, BitValues.ANY);
                imm64 = imm8 << 40 | imm8 << 8;
                ASIMDImmediateTable.registerImmediate(immediateMap, imm64, imm8, 1, BitValues.ANY, BitValues.ANY);
                imm64 = imm8 << 48 | imm8 << 16;
                ASIMDImmediateTable.registerImmediate(immediateMap, imm64, imm8, 2, BitValues.ANY, BitValues.ANY);
                imm64 = imm8 << 56 | imm8 << 24;
                ASIMDImmediateTable.registerImmediate(immediateMap, imm64, imm8, 3, BitValues.ANY, BitValues.ANY);
                imm64 = imm8 << 48 | imm8 << 32 | imm8 << 16 | imm8;
                ASIMDImmediateTable.registerImmediate(immediateMap, imm64, imm8, 4, BitValues.ANY, BitValues.ANY);
                imm64 = imm8 << 56 | imm8 << 40 | imm8 << 24 | imm8 << 8;
                ASIMDImmediateTable.registerImmediate(immediateMap, imm64, imm8, 5, BitValues.ANY, BitValues.ANY);
                imm64 = imm8 << 40 | 0xFF00000000L | imm8 << 8 | 0xFFL;
                ASIMDImmediateTable.registerImmediate(immediateMap, imm64, imm8, 6, BitValues.ZERO, BitValues.ANY);
                imm64 = imm8 << 48 | 0xFFFF00000000L | imm8 << 16 | 0xFFFFL;
                ASIMDImmediateTable.registerImmediate(immediateMap, imm64, imm8, 6, BitValues.ONE, BitValues.ANY);
                long[] bitArray = ASIMDImmediateTable.asBitArray(imm8);
                imm64 = imm8 << 56 | imm8 << 48 | imm8 << 40 | imm8 << 32 | imm8 << 24 | imm8 << 16 | imm8 << 8 | imm8;
                ASIMDImmediateTable.registerImmediate(immediateMap, imm64, imm8, 7, BitValues.ZERO, BitValues.ZERO);
                imm64 = ASIMDImmediateTable.replicateBit(bitArray[7], 8) << 56 | ASIMDImmediateTable.replicateBit(bitArray[6], 8) << 48 | ASIMDImmediateTable.replicateBit(bitArray[5], 8) << 40 | ASIMDImmediateTable.replicateBit(bitArray[4], 8) << 32 | ASIMDImmediateTable.replicateBit(bitArray[3], 8) << 24 | ASIMDImmediateTable.replicateBit(bitArray[2], 8) << 16 | ASIMDImmediateTable.replicateBit(bitArray[1], 8) << 8 | ASIMDImmediateTable.replicateBit(bitArray[0], 8);
                ASIMDImmediateTable.registerImmediate(immediateMap, imm64, imm8, 7, BitValues.ZERO, BitValues.ONE);
                long imm32 = bitArray[7] << 31 | ASIMDImmediateTable.notBit(bitArray[6]) << 30 | ASIMDImmediateTable.replicateBit(bitArray[6], 5) << 25 | (imm8 & 0x3FL) << 19;
                imm64 = imm32 << 32 | imm32;
                ASIMDImmediateTable.registerImmediate(immediateMap, imm64, imm8, 7, BitValues.ONE, BitValues.ZERO);
                imm64 = bitArray[7] << 63 | ASIMDImmediateTable.notBit(bitArray[6]) << 62 | ASIMDImmediateTable.replicateBit(bitArray[6], 8) << 54 | (imm8 & 0x3FL) << 48;
                ASIMDImmediateTable.registerImmediate(immediateMap, imm64, imm8, 7, BitValues.ONE, BitValues.ONE);
            }
            Object[] table = immediateMap.values().toArray(new ImmediateEncodings[0]);
            Arrays.sort(table);
            return table;
        }

        private static final class ImmediateEncodings
        implements Comparable<ImmediateEncodings> {
            public final long imm;
            private final boolean[] validEncoding;
            private final byte[] imm8;

            private ImmediateEncodings(long imm) {
                this.imm = imm;
                this.validEncoding = null;
                this.imm8 = null;
            }

            public static ImmediateEncodings createRepresentativeEncoding(long imm) {
                return new ImmediateEncodings(imm);
            }

            ImmediateEncodings(long imm, byte imm8Val, int cmodeBits3to1, BitValues cmodeBit0, BitValues op) {
                this.imm = imm;
                this.validEncoding = new boolean[32];
                this.imm8 = new byte[32];
                for (int bit0 : cmodeBit0.values) {
                    for (int opBit : op.values) {
                        int cmodeOpEncoding = ASIMDImmediateTable.getCmodeOpEncoding(cmodeBits3to1, bit0, opBit);
                        assert (!this.validEncoding[cmodeOpEncoding]);
                        this.validEncoding[cmodeOpEncoding] = true;
                        this.imm8[cmodeOpEncoding] = imm8Val;
                    }
                }
            }

            public ImmediateEncodings addEncoding(long imm64, byte imm8Val, int cmodeBits3to1, BitValues cmodeBit0, BitValues op) {
                assert (imm64 == this.imm) : imm64 + " " + this.imm;
                for (int bit0 : cmodeBit0.values) {
                    for (int opBit : op.values) {
                        int cmodeOpEncoding = ASIMDImmediateTable.getCmodeOpEncoding(cmodeBits3to1, bit0, opBit);
                        assert (!this.validEncoding[cmodeOpEncoding]);
                        this.validEncoding[cmodeOpEncoding] = true;
                        this.imm8[cmodeOpEncoding] = imm8Val;
                    }
                }
                return this;
            }

            @Override
            public int compareTo(ImmediateEncodings o) {
                return Long.compare(this.imm, o.imm);
            }
        }

        public static enum BitValues {
            ZERO(0),
            ONE(1),
            ANY(0, 1);

            final int[] values;

            private BitValues(int ... values) {
                this.values = values;
            }
        }
    }

    public static enum ImmediateOp {
        MOVI,
        MVNI,
        ORR,
        BIC,
        FMOVSP,
        FMOVDP;

        private static byte[] moviEncodings;
        private static byte[] mvniEncodings;
        private static byte[] orrEncodings;
        private static byte[] bicEncodings;
        private static byte[] fmovSPEncodings;
        private static byte[] fmovDPEncodings;

        public static byte[] getCmodeOpEncodings(ImmediateOp op) {
            switch (op.ordinal()) {
                case 0: {
                    return moviEncodings;
                }
                case 1: {
                    return mvniEncodings;
                }
                case 2: {
                    return orrEncodings;
                }
                case 3: {
                    return bicEncodings;
                }
                case 4: {
                    return fmovSPEncodings;
                }
                case 5: {
                    return fmovDPEncodings;
                }
            }
            throw GraalError.shouldNotReachHereUnexpectedValue((Object)op);
        }

        static {
            moviEncodings = new byte[]{0, 4, 8, 12, 16, 20, 24, 26, 28, 29, 30};
            mvniEncodings = new byte[]{1, 5, 9, 13, 17, 21, 25, 27};
            orrEncodings = new byte[]{2, 6, 10, 14, 18, 22};
            bicEncodings = new byte[]{3, 7, 11, 15, 19, 23};
            fmovSPEncodings = new byte[]{30};
            fmovDPEncodings = new byte[]{31};
        }
    }
}

