/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.asm.aarch64;

import jdk.graal.compiler.asm.AbstractAddress;
import jdk.graal.compiler.asm.aarch64.AArch64ASIMDAssembler;
import jdk.graal.compiler.asm.aarch64.AArch64Assembler;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Register;

public final class AArch64Address
extends AbstractAddress {
    public static final int ANY_SIZE = -1;
    public static final AArch64Address PLACEHOLDER = AArch64Address.createPCLiteralAddress(-1);
    private final int bitMemoryTransferSize;
    private final Register base;
    private final Register offset;
    private final int immediate;
    private final boolean registerOffsetScaled;
    private final AArch64Assembler.ExtendType extendType;
    private final AddressingMode addressingMode;

    public static AArch64Address createAddress(int bitMemoryTransferSize, AddressingMode addressingMode, Register base, Register offset, int immediate, boolean registerOffsetScaled, AArch64Assembler.ExtendType extendType) {
        return new AArch64Address(bitMemoryTransferSize, base, offset, immediate, registerOffsetScaled, extendType, addressingMode);
    }

    private static boolean isValidSize(int bitMemoryTransferSize, AddressingMode mode) {
        switch (mode.ordinal()) {
            case 0: 
            case 1: 
            case 6: 
            case 7: {
                return bitMemoryTransferSize == 8 || bitMemoryTransferSize == 16 || bitMemoryTransferSize == 32 || bitMemoryTransferSize == 64 || bitMemoryTransferSize == 128;
            }
            case 8: 
            case 9: 
            case 10: {
                return bitMemoryTransferSize == 32 || bitMemoryTransferSize == 64 || bitMemoryTransferSize == 128;
            }
        }
        throw GraalError.shouldNotReachHereUnexpectedValue((Object)mode);
    }

    private static boolean immediateFitsInInstruction(AddressingMode mode, int immediate) {
        switch (mode.ordinal()) {
            case 1: 
            case 6: 
            case 7: {
                return NumUtil.isSignedNbit(9, immediate);
            }
            case 0: {
                return NumUtil.isUnsignedNbit(12, immediate);
            }
            case 8: 
            case 9: 
            case 10: {
                return NumUtil.isSignedNbit(7, immediate);
            }
        }
        throw GraalError.shouldNotReachHereUnexpectedValue((Object)mode);
    }

    public static boolean isImmediateScaled(AddressingMode mode) {
        switch (mode.ordinal()) {
            case 0: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    public static boolean isOffsetAligned(int bitMemoryTransferSize, long offset) {
        assert (bitMemoryTransferSize == 8 || bitMemoryTransferSize == 16 || bitMemoryTransferSize == 32 || bitMemoryTransferSize == 64 || bitMemoryTransferSize == 128) : bitMemoryTransferSize;
        int mask = bitMemoryTransferSize / 8 - 1;
        return (offset & (long)mask) == 0L;
    }

    private static int getScaledImmediate(int bitMemoryTransferSize, int immediate) {
        if (!AArch64Address.isOffsetAligned(bitMemoryTransferSize, immediate)) {
            return Integer.MAX_VALUE;
        }
        return immediate / (bitMemoryTransferSize / 8);
    }

    public static AArch64Address createImmediateAddress(int bitMemoryTransferSize, AddressingMode addressingMode, Register base, int immediate) {
        GraalError.guarantee(AArch64Address.isValidImmediateAddress(bitMemoryTransferSize, addressingMode, immediate), "provided immediate cannot be encoded in instruction");
        boolean isScaled = AArch64Address.isImmediateScaled(addressingMode);
        int absoluteImm = immediate;
        if (isScaled) {
            absoluteImm = AArch64Address.getScaledImmediate(bitMemoryTransferSize, immediate);
        }
        return new AArch64Address(bitMemoryTransferSize, base, AArch64.zr, absoluteImm, false, null, addressingMode);
    }

    public static boolean isValidImmediateAddress(int bitMemoryTransferSize, AddressingMode addressingMode, int immediate) {
        assert (AArch64Address.isValidSize(bitMemoryTransferSize, addressingMode)) : "invalid transfer size";
        int absoluteImm = immediate;
        if (AArch64Address.isImmediateScaled(addressingMode) && (absoluteImm = AArch64Address.getScaledImmediate(bitMemoryTransferSize, immediate)) == Integer.MAX_VALUE) {
            return false;
        }
        return AArch64Address.immediateFitsInInstruction(addressingMode, absoluteImm);
    }

    public static AArch64Address createBaseRegisterOnlyAddress(int bitMemoryTransferSize, Register base) {
        return AArch64Address.createRegisterOffsetAddress(bitMemoryTransferSize, base, AArch64.zr, false);
    }

    public static AArch64Address createRegisterOffsetAddress(int bitMemoryTransferSize, Register base, Register offset, boolean scaled) {
        return new AArch64Address(bitMemoryTransferSize, base, offset, 0, scaled, null, AddressingMode.REGISTER_OFFSET);
    }

    public static AArch64Address createExtendedRegisterOffsetAddress(int bitMemoryTransferSize, Register base, Register offset, boolean scaled, AArch64Assembler.ExtendType extendType) {
        return new AArch64Address(bitMemoryTransferSize, base, offset, 0, scaled, extendType, AddressingMode.EXTENDED_REGISTER_OFFSET);
    }

    public static AArch64Address createPCLiteralAddress(int bitMemoryTransferSize) {
        return new AArch64Address(bitMemoryTransferSize, AArch64.zr, AArch64.zr, 0, false, null, AddressingMode.PC_LITERAL);
    }

    public static AArch64Address createPairBaseRegisterOnlyAddress(int bitMemoryTransferSize, Register base) {
        return AArch64Address.createImmediateAddress(bitMemoryTransferSize, AddressingMode.IMMEDIATE_PAIR_SIGNED_SCALED, base, 0);
    }

    public static AArch64Address createStructureNoOffsetAddress(Register base) {
        return new AArch64Address(-1, base, AArch64.zr, 0, false, null, AddressingMode.BASE_REGISTER_ONLY);
    }

    public static AArch64Address createStructureRegisterPostIndexAddress(Register base, Register offset) {
        return new AArch64Address(-1, base, offset, 0, false, null, AddressingMode.REGISTER_STRUCTURE_POST_INDEXED);
    }

    static int determineStructureImmediateValue(AArch64ASIMDAssembler.ASIMDInstruction instruction, AArch64ASIMDAssembler.ASIMDSize size, AArch64ASIMDAssembler.ElementSize eSize) {
        int regByteSize = size.bytes();
        int eByteSize = eSize.bytes();
        switch (instruction) {
            case LD1R: {
                return eByteSize;
            }
            case ST1_MULTIPLE_1R: 
            case LD1_MULTIPLE_1R: {
                return regByteSize;
            }
            case ST1_MULTIPLE_2R: 
            case ST2_MULTIPLE_2R: 
            case LD1_MULTIPLE_2R: 
            case LD2_MULTIPLE_2R: {
                return regByteSize * 2;
            }
            case ST1_MULTIPLE_3R: 
            case LD1_MULTIPLE_3R: {
                return regByteSize * 3;
            }
            case ST1_MULTIPLE_4R: 
            case ST4_MULTIPLE_4R: 
            case LD1_MULTIPLE_4R: 
            case LD4_MULTIPLE_4R: {
                return regByteSize * 4;
            }
        }
        throw GraalError.shouldNotReachHereUnexpectedValue((Object)instruction);
    }

    public static AArch64Address createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction instruction, AArch64ASIMDAssembler.ASIMDSize size, AArch64ASIMDAssembler.ElementSize eSize, Register base, int immediate) {
        int expectedImmediate = AArch64Address.determineStructureImmediateValue(instruction, size, eSize);
        GraalError.guarantee(expectedImmediate == immediate, "provided immediate cannot be encoded in instruction.");
        return new AArch64Address(-1, base, AArch64.zr, immediate, false, null, AddressingMode.IMMEDIATE_STRUCTURE_POST_INDEXED);
    }

    private AArch64Address(int bitMemoryTransferSize, Register base, Register offset, int immediate, boolean registerOffsetScaled, AArch64Assembler.ExtendType extendType, AddressingMode addressingMode) {
        this.bitMemoryTransferSize = bitMemoryTransferSize;
        this.base = base;
        this.offset = offset;
        this.addressingMode = (addressingMode == AddressingMode.REGISTER_OFFSET || addressingMode == AddressingMode.EXTENDED_REGISTER_OFFSET) && offset.equals((Object)AArch64.zr) ? AddressingMode.BASE_REGISTER_ONLY : addressingMode;
        this.immediate = immediate;
        this.registerOffsetScaled = registerOffsetScaled;
        this.extendType = extendType;
        assert (this.verify());
    }

    private boolean verify() {
        assert (this.bitMemoryTransferSize == -1 || this.bitMemoryTransferSize == 8 || this.bitMemoryTransferSize == 16 || this.bitMemoryTransferSize == 32 || this.bitMemoryTransferSize == 64 || this.bitMemoryTransferSize == 128) : this.bitMemoryTransferSize;
        assert (this.addressingMode != null);
        assert (this.base.getRegisterCategory().equals((Object)AArch64.CPU));
        assert (this.offset.getRegisterCategory().equals((Object)AArch64.CPU));
        switch (this.addressingMode.ordinal()) {
            case 0: {
                assert (this.bitMemoryTransferSize != -1) : this.bitMemoryTransferSize;
                assert (!this.base.equals((Object)AArch64.zr));
                assert (this.offset.equals((Object)AArch64.zr));
                assert (this.extendType == null);
                assert (NumUtil.isUnsignedNbit(12, this.immediate));
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                assert (!this.base.equals((Object)AArch64.zr));
                assert (this.offset.equals((Object)AArch64.zr));
                assert (this.extendType == null);
                assert (NumUtil.isSignedNbit(9, this.immediate));
                break;
            }
            case 2: {
                assert (!this.base.equals((Object)AArch64.zr));
                assert (this.offset.equals((Object)AArch64.zr));
                assert (this.extendType == null);
                assert (this.immediate == 0) : this.immediate;
                break;
            }
            case 3: {
                assert (!this.registerOffsetScaled || this.bitMemoryTransferSize != -1) : this.registerOffsetScaled + " " + this.bitMemoryTransferSize;
                assert (!this.base.equals((Object)AArch64.zr));
                assert (!this.base.equals((Object)this.offset));
                assert (this.extendType == null);
                assert (this.immediate == 0) : this.immediate;
                break;
            }
            case 4: {
                assert (!this.registerOffsetScaled || this.bitMemoryTransferSize != -1) : this.registerOffsetScaled + " " + this.bitMemoryTransferSize;
                assert (!this.base.equals((Object)AArch64.zr));
                assert (!this.base.equals((Object)this.offset));
                assert (this.extendType == AArch64Assembler.ExtendType.SXTW || this.extendType == AArch64Assembler.ExtendType.UXTW) : Assertions.errorMessage(new Object[]{this.extendType});
                assert (this.immediate == 0) : this.immediate;
                break;
            }
            case 5: {
                assert (this.base.equals((Object)AArch64.zr));
                assert (this.offset.equals((Object)AArch64.zr));
                assert (this.extendType == null);
                assert (NumUtil.isSignedNbit(21, this.immediate)) : this.immediate;
                assert ((this.immediate & 3) == 0) : this.immediate;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                assert (this.bitMemoryTransferSize != -1) : this.bitMemoryTransferSize;
                assert (!this.base.equals((Object)AArch64.zr));
                assert (this.offset.equals((Object)AArch64.zr));
                assert (this.extendType == null);
                assert (NumUtil.isSignedNbit(7, this.immediate)) : this.immediate;
                break;
            }
            case 11: {
                assert (!this.registerOffsetScaled);
                assert (!this.base.equals((Object)AArch64.zr));
                assert (!this.offset.equals((Object)AArch64.sp) && !this.offset.equals((Object)AArch64.zr)) : this.offset;
                assert (this.extendType == null);
                break;
            }
            case 12: {
                assert (!this.base.equals((Object)AArch64.zr));
                assert (this.offset.equals((Object)AArch64.zr));
                assert (this.extendType == null);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHereUnexpectedValue((Object)this.addressingMode);
            }
        }
        return true;
    }

    public int getBitMemoryTransferSize() {
        return this.bitMemoryTransferSize;
    }

    public Register getBase() {
        return this.base;
    }

    public Register getOffset() {
        return this.offset;
    }

    public int getImmediate() {
        switch (this.addressingMode.ordinal()) {
            case 1: 
            case 6: 
            case 7: {
                assert (NumUtil.isSignedNbit(9, this.immediate));
                return this.immediate & NumUtil.getNbitNumberInt(9);
            }
            case 0: {
                assert (NumUtil.isUnsignedNbit(12, this.immediate));
                return this.immediate;
            }
            case 8: 
            case 9: 
            case 10: {
                assert (NumUtil.isSignedNbit(7, this.immediate));
                return this.immediate & NumUtil.getNbitNumberInt(7);
            }
            case 5: {
                assert (NumUtil.isSignedNbit(19, this.immediate >> 2));
                return this.immediate >> 2 & NumUtil.getNbitNumberInt(19);
            }
        }
        throw GraalError.shouldNotReachHere("Should only be called for addressing modes that use immediate values.");
    }

    public int getImmediateRaw() {
        switch (this.addressingMode.ordinal()) {
            case 0: 
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                return this.immediate;
            }
        }
        throw GraalError.shouldNotReachHere("Should only be called for addressing modes that use immediate values.");
    }

    public boolean isRegisterOffsetScaled() {
        return this.registerOffsetScaled;
    }

    public AArch64Assembler.ExtendType getExtendType() {
        return this.extendType;
    }

    public AddressingMode getAddressingMode() {
        return this.addressingMode;
    }

    public boolean isBaseRegisterOnly() {
        switch (this.getAddressingMode().ordinal()) {
            case 0: 
            case 1: {
                return this.immediate == 0;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        String transferSize = this.bitMemoryTransferSize == -1 ? "(unknown)" : Integer.toString(AArch64Assembler.getLog2TransferSize(this.bitMemoryTransferSize));
        return String.format("%s: %s", this.addressingMode.toString(), switch (this.addressingMode.ordinal()) {
            case 0, 8 -> String.format("[X%d, %d << %s]", this.base.encoding, this.immediate, transferSize);
            case 1 -> String.format("[X%d, %d]", this.base.encoding, this.immediate);
            case 2 -> String.format("[X%d]", this.base.encoding);
            case 4 -> {
                if (this.registerOffsetScaled) {
                    yield String.format("[X%d, W%d, %s << %s]", this.base.encoding, this.offset.encoding, this.extendType.name(), transferSize);
                }
                yield String.format("[X%d, W%d, %s]", this.base.encoding, this.offset.encoding, this.extendType.name());
            }
            case 3 -> {
                if (this.registerOffsetScaled) {
                    yield String.format("[X%d, X%d, LSL %s]", this.base.encoding, this.offset.encoding, transferSize);
                }
                yield String.format("[X%d, X%d]", this.base.encoding, this.offset.encoding);
            }
            case 5 -> String.format(".%s%d", this.immediate >= 0 ? "+" : "", this.immediate);
            case 6, 12 -> String.format("[X%d], %d", this.base.encoding, this.immediate);
            case 7 -> String.format("[X%d, %d]!", this.base.encoding, this.immediate);
            case 9 -> String.format("[X%d], %d << %s", this.base.encoding, this.immediate, transferSize);
            case 10 -> String.format("[X%d, %d << %s]!", this.base.encoding, this.immediate, transferSize);
            case 11 -> String.format("[X%d], X%d", this.base.encoding, this.offset.encoding);
            default -> throw GraalError.shouldNotReachHereUnexpectedValue((Object)this.addressingMode);
        });
    }

    public static enum AddressingMode {
        IMMEDIATE_UNSIGNED_SCALED,
        IMMEDIATE_SIGNED_UNSCALED,
        BASE_REGISTER_ONLY,
        REGISTER_OFFSET,
        EXTENDED_REGISTER_OFFSET,
        PC_LITERAL,
        IMMEDIATE_POST_INDEXED,
        IMMEDIATE_PRE_INDEXED,
        IMMEDIATE_PAIR_SIGNED_SCALED,
        IMMEDIATE_PAIR_POST_INDEXED,
        IMMEDIATE_PAIR_PRE_INDEXED,
        REGISTER_STRUCTURE_POST_INDEXED,
        IMMEDIATE_STRUCTURE_POST_INDEXED;

    }
}

