/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.asm.amd64;

import java.util.EnumSet;
import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64BaseAssembler;
import jdk.graal.compiler.asm.amd64.AVXKind;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.Stride;
import jdk.graal.compiler.core.common.calc.Condition;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.TargetDescription;

public class AMD64Assembler
extends AMD64BaseAssembler {
    private final boolean useBranchesWithin32ByteBoundary;
    protected static final int P_0F = 15;
    protected static final int P_0F38 = 14351;
    protected static final int P_0F3A = 14863;
    private static final UnionRegisterCategory CPU_OR_MASK = new UnionRegisterCategory("CPU_OR_MASK", AMD64.CPU, AMD64.MASK);
    public static final int JCC_ERRATUM_MITIGATION_BOUNDARY = 32;
    public static final int OPCODE_IN_BYTES = 1;
    public static final int MODRM_IN_BYTES = 1;

    public AMD64Assembler(TargetDescription target) {
        super(target);
        this.useBranchesWithin32ByteBoundary = false;
    }

    public AMD64Assembler(TargetDescription target, OptionValues optionValues) {
        super(target);
        this.useBranchesWithin32ByteBoundary = Options.UseBranchesWithin32ByteBoundary.getValue(optionValues);
    }

    public AMD64Assembler(TargetDescription target, OptionValues optionValues, boolean hasIntelJccErratum) {
        super(target);
        this.useBranchesWithin32ByteBoundary = Options.UseBranchesWithin32ByteBoundary.hasBeenSet(optionValues) ? Options.UseBranchesWithin32ByteBoundary.getValue(optionValues) : hasIntelJccErratum;
    }

    private static boolean categoryContains(Register.RegisterCategory category, Register register) {
        return register.getRegisterCategory().equals((Object)category) || category instanceof UnionRegisterCategory && ((UnionRegisterCategory)category).contains(register);
    }

    public final void emit(VexRMOp op, Register dst, Register src, AVXKind.AVXSize size) {
        op.emit(this, size, dst, src);
    }

    public final void emit(VexRMOp op, Register dst, AMD64Address src, AVXKind.AVXSize size) {
        op.emit(this, size, dst, src);
    }

    public final void emit(VexRMIOp op, Register dst, Register src, int imm8, AVXKind.AVXSize size) {
        op.emit(this, size, dst, src, imm8);
    }

    public final void emit(VexMRIOp op, Register dst, Register src, int imm8, AVXKind.AVXSize size) {
        op.emit(this, size, dst, src, imm8);
    }

    public final void emit(VexRVMOp op, Register dst, Register src1, Register src2, AVXKind.AVXSize size) {
        op.emit(this, size, dst, src1, src2);
    }

    public final void emit(VexGeneralPurposeRMVOp op, Register dst, Register src1, Register src2, AVXKind.AVXSize size) {
        op.emit(this, size, dst, src1, src2);
    }

    public final void addl(AMD64Address dst, int imm32) {
        AMD64BinaryArithmetic.ADD.getMIOpcode(AMD64BaseAssembler.OperandSize.DWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm32);
    }

    public final void addl(Register dst, int imm32) {
        AMD64BinaryArithmetic.ADD.getMIOpcode(AMD64BaseAssembler.OperandSize.DWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm32);
    }

    public final void addl(Register dst, Register src) {
        AMD64BinaryArithmetic.ADD.rmOp.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void addl(Register dst, AMD64Address src) {
        AMD64BinaryArithmetic.ADD.rmOp.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void adcl(Register dst, int imm32) {
        AMD64BinaryArithmetic.ADC.getMIOpcode(AMD64BaseAssembler.OperandSize.DWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm32);
    }

    public final void addpd(Register dst, Register src) {
        SSEOp.ADD.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void addpd(Register dst, AMD64Address src) {
        SSEOp.ADD.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void addsd(Register dst, Register src) {
        SSEOp.ADD.emit(this, AMD64BaseAssembler.OperandSize.SD, dst, src);
    }

    public final void addsd(Register dst, AMD64Address src) {
        SSEOp.ADD.emit(this, AMD64BaseAssembler.OperandSize.SD, dst, src);
    }

    private void addrNop4() {
        this.emitByte(15);
        this.emitByte(31);
        this.emitByte(64);
        this.emitByte(0);
    }

    private void addrNop5() {
        this.emitByte(15);
        this.emitByte(31);
        this.emitByte(68);
        this.emitByte(0);
        this.emitByte(0);
    }

    private void addrNop7() {
        this.emitByte(15);
        this.emitByte(31);
        this.emitByte(128);
        this.emitInt(0);
    }

    private void addrNop8() {
        this.emitByte(15);
        this.emitByte(31);
        this.emitByte(132);
        this.emitByte(0);
        this.emitInt(0);
    }

    public final void andl(Register dst, int imm32) {
        AMD64BinaryArithmetic.AND.getMIOpcode(AMD64BaseAssembler.OperandSize.DWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm32);
    }

    public final void andl(Register dst, Register src) {
        AMD64BinaryArithmetic.AND.rmOp.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void mull(Register src) {
        AMD64MOp.MUL.emit(this, AMD64BaseAssembler.OperandSize.DWORD, src);
    }

    public final void andpd(Register dst, Register src) {
        SSEOp.AND.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void andpd(Register dst, AMD64Address src) {
        SSEOp.AND.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void bsfq(Register dst, Register src) {
        this.prefixq(dst, src);
        this.emitByte(15);
        this.emitByte(188);
        this.emitModRM(dst, src);
    }

    public final void bsrl(Register dst, Register src) {
        this.prefix(dst, src);
        this.emitByte(15);
        this.emitByte(189);
        this.emitModRM(dst, src);
    }

    public final void popcntl(Register dst, Register src) {
        AMD64RMOp.POPCNT.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void bswapl(Register reg) {
        this.prefix(reg);
        this.emitByte(15);
        this.emitModRM(1, reg);
    }

    public final void cdql() {
        this.emitByte(153);
    }

    public final void cmovl(ConditionFlag cc, Register dst, Register src) {
        this.prefix(dst, src);
        this.emitByte(15);
        this.emitByte(0x40 | cc.getValue());
        this.emitModRM(dst, src);
    }

    public final void cmovl(ConditionFlag cc, Register dst, AMD64Address src) {
        this.prefix(src, dst);
        this.emitByte(15);
        this.emitByte(0x40 | cc.getValue());
        this.emitOperandHelper(dst, src, 0);
    }

    public final void cmpb(Register dst, Register src) {
        AMD64BinaryArithmetic.CMP.byteRmOp.emit(this, AMD64BaseAssembler.OperandSize.BYTE, dst, src);
    }

    public final void cmpw(Register dst, Register src) {
        AMD64BinaryArithmetic.CMP.rmOp.emit(this, AMD64BaseAssembler.OperandSize.WORD, dst, src);
    }

    public final void cmpl(Register dst, int imm32) {
        AMD64BinaryArithmetic.CMP.getMIOpcode(AMD64BaseAssembler.OperandSize.DWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm32);
    }

    public final void cmpl(Register dst, Register src) {
        AMD64BinaryArithmetic.CMP.rmOp.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void cmpl(Register dst, AMD64Address src) {
        AMD64BinaryArithmetic.CMP.rmOp.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void cmpl(AMD64Address dst, int imm32) {
        AMD64BinaryArithmetic.CMP.getMIOpcode(AMD64BaseAssembler.OperandSize.DWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm32);
    }

    public final void cmpxchgb(Register reg, AMD64Address adr) {
        this.prefixb(adr, reg);
        this.emitByte(15);
        this.emitByte(176);
        this.emitOperandHelper(reg, adr, 0);
    }

    public final void cmpxchgw(Register reg, AMD64Address adr) {
        this.emitByte(102);
        this.prefix(adr, reg);
        this.emitByte(15);
        this.emitByte(177);
        this.emitOperandHelper(reg, adr, 0);
    }

    public final void cmpxchgl(Register reg, AMD64Address adr) {
        this.prefix(adr, reg);
        this.emitByte(15);
        this.emitByte(177);
        this.emitOperandHelper(reg, adr, 0);
    }

    public final void cvtsi2sdl(Register dst, Register src) {
        SSEOp.CVTSI2SD.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void cvttsd2sil(Register dst, Register src) {
        SSEOp.CVTTSD2SI.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void decl(AMD64Address dst) {
        AMD64MOp.DEC.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst);
    }

    public final void divsd(Register dst, Register src) {
        SSEOp.DIV.emit(this, AMD64BaseAssembler.OperandSize.SD, dst, src);
    }

    public final void hlt() {
        this.emitByte(244);
    }

    public final void imull(Register dst, Register src, int value) {
        if (NumUtil.isByte(value)) {
            AMD64RMIOp.IMUL_SX.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src, value);
        } else {
            AMD64RMIOp.IMUL.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src, value);
        }
    }

    public final void incl(AMD64Address dst) {
        AMD64MOp.INC.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst);
    }

    protected static int getPrefixInBytes(AMD64BaseAssembler.OperandSize size, Register dst, boolean dstIsByte) {
        boolean needsRex = AMD64Assembler.needsRex(dst, dstIsByte);
        if (size == AMD64BaseAssembler.OperandSize.WORD) {
            return needsRex ? 2 : 1;
        }
        return size == AMD64BaseAssembler.OperandSize.QWORD || needsRex ? 1 : 0;
    }

    protected static int getPrefixInBytes(AMD64BaseAssembler.OperandSize size, AMD64Address src) {
        boolean needsRex;
        boolean bl = needsRex = AMD64Assembler.needsRex(src.getBase()) || AMD64Assembler.needsRex(src.getIndex());
        if (size == AMD64BaseAssembler.OperandSize.WORD) {
            return needsRex ? 2 : 1;
        }
        return size == AMD64BaseAssembler.OperandSize.QWORD || needsRex ? 1 : 0;
    }

    protected static int getPrefixInBytes(AMD64BaseAssembler.OperandSize size, Register dst, boolean dstIsByte, Register src, boolean srcIsByte) {
        boolean needsRex;
        boolean bl = needsRex = AMD64Assembler.needsRex(dst, dstIsByte) || AMD64Assembler.needsRex(src, srcIsByte);
        if (size == AMD64BaseAssembler.OperandSize.WORD) {
            return needsRex ? 2 : 1;
        }
        return size == AMD64BaseAssembler.OperandSize.QWORD || needsRex ? 1 : 0;
    }

    protected static int getPrefixInBytes(AMD64BaseAssembler.OperandSize size, Register dst, boolean dstIsByte, AMD64Address src) {
        boolean needsRex;
        boolean bl = needsRex = AMD64Assembler.needsRex(dst, dstIsByte) || AMD64Assembler.needsRex(src.getBase()) || AMD64Assembler.needsRex(src.getIndex());
        if (size == AMD64BaseAssembler.OperandSize.WORD) {
            return needsRex ? 2 : 1;
        }
        return size == AMD64BaseAssembler.OperandSize.QWORD || needsRex ? 1 : 0;
    }

    protected boolean mayCrossBoundary(int opStart, int opEnd) {
        return opStart / 32 != (opEnd - 1) / 32 || opEnd % 32 == 0;
    }

    private static int bytesUntilBoundary(int pos) {
        return 32 - pos % 32;
    }

    protected boolean ensureWithinBoundary(int opStart) {
        int nextOpStart;
        int opEnd;
        if (this.useBranchesWithin32ByteBoundary && this.mayCrossBoundary(opStart, opEnd = (nextOpStart = this.position()) - 1)) {
            throw new GraalError("instruction at %d of size %d bytes crosses a JCC erratum boundary", opStart, nextOpStart - opStart);
        }
        return true;
    }

    protected final int mitigateJCCErratum(int bytesToEmit) {
        return this.mitigateJCCErratum(this.position(), bytesToEmit);
    }

    protected final int mitigateJCCErratum(int position, int bytesToEmit) {
        int bytesUntilBoundary;
        if (this.useBranchesWithin32ByteBoundary && (bytesUntilBoundary = AMD64Assembler.bytesUntilBoundary(position)) < bytesToEmit) {
            this.nop(bytesUntilBoundary);
            return bytesUntilBoundary;
        }
        return 0;
    }

    public void jcc(ConditionFlag cc, int jumpTarget, boolean forceDisp32) {
        int shortSize = 2;
        int longSize = 6;
        long disp = jumpTarget - this.position();
        if (!forceDisp32 && NumUtil.isByte(disp - 2L)) {
            this.mitigateJCCErratum(2);
            disp = jumpTarget - this.position();
            if (NumUtil.isByte(disp - 2L)) {
                this.emitByte(0x70 | cc.getValue());
                this.emitByte((int)(disp - 2L & 0xFFL));
                return;
            }
        }
        assert (forceDisp32 || NumUtil.isInt(disp - 6L)) : "must be 32bit offset (call4)";
        this.mitigateJCCErratum(6);
        disp = jumpTarget - this.position();
        this.emitByte(15);
        this.emitByte(0x80 | cc.getValue());
        this.emitInt((int)(disp - 6L));
    }

    public final void jcc(ConditionFlag cc) {
        this.annotatePatchingImmediate(2, 4);
        this.emitByte(15);
        this.emitByte(0x80 | cc.getValue());
        this.emitInt(0);
    }

    public final void jcc(ConditionFlag cc, Label l) {
        assert (0 <= cc.getValue() && cc.getValue() < 16) : "illegal cc";
        if (l.isBound()) {
            this.jcc(cc, l.position(), false);
        } else {
            this.mitigateJCCErratum(6);
            l.addPatchAt(this.position(), this);
            this.emitByte(15);
            this.emitByte(0x80 | cc.getValue());
            this.emitInt(0);
        }
    }

    public final void jccb(ConditionFlag cc, Label l) {
        if (this.force4ByteNonZeroDisplacements) {
            this.jcc(cc, l);
            return;
        }
        int shortSize = 2;
        this.mitigateJCCErratum(2);
        if (l.isBound()) {
            int entry = l.position();
            assert (NumUtil.isByte(entry - (this.position() + 2))) : "Displacement too large for a short jmp: " + (entry - (this.position() + 2));
            long disp = entry - this.position();
            this.emitByte(0x70 | cc.getValue());
            this.emitByte((int)(disp - 2L & 0xFFL));
        } else {
            l.addPatchAt(this.position(), this);
            this.emitByte(0x70 | cc.getValue());
            this.emitByte(0);
        }
    }

    public final void jcc(ConditionFlag cc, Label branchTarget, boolean isShortJmp) {
        if (branchTarget == null) {
            this.jcc(cc, 0, true);
        } else if (isShortJmp) {
            this.jccb(cc, branchTarget);
        } else {
            this.jcc(cc, branchTarget);
        }
    }

    public final int jmp(int jumpTarget, boolean forceDisp32) {
        long disp;
        int pos;
        int shortSize = 2;
        int longSize = 5;
        if (!forceDisp32) {
            this.mitigateJCCErratum(2);
            pos = this.position();
            disp = jumpTarget - pos;
            if (NumUtil.isByte(disp - 2L)) {
                this.emitByte(235);
                this.emitByte((int)(disp - 2L & 0xFFL));
                return pos;
            }
        }
        this.mitigateJCCErratum(5);
        pos = this.position();
        disp = jumpTarget - pos;
        this.emitByte(233);
        this.emitInt((int)(disp - 5L));
        return pos;
    }

    @Override
    public void halt() {
        this.hlt();
    }

    @Override
    public final void jmp(Label l) {
        if (l.isBound()) {
            this.jmp(l.position(), false);
        } else {
            this.mitigateJCCErratum(5);
            l.addPatchAt(this.position(), this);
            this.emitByte(233);
            this.emitInt(0);
        }
    }

    public final void jmp(Label l, boolean isShortJmp) {
        if (isShortJmp) {
            this.jmpb(l);
        } else {
            this.jmp(l);
        }
    }

    protected final void jmpWithoutAlignment(Register entry) {
        this.prefix(entry);
        this.emitByte(255);
        this.emitModRM(4, entry);
    }

    public void jmp(Register entry) {
        int bytesToEmit = AMD64Assembler.needsRex(entry) ? 3 : 2;
        this.mitigateJCCErratum(bytesToEmit);
        int beforeJmp = this.position();
        this.jmpWithoutAlignment(entry);
        assert (beforeJmp + bytesToEmit == this.position()) : beforeJmp + " " + bytesToEmit + " " + this.position();
    }

    public void jmp(AMD64Address adr) {
        int bytesToEmit = AMD64Assembler.getPrefixInBytes(AMD64BaseAssembler.OperandSize.DWORD, adr) + 1 + this.addressInBytes(adr);
        this.mitigateJCCErratum(bytesToEmit);
        int beforeJmp = this.position();
        this.prefix(adr);
        this.emitByte(255);
        this.emitOperandHelper(AMD64.rsp, adr, 0);
        assert (beforeJmp + bytesToEmit == this.position()) : beforeJmp + " " + bytesToEmit + " " + this.position();
    }

    protected int addressInBytes(AMD64Address addr) {
        Register base = addr.getBase();
        Register index = addr.getIndex();
        int disp = addr.getDisplacement();
        if (base.equals((Object)AMD64.rip)) {
            return 5;
        }
        if (base.isValid()) {
            boolean isByteDisplacement;
            boolean isZeroDisplacement = addr.getDisplacementAnnotation() == null && disp == 0 && !base.equals((Object)AMD64.rbp) && !base.equals((Object)AMD64.r13);
            boolean bl = isByteDisplacement = addr.getDisplacementAnnotation() == null && NumUtil.isByte(disp) && (!this.force4ByteNonZeroDisplacements || disp == 0);
            if (index.isValid()) {
                if (isZeroDisplacement) {
                    return 2;
                }
                if (isByteDisplacement) {
                    return 3;
                }
                return 6;
            }
            if (base.equals((Object)AMD64.rsp) || base.equals((Object)AMD64.r12)) {
                if (disp == 0) {
                    return 2;
                }
                if (isByteDisplacement) {
                    return 3;
                }
                return 6;
            }
            if (isZeroDisplacement) {
                return 1;
            }
            if (isByteDisplacement) {
                return 2;
            }
            return 5;
        }
        return 6;
    }

    public final void jmpb(Label l) {
        if (this.force4ByteNonZeroDisplacements) {
            this.jmp(l);
            return;
        }
        int shortSize = 2;
        this.mitigateJCCErratum(2);
        if (l.isBound()) {
            int displacement = l.position() - this.position() - 2;
            GraalError.guarantee(NumUtil.isByte(displacement), "Displacement too large to be encoded as a byte: %d", (Object)displacement);
            this.emitByte(235);
            this.emitByte(displacement & 0xFF);
        } else {
            l.addPatchAt(this.position(), this);
            this.emitByte(235);
            this.emitByte(0);
        }
    }

    public final void lead(Register dst, AMD64Address src) {
        this.prefix(src, dst);
        this.emitByte(141);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void leaq(Register dst, AMD64Address src) {
        this.prefixq(src, dst);
        this.emitByte(141);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void leave() {
        this.emitByte(201);
    }

    public final void lock() {
        this.emitByte(240);
    }

    public final void movapd(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(40);
        this.emitModRM(dst, src);
    }

    public final void movaps(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.PS, 15, false);
        this.emitByte(40);
        this.emitModRM(dst, src);
    }

    public final void movb(Register dst, AMD64Address src) {
        this.prefixb(src, dst);
        this.emitByte(138);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void movb(AMD64Address dst, int imm8) {
        this.prefix(dst);
        this.emitByte(198);
        this.emitOperandHelper(0, dst, 1);
        this.emitByte(imm8);
    }

    public final void movb(AMD64Address dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.CPU, src)) : "must have byte register";
        this.prefixb(dst, src);
        this.emitByte(136);
        this.emitOperandHelper(src, dst, 0);
    }

    public final void movl(Register dst, int imm32) {
        this.movl(dst, imm32, false);
    }

    public final void movl(Register dst, int imm32, boolean annotateImm) {
        int insnPos = this.position();
        this.prefix(dst);
        this.emitByte(184 + AMD64Assembler.encode(dst));
        int immPos = this.position();
        this.emitInt(imm32);
        int nextInsnPos = this.position();
        if (annotateImm && this.codePatchingAnnotationConsumer != null) {
            this.codePatchingAnnotationConsumer.accept(new AMD64BaseAssembler.OperandDataAnnotation(insnPos, immPos, nextInsnPos - immPos, nextInsnPos));
        }
    }

    public final void movl(Register dst, Register src) {
        this.prefix(dst, src);
        this.emitByte(139);
        this.emitModRM(dst, src);
    }

    public final void movl(Register dst, AMD64Address src) {
        this.prefix(src, dst);
        this.emitByte(139);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void movl(Register dst, AMD64Address src, boolean wide) {
        this.prefix(src, dst);
        this.emitByte(139);
        this.emitOperandHelper(dst, src, wide, 0);
    }

    public final void movl(AMD64Address dst, int imm32) {
        this.prefix(dst);
        this.emitByte(199);
        this.emitOperandHelper(0, dst, 4);
        this.emitInt(imm32);
    }

    public final void movl(AMD64Address dst, Register src) {
        this.prefix(dst, src);
        this.emitByte(137);
        this.emitOperandHelper(src, dst, 0);
    }

    public final void movlpd(Register dst, AMD64Address src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(18);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void movlhps(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PS, 15, false);
        this.emitByte(22);
        this.emitModRM(dst, src);
    }

    public final void movq(Register dst, AMD64Address src) {
        this.movq(dst, src, false);
    }

    public final void movq(Register dst, AMD64Address src, boolean force4BytesDisplacement) {
        if (AMD64Assembler.inRC(AMD64.XMM, dst)) {
            this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.SS, 15, false);
            this.emitByte(126);
            this.emitOperandHelper(dst, src, force4BytesDisplacement, 0);
        } else {
            this.prefixq(src, dst);
            this.emitByte(139);
            this.emitOperandHelper(dst, src, force4BytesDisplacement, 0);
        }
    }

    public final void movq(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.CPU, dst) && AMD64Assembler.inRC(AMD64.CPU, src)) : String.valueOf(src) + " " + String.valueOf(dst);
        this.prefixq(dst, src);
        this.emitByte(139);
        this.emitModRM(dst, src);
    }

    public final void movq(AMD64Address dst, Register src) {
        if (AMD64Assembler.inRC(AMD64.XMM, src)) {
            this.simdPrefix(src, Register.None, dst, AMD64BaseAssembler.OperandSize.PD, 15, false);
            this.emitByte(214);
            this.emitOperandHelper(src, dst, 0);
        } else {
            this.prefixq(dst, src);
            this.emitByte(137);
            this.emitOperandHelper(src, dst, 0);
        }
    }

    public final void movsbl(Register dst, AMD64Address src) {
        this.prefix(src, dst);
        this.emitByte(15);
        this.emitByte(190);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void movsbl(Register dst, Register src) {
        this.prefix(dst, false, src, true);
        this.emitByte(15);
        this.emitByte(190);
        this.emitModRM(dst, src);
    }

    public final void movsbq(Register dst, AMD64Address src) {
        this.prefixq(src, dst);
        this.emitByte(15);
        this.emitByte(190);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void movsbq(Register dst, Register src) {
        this.prefixq(dst, src);
        this.emitByte(15);
        this.emitByte(190);
        this.emitModRM(dst, src);
    }

    public final void movsd(Register dst, Register src) {
        SSEOp.MOVSD.emit(this, AMD64BaseAssembler.OperandSize.SD, dst, src);
    }

    public final void movsd(Register dst, AMD64Address src) {
        SSEOp.MOVSD.emit(this, AMD64BaseAssembler.OperandSize.SD, dst, src);
    }

    public final void movsd(AMD64Address dst, Register src) {
        SSEMROp.MOVSD.emit(this, AMD64BaseAssembler.OperandSize.SD, dst, src);
    }

    public final void movss(Register dst, Register src) {
        SSEOp.MOVSS.emit(this, AMD64BaseAssembler.OperandSize.SS, dst, src);
    }

    public final void movss(Register dst, AMD64Address src) {
        SSEOp.MOVSS.emit(this, AMD64BaseAssembler.OperandSize.SS, dst, src);
    }

    public final void movss(AMD64Address dst, Register src) {
        SSEMROp.MOVSS.emit(this, AMD64BaseAssembler.OperandSize.SS, dst, src);
    }

    public final void mulpd(Register dst, Register src) {
        SSEOp.MUL.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void mulpd(Register dst, AMD64Address src) {
        SSEOp.MUL.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void mulsd(Register dst, Register src) {
        SSEOp.MUL.emit(this, AMD64BaseAssembler.OperandSize.SD, dst, src);
    }

    public final void mulsd(Register dst, AMD64Address src) {
        SSEOp.MUL.emit(this, AMD64BaseAssembler.OperandSize.SD, dst, src);
    }

    public final void mulss(Register dst, Register src) {
        SSEOp.MUL.emit(this, AMD64BaseAssembler.OperandSize.SS, dst, src);
    }

    public final void movswl(Register dst, Register src) {
        AMD64RMOp.MOVSX.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void movswl(Register dst, AMD64Address src) {
        AMD64RMOp.MOVSX.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void movswq(Register dst, AMD64Address src) {
        AMD64RMOp.MOVSX.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void movw(AMD64Address dst, int imm16) {
        this.emitByte(102);
        this.prefix(dst);
        this.emitByte(199);
        this.emitOperandHelper(0, dst, 2);
        this.emitShort(imm16);
    }

    public final void movw(AMD64Address dst, Register src) {
        this.emitByte(102);
        this.prefix(dst, src);
        this.emitByte(137);
        this.emitOperandHelper(src, dst, 0);
    }

    public final void movw(Register dst, AMD64Address src) {
        this.emitByte(102);
        this.prefix(src, dst);
        this.emitByte(139);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void movzbl(Register dst, AMD64Address src) {
        this.prefix(src, dst);
        this.emitByte(15);
        this.emitByte(182);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void movzbl(Register dst, Register src) {
        AMD64RMOp.MOVZXB.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void movzbq(Register dst, Register src) {
        AMD64RMOp.MOVZXB.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void movzbq(Register dst, AMD64Address src) {
        AMD64RMOp.MOVZXB.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void movzwl(Register dst, AMD64Address src) {
        AMD64RMOp.MOVZX.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void movzwq(Register dst, AMD64Address src) {
        AMD64RMOp.MOVZX.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void negl(Register dst) {
        AMD64MOp.NEG.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst);
    }

    public final void notl(Register dst) {
        AMD64MOp.NOT.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst);
    }

    public final void notq(Register dst) {
        AMD64MOp.NOT.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst);
    }

    @Override
    public final void ensureUniquePC() {
        this.nop();
    }

    public final void nop() {
        this.nop(1);
    }

    public void nop(int count) {
        this.intelNops(count);
    }

    private void intelNops(int count) {
        int i;
        for (i = count; i >= 15; i -= 15) {
            this.emitByte(102);
            this.emitByte(102);
            this.emitByte(102);
            this.addrNop8();
            this.emitByte(102);
            this.emitByte(102);
            this.emitByte(102);
            this.emitByte(144);
        }
        switch (i) {
            case 14: {
                this.emitByte(102);
            }
            case 13: {
                this.emitByte(102);
            }
            case 12: {
                this.addrNop8();
                this.emitByte(102);
                this.emitByte(102);
                this.emitByte(102);
                this.emitByte(144);
                break;
            }
            case 11: {
                this.emitByte(102);
            }
            case 10: {
                this.emitByte(102);
            }
            case 9: {
                this.emitByte(102);
            }
            case 8: {
                this.addrNop8();
                break;
            }
            case 7: {
                this.addrNop7();
                break;
            }
            case 6: {
                this.emitByte(102);
            }
            case 5: {
                this.addrNop5();
                break;
            }
            case 4: {
                this.addrNop4();
                break;
            }
            case 3: {
                this.emitByte(102);
            }
            case 2: {
                this.emitByte(102);
            }
            case 1: {
                this.emitByte(144);
                break;
            }
            default: {
                assert (i == 0) : i;
                break;
            }
        }
    }

    public final void orl(Register dst, Register src) {
        AMD64BinaryArithmetic.OR.rmOp.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void orl(Register dst, AMD64Address src) {
        AMD64BinaryArithmetic.OR.rmOp.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void orl(AMD64Address dst, Register src) {
        AMD64BinaryArithmetic.OR.mrOp.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void orl(Register dst, int imm32) {
        AMD64BinaryArithmetic.OR.getMIOpcode(AMD64BaseAssembler.OperandSize.DWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm32);
    }

    public final void packuswb(Register dst, Register src) {
        SSEOp.PACKUSWB.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void packusdw(Register dst, Register src) {
        SSEOp.PACKUSDW.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pop(Register dst) {
        this.prefix(dst);
        this.emitByte(88 + AMD64Assembler.encode(dst));
    }

    public void popfq() {
        this.emitByte(157);
    }

    public final void ptest(Register dst, Register src) {
        GraalError.guarantee(this.supports(AMD64.CPUFeature.SSE4_1), "PTEST requires SSE4.1");
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.PD, 14351, false);
        this.emitByte(23);
        this.emitModRM(dst, src);
    }

    public final void ptest(Register dst, AMD64Address src) {
        GraalError.guarantee(this.supports(AMD64.CPUFeature.SSE4_1), "PTEST requires SSE4.1");
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.PD, 14351, false);
        this.emitByte(23);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void pcmpeqb(Register dst, Register src) {
        assert (this.supports(AMD64.CPUFeature.SSE2));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(116);
        this.emitModRM(dst, src);
    }

    public final void pcmpeqb(Register dst, AMD64Address src) {
        assert (this.supports(AMD64.CPUFeature.SSE2));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(116);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void pcmpeqw(Register dst, Register src) {
        assert (this.supports(AMD64.CPUFeature.SSE2));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(117);
        this.emitModRM(dst, src);
    }

    public final void pcmpeqw(Register dst, AMD64Address src) {
        assert (this.supports(AMD64.CPUFeature.SSE2));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(117);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void pcmpeqd(Register dst, Register src) {
        assert (this.supports(AMD64.CPUFeature.SSE2));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(118);
        this.emitModRM(dst, src);
    }

    public final void pcmpeqd(Register dst, AMD64Address src) {
        assert (this.supports(AMD64.CPUFeature.SSE2));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(118);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void pminub(Register dst, Register src) {
        SSEOp.PMINUB.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pminuw(Register dst, Register src) {
        SSEOp.PMINUW.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pminud(Register dst, Register src) {
        SSEOp.PMINUD.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pcmpgtb(Register dst, Register src) {
        assert (this.supports(AMD64.CPUFeature.SSE2));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(100);
        this.emitModRM(dst, src);
    }

    public final void pcmpgtd(Register dst, Register src) {
        assert (this.supports(AMD64.CPUFeature.SSE2));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(102);
        this.emitModRM(dst, src);
    }

    public final void pcmpestri(Register dst, AMD64Address src, int imm8) {
        assert (this.supports(AMD64.CPUFeature.SSE4_2));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.PD, 14863, false);
        this.emitByte(97);
        this.emitOperandHelper(dst, src, 0);
        this.emitByte(imm8);
    }

    public final void pcmpestri(Register dst, Register src, int imm8) {
        assert (this.supports(AMD64.CPUFeature.SSE4_2));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.PD, 14863, false);
        this.emitByte(97);
        this.emitModRM(dst, src);
        this.emitByte(imm8);
    }

    public final void pmovmskb(Register dst, Register src) {
        assert (this.supports(AMD64.CPUFeature.SSE2));
        assert (AMD64Assembler.inRC(AMD64.CPU, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(215);
        this.emitModRM(dst, src);
    }

    private void pmovSZx(Register dst, AMD64Address src, int op) {
        assert (this.supports(AMD64.CPUFeature.SSE4_1));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.PD, 14351, false);
        this.emitByte(op);
        this.emitOperandHelper(dst, src, 0);
    }

    private void pmovSZx(Register dst, Register src, int op) {
        assert (this.supports(AMD64.CPUFeature.SSE4_1));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.PD, 14351, false);
        this.emitByte(op);
        this.emitModRM(dst, src);
    }

    public final void pmovsxbw(Register dst, AMD64Address src) {
        this.pmovSZx(dst, src, 32);
    }

    public final void pmovsxbd(Register dst, AMD64Address src) {
        this.pmovSZx(dst, src, 33);
    }

    public final void pmovsxbq(Register dst, AMD64Address src) {
        this.pmovSZx(dst, src, 34);
    }

    public final void pmovsxwd(Register dst, AMD64Address src) {
        this.pmovSZx(dst, src, 35);
    }

    public final void pmovsxwq(Register dst, AMD64Address src) {
        this.pmovSZx(dst, src, 36);
    }

    public final void pmovsxdq(Register dst, AMD64Address src) {
        this.pmovSZx(dst, src, 37);
    }

    public final void pmovzxbw(Register dst, AMD64Address src) {
        this.pmovSZx(dst, src, 48);
    }

    public final void pmovzxbd(Register dst, AMD64Address src) {
        this.pmovSZx(dst, src, 49);
    }

    public final void pmovzxbq(Register dst, AMD64Address src) {
        this.pmovSZx(dst, src, 50);
    }

    public final void pmovzxwd(Register dst, AMD64Address src) {
        this.pmovSZx(dst, src, 51);
    }

    public final void pmovzxwq(Register dst, AMD64Address src) {
        this.pmovSZx(dst, src, 52);
    }

    public final void pmovzxdq(Register dst, AMD64Address src) {
        this.pmovSZx(dst, src, 53);
    }

    public final void pmovsxbw(Register dst, Register src) {
        this.pmovSZx(dst, src, 32);
    }

    public final void pmovsxbd(Register dst, Register src) {
        this.pmovSZx(dst, src, 33);
    }

    public final void pmovsxbq(Register dst, Register src) {
        this.pmovSZx(dst, src, 34);
    }

    public final void pmovsxwd(Register dst, Register src) {
        this.pmovSZx(dst, src, 35);
    }

    public final void pmovsxwq(Register dst, Register src) {
        this.pmovSZx(dst, src, 36);
    }

    public final void pmovsxdq(Register dst, Register src) {
        this.pmovSZx(dst, src, 37);
    }

    public final void pmovzxbw(Register dst, Register src) {
        this.pmovSZx(dst, src, 48);
    }

    public final void pmovzxbd(Register dst, Register src) {
        this.pmovSZx(dst, src, 49);
    }

    public final void pmovzxbq(Register dst, Register src) {
        this.pmovSZx(dst, src, 50);
    }

    public final void pmovzxwd(Register dst, Register src) {
        this.pmovSZx(dst, src, 51);
    }

    public final void pmovzxwq(Register dst, Register src) {
        this.pmovSZx(dst, src, 52);
    }

    public final void pmovzxdq(Register dst, Register src) {
        this.pmovSZx(dst, src, 53);
    }

    public final void gf2p8affineqb(Register dst, Register src, int imm8) {
        GraalError.guarantee(this.supports(AMD64.CPUFeature.GFNI), "gf2p8affineqb requires GFNI");
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        if (this.supports(AMD64.CPUFeature.AVX)) {
            VexRVMIOp.VGF2P8AFFINEQB.emit(this, AVXKind.AVXSize.XMM, dst, dst, src, imm8);
        } else {
            this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 14863, false);
            this.emitByte(206);
            this.emitModRM(dst, src);
            this.emitByte(imm8);
        }
    }

    public final void vcvtps2ph(Register dst, Register src, int imm8) {
        GraalError.guarantee(this.supports(AMD64.CPUFeature.F16C), "vcvtps2ph requires F16C");
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        VexMRIOp.VCVTPS2PH.emit(this, AVXKind.AVXSize.XMM, dst, src, imm8);
    }

    public final void vcvtph2ps(Register dst, Register src) {
        GraalError.guarantee(this.supports(AMD64.CPUFeature.F16C), "vcvtph2ps requires F16C");
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        VexRMOp.VCVTPH2PS.emit(this, AVXKind.AVXSize.XMM, dst, src);
    }

    public final void push(Register src) {
        assert (AMD64Assembler.inRC(AMD64.CPU, src));
        this.prefix(src);
        this.emitByte(80 + AMD64Assembler.encode(src));
    }

    public final void push(int imm32) {
        this.emitByte(104);
        this.emitInt(imm32);
    }

    public void pushfq() {
        this.emitByte(156);
    }

    public final void paddd(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(254);
        this.emitModRM(dst, src);
    }

    public final void paddd(Register dst, AMD64Address src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(254);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void paddq(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(212);
        this.emitModRM(dst, src);
    }

    public final void pextrb(AMD64Address dst, Register src, int imm8) {
        assert (this.supports(AMD64.CPUFeature.SSE4_1));
        assert (AMD64Assembler.inRC(AMD64.XMM, src));
        this.simdPrefix(src, Register.None, dst, AMD64BaseAssembler.OperandSize.PD, 14863, false);
        this.emitByte(20);
        this.emitOperandHelper(src, dst, 0);
        this.emitByte(imm8);
    }

    public final void pextrw(Register dst, Register src, int imm8) {
        assert (AMD64Assembler.inRC(AMD64.CPU, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(197);
        this.emitModRM(dst, src);
        this.emitByte(imm8);
    }

    public final void pextrw(AMD64Address dst, Register src, int imm8) {
        assert (this.supports(AMD64.CPUFeature.SSE4_1));
        assert (AMD64Assembler.inRC(AMD64.XMM, src));
        this.simdPrefix(src, Register.None, dst, AMD64BaseAssembler.OperandSize.PD, 14863, false);
        this.emitByte(21);
        this.emitOperandHelper(src, dst, 0);
        this.emitByte(imm8);
    }

    public final void pextrd(AMD64Address dst, Register src, int imm8) {
        assert (this.supports(AMD64.CPUFeature.SSE4_1));
        assert (AMD64Assembler.inRC(AMD64.XMM, src));
        this.simdPrefix(src, Register.None, dst, AMD64BaseAssembler.OperandSize.PD, 14863, false);
        this.emitByte(22);
        this.emitOperandHelper(src, dst, 0);
        this.emitByte(imm8);
    }

    public final void pextrq(Register dst, Register src, int imm8) {
        assert (this.supports(AMD64.CPUFeature.SSE4_1));
        assert (AMD64Assembler.inRC(AMD64.CPU, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(src, Register.None, dst, AMD64BaseAssembler.OperandSize.PD, 14863, true);
        this.emitByte(22);
        this.emitModRM(src, dst);
        this.emitByte(imm8);
    }

    public final void pextrq(AMD64Address dst, Register src, int imm8) {
        assert (this.supports(AMD64.CPUFeature.SSE4_1));
        assert (AMD64Assembler.inRC(AMD64.XMM, src));
        this.simdPrefix(src, Register.None, dst, AMD64BaseAssembler.OperandSize.PD, 14863, true);
        this.emitByte(22);
        this.emitOperandHelper(src, dst, 0);
        this.emitByte(imm8);
    }

    public final void pinsrb(Register dst, AMD64Address src, int imm8) {
        assert (this.supports(AMD64.CPUFeature.SSE4_1));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 14863, false);
        this.emitByte(32);
        this.emitOperandHelper(dst, src, 0);
        this.emitByte(imm8);
    }

    public final void pinsrw(Register dst, Register src, int imm8) {
        assert (this.supports(AMD64.CPUFeature.SSE2));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.CPU, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(196);
        this.emitModRM(dst, src);
        this.emitByte(imm8);
    }

    public final void pinsrw(Register dst, AMD64Address src, int imm8) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(196);
        this.emitOperandHelper(dst, src, 0);
        this.emitByte(imm8);
    }

    public final void pinsrd(Register dst, AMD64Address src, int imm8) {
        assert (this.supports(AMD64.CPUFeature.SSE4_1));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 14863, false);
        this.emitByte(34);
        this.emitOperandHelper(dst, src, 0);
        this.emitByte(imm8);
    }

    public final void pinsrq(Register dst, Register src, int imm8) {
        assert (this.supports(AMD64.CPUFeature.SSE4_1));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.CPU, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 14863, true);
        this.emitByte(34);
        this.emitModRM(dst, src);
        this.emitByte(imm8);
    }

    public final void pinsrq(Register dst, AMD64Address src, int imm8) {
        assert (this.supports(AMD64.CPUFeature.SSE4_1));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 14863, true);
        this.emitByte(34);
        this.emitOperandHelper(dst, src, 0);
        this.emitByte(imm8);
    }

    public final void por(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(235);
        this.emitModRM(dst, src);
    }

    public final void palignr(Register dst, Register src, int imm8) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 14863, false);
        this.emitByte(15);
        this.emitModRM(dst, src);
        this.emitByte(imm8);
    }

    public final void pblendw(Register dst, Register src, int imm8) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 14863, false);
        this.emitByte(14);
        this.emitModRM(dst, src);
        this.emitByte(imm8);
    }

    public final void pand(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(219);
        this.emitModRM(dst, src);
    }

    public final void pand(Register dst, AMD64Address src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(219);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void pandn(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(223);
        this.emitModRM(dst, src);
    }

    public final void pxor(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(239);
        this.emitModRM(dst, src);
    }

    public final void psllw(Register dst, int imm8) {
        assert (NumUtil.isUByte(imm8)) : "invalid value";
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.simdPrefix(AMD64.xmm6, dst, dst, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(113);
        this.emitModRM(6, dst);
        this.emitByte(imm8 & 0xFF);
    }

    public final void pslld(Register dst, int imm8) {
        assert (NumUtil.isUByte(imm8)) : "invalid value";
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.simdPrefix(AMD64.xmm6, dst, dst, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(114);
        this.emitModRM(6, dst);
        this.emitByte(imm8 & 0xFF);
    }

    public final void pslldq(Register dst, int imm8) {
        assert (NumUtil.isUByte(imm8)) : "invalid value";
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.simdPrefix(AMD64.xmm7, dst, dst, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(115);
        this.emitModRM(7, dst);
        this.emitByte(imm8 & 0xFF);
    }

    public final void psllq(Register dst, Register shift) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, shift)) : String.valueOf(dst) + " " + String.valueOf(shift);
        this.simdPrefix(dst, dst, shift, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(243);
        this.emitModRM(dst, shift);
    }

    public final void psllq(Register dst, int imm8) {
        assert (NumUtil.isUByte(imm8)) : "invalid value";
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.simdPrefix(AMD64.xmm6, dst, dst, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(115);
        this.emitModRM(6, dst);
        this.emitByte(imm8);
    }

    public final void psrad(Register dst, int imm8) {
        assert (NumUtil.isUByte(imm8)) : "invalid value";
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.simdPrefix(AMD64.xmm4, dst, dst, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(114);
        this.emitModRM(4, dst);
        this.emitByte(imm8);
    }

    public final void psrlw(Register dst, int imm8) {
        assert (NumUtil.isUByte(imm8)) : "invalid value";
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.simdPrefix(AMD64.xmm2, dst, dst, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(113);
        this.emitModRM(2, dst);
        this.emitByte(imm8);
    }

    public final void psrld(Register dst, int imm8) {
        assert (NumUtil.isUByte(imm8)) : "invalid value";
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.simdPrefix(AMD64.xmm2, dst, dst, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(114);
        this.emitModRM(2, dst);
        this.emitByte(imm8);
    }

    public final void psrlq(Register dst, int imm8) {
        assert (NumUtil.isUByte(imm8)) : "invalid value";
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.simdPrefix(AMD64.xmm2, dst, dst, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(115);
        this.emitModRM(2, dst);
        this.emitByte(imm8);
    }

    public final void psrldq(Register dst, int imm8) {
        assert (NumUtil.isUByte(imm8)) : "invalid value";
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.simdPrefix(AMD64.xmm3, dst, dst, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(115);
        this.emitModRM(3, dst);
        this.emitByte(imm8);
    }

    public final void pshufb(Register dst, Register src) {
        SSEOp.PSHUFB.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pshufb(Register dst, AMD64Address src) {
        SSEOp.PSHUFB.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pshuflw(Register dst, Register src, int imm8) {
        GraalError.guarantee(this.supports(AMD64.CPUFeature.SSE2), "pshuflw requires SSE2");
        assert (NumUtil.isUByte(imm8)) : "invalid value";
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.SD, 15, false);
        this.emitByte(112);
        this.emitModRM(dst, src);
        this.emitByte(imm8);
    }

    public final void pshufd(Register dst, Register src, int imm8) {
        assert (NumUtil.isUByte(imm8)) : "invalid value";
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(112);
        this.emitModRM(dst, src);
        this.emitByte(imm8);
    }

    public final void psubusb(Register dst, Register src) {
        SSEOp.PSUBUSB.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void psubusb(Register dst, AMD64Address src) {
        SSEOp.PSUBUSB.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void psubusw(Register dst, Register src) {
        SSEOp.PSUBUSW.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void psubusw(Register dst, AMD64Address src) {
        SSEOp.PSUBUSW.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void psubd(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(250);
        this.emitModRM(dst, src);
    }

    public final void punpcklbw(Register dst, Register src) {
        assert (this.supports(AMD64.CPUFeature.SSE2));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(96);
        this.emitModRM(dst, src);
    }

    public final void pclmulqdq(Register dst, Register src, int imm8) {
        assert (this.supports(AMD64.CPUFeature.CLMUL));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 14863, false);
        this.emitByte(68);
        this.emitModRM(dst, src);
        this.emitByte(imm8);
    }

    public final void vpshufb(Register dst, Register src1, Register src2, AVXKind.AVXSize size) {
        VexRVMOp.VPSHUFB.emit(this, size, dst, src1, src2);
    }

    public final void vpshufd(Register dst, Register src, int imm8, AVXKind.AVXSize size) {
        VexRMIOp.VPSHUFD.emit(this, size, dst, src, imm8);
    }

    public final void vpclmulqdq(Register dst, Register nds, Register src, int imm8) {
        VexRVMIOp.VPCLMULQDQ.emit(this, AVXKind.AVXSize.XMM, dst, nds, src, imm8);
    }

    public final void vpblendd(Register dst, Register nds, Register src, int imm8, AVXKind.AVXSize size) {
        VexRVMIOp.VPBLENDD.emit(this, size, dst, nds, src, imm8);
    }

    public final void vpclmullqlqdq(Register dst, Register nds, Register src) {
        VexRVMIOp.VPCLMULQDQ.emit(this, AVXKind.AVXSize.XMM, dst, nds, src, 0);
    }

    public final void vpclmulhqlqdq(Register dst, Register nds, Register src) {
        VexRVMIOp.VPCLMULQDQ.emit(this, AVXKind.AVXSize.XMM, dst, nds, src, 1);
    }

    public final void vpclmullqhqdq(Register dst, Register nds, Register src) {
        VexRVMIOp.VPCLMULQDQ.emit(this, AVXKind.AVXSize.XMM, dst, nds, src, 16);
    }

    public final void vpclmulhqhqdq(Register dst, Register nds, Register src) {
        VexRVMIOp.VPCLMULQDQ.emit(this, AVXKind.AVXSize.XMM, dst, nds, src, 17);
    }

    public final void vpsrlq(Register dst, Register src, int imm8, AVXKind.AVXSize size) {
        VexShiftOp.VPSRLQ.emit(this, size, dst, src, imm8);
    }

    public final void vpsllq(Register dst, Register src, int imm8, AVXKind.AVXSize size) {
        VexShiftOp.VPSLLQ.emit(this, size, dst, src, imm8);
    }

    public final void rcpps(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.PS, 15, false);
        this.emitByte(83);
        this.emitModRM(dst, src);
    }

    public void ret(int imm16) {
        if (imm16 == 0) {
            this.mitigateJCCErratum(1);
            this.emitByte(195);
        } else {
            this.mitigateJCCErratum(3);
            this.emitByte(194);
            this.emitShort(imm16);
        }
    }

    public final void sarl(Register dst, int imm8) {
        this.prefix(dst);
        assert (NumUtil.isShiftCount(imm8 >> 1)) : "illegal shift count";
        if (imm8 == 1) {
            this.emitByte(209);
            this.emitModRM(7, dst);
        } else {
            this.emitByte(193);
            this.emitModRM(7, dst);
            this.emitByte(imm8);
        }
    }

    public final void sarl(Register dst) {
        this.prefix(dst);
        this.emitByte(211);
        this.emitModRM(7, dst);
    }

    public final void shll(Register dst, int imm8) {
        assert (NumUtil.isShiftCount(imm8 >> 1)) : "illegal shift count";
        this.prefix(dst);
        if (imm8 == 1) {
            this.emitByte(209);
            this.emitModRM(4, dst);
        } else {
            this.emitByte(193);
            this.emitModRM(4, dst);
            this.emitByte(imm8);
        }
    }

    public final void shll(Register dst) {
        this.prefix(dst);
        this.emitByte(211);
        this.emitModRM(4, dst);
    }

    public final void shlxl(Register dst, Register src1, Register src2) {
        VexGeneralPurposeRMVOp.SHLX.emit(this, AVXKind.AVXSize.DWORD, dst, src1, src2);
    }

    public final void shrl(Register dst, int imm8) {
        assert (NumUtil.isShiftCount(imm8 >> 1)) : "illegal shift count";
        this.prefix(dst);
        this.emitByte(193);
        this.emitModRM(5, dst);
        this.emitByte(imm8);
    }

    public final void shrl(Register dst) {
        this.prefix(dst);
        this.emitByte(211);
        this.emitModRM(5, dst);
    }

    public final void subl(AMD64Address dst, int imm32) {
        AMD64BinaryArithmetic.SUB.getMIOpcode(AMD64BaseAssembler.OperandSize.DWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm32);
    }

    public final void subl(Register dst, int imm32) {
        AMD64BinaryArithmetic.SUB.getMIOpcode(AMD64BaseAssembler.OperandSize.DWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm32);
    }

    public final void subl(Register dst, Register src) {
        AMD64BinaryArithmetic.SUB.rmOp.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void subpd(Register dst, Register src) {
        SSEOp.SUB.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void subsd(Register dst, Register src) {
        SSEOp.SUB.emit(this, AMD64BaseAssembler.OperandSize.SD, dst, src);
    }

    public final void subsd(Register dst, AMD64Address src) {
        SSEOp.SUB.emit(this, AMD64BaseAssembler.OperandSize.SD, dst, src);
    }

    public final void testl(Register dst, int imm32) {
        if (dst.encoding == 0) {
            this.emitByte(169);
            this.emitInt(imm32);
        } else {
            AMD64MIOp.TEST.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm32);
        }
    }

    public final void testl(Register dst, Register src) {
        AMD64RMOp.TEST.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void testl(Register dst, AMD64Address src) {
        AMD64RMOp.TEST.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void unpckhpd(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(21);
        this.emitModRM(dst, src);
    }

    public final void unpcklpd(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(20);
        this.emitModRM(dst, src);
    }

    public final void xorb(Register dst, AMD64Address src) {
        AMD64BinaryArithmetic.XOR.byteRmOp.emit(this, AMD64BaseAssembler.OperandSize.BYTE, dst, src);
    }

    public final void xorl(Register dst, Register src) {
        AMD64BinaryArithmetic.XOR.rmOp.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void xorl(Register dst, int imm32) {
        AMD64BinaryArithmetic.XOR.getMIOpcode(AMD64BaseAssembler.OperandSize.DWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm32);
    }

    public final void xorq(Register dst, Register src) {
        AMD64BinaryArithmetic.XOR.rmOp.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void xorpd(Register dst, Register src) {
        SSEOp.XOR.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void xorpd(Register dst, AMD64Address src) {
        SSEOp.XOR.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void xorps(Register dst, Register src) {
        SSEOp.XOR.emit(this, AMD64BaseAssembler.OperandSize.PS, dst, src);
    }

    public final void xorps(Register dst, AMD64Address src) {
        SSEOp.XOR.emit(this, AMD64BaseAssembler.OperandSize.PS, dst, src);
    }

    public final void ucomiss(Register dst, Register src) {
        SSEOp.UCOMIS.emit(this, AMD64BaseAssembler.OperandSize.PS, dst, src);
    }

    public final void ucomisd(Register dst, Register src) {
        SSEOp.UCOMIS.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void decl(Register dst) {
        AMD64MOp.DEC.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst);
    }

    public final void incl(Register dst) {
        AMD64MOp.INC.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst);
    }

    public final void imull(Register dst, Register src) {
        AMD64RMOp.IMUL.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void addq(Register dst, int imm32) {
        AMD64BinaryArithmetic.ADD.getMIOpcode(AMD64BaseAssembler.OperandSize.QWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, imm32);
    }

    public final void addq(AMD64Address dst, int imm32) {
        AMD64BinaryArithmetic.ADD.getMIOpcode(AMD64BaseAssembler.OperandSize.QWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, imm32);
    }

    public final void addq(Register dst, Register src) {
        AMD64BinaryArithmetic.ADD.rmOp.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void addq(Register dst, AMD64Address src) {
        AMD64BinaryArithmetic.ADD.rmOp.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void addq(AMD64Address dst, Register src) {
        AMD64BinaryArithmetic.ADD.mrOp.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void adcq(Register dst, int imm32) {
        AMD64BinaryArithmetic.ADC.getMIOpcode(AMD64BaseAssembler.OperandSize.QWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, imm32);
    }

    public final void adcxq(Register dst, Register src) {
        AMD64RMOp.ADCX.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void adoxq(Register dst, Register src) {
        AMD64RMOp.ADOX.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void andq(Register dst, int imm32) {
        AMD64BinaryArithmetic.AND.getMIOpcode(AMD64BaseAssembler.OperandSize.QWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, imm32);
    }

    public final void andq(Register dst, AMD64Address src) {
        AMD64BinaryArithmetic.AND.getRMOpcode(AMD64BaseAssembler.OperandSize.QWORD).emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void andq(Register dst, Register src) {
        AMD64BinaryArithmetic.AND.getRMOpcode(AMD64BaseAssembler.OperandSize.QWORD).emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void mulq(Register src) {
        AMD64MOp.MUL.emit(this, AMD64BaseAssembler.OperandSize.QWORD, src);
    }

    public final void mulxq(Register dst1, Register dst2, Register src) {
        VexGeneralPurposeRVMOp.MULX.emit(this, AVXKind.AVXSize.QWORD, dst1, dst2, src);
    }

    public final void roll(Register dst, int imm8) {
        GraalError.guarantee(NumUtil.isByte(imm8), "only byte immediate is supported");
        AMD64Shift.ROL.miOp.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, (int)((byte)imm8));
    }

    public final void rorq(Register dst, int imm8) {
        GraalError.guarantee(NumUtil.isByte(imm8), "only byte immediate is supported");
        AMD64Shift.ROR.miOp.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, (int)((byte)imm8));
    }

    public final void rorxl(Register dst, Register src, int imm8) {
        VexRMIOp.RORXL.emit(this, AVXKind.AVXSize.QWORD, dst, src, (int)((byte)imm8));
    }

    public final void rorxq(Register dst, Register src, int imm8) {
        VexRMIOp.RORXQ.emit(this, AVXKind.AVXSize.QWORD, dst, src, (int)((byte)imm8));
    }

    public final void rclq(Register dst, int imm8) {
        GraalError.guarantee(NumUtil.isByte(imm8), "only byte immediate is supported");
        AMD64Shift.RCL.miOp.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, (int)((byte)imm8));
    }

    public final void rcrq(Register dst, int imm8) {
        GraalError.guarantee(NumUtil.isByte(imm8), "only byte immediate is supported");
        AMD64Shift.RCR.miOp.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, (int)((byte)imm8));
    }

    public final void bsrq(Register dst, Register src) {
        this.prefixq(dst, src);
        this.emitByte(15);
        this.emitByte(189);
        this.emitModRM(dst, src);
    }

    public final void bswapq(Register reg) {
        this.prefixq(reg);
        this.emitByte(15);
        this.emitByte(200 + AMD64Assembler.encode(reg));
    }

    public final void cdqq() {
        this.rexw();
        this.emitByte(153);
    }

    public final void repStosb() {
        this.emitByte(243);
        this.rexw();
        this.emitByte(170);
    }

    public final void repStosq() {
        this.emitByte(243);
        this.rexw();
        this.emitByte(171);
    }

    public final void cmovq(ConditionFlag cc, Register dst, Register src) {
        this.prefixq(dst, src);
        this.emitByte(15);
        this.emitByte(0x40 | cc.getValue());
        this.emitModRM(dst, src);
    }

    public final void setb(ConditionFlag cc, Register dst) {
        this.prefix(dst, true);
        this.emitByte(15);
        this.emitByte(0x90 | cc.getValue());
        this.emitModRM(0, dst);
    }

    public final void cmovq(ConditionFlag cc, Register dst, AMD64Address src) {
        this.prefixq(src, dst);
        this.emitByte(15);
        this.emitByte(0x40 | cc.getValue());
        this.emitOperandHelper(dst, src, 0);
    }

    public final void cmpq(Register dst, int imm32) {
        AMD64BinaryArithmetic.CMP.getMIOpcode(AMD64BaseAssembler.OperandSize.QWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, imm32);
    }

    public final void cmpq(Register dst, Register src) {
        AMD64BinaryArithmetic.CMP.rmOp.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void cmpq(Register dst, AMD64Address src) {
        AMD64BinaryArithmetic.CMP.rmOp.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void cmpxchgq(Register reg, AMD64Address adr) {
        this.prefixq(adr, reg);
        this.emitByte(15);
        this.emitByte(177);
        this.emitOperandHelper(reg, adr, 0);
    }

    public final void cvtdq2pd(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.SS, 15, false);
        this.emitByte(230);
        this.emitModRM(dst, src);
    }

    public final void cvtsi2sdq(Register dst, Register src) {
        SSEOp.CVTSI2SD.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void cvttss2sil(Register dst, Register src) {
        SSEOp.CVTTSS2SI.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void cvttsd2siq(Register dst, Register src) {
        SSEOp.CVTTSD2SI.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void cvttpd2dq(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(230);
        this.emitModRM(dst, src);
    }

    public final void decq(Register dst) {
        AMD64MOp.DEC.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst);
    }

    public final void decq(AMD64Address dst) {
        AMD64MOp.DEC.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst);
    }

    public final void imulq(Register dst, Register src) {
        AMD64RMOp.IMUL.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void incq(Register dst) {
        AMD64MOp.INC.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst);
    }

    public final void incq(AMD64Address dst) {
        AMD64MOp.INC.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst);
    }

    public final void movq(Register dst, long imm64) {
        this.movq(dst, imm64, false);
    }

    public final void movq(Register dst, long imm64, boolean annotateImm) {
        int insnPos = this.position();
        this.prefixq(dst);
        this.emitByte(184 + AMD64Assembler.encode(dst));
        int immPos = this.position();
        this.emitLong(imm64);
        int nextInsnPos = this.position();
        if (annotateImm && this.codePatchingAnnotationConsumer != null) {
            this.codePatchingAnnotationConsumer.accept(new AMD64BaseAssembler.OperandDataAnnotation(insnPos, immPos, nextInsnPos - immPos, nextInsnPos));
        }
    }

    public final void movslq(Register dst, int imm32) {
        this.prefixq(dst);
        this.emitByte(199);
        this.emitModRM(0, dst);
        this.emitInt(imm32);
    }

    public final void movdq(Register dst, AMD64Address src) {
        SSEOp.MOVQ.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void movdq(AMD64Address dst, Register src) {
        SSEMROp.MOVQ.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void movdq(Register dst, Register src) {
        if (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.CPU, src)) {
            SSEOp.MOVQ.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
        } else if (AMD64Assembler.inRC(AMD64.XMM, src) && AMD64Assembler.inRC(AMD64.CPU, dst)) {
            SSEMROp.MOVQ.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
        } else {
            throw new InternalError("should not reach here");
        }
    }

    public final void movdl(Register dst, Register src) {
        if (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.CPU, src)) {
            SSEOp.MOVD.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
        } else if (AMD64Assembler.inRC(AMD64.XMM, src) && AMD64Assembler.inRC(AMD64.CPU, dst)) {
            SSEMROp.MOVD.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
        } else {
            throw new InternalError("should not reach here");
        }
    }

    public final void movdl(Register dst, AMD64Address src) {
        SSEOp.MOVD.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void movddup(Register dst, Register src) {
        assert (this.supports(AMD64.CPUFeature.SSE3));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.SD, 15, false);
        this.emitByte(18);
        this.emitModRM(dst, src);
    }

    public final void movdqu(Register dst, AMD64Address src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.SS, 15, false);
        this.emitByte(111);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void movdqu(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.SS, 15, false);
        this.emitByte(111);
        this.emitModRM(dst, src);
    }

    public final void movdqu(AMD64Address dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, src));
        this.simdPrefix(src, Register.None, dst, AMD64BaseAssembler.OperandSize.SS, 15, false);
        this.emitByte(127);
        this.emitOperandHelper(src, dst, 0);
    }

    public final void movdqa(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(111);
        this.emitModRM(dst, src);
    }

    public final void movslq(AMD64Address dst, int imm32) {
        this.prefixq(dst);
        this.emitByte(199);
        this.emitOperandHelper(0, dst, 4);
        this.emitInt(imm32);
    }

    public final void movslq(Register dst, AMD64Address src) {
        this.prefixq(src, dst);
        this.emitByte(99);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void movslq(Register dst, Register src) {
        this.prefixq(dst, src);
        this.emitByte(99);
        this.emitModRM(dst, src);
    }

    public final void negq(Register dst) {
        this.prefixq(dst);
        this.emitByte(247);
        this.emitModRM(3, dst);
    }

    public final void orq(Register dst, Register src) {
        AMD64BinaryArithmetic.OR.rmOp.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void orq(Register dst, AMD64Address src) {
        AMD64BinaryArithmetic.OR.rmOp.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void orq(Register dst, int imm32) {
        AMD64BinaryArithmetic.OR.getMIOpcode(AMD64BaseAssembler.OperandSize.QWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, imm32);
    }

    public final void shlq(Register dst, int imm8) {
        assert (NumUtil.isShiftCount(imm8 >> 1)) : "illegal shift count";
        this.prefixq(dst);
        if (imm8 == 1) {
            this.emitByte(209);
            this.emitModRM(4, dst);
        } else {
            this.emitByte(193);
            this.emitModRM(4, dst);
            this.emitByte(imm8);
        }
    }

    public final void shlq(Register dst) {
        this.prefixq(dst);
        this.emitByte(211);
        this.emitModRM(4, dst);
    }

    public final void shrq(Register dst, int imm8) {
        assert (NumUtil.isShiftCount(imm8 >> 1)) : "illegal shift count";
        this.prefixq(dst);
        if (imm8 == 1) {
            this.emitByte(209);
            this.emitModRM(5, dst);
        } else {
            this.emitByte(193);
            this.emitModRM(5, dst);
            this.emitByte(imm8);
        }
    }

    public final void shrq(Register dst) {
        this.prefixq(dst);
        this.emitByte(211);
        this.emitModRM(5, dst);
    }

    public final void sarq(Register dst, int imm8) {
        assert (NumUtil.isShiftCount(imm8 >> 1)) : "illegal shift count";
        this.prefixq(dst);
        if (imm8 == 1) {
            this.emitByte(209);
            this.emitModRM(7, dst);
        } else {
            this.emitByte(193);
            this.emitModRM(7, dst);
            this.emitByte(imm8);
        }
    }

    public final void sarq(Register dst) {
        this.prefixq(dst);
        this.emitByte(211);
        this.emitModRM(7, dst);
    }

    public final void sbbq(Register dst, Register src) {
        AMD64BinaryArithmetic.SBB.rmOp.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void subq(Register dst, int imm32) {
        AMD64BinaryArithmetic.SUB.getMIOpcode(AMD64BaseAssembler.OperandSize.QWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, imm32);
    }

    public final void subq(AMD64Address dst, int imm32) {
        AMD64BinaryArithmetic.SUB.getMIOpcode(AMD64BaseAssembler.OperandSize.QWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, imm32);
    }

    public final void subqWide(Register dst, int imm32) {
        AMD64BinaryArithmetic.SUB.getMIOpcode(AMD64BaseAssembler.OperandSize.QWORD, false).emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, imm32);
    }

    public final void subq(Register dst, Register src) {
        AMD64BinaryArithmetic.SUB.rmOp.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void sqrtsd(Register dst, Register src) {
        SSEOp.SQRT.emit(this, AMD64BaseAssembler.OperandSize.SD, dst, src);
    }

    public final void testq(Register dst, Register src) {
        AMD64RMOp.TEST.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void testq(Register dst, AMD64Address src) {
        AMD64RMOp.TEST.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void btrq(Register src, int imm8) {
        this.prefixq(src);
        this.emitByte(15);
        this.emitByte(186);
        this.emitModRM(6, src);
        this.emitByte(imm8);
    }

    public final void xaddb(AMD64Address dst, Register src) {
        this.prefixb(dst, src);
        this.emitByte(15);
        this.emitByte(192);
        this.emitOperandHelper(src, dst, 0);
    }

    public final void xaddw(AMD64Address dst, Register src) {
        this.emitByte(102);
        this.prefix(dst, src);
        this.emitByte(15);
        this.emitByte(193);
        this.emitOperandHelper(src, dst, 0);
    }

    public final void xaddl(AMD64Address dst, Register src) {
        this.prefix(dst, src);
        this.emitByte(15);
        this.emitByte(193);
        this.emitOperandHelper(src, dst, 0);
    }

    public final void xaddq(AMD64Address dst, Register src) {
        this.prefixq(dst, src);
        this.emitByte(15);
        this.emitByte(193);
        this.emitOperandHelper(src, dst, 0);
    }

    public final void xchgb(Register dst, AMD64Address src) {
        this.prefixb(src, dst);
        this.emitByte(134);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void xchgw(Register dst, AMD64Address src) {
        this.emitByte(102);
        this.prefix(src, dst);
        this.emitByte(135);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void xchgl(Register dst, AMD64Address src) {
        this.prefix(src, dst);
        this.emitByte(135);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void xchgq(Register dst, AMD64Address src) {
        this.prefixq(src, dst);
        this.emitByte(135);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void sha1msg1(Register dst, Register src) {
        AMD64RMOp.SHA1MSG1.emit(this, AMD64BaseAssembler.OperandSize.PS, dst, src);
    }

    public final void sha1msg2(Register dst, Register src) {
        AMD64RMOp.SHA1MSG2.emit(this, AMD64BaseAssembler.OperandSize.PS, dst, src);
    }

    public final void sha1nexte(Register dst, Register src) {
        AMD64RMOp.SHA1NEXTE.emit(this, AMD64BaseAssembler.OperandSize.PS, dst, src);
    }

    public final void sha1rnds4(Register dst, Register src, int imm8) {
        AMD64RMIOp.SHA1RNDS4.emit(this, AMD64BaseAssembler.OperandSize.PS, dst, src, imm8);
    }

    public final void sha256msg1(Register dst, Register src) {
        AMD64RMOp.SHA256MSG1.emit(this, AMD64BaseAssembler.OperandSize.PS, dst, src);
    }

    public final void sha256msg2(Register dst, Register src) {
        AMD64RMOp.SHA256MSG2.emit(this, AMD64BaseAssembler.OperandSize.PS, dst, src);
    }

    public final void sha256rnds2(Register dst, Register src) {
        AMD64RMOp.SHA256RNDS2.emit(this, AMD64BaseAssembler.OperandSize.PS, dst, src);
    }

    public final void membar(int barriers) {
        if (this.isTargetMP() && (barriers & 4) != 0) {
            this.lock();
            this.addl(new AMD64Address(AMD64.rsp, 0), 0);
        }
    }

    @Override
    protected final void patchJumpTarget(int branch, int branchTarget) {
        int op = this.getByte(branch);
        assert (op == 232 || op == 0 || op == 233 || op == 235 || (op & 0xF0) == 112 || op == 15 && (this.getByte(branch + 1) & 0xF0) == 128) : "Invalid opcode at patch point branch=" + branch + ", branchTarget=" + branchTarget + ", op=" + op;
        if (op == 0) {
            int offsetToJumpTableBase = this.getShort(branch + 1);
            int jumpTableBase = branch - offsetToJumpTableBase;
            int imm32 = branchTarget - jumpTableBase;
            this.emitInt(imm32, branch);
        } else if (op == 235 || (op & 0xF0) == 112) {
            int imm8 = branchTarget - (branch + 2);
            GraalError.guarantee(NumUtil.isByte(imm8), "Displacement too large to be encoded as a byte: %d", (Object)imm8);
            this.emitByte(imm8, branch + 1);
        } else {
            int off = 1;
            if (op == 15) {
                off = 2;
            }
            int imm32 = branchTarget - (branch + 4 + off);
            this.emitInt(imm32, branch + off);
        }
    }

    public void nullCheck(AMD64Address address) {
        this.testl(AMD64.rax, address);
    }

    @Override
    public void align(int modulus) {
        if (this.position() % modulus != 0) {
            this.nop(modulus - this.position() % modulus);
        }
    }

    protected final void call() {
        this.annotatePatchingImmediate(1, 4);
        this.emitByte(232);
        this.emitInt(0);
    }

    public final void call(Label l) {
        if (l.isBound()) {
            this.emitByte(232);
            this.emitInt(l.position());
        } else {
            l.addPatchAt(this.position(), this);
            this.emitByte(232);
            this.emitInt(0);
        }
    }

    public final void call(Register src) {
        this.prefix(src);
        this.emitByte(255);
        this.emitModRM(2, src);
    }

    protected final void endbranch() {
        this.emitByte(243);
        this.emitByte(15);
        this.emitByte(30);
        this.emitByte(250);
    }

    public final void int3() {
        this.emitByte(204);
    }

    public final void pause() {
        this.emitByte(243);
        this.emitByte(144);
    }

    private void emitx87(int b1, int b2, int i) {
        assert (0 <= i && i < 8) : "illegal stack offset";
        this.emitByte(b1);
        this.emitByte(b2 + i);
    }

    public final void fldd(AMD64Address src) {
        this.emitByte(221);
        this.emitOperandHelper(0, src, 0);
    }

    public final void flds(AMD64Address src) {
        this.emitByte(217);
        this.emitOperandHelper(0, src, 0);
    }

    public final void fldln2() {
        this.emitByte(217);
        this.emitByte(237);
    }

    public final void fldlg2() {
        this.emitByte(217);
        this.emitByte(236);
    }

    public final void fyl2x() {
        this.emitByte(217);
        this.emitByte(241);
    }

    public final void fstps(AMD64Address src) {
        this.emitByte(217);
        this.emitOperandHelper(3, src, 0);
    }

    public final void fstpd(AMD64Address src) {
        this.emitByte(221);
        this.emitOperandHelper(3, src, 0);
    }

    private void emitFPUArith(int b1, int b2, int i) {
        assert (0 <= i && i < 8) : "illegal FPU register: " + i;
        this.emitByte(b1);
        this.emitByte(b2 + i);
    }

    public void ffree(int i) {
        this.emitFPUArith(221, 192, i);
    }

    public void fincstp() {
        this.emitByte(217);
        this.emitByte(247);
    }

    public void fxch(int i) {
        this.emitFPUArith(217, 200, i);
    }

    public void fnstswAX() {
        this.emitByte(223);
        this.emitByte(224);
    }

    public void fwait() {
        this.emitByte(155);
    }

    public void fprem() {
        this.emitByte(217);
        this.emitByte(248);
    }

    public final void fsin() {
        this.emitByte(217);
        this.emitByte(254);
    }

    public final void fcos() {
        this.emitByte(217);
        this.emitByte(255);
    }

    public final void fptan() {
        this.emitByte(217);
        this.emitByte(242);
    }

    public final void fstp(int i) {
        this.emitx87(221, 216, i);
    }

    @Override
    public AMD64Address makeAddress(int transferSize, Register base, int displacement) {
        return this.makeAddress(base, displacement);
    }

    public AMD64Address makeAddress(Register base, int displacement) {
        return new AMD64Address(base, displacement);
    }

    @Override
    public AMD64Address getPlaceholder(int instructionStartPosition) {
        return new AMD64Address(AMD64.rip, Register.None, Stride.S1, 0, null, instructionStartPosition);
    }

    private void prefetchPrefix(AMD64Address src) {
        this.prefix(src);
        this.emitByte(15);
    }

    public void prefetchnta(AMD64Address src) {
        this.prefetchPrefix(src);
        this.emitByte(24);
        this.emitOperandHelper(0, src, 0);
    }

    void prefetchr(AMD64Address src) {
        assert (this.supports(AMD64.CPUFeature.AMD_3DNOW_PREFETCH));
        this.prefetchPrefix(src);
        this.emitByte(13);
        this.emitOperandHelper(0, src, 0);
    }

    public void prefetcht0(AMD64Address src) {
        assert (this.supports(AMD64.CPUFeature.SSE));
        this.prefetchPrefix(src);
        this.emitByte(24);
        this.emitOperandHelper(1, src, 0);
    }

    public void prefetcht1(AMD64Address src) {
        assert (this.supports(AMD64.CPUFeature.SSE));
        this.prefetchPrefix(src);
        this.emitByte(24);
        this.emitOperandHelper(2, src, 0);
    }

    public void prefetcht2(AMD64Address src) {
        assert (this.supports(AMD64.CPUFeature.SSE));
        this.prefix(src);
        this.emitByte(15);
        this.emitByte(24);
        this.emitOperandHelper(3, src, 0);
    }

    public void prefetchw(AMD64Address src) {
        assert (this.supports(AMD64.CPUFeature.AMD_3DNOW_PREFETCH));
        this.prefix(src);
        this.emitByte(15);
        this.emitByte(13);
        this.emitOperandHelper(1, src, 0);
    }

    public void rdtsc() {
        this.emitByte(15);
        this.emitByte(49);
    }

    public void rdtscp() {
        this.emitByte(15);
        this.emitByte(1);
        this.emitByte(249);
    }

    public void rdpid(Register dst) {
        assert (this.supports("RDPID"));
        this.emitByte(243);
        this.prefix(dst);
        this.emitByte(15);
        this.emitByte(199);
        this.emitModRM(7, dst);
    }

    public void illegal() {
        this.emitByte(15);
        this.emitByte(11);
    }

    public void lfence() {
        this.emitByte(15);
        this.emitByte(174);
        this.emitByte(232);
    }

    public void sfence() {
        assert (this.supports(AMD64.CPUFeature.SSE2));
        this.emitByte(15);
        this.emitByte(174);
        this.emitByte(248);
    }

    public void clflush(AMD64Address adr) {
        this.prefix(adr);
        this.emitByte(15);
        this.emitByte(174);
        this.emitOperandHelper(7, adr, 0);
    }

    public final void vpaddd(Register dst, Register nds, Register src, AVXKind.AVXSize size) {
        VexRVMOp.VPADDD.emit(this, size, dst, nds, src);
    }

    public final void vpaddd(Register dst, Register nds, AMD64Address src, AVXKind.AVXSize size) {
        VexRVMOp.VPADDD.emit(this, size, dst, nds, src);
    }

    public final void vpaddq(Register dst, Register nds, Register src, AVXKind.AVXSize size) {
        VexRVMOp.VPADDQ.emit(this, size, dst, nds, src);
    }

    public final void vpaddq(Register dst, Register nds, AMD64Address src, AVXKind.AVXSize size) {
        VexRVMOp.VPADDQ.emit(this, size, dst, nds, src);
    }

    public final void vpand(Register dst, Register nds, Register src, AVXKind.AVXSize size) {
        VexRVMOp.VPAND.emit(this, size, dst, nds, src);
    }

    public final void vpandn(Register dst, Register nds, Register src) {
        VexRVMOp.VPANDN.emit(this, AVXKind.AVXSize.YMM, dst, nds, src);
    }

    public final void vpor(Register dst, Register nds, Register src, AVXKind.AVXSize size) {
        VexRVMOp.VPOR.emit(this, size, dst, nds, src);
    }

    public final void vptest(Register dst, Register src, AVXKind.AVXSize size) {
        VexRMOp.VPTEST.emit(this, size, dst, src);
    }

    public final void vpxor(Register dst, Register nds, Register src, AVXKind.AVXSize size) {
        VexRVMOp.VPXOR.emit(this, size, dst, nds, src);
    }

    public final void vpxor(Register dst, Register nds, AMD64Address src, AVXKind.AVXSize size) {
        VexRVMOp.VPXOR.emit(this, size, dst, nds, src);
    }

    public final void vpsllw(Register dst, Register src, int imm8) {
        VexShiftOp.VPSLLW.emit(this, AVXKind.AVXSize.YMM, dst, src, imm8);
    }

    public final void vpsrlw(Register dst, Register src, int imm8) {
        VexShiftOp.VPSRLW.emit(this, AVXKind.AVXSize.YMM, dst, src, imm8);
    }

    public final void vpslld(Register dst, Register src, int imm8, AVXKind.AVXSize size) {
        VexShiftOp.VPSLLD.emit(this, size, dst, src, imm8);
    }

    public final void vpslldq(Register dst, Register src, int imm8, AVXKind.AVXSize size) {
        VexShiftImmOp.VPSLLDQ.emit(this, size, dst, src, imm8);
    }

    public final void vpsrld(Register dst, Register src, int imm8, AVXKind.AVXSize size) {
        VexShiftOp.VPSRLD.emit(this, size, dst, src, imm8);
    }

    public final void vpsrldq(Register dst, Register src, int imm8, AVXKind.AVXSize size) {
        VexShiftImmOp.VPSRLDQ.emit(this, size, dst, src, imm8);
    }

    public final void vpcmpeqb(Register dst, Register src1, Register src2) {
        VexRVMOp.VPCMPEQB.emit(this, AVXKind.AVXSize.YMM, dst, src1, src2);
    }

    public final void vpcmpeqw(Register dst, Register src1, Register src2) {
        VexRVMOp.VPCMPEQW.emit(this, AVXKind.AVXSize.YMM, dst, src1, src2);
    }

    public final void vpcmpeqd(Register dst, Register src1, Register src2) {
        VexRVMOp.VPCMPEQD.emit(this, AVXKind.AVXSize.YMM, dst, src1, src2);
    }

    public final void vpmovmskb(Register dst, Register src) {
        VexRMOp.VPMOVMSKB.emit(this, AVXKind.AVXSize.YMM, dst, src);
    }

    public final void vmovdqu(Register dst, AMD64Address src) {
        VexMoveOp.VMOVDQU32.emit(this, AVXKind.AVXSize.YMM, dst, src);
    }

    public final void vmovdqu(Register dst, Register src) {
        VexMoveOp.VMOVDQU32.emit(this, AVXKind.AVXSize.YMM, dst, src);
    }

    public final void vmovdqu(AMD64Address dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, src));
        VexMoveOp.VMOVDQU32.emit(this, AVXKind.AVXSize.YMM, dst, src);
    }

    public final void vmovdqu64(Register dst, AMD64Address src) {
        VexMoveOp.VMOVDQU64.emit(this, AVXKind.AVXSize.ZMM, dst, src);
    }

    public final void vmovdqu64(AMD64Address dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, src));
        VexMoveOp.VMOVDQU64.emit(this, AVXKind.AVXSize.ZMM, dst, src);
    }

    public final void vpmovzxbw(Register dst, AMD64Address src) {
        assert (this.supports(AMD64.CPUFeature.AVX2));
        VexRMOp.VPMOVZXBW.emit(this, AVXKind.AVXSize.YMM, dst, src);
    }

    public final void vpalignr(Register dst, Register nds, Register src, int imm8, AVXKind.AVXSize size) {
        VexRVMIOp.VPALIGNR.emit(this, size, dst, nds, src, imm8);
    }

    public final void vperm2f128(Register dst, Register nds, Register src, int imm8) {
        VexRVMIOp.VPERM2F128.emit(this, AVXKind.AVXSize.YMM, dst, nds, src, imm8);
    }

    public final void vperm2i128(Register dst, Register nds, Register src, int imm8) {
        VexRVMIOp.VPERM2I128.emit(this, AVXKind.AVXSize.YMM, dst, nds, src, imm8);
    }

    public final void vzeroupper() {
        this.emitVEX(0, 0, 1, 0, 0, 0, true);
        this.emitByte(119);
    }

    public final void aesenc(Register dst, Register src) {
        assert (this.supports(AMD64.CPUFeature.AES));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 14351, false);
        this.emitByte(220);
        this.emitModRM(dst, src);
    }

    public final void aesenclast(Register dst, Register src) {
        assert (this.supports(AMD64.CPUFeature.AES));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 14351, false);
        this.emitByte(221);
        this.emitModRM(dst, src);
    }

    public final void aesdec(Register dst, Register src) {
        assert (this.supports(AMD64.CPUFeature.AES));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 14351, false);
        this.emitByte(222);
        this.emitModRM(dst, src);
    }

    public final void aesdeclast(Register dst, Register src) {
        assert (this.supports(AMD64.CPUFeature.AES));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 14351, false);
        this.emitByte(223);
        this.emitModRM(dst, src);
    }

    public final void kortestd(Register src1, Register src2) {
        assert (this.supports(AMD64.CPUFeature.AVX512BW));
        assert (AMD64Assembler.inRC(AMD64.MASK, src1) && AMD64Assembler.inRC(AMD64.MASK, src2)) : String.valueOf(src1) + " " + String.valueOf(src2);
        this.vexPrefix(src1, Register.None, src2, AVXKind.AVXSize.XMM, 1, 1, 1, 1, true);
        this.emitByte(152);
        this.emitModRM(src1, src2);
    }

    public final void kortestq(Register src1, Register src2) {
        assert (this.supports(AMD64.CPUFeature.AVX512BW));
        assert (AMD64Assembler.inRC(AMD64.MASK, src1) && AMD64Assembler.inRC(AMD64.MASK, src2)) : Assertions.errorMessage(src1, src2);
        this.vexPrefix(src1, Register.None, src2, AVXKind.AVXSize.XMM, 0, 1, 1, 1, true);
        this.emitByte(152);
        this.emitModRM(src1, src2);
    }

    public final void kmovb(Register dst, Register src) {
        VexMoveMaskOp.KMOVB.emit(this, AVXKind.AVXSize.XMM, dst, src);
    }

    public final void kmovb(AMD64Address dst, Register src) {
        VexMoveMaskOp.KMOVB.emit(this, AVXKind.AVXSize.XMM, dst, src);
    }

    public final void kmovb(Register dst, AMD64Address src) {
        VexMoveMaskOp.KMOVB.emit(this, AVXKind.AVXSize.XMM, dst, src);
    }

    public final void kmovw(Register dst, Register src) {
        VexMoveMaskOp.KMOVW.emit(this, AVXKind.AVXSize.XMM, dst, src);
    }

    public final void kmovw(AMD64Address dst, Register src) {
        VexMoveMaskOp.KMOVW.emit(this, AVXKind.AVXSize.XMM, dst, src);
    }

    public final void kmovw(Register dst, AMD64Address src) {
        VexMoveMaskOp.KMOVW.emit(this, AVXKind.AVXSize.XMM, dst, src);
    }

    public final void kmovd(Register dst, Register src) {
        VexMoveMaskOp.KMOVD.emit(this, AVXKind.AVXSize.XMM, dst, src);
    }

    public final void kmovd(AMD64Address dst, Register src) {
        VexMoveMaskOp.KMOVD.emit(this, AVXKind.AVXSize.XMM, dst, src);
    }

    public final void kmovd(Register dst, AMD64Address src) {
        VexMoveMaskOp.KMOVD.emit(this, AVXKind.AVXSize.XMM, dst, src);
    }

    public final void kmovq(Register dst, Register src) {
        VexMoveMaskOp.KMOVQ.emit(this, AVXKind.AVXSize.XMM, dst, src);
    }

    public final void kmovq(AMD64Address dst, Register src) {
        VexMoveMaskOp.KMOVQ.emit(this, AVXKind.AVXSize.XMM, dst, src);
    }

    public final void kmovq(Register dst, AMD64Address src) {
        VexMoveMaskOp.KMOVQ.emit(this, AVXKind.AVXSize.XMM, dst, src);
    }

    public final void ktestd(Register src1, Register src2) {
        assert (this.supports(AMD64.CPUFeature.AVX512BW));
        assert (AMD64Assembler.inRC(AMD64.MASK, src1) && AMD64Assembler.inRC(AMD64.MASK, src2)) : String.valueOf(src1) + " " + String.valueOf(src2);
        this.vexPrefix(src1, Register.None, src2, AVXKind.AVXSize.XMM, 1, 1, 1, 1, true);
        this.emitByte(153);
        this.emitModRM(src1, src2);
    }

    public final void ktestq(Register src1, Register src2) {
        assert (this.supports(AMD64.CPUFeature.AVX512BW));
        assert (AMD64Assembler.inRC(AMD64.MASK, src1) && AMD64Assembler.inRC(AMD64.MASK, src2)) : String.valueOf(src1) + " " + String.valueOf(src2);
        this.vexPrefix(src1, Register.None, src2, AVXKind.AVXSize.XMM, 0, 1, 1, 1, true);
        this.emitByte(153);
        this.emitModRM(src1, src2);
    }

    public final void evmovdqu64(Register dst, AMD64Address src) {
        assert (this.supports(AMD64.CPUFeature.AVX512F));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.evexPrefix(dst, Register.None, Register.None, src, AVXKind.AVXSize.ZMM, 2, 1, 1, 0, 0);
        this.emitByte(111);
        this.emitOperandHelper(dst, src, 0, AMD64BaseAssembler.EVEXTuple.FVM.getDisp8ScalingFactor(AVXKind.AVXSize.ZMM));
    }

    public final void evmovdqu64(AMD64Address dst, Register src) {
        assert (this.supports(AMD64.CPUFeature.AVX512F));
        assert (AMD64Assembler.inRC(AMD64.XMM, src));
        this.evexPrefix(src, Register.None, Register.None, dst, AVXKind.AVXSize.ZMM, 2, 1, 1, 0, 0);
        this.emitByte(127);
        this.emitOperandHelper(src, dst, 0, AMD64BaseAssembler.EVEXTuple.FVM.getDisp8ScalingFactor(AVXKind.AVXSize.ZMM));
    }

    public final void evpmovzxbw(Register dst, AMD64Address src) {
        assert (this.supports(AMD64.CPUFeature.AVX512BW));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.evexPrefix(dst, Register.None, Register.None, src, AVXKind.AVXSize.ZMM, 1, 2, 0, 0, 0);
        this.emitByte(48);
        this.emitOperandHelper(dst, src, 0, AMD64BaseAssembler.EVEXTuple.HVM.getDisp8ScalingFactor(AVXKind.AVXSize.ZMM));
    }

    public final void evpcmpeqb(Register kdst, Register nds, AMD64Address src) {
        assert (this.supports(AMD64.CPUFeature.AVX512BW));
        assert (AMD64Assembler.inRC(AMD64.MASK, kdst) && AMD64Assembler.inRC(AMD64.XMM, nds)) : String.valueOf(kdst) + " " + String.valueOf(nds);
        this.evexPrefix(kdst, Register.None, nds, src, AVXKind.AVXSize.ZMM, 1, 1, 0, 0, 0);
        this.emitByte(116);
        this.emitOperandHelper(kdst, src, 0, AMD64BaseAssembler.EVEXTuple.FVM.getDisp8ScalingFactor(AVXKind.AVXSize.ZMM));
    }

    public final void evmovdqu16(Register dst, AMD64Address src) {
        assert (this.supports(AMD64.CPUFeature.AVX512BW));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.evexPrefix(dst, Register.None, Register.None, src, AVXKind.AVXSize.ZMM, 3, 1, 1, 0, 0);
        this.emitByte(111);
        this.emitOperandHelper(dst, src, 0, AMD64BaseAssembler.EVEXTuple.FVM.getDisp8ScalingFactor(AVXKind.AVXSize.ZMM));
    }

    public final void evmovdqu16(Register dst, Register mask, AMD64Address src) {
        assert (this.supports(AMD64.CPUFeature.AVX512BW));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.MASK, mask)) : String.valueOf(dst) + " " + String.valueOf(mask);
        this.evexPrefix(dst, mask, Register.None, src, AVXKind.AVXSize.ZMM, 3, 1, 1, 1, 0);
        this.emitByte(111);
        this.emitOperandHelper(dst, src, 0, AMD64BaseAssembler.EVEXTuple.FVM.getDisp8ScalingFactor(AVXKind.AVXSize.ZMM));
    }

    public final void evmovdqu16(AMD64Address dst, Register src) {
        assert (this.supports(AMD64.CPUFeature.AVX512BW));
        assert (AMD64Assembler.inRC(AMD64.XMM, src));
        this.evexPrefix(src, Register.None, Register.None, dst, AVXKind.AVXSize.ZMM, 3, 1, 1, 0, 0);
        this.emitByte(127);
        this.emitOperandHelper(src, dst, 0, AMD64BaseAssembler.EVEXTuple.FVM.getDisp8ScalingFactor(AVXKind.AVXSize.ZMM));
    }

    public final void evmovdqu16(AMD64Address dst, Register mask, Register src) {
        assert (this.supports(AMD64.CPUFeature.AVX512BW));
        assert (AMD64Assembler.inRC(AMD64.MASK, mask) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(mask) + " " + String.valueOf(src);
        this.evexPrefix(src, mask, Register.None, dst, AVXKind.AVXSize.ZMM, 3, 1, 1, 0, 0);
        this.emitByte(127);
        this.emitOperandHelper(src, dst, 0, AMD64BaseAssembler.EVEXTuple.FVM.getDisp8ScalingFactor(AVXKind.AVXSize.ZMM));
    }

    public final void evpbroadcastw(Register dst, Register src) {
        assert (this.supports(AMD64.CPUFeature.AVX512BW));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.CPU, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.evexPrefix(dst, Register.None, Register.None, src, AVXKind.AVXSize.ZMM, 1, 2, 0, 0, 0);
        this.emitByte(123);
        this.emitModRM(dst, src);
    }

    public final void evpcmpuw(Register kdst, Register nds, Register src, int vcc) {
        assert (this.supports(AMD64.CPUFeature.AVX512BW));
        assert (AMD64Assembler.inRC(AMD64.MASK, kdst) && AMD64Assembler.inRC(AMD64.XMM, nds) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(kdst) + " " + String.valueOf(src);
        this.evexPrefix(kdst, Register.None, nds, src, AVXKind.AVXSize.ZMM, 1, 3, 1, 0, 0);
        this.emitByte(62);
        this.emitModRM(kdst, src);
        this.emitByte(vcc);
    }

    public final void evpcmpuw(Register kdst, Register mask, Register nds, Register src, int vcc) {
        assert (this.supports(AMD64.CPUFeature.AVX512BW));
        assert (AMD64Assembler.inRC(AMD64.MASK, kdst) && AMD64Assembler.inRC(AMD64.MASK, mask)) : String.valueOf(kdst) + " " + String.valueOf(mask);
        assert (AMD64Assembler.inRC(AMD64.XMM, nds) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(nds) + " " + String.valueOf(src);
        this.evexPrefix(kdst, mask, nds, src, AVXKind.AVXSize.ZMM, 1, 3, 1, 0, 0);
        this.emitByte(62);
        this.emitModRM(kdst, src);
        this.emitByte(vcc);
    }

    public final void evpcmpgtb(Register kdst, Register nds, AMD64Address src) {
        assert (this.supports(AMD64.CPUFeature.AVX512BW));
        assert (AMD64Assembler.inRC(AMD64.MASK, kdst));
        assert (AMD64Assembler.inRC(AMD64.XMM, nds));
        this.evexPrefix(kdst, Register.None, nds, src, AVXKind.AVXSize.ZMM, 1, 1, 0, 0, 0);
        this.emitByte(100);
        this.emitOperandHelper(kdst, src, 0, AMD64BaseAssembler.EVEXTuple.FVM.getDisp8ScalingFactor(AVXKind.AVXSize.ZMM));
    }

    public final void evpcmpgtb(Register kdst, Register mask, Register nds, AMD64Address src) {
        assert (this.supports(AMD64.CPUFeature.AVX512BW));
        assert (AMD64Assembler.inRC(AMD64.MASK, kdst) && AMD64Assembler.inRC(AMD64.MASK, mask)) : String.valueOf(kdst) + " " + String.valueOf(mask);
        assert (AMD64Assembler.inRC(AMD64.XMM, nds));
        this.evexPrefix(kdst, mask, nds, src, AVXKind.AVXSize.ZMM, 1, 1, 0, 0, 0);
        this.emitByte(100);
        this.emitOperandHelper(kdst, src, 0, AMD64BaseAssembler.EVEXTuple.FVM.getDisp8ScalingFactor(AVXKind.AVXSize.ZMM));
    }

    public final void evpmovwb(AMD64Address dst, Register src) {
        assert (this.supports(AMD64.CPUFeature.AVX512BW));
        assert (AMD64Assembler.inRC(AMD64.XMM, src));
        this.evexPrefix(src, Register.None, Register.None, dst, AVXKind.AVXSize.ZMM, 2, 2, 0, 0, 0);
        this.emitByte(48);
        this.emitOperandHelper(src, dst, 0, AMD64BaseAssembler.EVEXTuple.HVM.getDisp8ScalingFactor(AVXKind.AVXSize.ZMM));
    }

    public final void evpmovwb(AMD64Address dst, Register mask, Register src) {
        assert (this.supports(AMD64.CPUFeature.AVX512BW));
        assert (AMD64Assembler.inRC(AMD64.MASK, mask) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(mask) + " " + String.valueOf(src);
        this.evexPrefix(src, mask, Register.None, dst, AVXKind.AVXSize.ZMM, 2, 2, 0, 0, 0);
        this.emitByte(48);
        this.emitOperandHelper(src, dst, 0, AMD64BaseAssembler.EVEXTuple.HVM.getDisp8ScalingFactor(AVXKind.AVXSize.ZMM));
    }

    public final void evpmovzxbw(Register dst, Register mask, AMD64Address src) {
        assert (this.supports(AMD64.CPUFeature.AVX512BW));
        assert (AMD64Assembler.inRC(AMD64.MASK, mask) && AMD64Assembler.inRC(AMD64.XMM, dst)) : String.valueOf(mask) + " " + String.valueOf(dst);
        this.evexPrefix(dst, mask, Register.None, src, AVXKind.AVXSize.ZMM, 1, 2, 0, 0, 0);
        this.emitByte(48);
        this.emitOperandHelper(dst, src, 0, AMD64BaseAssembler.EVEXTuple.HVM.getDisp8ScalingFactor(AVXKind.AVXSize.ZMM));
    }

    public final void vfpclassss(Register dst, Register mask, Register src, int imm8) {
        assert (this.supports(AMD64.CPUFeature.AVX512DQ));
        assert (AMD64Assembler.inRC(AMD64.MASK, mask) && AMD64Assembler.inRC(AMD64.MASK, mask) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(mask) + " " + String.valueOf(src);
        this.evexPrefix(dst, mask, Register.None, src, AVXKind.AVXSize.XMM, 1, 3, 0, 0, 0);
        this.emitByte(103);
        this.emitModRM(dst, src);
        this.emitByte(imm8);
    }

    public static class Options {
        public static final OptionKey<Boolean> UseBranchesWithin32ByteBoundary = new OptionKey<Boolean>(false);
    }

    private static class UnionRegisterCategory
    extends Register.RegisterCategory {
        private final Register.RegisterCategory[] categories;

        UnionRegisterCategory(String name, Register.RegisterCategory ... categories) {
            super(name);
            this.categories = categories;
        }

        public boolean contains(Register r) {
            for (Register.RegisterCategory category : this.categories) {
                if (!r.getRegisterCategory().equals((Object)category)) continue;
                return true;
            }
            return false;
        }
    }

    public static class VexRMOp
    extends VexRROp {
        public static final VexRMOp VAESIMC = new VexRMOp("VAESIMC", 1, 2, 0, 219, VEXOpAssertion.AVX1_128ONLY_AES);
        public static final VexRMOp VCVTTSS2SI = new VexRMOp("VCVTTSS2SI", 2, 1, 0, 44, VEXOpAssertion.CPU_XMM_AVX512F_128ONLY, AMD64BaseAssembler.EVEXTuple.T1F_32BIT, 0);
        public static final VexRMOp VCVTTSS2SQ = new VexRMOp("VCVTTSS2SQ", 2, 1, 1, 44, VEXOpAssertion.CPU_XMM_AVX512F_128ONLY, AMD64BaseAssembler.EVEXTuple.T1F_32BIT, 1);
        public static final VexRMOp VCVTTSD2SI = new VexRMOp("VCVTTSD2SI", 3, 1, 0, 44, VEXOpAssertion.CPU_XMM_AVX512F_128ONLY, AMD64BaseAssembler.EVEXTuple.T1F_64BIT, 0);
        public static final VexRMOp VCVTTSD2SQ = new VexRMOp("VCVTTSD2SQ", 3, 1, 1, 44, VEXOpAssertion.CPU_XMM_AVX512F_128ONLY, AMD64BaseAssembler.EVEXTuple.T1F_64BIT, 1);
        public static final VexRMOp VCVTPS2PD = new VexRMOp("VCVTPS2PD", 0, 1, 0, 90, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.HVM, 0);
        public static final VexRMOp VCVTPD2PS = new VexRMOp("VCVTPD2PS", 1, 1, 0, 90, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRMOp VCVTDQ2PS = new VexRMOp("VCVTDQ2PS", 0, 1, 0, 91, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRMOp VCVTQQ2PS = new VexRMOp("VCVTQQ2PS", 0, 1, 1, 91, VEXOpAssertion.AVX512DQ_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRMOp VCVTQQ2PD = new VexRMOp("VCVTQQ2PD", 2, 1, 1, 230, VEXOpAssertion.AVX512DQ_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRMOp VCVTTPS2DQ = new VexRMOp("VCVTTPS2DQ", 2, 1, 0, 91, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRMOp VCVTTPS2QQ = new VexRMOp("VCVTTPS2QQ", 1, 1, 0, 122, VEXOpAssertion.AVX512DQ_VL, AMD64BaseAssembler.EVEXTuple.HVM, 0);
        public static final VexRMOp VCVTTPD2DQ = new VexRMOp("VCVTTPD2DQ", 1, 1, 0, 230, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRMOp VCVTTPD2QQ = new VexRMOp("VCVTTPD2QQ", 1, 1, 1, 122, VEXOpAssertion.AVX512DQ_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRMOp VCVTDQ2PD = new VexRMOp("VCVTDQ2PD", 2, 1, 0, 230, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.HVM, 0);
        public static final VexRMOp VBROADCASTSS = new VexRMOp("VBROADCASTSS", 1, 2, 0, 24, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRMOp VBROADCASTSD = new VexRMOp("VBROADCASTSD", 1, 2, 0, 25, VEXOpAssertion.AVX1_256ONLY_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRMOp VBROADCASTF128 = new VexRMOp("VBROADCASTF128", 1, 2, 0, 26, VEXOpAssertion.AVX1_256ONLY);
        public static final VexRMOp VPBROADCASTI128 = new VexRMOp("VPBROADCASTI128", 1, 2, 0, 90, VEXOpAssertion.AVX2_256ONLY);
        public static final VexRMOp VPBROADCASTB = new VexRMOp("VPBROADCASTB", 1, 2, 0, 120, VEXOpAssertion.AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRMOp VPBROADCASTW = new VexRMOp("VPBROADCASTW", 1, 2, 0, 121, VEXOpAssertion.AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRMOp VPBROADCASTD = new VexRMOp("VPBROADCASTD", 1, 2, 0, 88, VEXOpAssertion.AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRMOp VPBROADCASTQ = new VexRMOp("VPBROADCASTQ", 1, 2, 0, 89, VEXOpAssertion.AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRMOp VPMOVMSKB = new VexRMOp("VPMOVMSKB", 1, 1, 0, 215, VEXOpAssertion.AVX1_2_CPU_XMM);
        public static final VexRMOp VPMOVB2M = new VexRMOp("VPMOVB2M", 2, 2, 0, 41, VEXOpAssertion.MASK_NULL_XMM_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRMOp VPMOVW2M = new VexRMOp("VPMOVW2M", 2, 2, 1, 41, VEXOpAssertion.MASK_NULL_XMM_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRMOp VPMOVD2M = new VexRMOp("VPMOVD2M", 2, 2, 0, 57, VEXOpAssertion.MASK_NULL_XMM_AVX512DQ_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRMOp VPMOVQ2M = new VexRMOp("VPMOVQ2M", 2, 2, 1, 57, VEXOpAssertion.MASK_NULL_XMM_AVX512DQ_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRMOp VPMOVSXBW = new VexRMOp("VPMOVSXBW", 1, 2, 0, 32, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.HVM, 0);
        public static final VexRMOp VPMOVSXBD = new VexRMOp("VPMOVSXBD", 1, 2, 0, 33, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.QVM, 0);
        public static final VexRMOp VPMOVSXBQ = new VexRMOp("VPMOVSXBQ", 1, 2, 0, 34, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.OVM, 0);
        public static final VexRMOp VPMOVSXWD = new VexRMOp("VPMOVSXWD", 1, 2, 0, 35, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.HVM, 0);
        public static final VexRMOp VPMOVSXWQ = new VexRMOp("VPMOVSXWQ", 1, 2, 0, 36, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.QVM, 0);
        public static final VexRMOp VPMOVSXDQ = new VexRMOp("VPMOVSXDQ", 1, 2, 0, 37, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.HVM, 0);
        public static final VexRMOp VPMOVZXBW = new VexRMOp("VPMOVZXBW", 1, 2, 0, 48, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.HVM, 0);
        public static final VexRMOp VPMOVZXBD = new VexRMOp("VPMOVZXBD", 1, 2, 0, 49, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.QVM, 0);
        public static final VexRMOp VPMOVZXBQ = new VexRMOp("VPMOVZXBQ", 1, 2, 0, 50, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.OVM, 0);
        public static final VexRMOp VPMOVZXWD = new VexRMOp("VPMOVZXWD", 1, 2, 0, 51, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.HVM, 0);
        public static final VexRMOp VPMOVZXWQ = new VexRMOp("VPMOVZXWQ", 1, 2, 0, 52, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.QVM, 0);
        public static final VexRMOp VPMOVZXDQ = new VexRMOp("VPMOVZXDQ", 1, 2, 0, 53, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.HVM, 0);
        public static final VexRMOp VPTEST = new VexRMOp("VPTEST", 1, 2, 0, 23);
        public static final VexRMOp VSQRTPD = new VexRMOp("VSQRTPD", 1, 1, 0, 81, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRMOp VSQRTPS = new VexRMOp("VSQRTPS", 0, 1, 0, 81, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRMOp VUCOMISS = new VexRMOp("VUCOMISS", 0, 1, 0, 46, VEXOpAssertion.AVX1_AVX512F_128_ONLY, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final VexRMOp VUCOMISD = new VexRMOp("VUCOMISD", 1, 1, 0, 46, VEXOpAssertion.AVX1_AVX512F_128_ONLY, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final VexRMOp VPABSB = new VexRMOp("VPABSB", 1, 2, 0, 28, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRMOp VPABSW = new VexRMOp("VPABSW", 1, 2, 0, 29, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRMOp VPABSD = new VexRMOp("VPABSD", 1, 2, 0, 30, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRMOp VPABSQ = new VexRMOp("VPABSQ", 1, 2, 0, 31, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRMOp VCVTPH2PS = new VexRMOp("VCVTPH2PS", 1, 2, 0, 19, VEXOpAssertion.F16C_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.HVM, 0);

        protected VexRMOp(String opcode, int pp, int mmmmm, int w, int op) {
            this(opcode, pp, mmmmm, w, op, VEXOpAssertion.AVX1, AMD64BaseAssembler.EVEXTuple.INVALID, 0);
        }

        protected VexRMOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion) {
            this(opcode, pp, mmmmm, w, op, assertion, AMD64BaseAssembler.EVEXTuple.INVALID, 0);
        }

        protected VexRMOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, AMD64Address src) {
            this.emit(asm, size, dst, src, Register.None, 0, 0);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src, Register mask, int z, int b) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, dst, null, src), "emitting invalid instruction");
            asm.vexPrefix(dst, Register.None, src, mask, size, this.pp, this.mmmmm, this.w, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature, z, b);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, AMD64Address src, Register mask, int z, int b) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, dst, null, null), "emitting invalid instruction");
            boolean useEvex = asm.vexPrefix(dst, Register.None, src, mask, size, this.pp, this.mmmmm, this.w, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature, z, b);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, src, 0, this.getDisp8Scale(useEvex, size));
        }
    }

    public static class VexRMIOp
    extends VexOp
    implements VexRRIOp {
        public static final VexRMIOp VAESKEYGENASSIST = new VexRMIOp("VAESKEYGENASSIST", 1, 3, 0, 223, VEXOpAssertion.AVX1_128ONLY_AES);
        public static final VexRMIOp VPERMQ = new VexRMIOp("VPERMQ", 1, 3, 1, 0, VEXOpAssertion.AVX2_AVX512F_VL_256_512, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRMIOp VPSHUFLW = new VexRMIOp("VPSHUFLW", 3, 1, 0, 112, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRMIOp VPSHUFHW = new VexRMIOp("VPSHUFHW", 2, 1, 0, 112, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRMIOp VPSHUFD = new VexRMIOp("VPSHUFD", 1, 1, 0, 112, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRMIOp RORXL = new VexRMIOp("RORXL", 3, 3, 0, 240, VEXOpAssertion.BMI2);
        public static final VexRMIOp RORXQ = new VexRMIOp("RORXQ", 3, 3, 1, 240, VEXOpAssertion.BMI2);

        protected VexRMIOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, op, assertion, AMD64BaseAssembler.EVEXTuple.INVALID, 0);
        }

        protected VexRMIOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src, int imm8) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, dst, null, src), "emitting invalid instruction");
            asm.vexPrefix(dst, Register.None, src, size, this.pp, this.mmmmm, this.w, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src);
            asm.emitByte(imm8);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, AMD64Address src, int imm8) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, dst, null, null), "emitting invalid instruction");
            boolean useEvex = asm.vexPrefix(dst, Register.None, src, size, this.pp, this.mmmmm, this.w, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, src, 1, this.getDisp8Scale(useEvex, size));
            asm.emitByte(imm8);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src, int imm8, Register mask, int z, int b) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, dst, null, src), "emitting invalid instruction");
            asm.evexPrefix(dst, mask, Register.None, src, size, this.pp, this.mmmmm, this.wEvex, z, b);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src);
            asm.emitByte(imm8);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, AMD64Address src, int imm8, Register mask, int z, int b) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, dst, null, null), "emitting invalid instruction");
            asm.evexPrefix(dst, mask, Register.None, src, size, this.pp, this.mmmmm, this.wEvex, z, b);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, src, 1, this.getDisp8Scale(true, size));
            asm.emitByte(imm8);
        }
    }

    public static final class VexMRIOp
    extends VexOp
    implements VexRRIOp {
        public static final VexMRIOp VPEXTRB = new VexMRIOp("VPEXTRB", 1, 3, 0, 20, VEXOpAssertion.XMM_CPU);
        public static final VexMRIOp VPEXTRW = new VexMRIOp("VPEXTRW", 1, 3, 0, 21, VEXOpAssertion.XMM_CPU);
        public static final VexMRIOp VPEXTRD = new VexMRIOp("VPEXTRD", 1, 3, 0, 22, VEXOpAssertion.XMM_CPU);
        public static final VexMRIOp VPEXTRQ = new VexMRIOp("VPEXTRQ", 1, 3, 1, 22, VEXOpAssertion.XMM_CPU);
        public static final VexMRIOp VEXTRACTF128 = new VexMRIOp("VEXTRACTF128", 1, 3, 0, 25, VEXOpAssertion.AVX1_256ONLY);
        public static final VexMRIOp VEXTRACTI128 = new VexMRIOp("VEXTRACTI128", 1, 3, 0, 57, VEXOpAssertion.AVX2_256ONLY);
        public static final VexMRIOp VEXTRACTF32X4 = new VexMRIOp("VEXTRACTF32X4", 1, 3, 0, 25, VEXOpAssertion.AVX512F_VL_256_512, AMD64BaseAssembler.EVEXTuple.T4_32BIT, 0);
        public static final VexMRIOp VEXTRACTI32X4 = new VexMRIOp("VEXTRACTI32X4", 1, 3, 0, 57, VEXOpAssertion.AVX512F_VL_256_512, AMD64BaseAssembler.EVEXTuple.T4_32BIT, 0);
        public static final VexMRIOp VEXTRACTF64X2 = new VexMRIOp("VEXTRACTF64X2", 1, 3, 1, 25, VEXOpAssertion.AVX512DQ_VL_256_512, AMD64BaseAssembler.EVEXTuple.T2_64BIT, 1);
        public static final VexMRIOp VEXTRACTI64X2 = new VexMRIOp("VEXTRACTI64X2", 1, 3, 1, 57, VEXOpAssertion.AVX512DQ_VL_256_512, AMD64BaseAssembler.EVEXTuple.T2_64BIT, 1);
        public static final VexMRIOp VEXTRACTF32X8 = new VexMRIOp("VEXTRACTF32X8", 1, 3, 0, 27, VEXOpAssertion.AVX512DQ_512ONLY, AMD64BaseAssembler.EVEXTuple.T8_32BIT, 0);
        public static final VexMRIOp VEXTRACTI32X8 = new VexMRIOp("VEXTRACTI32X8", 1, 3, 0, 59, VEXOpAssertion.AVX512DQ_512ONLY, AMD64BaseAssembler.EVEXTuple.T8_32BIT, 0);
        public static final VexMRIOp VEXTRACTF64X4 = new VexMRIOp("VEXTRACTF64X2", 1, 3, 1, 27, VEXOpAssertion.AVX512F_512ONLY, AMD64BaseAssembler.EVEXTuple.T4_64BIT, 1);
        public static final VexMRIOp VEXTRACTI64X4 = new VexMRIOp("VEXTRACTI64X2", 1, 3, 1, 59, VEXOpAssertion.AVX512F_512ONLY, AMD64BaseAssembler.EVEXTuple.T4_64BIT, 1);
        public static final VexMRIOp VCVTPS2PH = new VexMRIOp("VCVTPS2PH", 1, 3, 0, 29, VEXOpAssertion.F16C_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.HVM, 0);

        private VexMRIOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, op, assertion);
        }

        private VexMRIOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src, int imm8) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, src, null, dst), "emitting invalid instruction");
            asm.vexPrefix(src, Register.None, dst, size, this.pp, this.mmmmm, this.w, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature);
            asm.emitByte(this.op);
            asm.emitModRM(src, dst);
            asm.emitByte(imm8);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, AMD64Address dst, Register src, int imm8) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, src, null, null), "emitting invalid instruction");
            boolean useEvex = asm.vexPrefix(src, Register.None, dst, size, this.pp, this.mmmmm, this.w, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature);
            asm.emitByte(this.op);
            asm.emitOperandHelper(src, dst, 1, this.getDisp8Scale(useEvex, size));
            asm.emitByte(imm8);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src, int imm8, Register mask, int z, int b) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, src, null, dst), "emitting invalid instruction");
            asm.vexPrefix(src, Register.None, dst, mask, size, this.pp, this.mmmmm, this.w, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature, z, b);
            asm.emitByte(this.op);
            asm.emitModRM(src, dst);
            asm.emitByte(imm8);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, AMD64Address dst, Register src, int imm8, Register mask, int z, int b) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, src, null, null), "emitting invalid instruction");
            boolean useEvex = asm.vexPrefix(src, Register.None, dst, mask, size, this.pp, this.mmmmm, this.w, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature, z, b);
            asm.emitByte(this.op);
            asm.emitOperandHelper(src, dst, 1, this.getDisp8Scale(useEvex, size));
            asm.emitByte(imm8);
        }
    }

    public static class VexRVMOp
    extends VexOp {
        public static final VexRVMOp VANDPS = new VexRVMOp("VANDPS", 0, 1, 0, 84, VEXOpAssertion.AVX1_AVX512DQ_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VANDPD = new VexRVMOp("VANDPD", 1, 1, 0, 84, VEXOpAssertion.AVX1_AVX512DQ_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VANDNPS = new VexRVMOp("VANDNPS", 0, 1, 0, 85, VEXOpAssertion.AVX1_AVX512DQ_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VANDNPD = new VexRVMOp("VANDNPD", 1, 1, 0, 85, VEXOpAssertion.AVX1_AVX512DQ_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VORPS = new VexRVMOp("VORPS", 0, 1, 0, 86, VEXOpAssertion.AVX1_AVX512DQ_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VORPD = new VexRVMOp("VORPD", 1, 1, 0, 86, VEXOpAssertion.AVX1_AVX512DQ_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VXORPS = new VexRVMOp("VXORPS", 0, 1, 0, 87, VEXOpAssertion.AVX1_AVX512DQ_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VXORPD = new VexRVMOp("VXORPD", 1, 1, 0, 87, VEXOpAssertion.AVX1_AVX512DQ_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VADDPS = new VexRVMOp("VADDPS", 0, 1, 0, 88, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VADDPD = new VexRVMOp("VADDPD", 1, 1, 0, 88, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VADDSS = new VexRVMOp("VADDSS", 2, 1, 0, 88, VEXOpAssertion.AVX1_AVX512F_128_ONLY, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final VexRVMOp VADDSD = new VexRVMOp("VADDSD", 3, 1, 0, 88, VEXOpAssertion.AVX1_AVX512F_128_ONLY, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final VexRVMOp VMULPS = new VexRVMOp("VMULPS", 0, 1, 0, 89, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VMULPD = new VexRVMOp("VMULPD", 1, 1, 0, 89, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VMULSS = new VexRVMOp("VMULSS", 2, 1, 0, 89, VEXOpAssertion.AVX1_AVX512F_128_ONLY, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final VexRVMOp VMULSD = new VexRVMOp("VMULSD", 3, 1, 0, 89, VEXOpAssertion.AVX1_AVX512F_128_ONLY, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final VexRVMOp VSUBPS = new VexRVMOp("VSUBPS", 0, 1, 0, 92, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VSUBPD = new VexRVMOp("VSUBPD", 1, 1, 0, 92, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VSUBSS = new VexRVMOp("VSUBSS", 2, 1, 0, 92, VEXOpAssertion.AVX1_AVX512F_128_ONLY, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final VexRVMOp VSUBSD = new VexRVMOp("VSUBSD", 3, 1, 0, 92, VEXOpAssertion.AVX1_AVX512F_128_ONLY, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final VexRVMOp VMINPS = new VexRVMOp("VMINPS", 0, 1, 0, 93, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VMINPD = new VexRVMOp("VMINPD", 1, 1, 0, 93, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VMINSS = new VexRVMOp("VMINSS", 2, 1, 0, 93, VEXOpAssertion.AVX1_128ONLY_AVX512F_128ONLY, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final VexRVMOp VMINSD = new VexRVMOp("VMINSD", 3, 1, 0, 93, VEXOpAssertion.AVX1_128ONLY_AVX512F_128ONLY, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final VexRVMOp VDIVPS = new VexRVMOp("VDIVPS", 0, 1, 0, 94, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VDIVPD = new VexRVMOp("VDIVPD", 1, 1, 0, 94, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VDIVSS = new VexRVMOp("VDIVSS", 2, 1, 0, 94, VEXOpAssertion.AVX1_AVX512F_128_ONLY, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final VexRVMOp VDIVSD = new VexRVMOp("VDIVSD", 3, 1, 0, 94, VEXOpAssertion.AVX1_AVX512F_128_ONLY, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final VexRVMOp VMAXPS = new VexRVMOp("VMAXPS", 0, 1, 0, 95, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VMAXPD = new VexRVMOp("VMAXPD", 1, 1, 0, 95, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VMAXSS = new VexRVMOp("VMAXSS", 2, 1, 0, 95, VEXOpAssertion.AVX1_128ONLY_AVX512F_128ONLY, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final VexRVMOp VMAXSD = new VexRVMOp("VMAXSD", 3, 1, 0, 95, VEXOpAssertion.AVX1_128ONLY_AVX512F_128ONLY, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final VexRVMOp VPACKUSDW = new VexRVMOp("VPACKUSDW", 1, 2, 0, 43, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPACKUSWB = new VexRVMOp("VPACKUSWB", 1, 1, 0, 103, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VADDSUBPS = new VexRVMOp("VADDSUBPS", 3, 1, 0, 208, VEXOpAssertion.AVX1);
        public static final VexRVMOp VADDSUBPD = new VexRVMOp("VADDSUBPD", 1, 1, 0, 208, VEXOpAssertion.AVX1);
        public static final VexRVMOp VPAND = new VexRVMOp("VPAND", 1, 1, 0, 219, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VPANDN = new VexRVMOp("VPANDN", 1, 1, 0, 223, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VPOR = new VexRVMOp("VPOR", 1, 1, 0, 235, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VPXOR = new VexRVMOp("VPXOR", 1, 1, 0, 239, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VPADDB = new VexRVMOp("VPADDB", 1, 1, 0, 252, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPADDW = new VexRVMOp("VPADDW", 1, 1, 0, 253, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPADDD = new VexRVMOp("VPADDD", 1, 1, 0, 254, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPADDQ = new VexRVMOp("VPADDQ", 1, 1, 0, 212, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VPMAXSB = new VexRVMOp("VPMAXSB", 1, 2, 0, 60, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPMAXSW = new VexRVMOp("VPMAXSW", 1, 1, 0, 238, VEXOpAssertion.AVX1_AVX2_AVX512F_BW, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPMAXSD = new VexRVMOp("VPMAXSD", 1, 2, 0, 61, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPMAXSQ = new VexRVMOp("VPMAXSQ", 1, 2, 1, 61, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VPMAXUB = new VexRVMOp("VPMAXUB", 1, 1, 0, 222, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPMAXUW = new VexRVMOp("VPMAXUW", 1, 2, 0, 62, VEXOpAssertion.AVX1_AVX2_AVX512F_BW, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPMAXUD = new VexRVMOp("VPMAXUD", 1, 2, 0, 63, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPMAXUQ = new VexRVMOp("VPMAXUQ", 1, 2, 1, 63, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VPMINSB = new VexRVMOp("VPMINSB", 1, 2, 0, 56, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPMINSW = new VexRVMOp("VPMINSW", 1, 1, 0, 234, VEXOpAssertion.AVX1_AVX2_AVX512F_BW, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPMINSD = new VexRVMOp("VPMINSD", 1, 2, 0, 57, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPMINSQ = new VexRVMOp("VPMINSQ", 1, 2, 1, 57, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VPMINUB = new VexRVMOp("VPMINUB", 1, 1, 0, 218, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPMINUW = new VexRVMOp("VPMINUW", 1, 2, 0, 58, VEXOpAssertion.AVX1_AVX2_AVX512F_BW, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPMINUD = new VexRVMOp("VPMINUD", 1, 2, 0, 59, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPMINUQ = new VexRVMOp("VPMINUQ", 1, 2, 1, 59, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VPMULHUW = new VexRVMOp("VPMULHUW", 1, 1, 0, 228, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPMULHW = new VexRVMOp("VPMULHW", 1, 1, 0, 229, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPMULLW = new VexRVMOp("VPMULLW", 1, 1, 0, 213, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPMULLD = new VexRVMOp("VPMULLD", 1, 2, 0, 64, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPMULLQ = new VexRVMOp("VPMULLQ", 1, 2, 1, 64, VEXOpAssertion.AVX512DQ_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VPSUBUSB = new VexRVMOp("VPSUBUSB", 1, 1, 0, 216, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPSUBUSW = new VexRVMOp("VPSUBUSW", 1, 1, 0, 217, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPSUBB = new VexRVMOp("VPSUBB", 1, 1, 0, 248, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPSUBW = new VexRVMOp("VPSUBW", 1, 1, 0, 249, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPSUBD = new VexRVMOp("VPSUBD", 1, 1, 0, 250, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPSUBQ = new VexRVMOp("VPSUBQ", 1, 1, 0, 251, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VPSHUFB = new VexRVMOp("VPSHUFB", 1, 2, 0, 0, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPCMPEQB = new VexRVMOp("VPCMPEQB", 1, 1, 0, 116, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPCMPEQB_AVX512 = new VexRVMOp("VPCMPEQB", 1, 1, 0, 116, VEXOpAssertion.MASK_XMM_XMM_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPCMPEQW = new VexRVMOp("VPCMPEQW", 1, 1, 0, 117, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPCMPEQW_AVX512 = new VexRVMOp("VPCMPEQW", 1, 1, 0, 117, VEXOpAssertion.MASK_XMM_XMM_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPCMPEQD = new VexRVMOp("VPCMPEQD", 1, 1, 0, 118, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPCMPEQD_AVX512 = new VexRVMOp("VPCMPEQD", 1, 1, 0, 118, VEXOpAssertion.MASK_XMM_XMM_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPCMPEQQ = new VexRVMOp("VPCMPEQQ", 1, 2, 0, 41, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPCMPEQQ_AVX512 = new VexRVMOp("VPCMPEQQ", 1, 2, 0, 41, VEXOpAssertion.MASK_XMM_XMM_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VPCMPGTB = new VexRVMOp("VPCMPGTB", 1, 1, 0, 100, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPCMPGTB_AVX512 = new VexRVMOp("VPCMPGTB", 1, 1, 0, 100, VEXOpAssertion.MASK_XMM_XMM_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPCMPGTW = new VexRVMOp("VPCMPGTW", 1, 1, 0, 101, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPCMPGTW_AVX512 = new VexRVMOp("VPCMPGTW", 1, 1, 0, 101, VEXOpAssertion.MASK_XMM_XMM_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPCMPGTD = new VexRVMOp("VPCMPGTD", 1, 1, 0, 102, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPCMPGTD_AVX512 = new VexRVMOp("VPCMPGTD", 1, 1, 0, 102, VEXOpAssertion.MASK_XMM_XMM_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPCMPGTQ = new VexRVMOp("VPCMPGTQ", 1, 2, 0, 55, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPCMPGTQ_AVX512 = new VexRVMOp("VPCMPGTQ", 1, 2, 0, 55, VEXOpAssertion.MASK_XMM_XMM_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VFMADD231SS = new VexRVMOp("VFMADD231SS", 1, 2, 0, 185, VEXOpAssertion.FMA_AVX512F_128ONLY, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final VexRVMOp VFMADD231SD = new VexRVMOp("VFMADD231SD", 1, 2, 1, 185, VEXOpAssertion.FMA_AVX512F_128ONLY, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final VexRVMOp VSQRTSD = new VexRVMOp("VSQRTSD", 3, 1, 0, 81, VEXOpAssertion.AVX1_AVX512F_ALL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VSQRTSS = new VexRVMOp("VSQRTSS", 2, 1, 0, 81, VEXOpAssertion.AVX1_AVX512F_ALL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPERMW = new VexRVMOp("VPERMW", 1, 2, 1, 141, VEXOpAssertion.AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VPERMD = new VexRVMOp("VPERMD", 1, 2, 0, 54, VEXOpAssertion.AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPBLENDMB = new VexRVMOp("VPBLENDMB", 1, 2, 0, 102, VEXOpAssertion.AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPBLENDMW = new VexRVMOp("VPBLENDMW", 1, 2, 1, 102, VEXOpAssertion.AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VPBLENDMD = new VexRVMOp("VPBLENDMD", 1, 2, 0, 100, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPBLENDMQ = new VexRVMOp("VPBLENDMQ", 1, 2, 1, 100, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VBLENDMPS = new VexRVMOp("VBLENDMPS", 1, 2, 0, 101, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VBLENDMPD = new VexRVMOp("VBLENDMPD", 1, 2, 1, 101, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VPERMT2B = new VexRVMOp("VPERMT2B", 1, 2, 0, 125, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp MOVLHPS = new VexRVMOp("MOVLHPS", 0, 1, 0, 22, VEXOpAssertion.XMM_XMM_XMM_AVX512F_128ONLY, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPHADDW = new VexRVMOp("VPHADDW", 1, 2, 0, 1, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPHADDD = new VexRVMOp("VPHADDD", 1, 2, 0, 2, VEXOpAssertion.AVX1_2);

        protected VexRVMOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, op, assertion);
        }

        private VexRVMOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, Register src2) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, dst, src1, src2), "emitting invalid instruction");
            asm.vexPrefix(dst, src1, src2, size, this.pp, this.mmmmm, this.w, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src2);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, AMD64Address src2) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, dst, src1, null), "emitting invalid instruction");
            boolean useEvex = asm.vexPrefix(dst, src1, src2, size, this.pp, this.mmmmm, this.w, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, src2, 0, this.getDisp8Scale(useEvex, size));
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, Register src2, Register mask) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, dst, src1, src2), "emitting invalid instruction");
            asm.vexPrefix(dst, src1, src2, mask, size, this.pp, this.mmmmm, this.w, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature, 0, 0);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src2);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, AMD64Address src2, Register mask) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, dst, src1, null), "emitting invalid instruction");
            boolean useEvex = asm.vexPrefix(dst, src1, src2, mask, size, this.pp, this.mmmmm, this.w, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature, 0, 0);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, src2, 0, this.getDisp8Scale(useEvex, size));
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, Register src2, Register mask, int z, int b) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, dst, src1, src2), "emitting invalid instruction");
            asm.vexPrefix(dst, src1, src2, mask, size, this.pp, this.mmmmm, this.w, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature, z, b);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src2);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, AMD64Address src2, Register mask, int z, int b) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, dst, src1, null), "emitting invalid instruction");
            boolean useEvex = asm.vexPrefix(dst, src1, src2, mask, size, this.pp, this.mmmmm, this.w, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature, z, b);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, src2, 0, this.getDisp8Scale(useEvex, size));
        }

        public boolean isPacked() {
            return this.pp == 0 || this.pp == 1;
        }
    }

    public static final class VexGeneralPurposeRMVOp
    extends VexOp {
        public static final VexGeneralPurposeRMVOp BEXTR = new VexGeneralPurposeRMVOp("BEXTR", 0, 2, 0, 247, VEXOpAssertion.BMI1);
        public static final VexGeneralPurposeRMVOp BZHI = new VexGeneralPurposeRMVOp("BZHI", 0, 2, 0, 245, VEXOpAssertion.BMI2);
        public static final VexGeneralPurposeRMVOp SARX = new VexGeneralPurposeRMVOp("SARX", 2, 2, 0, 247, VEXOpAssertion.BMI2);
        public static final VexGeneralPurposeRMVOp SHRX = new VexGeneralPurposeRMVOp("SHRX", 3, 2, 0, 247, VEXOpAssertion.BMI2);
        public static final VexGeneralPurposeRMVOp SHLX = new VexGeneralPurposeRMVOp("SHLX", 1, 2, 0, 247, VEXOpAssertion.BMI2);

        private VexGeneralPurposeRMVOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, op, assertion);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, Register src2) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), 0, dst, src2, src1, null), "emitting invalid instruction");
            assert (size == AVXKind.AVXSize.DWORD || size == AVXKind.AVXSize.QWORD) : size;
            asm.vexPrefix(dst, src2, src1, size, this.pp, this.mmmmm, size == AVXKind.AVXSize.DWORD ? 0 : 1, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src1);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, AMD64Address src1, Register src2) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), 0, dst, src2, null, null), "emitting invalid instruction");
            assert (size == AVXKind.AVXSize.DWORD || size == AVXKind.AVXSize.QWORD) : size;
            asm.vexPrefix(dst, src2, src1, size, this.pp, this.mmmmm, size == AVXKind.AVXSize.DWORD ? 0 : 1, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, src1, 0);
        }
    }

    public static final class AMD64BinaryArithmetic {
        public static final AMD64BinaryArithmetic ADD = new AMD64BinaryArithmetic("ADD", 0);
        public static final AMD64BinaryArithmetic OR = new AMD64BinaryArithmetic("OR", 1);
        public static final AMD64BinaryArithmetic ADC = new AMD64BinaryArithmetic("ADC", 2);
        public static final AMD64BinaryArithmetic SBB = new AMD64BinaryArithmetic("SBB", 3);
        public static final AMD64BinaryArithmetic AND = new AMD64BinaryArithmetic("AND", 4);
        public static final AMD64BinaryArithmetic SUB = new AMD64BinaryArithmetic("SUB", 5);
        public static final AMD64BinaryArithmetic XOR = new AMD64BinaryArithmetic("XOR", 6);
        public static final AMD64BinaryArithmetic CMP = new AMD64BinaryArithmetic("CMP", 7);
        private final AMD64MIOp byteImmOp;
        private final AMD64MROp byteMrOp;
        private final AMD64RMOp byteRmOp;
        private final AMD64MIOp immOp;
        private final AMD64MIOp immSxOp;
        private final AMD64MROp mrOp;
        private final AMD64RMOp rmOp;

        private AMD64BinaryArithmetic(String opcode, int code) {
            int baseOp = code << 3;
            this.byteImmOp = new AMD64MIOp(opcode, true, 0, 128, code, OpAssertion.ByteAssertion);
            this.byteMrOp = new AMD64MROp(opcode, 0, baseOp, OpAssertion.ByteAssertion);
            this.byteRmOp = new AMD64RMOp(opcode, 0, baseOp | 2, OpAssertion.ByteAssertion);
            this.immOp = new AMD64MIOp(opcode, false, 0, 129, code, OpAssertion.WordOrLargerAssertion);
            this.immSxOp = new AMD64MIOp(opcode, true, 0, 131, code, OpAssertion.WordOrLargerAssertion);
            this.mrOp = new AMD64MROp(opcode, 0, baseOp | 1, OpAssertion.WordOrLargerAssertion);
            this.rmOp = new AMD64RMOp(opcode, 0, baseOp | 3, OpAssertion.WordOrLargerAssertion);
        }

        public AMD64MIOp getMIOpcode(AMD64BaseAssembler.OperandSize size, boolean sx) {
            if (size == AMD64BaseAssembler.OperandSize.BYTE) {
                return this.byteImmOp;
            }
            if (sx) {
                return this.immSxOp;
            }
            return this.immOp;
        }

        public AMD64MROp getMROpcode(AMD64BaseAssembler.OperandSize size) {
            if (size == AMD64BaseAssembler.OperandSize.BYTE) {
                return this.byteMrOp;
            }
            return this.mrOp;
        }

        public AMD64RMOp getRMOpcode(AMD64BaseAssembler.OperandSize size) {
            if (size == AMD64BaseAssembler.OperandSize.BYTE) {
                return this.byteRmOp;
            }
            return this.rmOp;
        }
    }

    public static class AMD64MIOp
    extends AMD64ImmOp {
        public static final AMD64MIOp MOVB = new AMD64MIOp("MOVB", true, 198, 0, OpAssertion.ByteAssertion);
        public static final AMD64MIOp MOV = new AMD64MIOp("MOV", false, 199, 0);
        public static final AMD64MIOp TEST = new AMD64MIOp("TEST", false, 247, 0);
        private final int ext;

        protected AMD64MIOp(String opcode, boolean immIsByte, int op, int ext) {
            this(opcode, immIsByte, op, ext, OpAssertion.WordOrLargerAssertion);
        }

        protected AMD64MIOp(String opcode, boolean immIsByte, int op, int ext, OpAssertion assertion) {
            this(opcode, immIsByte, 0, op, ext, assertion);
        }

        protected AMD64MIOp(String opcode, boolean immIsByte, int prefix, int op, int ext, OpAssertion assertion) {
            super(opcode, immIsByte, prefix, op, assertion);
            this.ext = ext;
        }

        public final void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register dst, int imm) {
            this.emit(asm, size, dst, imm, false);
        }

        public final void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register dst, int imm, boolean annotateImm) {
            assert (this.verify(asm, size, dst, null));
            int insnPos = asm.position();
            this.emitOpcode(asm, size, AMD64BaseAssembler.getRXB(null, dst), 0, dst.encoding);
            asm.emitModRM(this.ext, dst);
            int immPos = asm.position();
            this.emitImmediate(asm, size, imm);
            int nextInsnPos = asm.position();
            if (annotateImm && asm.codePatchingAnnotationConsumer != null) {
                asm.codePatchingAnnotationConsumer.accept(new AMD64BaseAssembler.OperandDataAnnotation(insnPos, immPos, nextInsnPos - immPos, nextInsnPos));
            }
        }

        public final void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, AMD64Address dst, int imm) {
            this.emit(asm, size, dst, imm, false);
        }

        public final void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, AMD64Address dst, int imm, boolean annotateImm) {
            assert (this.verify(asm, size, null, null));
            int insnPos = asm.position();
            this.emitOpcode(asm, size, AMD64BaseAssembler.getRXB(null, dst), 0, 0);
            asm.emitOperandHelper(this.ext, dst, this.immediateSize(size));
            int immPos = asm.position();
            this.emitImmediate(asm, size, imm);
            int nextInsnPos = asm.position();
            if (annotateImm && asm.codePatchingAnnotationConsumer != null) {
                asm.codePatchingAnnotationConsumer.accept(new AMD64BaseAssembler.OperandDataAnnotation(insnPos, immPos, nextInsnPos - immPos, nextInsnPos));
            }
        }
    }

    public static class AMD64RMOp
    extends AMD64RROp {
        public static final AMD64RMOp IMUL = new AMD64RMOp("IMUL", 15, 175, OpAssertion.ByteOrLargerAssertion);
        public static final AMD64RMOp BSF = new AMD64RMOp("BSF", 15, 188, OpAssertion.WordOrLargerAssertion);
        public static final AMD64RMOp BSR = new AMD64RMOp("BSR", 15, 189, OpAssertion.WordOrLargerAssertion);
        public static final AMD64RMOp POPCNT = new AMD64RMOp("POPCNT", 243, 15, 184, OpAssertion.DwordOrLargerAssertion, AMD64.CPUFeature.POPCNT);
        public static final AMD64RMOp TZCNT = new AMD64RMOp("TZCNT", 243, 15, 188, OpAssertion.DwordOrLargerAssertion, AMD64.CPUFeature.BMI1);
        public static final AMD64RMOp LZCNT = new AMD64RMOp("LZCNT", 243, 15, 189, OpAssertion.DwordOrLargerAssertion, AMD64.CPUFeature.LZCNT);
        public static final AMD64RMOp MOVZXB = new AMD64RMOp("MOVZXB", 15, 182, false, true, OpAssertion.WordOrLargerAssertion);
        public static final AMD64RMOp MOVZX = new AMD64RMOp("MOVZX", 15, 183, OpAssertion.DwordOrLargerAssertion);
        public static final AMD64RMOp MOVSXB = new AMD64RMOp("MOVSXB", 15, 190, false, true, OpAssertion.WordOrLargerAssertion);
        public static final AMD64RMOp MOVSX = new AMD64RMOp("MOVSX", 15, 191, OpAssertion.DwordOrLargerAssertion);
        public static final AMD64RMOp MOVSXD = new AMD64RMOp("MOVSXD", 99, OpAssertion.QwordAssertion);
        public static final AMD64RMOp MOVB = new AMD64RMOp("MOVB", 138, OpAssertion.ByteAssertion);
        public static final AMD64RMOp MOV = new AMD64RMOp("MOV", 139, OpAssertion.WordOrLargerAssertion);
        public static final AMD64RMOp CMP = new AMD64RMOp("CMP", 59, OpAssertion.WordOrLargerAssertion);
        public static final AMD64RMOp TESTB = new AMD64RMOp("TEST", 132, OpAssertion.ByteAssertion);
        public static final AMD64RMOp TEST = new AMD64RMOp("TEST", 133, OpAssertion.WordOrLargerAssertion);
        public static final AMD64RMOp ADCX = new AMD64RMOp("ADCX", 102, 14351, 246, OpAssertion.DwordOrLargerAssertion, AMD64.CPUFeature.ADX);
        public static final AMD64RMOp ADOX = new AMD64RMOp("ADOX", 243, 14351, 246, OpAssertion.DwordOrLargerAssertion, AMD64.CPUFeature.ADX);
        public static final AMD64RMOp SHA1MSG1 = new AMD64RMOp("SHA1MSG1", 14351, 201, OpAssertion.PackedSingleAssertion, AMD64.CPUFeature.SHA);
        public static final AMD64RMOp SHA1MSG2 = new AMD64RMOp("SHA1MSG2", 14351, 202, OpAssertion.PackedSingleAssertion, AMD64.CPUFeature.SHA);
        public static final AMD64RMOp SHA1NEXTE = new AMD64RMOp("SHA1NEXTE", 14351, 200, OpAssertion.PackedSingleAssertion, AMD64.CPUFeature.SHA);
        public static final AMD64RMOp SHA256MSG1 = new AMD64RMOp("SHA256MSG1", 14351, 204, OpAssertion.PackedSingleAssertion, AMD64.CPUFeature.SHA);
        public static final AMD64RMOp SHA256MSG2 = new AMD64RMOp("SHA256MSG2", 14351, 205, OpAssertion.PackedSingleAssertion, AMD64.CPUFeature.SHA);
        public static final AMD64RMOp SHA256RNDS2 = new AMD64RMOp("SHA256RNDS2", 14351, 203, OpAssertion.PackedSingleAssertion, AMD64.CPUFeature.SHA);

        protected AMD64RMOp(String opcode, int op, OpAssertion assertion) {
            this(opcode, 0, 0, op, assertion, null);
        }

        protected AMD64RMOp(String opcode, int prefix, int op, OpAssertion assertion) {
            this(opcode, 0, prefix, op, assertion, null);
        }

        protected AMD64RMOp(String opcode, int prefix, int op, OpAssertion assertion, AMD64.CPUFeature feature) {
            super(opcode, 0, prefix, op, assertion, feature);
        }

        protected AMD64RMOp(String opcode, int prefix1, int prefix2, int op, OpAssertion assertion, AMD64.CPUFeature feature) {
            super(opcode, prefix1, prefix2, op, assertion, feature);
        }

        protected AMD64RMOp(String opcode, int prefix, int op, boolean dstIsByte, boolean srcIsByte, OpAssertion assertion) {
            super(opcode, 0, prefix, op, dstIsByte, srcIsByte, assertion, null);
        }

        @Override
        public void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register dst, Register src) {
            assert (this.verify(asm, size, dst, src));
            assert (!this.isSSEInstruction());
            this.emitOpcode(asm, size, AMD64BaseAssembler.getRXB(dst, src), dst.encoding, src.encoding);
            asm.emitModRM(dst, src);
        }

        public void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register dst, AMD64Address src) {
            assert (this.verify(asm, size, dst, null));
            assert (!this.isSSEInstruction());
            this.emitOpcode(asm, size, AMD64BaseAssembler.getRXB(dst, src), dst.encoding, 0);
            asm.emitOperandHelper(dst, src, 0);
        }
    }

    public static class SSEOp
    extends AMD64RMOp {
        public static final SSEOp CVTSI2SS = new SSEOp("CVTSI2SS", 243, 15, 42, PreferredNDS.DST, OpAssertion.IntToFloatAssertion);
        public static final SSEOp CVTSI2SD = new SSEOp("CVTSI2SD", 242, 15, 42, PreferredNDS.DST, OpAssertion.IntToFloatAssertion);
        public static final SSEOp CVTTSS2SI = new SSEOp("CVTTSS2SI", 243, 15, 44, PreferredNDS.NONE, OpAssertion.FloatToIntAssertion);
        public static final SSEOp CVTTSD2SI = new SSEOp("CVTTSD2SI", 242, 15, 44, PreferredNDS.NONE, OpAssertion.FloatToIntAssertion);
        public static final SSEOp UCOMIS = new SSEOp("UCOMIS", 15, 46, PreferredNDS.NONE, OpAssertion.PackedFloatAssertion);
        public static final SSEOp SQRT = new SSEOp("SQRT", 15, 81, PreferredNDS.SRC, OpAssertion.ScalarFloatAssertion);
        public static final SSEOp AND = new SSEOp("AND", 15, 84, PreferredNDS.DST, OpAssertion.PackedFloatAssertion);
        public static final SSEOp ANDN = new SSEOp("ANDN", 15, 85, PreferredNDS.DST, OpAssertion.PackedFloatAssertion);
        public static final SSEOp OR = new SSEOp("OR", 15, 86, PreferredNDS.DST, OpAssertion.PackedFloatAssertion);
        public static final SSEOp XOR = new SSEOp("XOR", 15, 87, PreferredNDS.DST, OpAssertion.PackedFloatAssertion);
        public static final SSEOp ADD = new SSEOp("ADD", 15, 88, PreferredNDS.DST);
        public static final SSEOp MUL = new SSEOp("MUL", 15, 89, PreferredNDS.DST);
        public static final SSEOp CVTSS2SD = new SSEOp("CVTSS2SD", 15, 90, PreferredNDS.SRC, OpAssertion.SingleAssertion);
        public static final SSEOp CVTSD2SS = new SSEOp("CVTSD2SS", 15, 90, PreferredNDS.SRC, OpAssertion.DoubleAssertion);
        public static final SSEOp SUB = new SSEOp("SUB", 15, 92, PreferredNDS.DST);
        public static final SSEOp MIN = new SSEOp("MIN", 15, 93, PreferredNDS.DST);
        public static final SSEOp DIV = new SSEOp("DIV", 15, 94, PreferredNDS.DST);
        public static final SSEOp MAX = new SSEOp("MAX", 15, 95, PreferredNDS.DST);
        public static final SSEOp PSUBUSB = new SSEOp("PSUBUSB", 15, 216, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion);
        public static final SSEOp PSUBUSW = new SSEOp("PSUBUSW", 15, 217, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion);
        public static final SSEOp PMINUB = new SSEOp("PMINUB", 15, 218, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion);
        public static final SSEOp PMINUW = new SSEOp("PMINUW", 14351, 58, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE4_1);
        public static final SSEOp PMINUD = new SSEOp("PMINUD", 14351, 59, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE4_1);
        public static final SSEOp PACKUSWB = new SSEOp("PACKUSWB", 15, 103, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion);
        public static final SSEOp PACKUSDW = new SSEOp("PACKUSDW", 14351, 43, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE4_1);
        public static final SSEOp PSHUFB = new SSEOp("PSHUFB", 14351, 0, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSSE3);
        public static final SSEOp MOVD = new SSEOp("MOVD", 102, 15, 110, PreferredNDS.NONE, OpAssertion.DwordToFloatAssertion);
        public static final SSEOp MOVQ = new SSEOp("MOVQ", 102, 15, 110, PreferredNDS.NONE, OpAssertion.QwordToFloatAssertion);
        public static final SSEOp MOVSS = new SSEOp("MOVSS", 15, 16, PreferredNDS.SRC, OpAssertion.SingleAssertion);
        public static final SSEOp MOVSD = new SSEOp("MOVSD", 15, 16, PreferredNDS.SRC, OpAssertion.DoubleAssertion);
        private final PreferredNDS preferredNDS;

        protected SSEOp(String opcode, int prefix, int op, PreferredNDS preferredNDS) {
            this(opcode, 0, prefix, op, preferredNDS, OpAssertion.FloatAssertion);
        }

        protected SSEOp(String opcode, int prefix, int op, PreferredNDS preferredNDS, AMD64.CPUFeature feature) {
            this(opcode, 0, prefix, op, preferredNDS, OpAssertion.FloatAssertion, feature);
        }

        protected SSEOp(String opcode, int prefix, int op, PreferredNDS preferredNDS, OpAssertion assertion) {
            this(opcode, 0, prefix, op, preferredNDS, assertion);
        }

        protected SSEOp(String opcode, int prefix, int op, PreferredNDS preferredNDS, OpAssertion assertion, AMD64.CPUFeature feature) {
            this(opcode, 0, prefix, op, preferredNDS, assertion, feature);
        }

        protected SSEOp(String opcode, int mandatoryPrefix, int prefix, int op, PreferredNDS preferredNDS, OpAssertion assertion) {
            this(opcode, mandatoryPrefix, prefix, op, preferredNDS, assertion, AMD64.CPUFeature.SSE2);
        }

        protected SSEOp(String opcode, int mandatoryPrefix, int prefix, int op, PreferredNDS preferredNDS, OpAssertion assertion, AMD64.CPUFeature feature) {
            super(opcode, mandatoryPrefix, prefix, op, assertion, feature);
            this.preferredNDS = preferredNDS;
        }

        @Override
        public final void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register dst, Register src) {
            assert (this.verify(asm, size, dst, src));
            assert (this.isSSEInstruction());
            Register nds = this.preferredNDS.getNds(dst, src);
            asm.simdPrefix(dst, nds, src, size, this.prefix1, this.prefix2, size == AMD64BaseAssembler.OperandSize.QWORD);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src);
        }

        @Override
        public final void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register dst, AMD64Address src) {
            assert (this.verify(asm, size, dst, null));
            assert (this.isSSEInstruction());
            Register nds = this == MOVSS || this == MOVSD ? Register.None : this.preferredNDS.getNds(dst, src);
            asm.simdPrefix(dst, nds, src, size, this.prefix1, this.prefix2, size == AMD64BaseAssembler.OperandSize.QWORD);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, src, 0);
        }
    }

    public static final class AMD64MOp
    extends AMD64Op {
        public static final AMD64MOp NOTB = new AMD64MOp("NOT", 246, 2, OpAssertion.ByteAssertion);
        public static final AMD64MOp NEGB = new AMD64MOp("NEG", 246, 3, OpAssertion.ByteAssertion);
        public static final AMD64MOp NOT = new AMD64MOp("NOT", 247, 2);
        public static final AMD64MOp NEG = new AMD64MOp("NEG", 247, 3);
        public static final AMD64MOp MUL = new AMD64MOp("MUL", 247, 4);
        public static final AMD64MOp IMUL = new AMD64MOp("IMUL", 247, 5);
        public static final AMD64MOp DIV = new AMD64MOp("DIV", 247, 6);
        public static final AMD64MOp IDIV = new AMD64MOp("IDIV", 247, 7);
        public static final AMD64MOp INCB = new AMD64MOp("INC", 254, 0, OpAssertion.ByteAssertion);
        public static final AMD64MOp DECB = new AMD64MOp("DEC", 254, 1, OpAssertion.ByteAssertion);
        public static final AMD64MOp INC = new AMD64MOp("INC", 255, 0);
        public static final AMD64MOp DEC = new AMD64MOp("DEC", 255, 1);
        public static final AMD64MOp PUSH = new AMD64MOp("PUSH", 255, 6, OpAssertion.WordOrQwordAssertion);
        public static final AMD64MOp POP = new AMD64MOp("POP", 143, 0, OpAssertion.WordOrQwordAssertion);
        private final int ext;

        protected AMD64MOp(String opcode, int op, int ext) {
            this(opcode, 0, op, ext, OpAssertion.WordOrLargerAssertion);
        }

        protected AMD64MOp(String opcode, int op, int ext, OpAssertion assertion) {
            this(opcode, 0, op, ext, assertion);
        }

        protected AMD64MOp(String opcode, int prefix, int op, int ext, OpAssertion assertion) {
            super(opcode, 0, prefix, op, assertion, null);
            this.ext = ext;
        }

        public void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register dst) {
            assert (this.verify(asm, size, dst, null));
            this.emitOpcode(asm, size, AMD64BaseAssembler.getRXB(null, dst), 0, dst.encoding);
            asm.emitModRM(this.ext, dst);
        }

        public void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, AMD64Address dst) {
            assert (this.verify(asm, size, null, null));
            this.emitOpcode(asm, size, AMD64BaseAssembler.getRXB(null, dst), 0, 0);
            asm.emitOperandHelper(this.ext, dst, 0);
        }
    }

    public static enum ConditionFlag {
        Zero(4, "|zero|"),
        NotZero(5, "|nzero|"),
        Equal(4, "="),
        NotEqual(5, "!="),
        Less(12, "<"),
        LessEqual(14, "<="),
        Greater(15, ">"),
        GreaterEqual(13, ">="),
        Below(2, "|<|"),
        BelowEqual(6, "|<=|"),
        Above(7, "|>|"),
        AboveEqual(3, "|>=|"),
        Overflow(0, "|of|"),
        NoOverflow(1, "|nof|"),
        CarrySet(2, "|carry|"),
        CarryClear(3, "|ncarry|"),
        Negative(8, "|neg|"),
        Positive(9, "|pos|"),
        Parity(10, "|par|"),
        NoParity(11, "|npar|");

        private final int value;
        private final String operator;

        private ConditionFlag(int value, String operator) {
            this.value = value;
            this.operator = operator;
        }

        public ConditionFlag negate() {
            switch (this.ordinal()) {
                case 0: {
                    return NotZero;
                }
                case 1: {
                    return Zero;
                }
                case 2: {
                    return NotEqual;
                }
                case 3: {
                    return Equal;
                }
                case 4: {
                    return GreaterEqual;
                }
                case 5: {
                    return Greater;
                }
                case 6: {
                    return LessEqual;
                }
                case 7: {
                    return Less;
                }
                case 8: {
                    return AboveEqual;
                }
                case 9: {
                    return Above;
                }
                case 10: {
                    return BelowEqual;
                }
                case 11: {
                    return Below;
                }
                case 12: {
                    return NoOverflow;
                }
                case 13: {
                    return Overflow;
                }
                case 14: {
                    return CarryClear;
                }
                case 15: {
                    return CarrySet;
                }
                case 16: {
                    return Positive;
                }
                case 17: {
                    return Negative;
                }
                case 18: {
                    return NoParity;
                }
                case 19: {
                    return Parity;
                }
            }
            throw new IllegalArgumentException();
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return this.operator;
        }
    }

    public static class AMD64RMIOp
    extends AMD64ImmOp {
        public static final AMD64RMIOp IMUL = new AMD64RMIOp("IMUL", false, 105);
        public static final AMD64RMIOp IMUL_SX = new AMD64RMIOp("IMUL", true, 107);
        public static final AMD64RMIOp ROUNDSS = new AMD64RMIOp("ROUNDSS", true, 14863, 10, PreferredNDS.SRC, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE4_1);
        public static final AMD64RMIOp ROUNDSD = new AMD64RMIOp("ROUNDSD", true, 14863, 11, PreferredNDS.SRC, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE4_1);
        public static final AMD64RMIOp SHA1RNDS4 = new AMD64RMIOp("SHA1RNDS4", true, 14863, 204, PreferredNDS.NONE, OpAssertion.PackedSingleAssertion, AMD64.CPUFeature.SHA);
        private final PreferredNDS preferredNDS;

        protected AMD64RMIOp(String opcode, boolean immIsByte, int op) {
            super(opcode, immIsByte, 0, op, OpAssertion.WordOrLargerAssertion, null);
            this.preferredNDS = PreferredNDS.NONE;
        }

        protected AMD64RMIOp(String opcode, boolean immIsByte, int prefix, int op, PreferredNDS preferredNDS, OpAssertion assertion, AMD64.CPUFeature feature) {
            super(opcode, immIsByte, prefix, op, assertion, feature);
            this.preferredNDS = preferredNDS;
        }

        public final void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register dst, Register src, int imm) {
            assert (this.verify(asm, size, dst, src));
            if (this.isSSEInstruction()) {
                asm.simdPrefix(dst, this.preferredNDS.getNds(dst, src), src, size, this.prefix1, this.prefix2, false);
                asm.emitByte(this.op);
                asm.emitModRM(dst, src);
            } else {
                this.emitOpcode(asm, size, AMD64BaseAssembler.getRXB(dst, src), dst.encoding, src.encoding);
                asm.emitModRM(dst, src);
            }
            this.emitImmediate(asm, size, imm);
        }

        public final void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register dst, AMD64Address src, int imm) {
            assert (this.verify(asm, size, dst, null));
            if (this.isSSEInstruction()) {
                asm.simdPrefix(dst, this.preferredNDS.getNds(dst, src), src, size, this.prefix1, this.prefix2, false);
                asm.emitByte(this.op);
            } else {
                this.emitOpcode(asm, size, AMD64BaseAssembler.getRXB(dst, src), dst.encoding, 0);
            }
            asm.emitOperandHelper(dst, src, this.immediateSize(size));
            this.emitImmediate(asm, size, imm);
        }
    }

    public static class SSEMROp
    extends AMD64MROp {
        public static final SSEMROp MOVD = new SSEMROp("MOVD", 102, 15, 126, PreferredNDS.NONE, OpAssertion.DwordToFloatAssertion);
        public static final SSEMROp MOVQ = new SSEMROp("MOVQ", 102, 15, 126, PreferredNDS.NONE, OpAssertion.QwordToFloatAssertion);
        public static final SSEMROp MOVSS = new SSEMROp("MOVSS", 15, 17, PreferredNDS.SRC, OpAssertion.SingleAssertion);
        public static final SSEMROp MOVSD = new SSEMROp("MOVSD", 15, 17, PreferredNDS.SRC, OpAssertion.DoubleAssertion);
        private final PreferredNDS preferredNDS;

        protected SSEMROp(String opcode, int prefix, int op, PreferredNDS preferredNDS, OpAssertion assertion) {
            this(opcode, 0, prefix, op, preferredNDS, assertion);
        }

        protected SSEMROp(String opcode, int prefix1, int prefix2, int op, PreferredNDS preferredNDS, OpAssertion assertion) {
            super(opcode, prefix1, prefix2, op, assertion, AMD64.CPUFeature.SSE2);
            this.preferredNDS = preferredNDS;
        }

        @Override
        public final void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register dst, Register src) {
            assert (this.verify(asm, size, src, dst));
            assert (this.isSSEInstruction());
            asm.simdPrefix(src, this.preferredNDS.getNds(dst, src), dst, size, this.prefix1, this.prefix2, size == AMD64BaseAssembler.OperandSize.QWORD);
            asm.emitByte(this.op);
            asm.emitModRM(src, dst);
        }

        @Override
        public final void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, AMD64Address dst, Register src) {
            assert (this.verify(asm, size, src, null));
            assert (this.isSSEInstruction());
            Register nds = this == MOVSS || this == MOVSD ? Register.None : this.preferredNDS.getNds(src, dst);
            asm.simdPrefix(src, nds, dst, size, this.prefix1, this.prefix2, size == AMD64BaseAssembler.OperandSize.QWORD);
            asm.emitByte(this.op);
            asm.emitOperandHelper(src, dst, 0);
        }
    }

    public static class AMD64MROp
    extends AMD64RROp {
        public static final AMD64MROp MOVB = new AMD64MROp("MOVB", 136, OpAssertion.ByteAssertion);
        public static final AMD64MROp MOV = new AMD64MROp("MOV", 137, OpAssertion.WordOrLargerAssertion);

        protected AMD64MROp(String opcode, int op, OpAssertion assertion) {
            this(opcode, 0, 0, op, assertion, null);
        }

        protected AMD64MROp(String opcode, int prefix, int op, OpAssertion assertion) {
            this(opcode, 0, prefix, op, assertion, null);
        }

        protected AMD64MROp(String opcode, int prefix1, int prefix2, int op, OpAssertion assertion, AMD64.CPUFeature feature) {
            super(opcode, prefix1, prefix2, op, assertion, feature);
        }

        @Override
        public void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register dst, Register src) {
            assert (this.verify(asm, size, src, dst));
            assert (!this.isSSEInstruction());
            this.emitOpcode(asm, size, AMD64BaseAssembler.getRXB(src, dst), src.encoding, dst.encoding);
            asm.emitModRM(src, dst);
        }

        public void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, AMD64Address dst, Register src) {
            assert (this.verify(asm, size, src, null));
            assert (!this.isSSEInstruction());
            this.emitOpcode(asm, size, AMD64BaseAssembler.getRXB(src, dst), src.encoding, 0);
            asm.emitOperandHelper(src, dst, 0);
        }
    }

    public static final class VexRVMIOp
    extends VexOp {
        public static final VexRVMIOp VPINSRB = new VexRVMIOp("VPINSRB", 1, 3, 0, 32, VEXOpAssertion.XMM_XMM_CPU);
        public static final VexRVMIOp VPINSRW = new VexRVMIOp("VPINSRW", 1, 1, 0, 196, VEXOpAssertion.XMM_XMM_CPU);
        public static final VexRVMIOp VPINSRD = new VexRVMIOp("VPINSRD", 1, 3, 0, 34, VEXOpAssertion.XMM_XMM_CPU);
        public static final VexRVMIOp VPINSRQ = new VexRVMIOp("VPINSRQ", 1, 3, 1, 34, VEXOpAssertion.XMM_XMM_CPU);
        public static final VexRVMIOp VSHUFPS = new VexRVMIOp("VSHUFPS", 0, 1, 0, 198, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMIOp VSHUFPD = new VexRVMIOp("VSHUFPD", 1, 1, 0, 198, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMIOp VPTERNLOGD = new VexRVMIOp("VPTERNLOGD", 1, 3, 0, 37, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMIOp VPTERNLOGQ = new VexRVMIOp("VPTERNLOGQ", 1, 3, 1, 37, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMIOp VINSERTF128 = new VexRVMIOp("VINSERTF128", 1, 3, 0, 24, VEXOpAssertion.AVX1_256ONLY);
        public static final VexRVMIOp VINSERTI128 = new VexRVMIOp("VINSERTI128", 1, 3, 0, 56, VEXOpAssertion.AVX2_256ONLY);
        public static final VexRVMIOp VPERM2I128 = new VexRVMIOp("VPERM2I128", 1, 3, 0, 70, VEXOpAssertion.AVX2_256ONLY);
        public static final VexRVMIOp VPERM2F128 = new VexRVMIOp("VPERM2F128", 1, 3, 0, 6, VEXOpAssertion.AVX1_256ONLY);
        public static final VexRVMIOp VPCLMULQDQ = new VexRVMIOp("VPCLMULQDQ", 1, 3, 0, 68, VEXOpAssertion.AVX1_128ONLY_CLMUL);
        public static final VexRVMIOp VPALIGNR = new VexRVMIOp("VPALIGNR", 1, 3, 0, 15, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMIOp VPBLENDD = new VexRVMIOp("VPBLENDD", 1, 3, 0, 2, VEXOpAssertion.AVX2);
        public static final VexRVMIOp VINSERTF32X4 = new VexRVMIOp("VINSERTF32X4", 1, 3, 0, 24, VEXOpAssertion.AVX512F_VL_256_512, AMD64BaseAssembler.EVEXTuple.T4_32BIT, 0);
        public static final VexRVMIOp VINSERTI32X4 = new VexRVMIOp("VINSERTI32X4", 1, 3, 0, 56, VEXOpAssertion.AVX512F_VL_256_512, AMD64BaseAssembler.EVEXTuple.T4_32BIT, 0);
        public static final VexRVMIOp VINSERTF64X2 = new VexRVMIOp("VINSERTF64X2", 1, 3, 1, 24, VEXOpAssertion.AVX512DQ_VL_256_512, AMD64BaseAssembler.EVEXTuple.T2_64BIT, 1);
        public static final VexRVMIOp VINSERTI64X2 = new VexRVMIOp("VINSERTI64X2", 1, 3, 1, 56, VEXOpAssertion.AVX512DQ_VL_256_512, AMD64BaseAssembler.EVEXTuple.T2_64BIT, 1);
        public static final VexRVMIOp VINSERTF32X8 = new VexRVMIOp("VINSERTF32X8", 1, 3, 0, 26, VEXOpAssertion.AVX512DQ_512ONLY, AMD64BaseAssembler.EVEXTuple.T8_32BIT, 0);
        public static final VexRVMIOp VINSERTI32X8 = new VexRVMIOp("VINSERTI32X8", 1, 3, 0, 58, VEXOpAssertion.AVX512DQ_512ONLY, AMD64BaseAssembler.EVEXTuple.T8_32BIT, 0);
        public static final VexRVMIOp VINSERTF64X4 = new VexRVMIOp("VINSERTF64X4", 1, 3, 1, 26, VEXOpAssertion.AVX512F_512ONLY, AMD64BaseAssembler.EVEXTuple.T4_64BIT, 1);
        public static final VexRVMIOp VINSERTI64X4 = new VexRVMIOp("VINSERTI64X4", 1, 3, 1, 58, VEXOpAssertion.AVX512F_512ONLY, AMD64BaseAssembler.EVEXTuple.T4_64BIT, 1);
        public static final VexRVMIOp VALIGND = new VexRVMIOp("VALIGND", 1, 3, 0, 3, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMIOp VALIGNQ = new VexRVMIOp("VALIGNQ", 1, 3, 1, 3, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMIOp VPCMPUB = new VexRVMIOp("VPCMPUB", 1, 3, 0, 62, VEXOpAssertion.MASK_XMM_XMM_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMIOp VPCMPUW = new VexRVMIOp("VPCMPUW", 1, 3, 1, 62, VEXOpAssertion.MASK_XMM_XMM_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMIOp VPCMPUD = new VexRVMIOp("VPCMPUD", 1, 3, 0, 30, VEXOpAssertion.MASK_XMM_XMM_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMIOp VPCMPUQ = new VexRVMIOp("VPCMPUQ", 1, 3, 1, 30, VEXOpAssertion.MASK_XMM_XMM_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMIOp VGF2P8AFFINEQB = new VexRVMIOp("VGF2P8AFFINEQB", 1, 3, 1, 206, VEXOpAssertion.AVX1_GFNI_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);

        private VexRVMIOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, op, assertion);
        }

        private VexRVMIOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, Register src2, int imm8) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, dst, src1, src2), "emitting invalid instruction");
            assert ((imm8 & 0xFF) == imm8) : imm8;
            asm.vexPrefix(dst, src1, src2, size, this.pp, this.mmmmm, this.w, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src2);
            asm.emitByte(imm8);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, AMD64Address src2, int imm8) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, dst, src1, null), "emitting invalid instruction");
            assert ((imm8 & 0xFF) == imm8) : imm8;
            boolean useEvex = asm.vexPrefix(dst, src1, src2, size, this.pp, this.mmmmm, this.w, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, src2, 1, this.getDisp8Scale(useEvex, size));
            asm.emitByte(imm8);
        }
    }

    public static final class VexShiftOp
    extends VexRVMOp
    implements VexRRIOp {
        public static final VexShiftOp VPSRLW = new VexShiftOp("VPSRLW", 1, 1, 0, 209, 113, 2, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexShiftOp VPSRLD = new VexShiftOp("VPSRLD", 1, 1, 0, 210, 114, 2, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexShiftOp VPSRLQ = new VexShiftOp("VPSRLQ", 1, 1, 0, 211, 115, 2, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexShiftOp VPSRAW = new VexShiftOp("VPSRAW", 1, 1, 0, 225, 113, 4, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexShiftOp VPSRAD = new VexShiftOp("VPSRAD", 1, 1, 0, 226, 114, 4, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexShiftOp VPSRAQ = new VexShiftOp("VPSRAQ", 1, 1, 1, 226, 114, 4, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexShiftOp VPSLLW = new VexShiftOp("VPSLLW", 1, 1, 0, 241, 113, 6, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexShiftOp VPSLLD = new VexShiftOp("VPSLLD", 1, 1, 0, 242, 114, 6, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexShiftOp VPSLLQ = new VexShiftOp("VPSLLQ", 1, 1, 0, 243, 115, 6, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        private final int immOp;
        private final int r;

        private VexShiftOp(String opcode, int pp, int mmmmm, int w, int op, int immOp, int r, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex);
            this.immOp = immOp;
            this.r = r;
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src, int imm8) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, null, dst, src), "emitting invalid instruction");
            asm.vexPrefix(null, dst, src, size, this.pp, this.mmmmm, this.w, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature);
            asm.emitByte(this.immOp);
            asm.emitModRM(this.r, src);
            asm.emitByte(imm8);
        }
    }

    public static final class VexGeneralPurposeRVMOp
    extends VexRVMOp {
        public static final VexGeneralPurposeRVMOp ANDN = new VexGeneralPurposeRVMOp("ANDN", 0, 2, 0, 242, VEXOpAssertion.BMI1);
        public static final VexGeneralPurposeRVMOp MULX = new VexGeneralPurposeRVMOp("MULX", 3, 2, 0, 246, VEXOpAssertion.BMI2);
        public static final VexGeneralPurposeRVMOp PDEP = new VexGeneralPurposeRVMOp("PDEP", 3, 2, 0, 245, VEXOpAssertion.BMI2);
        public static final VexGeneralPurposeRVMOp PEXT = new VexGeneralPurposeRVMOp("PEXT", 2, 2, 0, 245, VEXOpAssertion.BMI2);

        private VexGeneralPurposeRVMOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, op, assertion);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, Register src2) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), 0, dst, src1, src2, null), "emitting invalid instruction");
            assert (size == AVXKind.AVXSize.DWORD || size == AVXKind.AVXSize.QWORD) : size;
            asm.vexPrefix(dst, src1, src2, size, this.pp, this.mmmmm, size == AVXKind.AVXSize.DWORD ? 0 : 1, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src2);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, Register src2, Register mask, int z, int b) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), 0, dst, src1, src2, null), "emitting invalid instruction");
            assert (size == AVXKind.AVXSize.DWORD || size == AVXKind.AVXSize.QWORD) : size;
            asm.vexPrefix(dst, src1, src2, mask, size, this.pp, this.mmmmm, size == AVXKind.AVXSize.DWORD ? 0 : 1, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature, z, b);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src2);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, AMD64Address src2) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), 0, dst, src1, null, null), "emitting invalid instruction");
            assert (size == AVXKind.AVXSize.DWORD || size == AVXKind.AVXSize.QWORD) : size;
            asm.vexPrefix(dst, src1, src2, size, this.pp, this.mmmmm, size == AVXKind.AVXSize.DWORD ? 0 : 1, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, src2, 0);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, AMD64Address src2, Register mask, int z, int b) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), 0, dst, src1, null, null), "emitting invalid instruction");
            assert (size == AVXKind.AVXSize.DWORD || size == AVXKind.AVXSize.QWORD) : size;
            asm.vexPrefix(dst, src1, src2, mask, size, this.pp, this.mmmmm, size == AVXKind.AVXSize.DWORD ? 0 : 1, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature, z, b);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, src2, 0);
        }
    }

    public static final class AMD64Shift {
        public static final AMD64Shift ROL = new AMD64Shift("ROL", 0);
        public static final AMD64Shift ROR = new AMD64Shift("ROR", 1);
        public static final AMD64Shift RCL = new AMD64Shift("RCL", 2);
        public static final AMD64Shift RCR = new AMD64Shift("RCR", 3);
        public static final AMD64Shift SHL = new AMD64Shift("SHL", 4);
        public static final AMD64Shift SHR = new AMD64Shift("SHR", 5);
        public static final AMD64Shift SAR = new AMD64Shift("SAR", 7);
        public final AMD64MOp m1Op;
        public final AMD64MOp mcOp;
        public final AMD64MIOp miOp;

        private AMD64Shift(String opcode, int code) {
            this.m1Op = new AMD64MOp(opcode, 0, 209, code, OpAssertion.WordOrLargerAssertion);
            this.mcOp = new AMD64MOp(opcode, 0, 211, code, OpAssertion.WordOrLargerAssertion);
            this.miOp = new AMD64MIOp(opcode, true, 0, 193, code, OpAssertion.WordOrLargerAssertion);
        }
    }

    public static final class VexShiftImmOp
    extends VexOp
    implements VexRRIOp {
        public static final VexShiftImmOp VPSLLDQ = new VexShiftImmOp("VPSLLDQ", 1, 1, 0, 115, 7, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexShiftImmOp VPSRLDQ = new VexShiftImmOp("VPSRLDQ", 1, 1, 0, 115, 3, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        private final int r;

        private VexShiftImmOp(String opcode, int pp, int mmmmm, int w, int op, int r, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex);
            this.r = r;
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src, int imm8) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, null, dst, src), "emitting invalid instruction");
            asm.vexPrefix(null, dst, src, size, this.pp, this.mmmmm, this.w, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature);
            asm.emitByte(this.op);
            asm.emitModRM(this.r, src);
            asm.emitByte(imm8);
        }
    }

    public static final class VexMoveOp
    extends VexGeneralMoveOp {
        public static final VexMoveOp VMOVDQA32 = new VexMoveOp("VMOVDQA32", 1, 1, 0, 111, 127, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexMoveOp VMOVDQA64 = new VexMoveOp("VMOVDQA64", 1, 1, 0, 111, 127, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexMoveOp VMOVDQU32 = new VexMoveOp("VMOVDQU32", 2, 1, 0, 111, 127, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexMoveOp VMOVDQU64 = new VexMoveOp("VMOVDQU64", 2, 1, 0, 111, 127, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexMoveOp VMOVAPS = new VexMoveOp("VMOVAPS", 0, 1, 0, 40, 41, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexMoveOp VMOVAPD = new VexMoveOp("VMOVAPD", 1, 1, 0, 40, 41, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexMoveOp VMOVUPS = new VexMoveOp("VMOVUPS", 0, 1, 0, 16, 17, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexMoveOp VMOVUPD = new VexMoveOp("VMOVUPD", 1, 1, 0, 16, 17, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexMoveOp VMOVSS = new VexMoveOp("VMOVSS", 2, 1, 0, 16, 17, VEXOpAssertion.AVX1_AVX512F_ALL, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final VexMoveOp VMOVSD = new VexMoveOp("VMOVSD", 3, 1, 0, 16, 17, VEXOpAssertion.AVX1_AVX512F_ALL, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final VexMoveOp VMOVD = new VexMoveOp("VMOVD", 1, 1, 0, 110, 126, VEXOpAssertion.XMM_CPU_AVX512F_128ONLY, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final VexMoveOp VMOVQ = new VexMoveOp("VMOVQ", 1, 1, 1, 110, 126, VEXOpAssertion.XMM_CPU_AVX512F_128ONLY, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        private final int opReverse;

        private VexMoveOp(String opcode, int pp, int mmmmm, int w, int op, int opReverse, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex);
            this.opReverse = opReverse;
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, AMD64Address dst, Register src) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, src, null, null), "emitting invalid instruction");
            boolean useEvex = asm.vexPrefix(src, Register.None, dst, size, this.pp, this.mmmmm, this.w, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature);
            asm.emitByte(this.opReverse);
            asm.emitOperandHelper(src, dst, 0, this.getDisp8Scale(useEvex, size));
        }

        public void emitReverse(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, src, null, dst), "emitting invalid instruction");
            asm.vexPrefix(src, Register.None, dst, size, this.pp, this.mmmmm, this.w, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature);
            asm.emitByte(this.opReverse);
            asm.emitModRM(src, dst);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, dst, null, src), "emitting invalid instruction");
            Register nds = this == VMOVSS || this == VMOVSD ? src : Register.None;
            asm.vexPrefix(dst, nds, src, size, this.pp, this.mmmmm, this.w, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src, Register mask, int z, int b) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, dst, null, src), "emitting invalid instruction");
            Register nds = this == VMOVSS || this == VMOVSD ? src : Register.None;
            asm.vexPrefix(dst, nds, src, mask, size, this.pp, this.mmmmm, this.w, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature, z, b);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src);
        }
    }

    public static final class VexMoveMaskOp
    extends VexGeneralMoveOp {
        public static final VexMoveMaskOp KMOVW = new VexMoveMaskOp("KMOVW", 0, 0, 1, 0, 0, VEXOpAssertion.AVX512F_CPU_OR_MASK);
        public static final VexMoveMaskOp KMOVB = new VexMoveMaskOp("KMOVB", 1, 1, 1, 0, 0, VEXOpAssertion.AVX512DQ_CPU_OR_MASK);
        public static final VexMoveMaskOp KMOVQ = new VexMoveMaskOp("KMOVQ", 0, 3, 1, 1, 1, VEXOpAssertion.AVX512BW_CPU_OR_MASK);
        public static final VexMoveMaskOp KMOVD = new VexMoveMaskOp("KMOVD", 1, 3, 1, 1, 0, VEXOpAssertion.AVX512BW_CPU_OR_MASK);
        private static final int OP_K_FROM_K_MEM = 144;
        private static final int OP_MEM_FROM_K = 145;
        private static final int OP_K_FROM_CPU = 146;
        private static final int OP_CPU_FROM_K = 147;
        private final int ppCPU;
        private final int wCPU;

        private VexMoveMaskOp(String opcode, int pp, int ppCPU, int mmmmm, int w, int wCPU, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, 144, assertion, AMD64BaseAssembler.EVEXTuple.INVALID, w);
            this.ppCPU = ppCPU;
            this.wCPU = wCPU;
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, dst, null, src), "emitting invalid instruction");
            GraalError.guarantee(!AMD64BaseAssembler.inRC(AMD64.CPU, dst) || !AMD64BaseAssembler.inRC(AMD64.CPU, src), "source and destination can't both be CPU registers");
            int actualOp = VexMoveMaskOp.op(dst, src);
            int actualPP = this.pp(dst, src);
            int actualW = this.w(dst, src);
            asm.vexPrefix(dst, Register.None, src, size, actualPP, this.mmmmm, actualW, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature);
            asm.emitByte(actualOp);
            asm.emitModRM(dst, src);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, AMD64Address dst, Register src) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, src, null, null), "emitting invalid instruction");
            GraalError.guarantee(AMD64BaseAssembler.inRC(AMD64.MASK, src), "source must be a mask register");
            asm.vexPrefix(src, Register.None, dst, size, this.pp, this.mmmmm, this.w, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature);
            asm.emitByte(145);
            asm.emitOperandHelper(src, dst, 0);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, AMD64Address src) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, dst, null, null), "emitting invalid instruction");
            GraalError.guarantee(AMD64BaseAssembler.inRC(AMD64.MASK, dst), "destination must be a mask register");
            asm.vexPrefix(dst, Register.None, src, size, this.pp, this.mmmmm, this.w, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature);
            asm.emitByte(144);
            asm.emitOperandHelper(dst, src, 0);
        }

        private static int op(Register dst, Register src) {
            if (AMD64BaseAssembler.inRC(AMD64.MASK, dst)) {
                if (AMD64BaseAssembler.inRC(AMD64.MASK, src)) {
                    return 144;
                }
                assert (AMD64BaseAssembler.inRC(AMD64.CPU, src));
                return 146;
            }
            assert (AMD64BaseAssembler.inRC(AMD64.CPU, dst) && AMD64BaseAssembler.inRC(AMD64.MASK, src)) : String.valueOf(src) + " " + String.valueOf(dst);
            return 147;
        }

        private int pp(Register dst, Register src) {
            if (AMD64BaseAssembler.inRC(AMD64.CPU, dst) || AMD64BaseAssembler.inRC(AMD64.CPU, src)) {
                return this.ppCPU;
            }
            return this.pp;
        }

        private int w(Register dst, Register src) {
            if (AMD64BaseAssembler.inRC(AMD64.CPU, dst) || AMD64BaseAssembler.inRC(AMD64.CPU, src)) {
                return this.wCPU;
            }
            return this.w;
        }
    }

    public static final class VexFloatCompareOp
    extends VexOp {
        public static final VexFloatCompareOp VCMPPS = new VexFloatCompareOp("VCMPPS", 0, 1, 0, 194);
        public static final VexFloatCompareOp VCMPPS_AVX512 = new VexFloatCompareOp("VCMPPS", 0, 1, 0, 194, VEXOpAssertion.MASK_XMM_XMM_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexFloatCompareOp VCMPPD = new VexFloatCompareOp("VCMPPD", 1, 1, 0, 194);
        public static final VexFloatCompareOp VCMPPD_AVX512 = new VexFloatCompareOp("VCMPPD", 1, 1, 1, 194, VEXOpAssertion.MASK_XMM_XMM_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexFloatCompareOp VCMPSS = new VexFloatCompareOp("VCMPSS", 2, 1, 0, 194);
        public static final VexFloatCompareOp VCMPSS_AVX512 = new VexFloatCompareOp("VCMPSS", 2, 1, 0, 194, VEXOpAssertion.MASK_XMM_XMM_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final VexFloatCompareOp VCMPSD = new VexFloatCompareOp("VCMPSD", 3, 1, 0, 194);
        public static final VexFloatCompareOp VCMPSD_AVX512 = new VexFloatCompareOp("VCMPSD", 3, 1, 1, 194, VEXOpAssertion.MASK_XMM_XMM_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);

        private VexFloatCompareOp(String opcode, int pp, int mmmmm, int w, int op) {
            super(opcode, pp, mmmmm, w, op, VEXOpAssertion.AVX1);
        }

        private VexFloatCompareOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, Register src2, Predicate p) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, dst, src1, src2), "emitting invalid instruction");
            asm.vexPrefix(dst, src1, src2, size, this.pp, this.mmmmm, this.w, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src2);
            asm.emitByte(p.imm8);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, AMD64Address src2, Predicate p) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, dst, src1, null), "emitting invalid instruction");
            boolean useEvex = asm.vexPrefix(dst, src1, src2, size, this.pp, this.mmmmm, this.w, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, src2, 1, this.getDisp8Scale(useEvex, size));
            asm.emitByte(p.imm8);
        }

        public static enum Predicate {
            EQ_OQ(0),
            LT_OS(1),
            LE_OS(2),
            UNORD_Q(3),
            NEQ_UQ(4),
            NLT_US(5),
            NLE_US(6),
            ORD_Q(7),
            EQ_UQ(8),
            NGE_US(9),
            NGT_US(10),
            FALSE_OQ(11),
            NEQ_OQ(12),
            GE_OS(13),
            GT_OS(14),
            TRUE_UQ(15),
            EQ_OS(16),
            LT_OQ(17),
            LE_OQ(18),
            UNORD_S(19),
            NEQ_US(20),
            NLT_UQ(21),
            NLE_UQ(22),
            ORD_S(23),
            EQ_US(24),
            NGE_UQ(25),
            NGT_UQ(26),
            FALSE_OS(27),
            NEQ_OS(28),
            GE_OQ(29),
            GT_OQ(30),
            TRUE_US(31);

            private int imm8;

            private Predicate(int imm8) {
                this.imm8 = imm8;
            }

            public static Predicate getPredicate(Condition condition, boolean unorderedIsTrue) {
                if (unorderedIsTrue) {
                    switch (condition) {
                        case EQ: {
                            return EQ_UQ;
                        }
                        case NE: {
                            return NEQ_UQ;
                        }
                        case LT: {
                            return NGE_UQ;
                        }
                        case LE: {
                            return NGT_UQ;
                        }
                        case GT: {
                            return NLE_UQ;
                        }
                        case GE: {
                            return NLT_UQ;
                        }
                    }
                    throw GraalError.shouldNotReachHereUnexpectedValue((Object)condition);
                }
                switch (condition) {
                    case EQ: {
                        return EQ_OQ;
                    }
                    case NE: {
                        return NEQ_OQ;
                    }
                    case LT: {
                        return LT_OQ;
                    }
                    case LE: {
                        return LE_OQ;
                    }
                    case GT: {
                        return GT_OQ;
                    }
                    case GE: {
                        return GE_OQ;
                    }
                }
                throw GraalError.shouldNotReachHereUnexpectedValue((Object)condition);
            }
        }
    }

    public static final class VexMaskedMoveOp
    extends VexOp {
        public static final VexMaskedMoveOp VMASKMOVPS = new VexMaskedMoveOp("VMASKMOVPS", 1, 2, 0, 44, 46);
        public static final VexMaskedMoveOp VMASKMOVPD = new VexMaskedMoveOp("VMASKMOVPD", 1, 2, 0, 45, 47);
        public static final VexMaskedMoveOp VPMASKMOVD = new VexMaskedMoveOp("VPMASKMOVD", 1, 2, 0, 140, 142, VEXOpAssertion.AVX2);
        public static final VexMaskedMoveOp VPMASKMOVQ = new VexMaskedMoveOp("VPMASKMOVQ", 1, 2, 1, 140, 142, VEXOpAssertion.AVX2);
        private final int opReverse;

        private VexMaskedMoveOp(String opcode, int pp, int mmmmm, int w, int op, int opReverse) {
            this(opcode, pp, mmmmm, w, op, opReverse, VEXOpAssertion.AVX1);
        }

        private VexMaskedMoveOp(String opcode, int pp, int mmmmm, int w, int op, int opReverse, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, op, assertion);
            this.opReverse = opReverse;
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register mask, AMD64Address src) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, dst, mask, null), "emitting invalid instruction");
            asm.vexPrefix(dst, mask, src, size, this.pp, this.mmmmm, this.w, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, src, 0);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, AMD64Address dst, Register mask, Register src) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, src, mask, null), "emitting invalid instruction");
            boolean useEvex = asm.vexPrefix(src, mask, dst, size, this.pp, this.mmmmm, this.w, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature);
            asm.emitByte(this.opReverse);
            asm.emitOperandHelper(src, dst, 0, this.getDisp8Scale(useEvex, size));
        }
    }

    public static final class VexGeneralPurposeRMOp
    extends VexRMOp {
        public static final VexGeneralPurposeRMOp BLSI = new VexGeneralPurposeRMOp("BLSI", 0, 2, 0, 243, 3, VEXOpAssertion.BMI1);
        public static final VexGeneralPurposeRMOp BLSMSK = new VexGeneralPurposeRMOp("BLSMSK", 0, 2, 0, 243, 2, VEXOpAssertion.BMI1);
        public static final VexGeneralPurposeRMOp BLSR = new VexGeneralPurposeRMOp("BLSR", 0, 2, 0, 243, 1, VEXOpAssertion.BMI1);
        private final int ext;

        private VexGeneralPurposeRMOp(String opcode, int pp, int mmmmm, int w, int op, int ext, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, op, assertion);
            this.ext = ext;
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, dst, null, null), "emitting invalid instruction");
            asm.vexPrefix(AMD64.cpuRegisters[this.ext], dst, src, size, this.pp, this.mmmmm, size == AVXKind.AVXSize.DWORD ? 0 : 1, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature);
            asm.emitByte(this.op);
            asm.emitModRM(this.ext, src);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src, Register mask, int z, int b) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, dst, null, null), "emitting invalid instruction");
            asm.vexPrefix(AMD64.cpuRegisters[this.ext], dst, src, mask, size, this.pp, this.mmmmm, size == AVXKind.AVXSize.DWORD ? 0 : 1, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature, z, b);
            asm.emitByte(this.op);
            asm.emitModRM(this.ext, src);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, AMD64Address src) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, dst, null, null), "emitting invalid instruction");
            asm.vexPrefix(AMD64.cpuRegisters[this.ext], dst, src, size, this.pp, this.mmmmm, size == AVXKind.AVXSize.DWORD ? 0 : 1, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature);
            asm.emitByte(this.op);
            asm.emitOperandHelper(this.ext, src, 0);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, AMD64Address src, Register mask, int z, int b) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, dst, null, null), "emitting invalid instruction");
            asm.vexPrefix(AMD64.cpuRegisters[this.ext], dst, src, mask, size, this.pp, this.mmmmm, size == AVXKind.AVXSize.DWORD ? 0 : 1, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature, z, b);
            asm.emitByte(this.op);
            asm.emitOperandHelper(this.ext, src, 0);
        }
    }

    public static final class EvexGatherOp
    extends VexOp {
        public static final EvexGatherOp VPGATHERDD = new EvexGatherOp("VPGATHERDD", 1, 2, 144, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final EvexGatherOp VPGATHERQD = new EvexGatherOp("VPGATHERQD", 1, 2, 145, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final EvexGatherOp VPGATHERDQ = new EvexGatherOp("VPGATHERDQ", 1, 2, 144, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final EvexGatherOp VPGATHERQQ = new EvexGatherOp("VPGATHERQQ", 1, 2, 145, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final EvexGatherOp VGATHERDPD = new EvexGatherOp("VGATHERDPD", 1, 2, 146, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final EvexGatherOp VGATHERQPD = new EvexGatherOp("VGATHERQPD", 1, 2, 147, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final EvexGatherOp VGATHERDPS = new EvexGatherOp("VGATHERDPS", 1, 2, 146, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final EvexGatherOp VGATHERQPS = new EvexGatherOp("VGATHERQPS", 1, 2, 147, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);

        protected EvexGatherOp(String opcode, int pp, int mmmmm, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex) {
            super(opcode, pp, mmmmm, wEvex, op, assertion, evexTuple, wEvex);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, AMD64Address address, Register mask, int z, int b) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, dst, null, null, null), "emitting invalid instruction");
            assert (size == AVXKind.AVXSize.XMM || size == AVXKind.AVXSize.YMM || size == AVXKind.AVXSize.ZMM) : size;
            asm.vexPrefix(dst, Register.None, address, mask, size, this.pp, this.mmmmm, this.w, this.wEvex, true, this.assertion.l128feature, this.assertion.l256feature, z, b);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, address, 0);
        }
    }

    public static final class VexGatherOp
    extends VexOp {
        public static final VexGatherOp VPGATHERDD = new VexGatherOp("VPGATHERDD", 1, 2, 0, 144, VEXOpAssertion.AVX2);
        public static final VexGatherOp VPGATHERQD = new VexGatherOp("VPGATHERQD", 1, 2, 0, 145, VEXOpAssertion.AVX2);
        public static final VexGatherOp VPGATHERDQ = new VexGatherOp("VPGATHERDQ", 1, 2, 1, 144, VEXOpAssertion.AVX2);
        public static final VexGatherOp VPGATHERQQ = new VexGatherOp("VPGATHERQQ", 1, 2, 1, 145, VEXOpAssertion.AVX2);
        public static final VexGatherOp VGATHERDPD = new VexGatherOp("VGATHERDPD", 1, 2, 1, 146, VEXOpAssertion.AVX2);
        public static final VexGatherOp VGATHERQPD = new VexGatherOp("VGATHERQPD", 1, 2, 1, 147, VEXOpAssertion.AVX2);
        public static final VexGatherOp VGATHERDPS = new VexGatherOp("VGATHERDPS", 1, 2, 0, 146, VEXOpAssertion.AVX2);
        public static final VexGatherOp VGATHERQPS = new VexGatherOp("VGATHERQPS", 1, 2, 0, 147, VEXOpAssertion.AVX2);

        protected VexGatherOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, op, assertion, AMD64BaseAssembler.EVEXTuple.INVALID, 0);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, AMD64Address address, Register mask) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, dst, mask, null, null), "emitting invalid instruction");
            assert (size == AVXKind.AVXSize.XMM || size == AVXKind.AVXSize.YMM) : size;
            asm.vexPrefix(dst, mask, address, size, this.pp, this.mmmmm, this.w, this.wEvex, true, this.assertion.l128feature, this.assertion.l256feature);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, address, 0);
        }
    }

    public static final class VexAESOp
    extends VexRVMOp {
        public static final VexAESOp VAESENC = new VexAESOp("VAESENC", 220, VEXOpAssertion.AVX1_128ONLY_AES);
        public static final VexAESOp VAESENCLAST = new VexAESOp("VAESENCLAST", 221, VEXOpAssertion.AVX1_128ONLY_AES);
        public static final VexAESOp VAESDEC = new VexAESOp("VAESDEC", 222, VEXOpAssertion.AVX1_128ONLY_AES);
        public static final VexAESOp VAESDECLAST = new VexAESOp("VAESDECLAST", 223, VEXOpAssertion.AVX1_128ONLY_AES);

        private VexAESOp(String opcode, int op, VEXOpAssertion assertion) {
            super(opcode, 1, 2, 0, op, assertion);
        }

        public void emit(AMD64Assembler asm, Register result, Register state, Register key) {
            this.emit(asm, AVXKind.AVXSize.XMM, result, state, key);
        }

        public void emit(AMD64Assembler asm, Register result, Register state, AMD64Address keyLocation) {
            this.emit(asm, AVXKind.AVXSize.XMM, result, state, keyLocation);
        }
    }

    public static final class VexRVMConvertOp
    extends VexRVMOp {
        public static final VexRVMConvertOp VCVTSD2SS = new VexRVMConvertOp("VCVTSD2SS", 3, 1, 0, 90, VEXOpAssertion.XMM_XMM_XMM_AVX512F_128ONLY, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final VexRVMConvertOp VCVTSS2SD = new VexRVMConvertOp("VCVTSS2SD", 2, 1, 0, 90, VEXOpAssertion.XMM_XMM_XMM_AVX512F_128ONLY, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final VexRVMConvertOp VCVTSI2SD = new VexRVMConvertOp("VCVTSI2SD", 3, 1, 0, 42, VEXOpAssertion.XMM_XMM_CPU_AVX512F_128ONLY, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final VexRVMConvertOp VCVTSQ2SD = new VexRVMConvertOp("VCVTSQ2SD", 3, 1, 1, 42, VEXOpAssertion.XMM_XMM_CPU_AVX512F_128ONLY, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final VexRVMConvertOp VCVTSI2SS = new VexRVMConvertOp("VCVTSI2SS", 2, 1, 0, 42, VEXOpAssertion.XMM_XMM_CPU_AVX512F_128ONLY, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final VexRVMConvertOp VCVTSQ2SS = new VexRVMConvertOp("VCVTSQ2SS", 2, 1, 1, 42, VEXOpAssertion.XMM_XMM_CPU_AVX512F_128ONLY, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);

        private VexRVMConvertOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex);
        }
    }

    public static class VexRVROp
    extends VexOp {
        public static final VexRVROp KANDW = new VexRVROp("KANDW", 0, 1, 0, 65, VEXOpAssertion.AVX512F_MASK);
        public static final VexRVROp KANDB = new VexRVROp("KANDB", 1, 1, 0, 65, VEXOpAssertion.AVX512DQ_MASK);
        public static final VexRVROp KANDQ = new VexRVROp("KANDQ", 0, 1, 1, 65, VEXOpAssertion.AVX512BW_MASK);
        public static final VexRVROp KANDD = new VexRVROp("KANDD", 1, 1, 1, 65, VEXOpAssertion.AVX512BW_MASK);
        public static final VexRVROp KANDNW = new VexRVROp("KANDNW", 0, 1, 0, 66, VEXOpAssertion.AVX512F_MASK);
        public static final VexRVROp KANDNB = new VexRVROp("KANDNB", 1, 1, 0, 66, VEXOpAssertion.AVX512DQ_MASK);
        public static final VexRVROp KANDNQ = new VexRVROp("KANDNQ", 0, 1, 1, 66, VEXOpAssertion.AVX512BW_MASK);
        public static final VexRVROp KANDND = new VexRVROp("KANDND", 1, 1, 1, 66, VEXOpAssertion.AVX512BW_MASK);
        public static final VexRVROp KORW = new VexRVROp("KORW", 0, 1, 0, 69, VEXOpAssertion.AVX512F_MASK);
        public static final VexRVROp KORB = new VexRVROp("KORB", 1, 1, 0, 69, VEXOpAssertion.AVX512DQ_MASK);
        public static final VexRVROp KORQ = new VexRVROp("KORQ", 0, 1, 1, 69, VEXOpAssertion.AVX512BW_MASK);
        public static final VexRVROp KORD = new VexRVROp("KORD", 1, 1, 1, 69, VEXOpAssertion.AVX512BW_MASK);
        public static final VexRVROp KXORW = new VexRVROp("KXORW", 0, 1, 0, 71, VEXOpAssertion.AVX512F_MASK);
        public static final VexRVROp KXORB = new VexRVROp("KXORB", 1, 1, 0, 71, VEXOpAssertion.AVX512DQ_MASK);
        public static final VexRVROp KXORQ = new VexRVROp("KXORQ", 0, 1, 1, 71, VEXOpAssertion.AVX512BW_MASK);
        public static final VexRVROp KXORD = new VexRVROp("KXORD", 1, 1, 1, 71, VEXOpAssertion.AVX512BW_MASK);

        protected VexRVROp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, op, assertion);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, Register src2) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, dst, src1, src2), "emitting invalid instruction");
            asm.emitVEX(1, this.pp, this.mmmmm, this.w, 0, src1.encoding(), false);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src2);
        }
    }

    public static class VexRVMROp
    extends VexOp {
        public static final VexRVMROp VPBLENDVB = new VexRVMROp("VPBLENDVB", 1, 3, 0, 76, VEXOpAssertion.AVX1_2);
        public static final VexRVMROp VBLENDVPS = new VexRVMROp("VBLENDVPS", 1, 3, 0, 74, VEXOpAssertion.AVX1);
        public static final VexRVMROp VBLENDVPD = new VexRVMROp("VBLENDVPD", 1, 3, 0, 75, VEXOpAssertion.AVX1);

        protected VexRVMROp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, op, assertion);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register mask, Register src1, Register src2) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, dst, mask, src1, src2), "emitting invalid instruction");
            asm.vexPrefix(dst, src1, src2, size, this.pp, this.mmmmm, this.w, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src2);
            asm.emitByte(mask.encoding() << 4);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register mask, Register src1, AMD64Address src2) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, dst, mask, src1, null), "emitting invalid instruction");
            boolean useEvex = asm.vexPrefix(dst, src1, src2, size, this.pp, this.mmmmm, this.w, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, src2, 0, this.getDisp8Scale(useEvex, size));
            asm.emitByte(mask.encoding() << 4);
        }
    }

    public static final class VexMROp
    extends VexRROp {
        public static final VexMROp VPCOMPRESSD = new VexMROp("VPCOMPRESSD", 1, 2, 0, 139, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);

        private VexMROp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src, Register mask, int z, int b) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, src, null, dst), "emitting invalid instruction");
            asm.vexPrefix(src, Register.None, dst, mask, size, this.pp, this.mmmmm, this.w, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature, z, b);
            asm.emitByte(this.op);
            asm.emitModRM(src, dst);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, AMD64Address dst, Register src, Register mask, int z, int b) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, src, null, null), "emitting invalid instruction");
            boolean useEvex = asm.vexPrefix(src, Register.None, dst, mask, size, this.pp, this.mmmmm, this.w, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature, z, b);
            asm.emitByte(this.op);
            asm.emitOperandHelper(src, dst, 1, this.getDisp8Scale(useEvex, size));
        }
    }

    public static final class EvexRMIOp
    extends VexRMIOp {
        public static final EvexRMIOp VFPCLASSSS = new EvexRMIOp("VFPCLASS", 1, 3, 0, 103, VEXOpAssertion.MASK_NULL_XMM_AVX512DQ, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final EvexRMIOp VFPCLASSSD = new EvexRMIOp("VFPCLASD", 1, 3, 1, 103, VEXOpAssertion.MASK_NULL_XMM_AVX512DQ, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);

        private EvexRMIOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src, int imm8) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, dst, null, src), "emitting invalid instruction");
            this.emit(asm, size, dst, src, imm8, Register.None, 0, 0);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, AMD64Address src, int imm8) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, dst, null, null), "emitting invalid instruction");
            this.emit(asm, size, dst, src, imm8, Register.None, 0, 0);
        }
    }

    public static interface VexRRIOp {
        public void emit(AMD64Assembler var1, AVXKind.AVXSize var2, Register var3, Register var4, int var5);
    }

    public static abstract class VexGeneralMoveOp
    extends VexRMOp {
        protected VexGeneralMoveOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex);
        }

        public abstract void emit(AMD64Assembler var1, AVXKind.AVXSize var2, AMD64Address var3, Register var4);
    }

    public static class VexRROp
    extends VexOp {
        public static final VexRROp VMASKMOVDQU = new VexRROp("VMASKMOVDQU", 1, 1, 0, 247, VEXOpAssertion.AVX1_128ONLY, AMD64BaseAssembler.EVEXTuple.INVALID, 0);
        public static final VexRROp KTESTB = new VexRROp("KTESTB", 1, 1, 0, 153, VEXOpAssertion.AVX512DQ_MASK, AMD64BaseAssembler.EVEXTuple.INVALID, 0);
        public static final VexRROp KTESTW = new VexRROp("KTESTW", 0, 1, 0, 153, VEXOpAssertion.AVX512DQ_MASK, AMD64BaseAssembler.EVEXTuple.INVALID, 0);
        public static final VexRROp KTESTD = new VexRROp("KTESTD", 1, 1, 1, 153, VEXOpAssertion.AVX512BW_MASK, AMD64BaseAssembler.EVEXTuple.INVALID, 1);
        public static final VexRROp KTESTQ = new VexRROp("KTESTQ", 0, 1, 1, 153, VEXOpAssertion.AVX512BW_MASK, AMD64BaseAssembler.EVEXTuple.INVALID, 1);
        public static final VexRROp KORTESTB = new VexRROp("KORTESTB", 1, 1, 0, 152, VEXOpAssertion.AVX512DQ_MASK, AMD64BaseAssembler.EVEXTuple.INVALID, 0);
        public static final VexRROp KORTESTW = new VexRROp("KORTESTW", 0, 1, 0, 152, VEXOpAssertion.AVX512F_MASK, AMD64BaseAssembler.EVEXTuple.INVALID, 0);
        public static final VexRROp KORTESTD = new VexRROp("KORTESTD", 1, 1, 1, 152, VEXOpAssertion.AVX512BW_MASK, AMD64BaseAssembler.EVEXTuple.INVALID, 1);
        public static final VexRROp KORTESTQ = new VexRROp("KORTESTQ", 0, 1, 1, 152, VEXOpAssertion.AVX512BW_MASK, AMD64BaseAssembler.EVEXTuple.INVALID, 1);
        public static final VexRROp KNOTB = new VexRROp("KNOTB", 1, 1, 0, 68, VEXOpAssertion.AVX512DQ_MASK, AMD64BaseAssembler.EVEXTuple.INVALID, 0);
        public static final VexRROp KNOTW = new VexRROp("KNOTW", 0, 1, 0, 68, VEXOpAssertion.AVX512F_MASK, AMD64BaseAssembler.EVEXTuple.INVALID, 0);
        public static final VexRROp KNOTD = new VexRROp("KNOTD", 1, 1, 1, 68, VEXOpAssertion.AVX512BW_MASK, AMD64BaseAssembler.EVEXTuple.INVALID, 1);
        public static final VexRROp KNOTQ = new VexRROp("KNOTQ", 0, 1, 1, 68, VEXOpAssertion.AVX512BW_MASK, AMD64BaseAssembler.EVEXTuple.INVALID, 1);

        protected VexRROp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, dst, null, src), "emitting invalid instruction");
            assert (this.op != 26 || this.op != 90) : this.op;
            asm.vexPrefix(dst, Register.None, src, size, this.pp, this.mmmmm, this.w, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src, Register mask, int z, int b) {
            GraalError.guarantee(this.assertion.check(asm.getFeatures(), size, dst, null, src), "emitting invalid instruction");
            assert (this.op != 26 || this.op != 90) : this.op;
            asm.vexPrefix(dst, Register.None, src, mask, size, this.pp, this.mmmmm, this.w, this.wEvex, false, this.assertion.l128feature, this.assertion.l256feature, z, b);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src);
        }
    }

    public static class VexOp {
        protected final int pp;
        protected final int mmmmm;
        protected final int w;
        protected final int op;
        private final String opcode;
        protected final VEXOpAssertion assertion;
        protected final AMD64BaseAssembler.EVEXTuple evexTuple;
        protected final int wEvex;

        protected VexOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex) {
            this.pp = pp;
            this.mmmmm = mmmmm;
            this.w = w;
            this.op = op;
            this.opcode = opcode;
            this.assertion = assertion;
            this.evexTuple = evexTuple;
            this.wEvex = wEvex;
        }

        protected VexOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion) {
            this(opcode, pp, mmmmm, w, op, assertion, AMD64BaseAssembler.EVEXTuple.INVALID, 0);
        }

        public final boolean isSupported(AMD64Assembler vasm, AVXKind.AVXSize size) {
            return this.isSupported(vasm, size, false);
        }

        public final boolean isSupported(AMD64Assembler vasm, AVXKind.AVXSize size, boolean useZMMRegisters) {
            return this.assertion.supports(vasm.getFeatures(), size, useZMMRegisters);
        }

        public final boolean isSupported(AMD64 arch, AMD64Kind kind) {
            return this.assertion.supports(arch.getFeatures(), AVXKind.getRegisterSize(kind), false);
        }

        public String toString() {
            return this.opcode;
        }

        protected final int getDisp8Scale(boolean useEvex, AVXKind.AVXSize size) {
            return useEvex ? this.evexTuple.getDisp8ScalingFactor(size) : 1;
        }
    }

    private static enum VEXOpAssertion {
        AVX1(AMD64.CPUFeature.AVX, AMD64.CPUFeature.AVX, null),
        AVX1_2(AMD64.CPUFeature.AVX, AMD64.CPUFeature.AVX2, null),
        AVX2(AMD64.CPUFeature.AVX2, AMD64.CPUFeature.AVX2, null),
        AVX1_128ONLY(AMD64.CPUFeature.AVX, null, null),
        AVX1_256ONLY(null, AMD64.CPUFeature.AVX, null),
        AVX2_256ONLY(null, AMD64.CPUFeature.AVX2, null),
        XMM_CPU(AMD64.CPUFeature.AVX, null, null, null, AMD64.XMM, null, AMD64.CPU, null),
        XMM_XMM_CPU(AMD64.CPUFeature.AVX, null, null, null, AMD64.XMM, AMD64.XMM, AMD64.CPU, null),
        CPU_XMM(AMD64.CPUFeature.AVX, null, null, null, AMD64.CPU, null, AMD64.XMM, null),
        AVX1_2_CPU_XMM(AMD64.CPUFeature.AVX, AMD64.CPUFeature.AVX2, null, null, AMD64.CPU, null, AMD64.XMM, null),
        BMI1(AMD64.CPUFeature.BMI1, null, null, null, AMD64.CPU, AMD64.CPU, AMD64.CPU, null),
        BMI2(AMD64.CPUFeature.BMI2, null, null, null, AMD64.CPU, AMD64.CPU, AMD64.CPU, null),
        FMA(AMD64.CPUFeature.FMA, null, null, null, AMD64.XMM, AMD64.XMM, AMD64.XMM, null),
        FMA_AVX512F_128ONLY(AMD64.CPUFeature.FMA, null, null, EVEXFeatureAssertion.AVX512F_128ONLY, AMD64.XMM, AMD64.XMM, AMD64.XMM, null),
        XMM_CPU_AVX512F_128ONLY(AMD64.CPUFeature.AVX, null, null, EVEXFeatureAssertion.AVX512F_128ONLY, AMD64.XMM, null, AMD64.CPU, null),
        CPU_XMM_AVX512F_128ONLY(AMD64.CPUFeature.AVX, null, null, EVEXFeatureAssertion.AVX512F_128ONLY, AMD64.CPU, null, AMD64.XMM, null),
        XMM_XMM_XMM_AVX512F_128ONLY(AMD64.CPUFeature.AVX, null, null, EVEXFeatureAssertion.AVX512F_128ONLY, AMD64.XMM, AMD64.XMM, AMD64.XMM, null),
        XMM_XMM_CPU_AVX512F_128ONLY(AMD64.CPUFeature.AVX, null, null, EVEXFeatureAssertion.AVX512F_128ONLY, AMD64.XMM, AMD64.XMM, AMD64.CPU, null),
        AVX1_AVX512F_128_ONLY(AMD64.CPUFeature.AVX, AMD64.CPUFeature.AVX, EVEXFeatureAssertion.AVX512F_128ONLY),
        AVX1_AVX512F_ALL(AMD64.CPUFeature.AVX, AMD64.CPUFeature.AVX, EVEXFeatureAssertion.AVX512F_ALL),
        AVX1_AVX512F_VL(AMD64.CPUFeature.AVX, AMD64.CPUFeature.AVX, EVEXFeatureAssertion.AVX512F_VL),
        AVX1_256ONLY_AVX512F_VL(null, AMD64.CPUFeature.AVX, EVEXFeatureAssertion.AVX512F_VL),
        AVX1_128ONLY_AVX512F_128ONLY(AMD64.CPUFeature.AVX, null, EVEXFeatureAssertion.AVX512F_128ONLY),
        AVX1_AVX2_AVX512F_BW(AMD64.CPUFeature.AVX, AMD64.CPUFeature.AVX2, EVEXFeatureAssertion.AVX512F_BW_ALL),
        AVX1_AVX2_AVX512BW_VL(AMD64.CPUFeature.AVX, AMD64.CPUFeature.AVX2, EVEXFeatureAssertion.AVX512F_BW_VL),
        AVX1_AVX2_AVX512F_VL(AMD64.CPUFeature.AVX, AMD64.CPUFeature.AVX2, EVEXFeatureAssertion.AVX512F_VL),
        AVX2_AVX512BW_VL(AMD64.CPUFeature.AVX2, AMD64.CPUFeature.AVX2, EVEXFeatureAssertion.AVX512F_BW_VL),
        AVX2_AVX512F_VL(AMD64.CPUFeature.AVX2, AMD64.CPUFeature.AVX2, EVEXFeatureAssertion.AVX512F_VL),
        AVX512BW_VL(AMD64.CPUFeature.AVX512VL, AMD64.CPUFeature.AVX512VL, EVEXFeatureAssertion.AVX512F_BW_VL),
        AVX512F_VL(AMD64.CPUFeature.AVX512VL, AMD64.CPUFeature.AVX512VL, EVEXFeatureAssertion.AVX512F_VL),
        AVX512F_VL_256_512(null, AMD64.CPUFeature.AVX512VL, EVEXFeatureAssertion.AVX512F_VL_256_512),
        AVX512DQ_VL(AMD64.CPUFeature.AVX512VL, AMD64.CPUFeature.AVX512VL, EVEXFeatureAssertion.AVX512F_DQ_VL),
        AVX512DQ_VL_256_512(null, AMD64.CPUFeature.AVX512VL, EVEXFeatureAssertion.AVX512F_DQ_VL_256_512),
        AVX512DQ_512ONLY(null, null, EVEXFeatureAssertion.AVX512F_DQ_512ONLY),
        AVX512F_512ONLY(null, null, EVEXFeatureAssertion.AVX512F_512ONLY),
        AVX_AVX512F_VL_256_512(null, AMD64.CPUFeature.AVX, EVEXFeatureAssertion.AVX512F_VL),
        AVX2_AVX512F_VL_256_512(null, AMD64.CPUFeature.AVX2, EVEXFeatureAssertion.AVX512F_VL),
        AVX1_AVX512DQ_VL(AMD64.CPUFeature.AVX, AMD64.CPUFeature.AVX, EVEXFeatureAssertion.AVX512F_DQ_VL),
        AVX512F_CPU_OR_MASK(AMD64.CPUFeature.AVX512F, null, null, EVEXFeatureAssertion.AVX512F_ALL, CPU_OR_MASK, null, CPU_OR_MASK, null),
        AVX512DQ_CPU_OR_MASK(AMD64.CPUFeature.AVX512DQ, null, null, EVEXFeatureAssertion.AVX512F_DQ_ALL, CPU_OR_MASK, null, CPU_OR_MASK, null),
        AVX512BW_CPU_OR_MASK(AMD64.CPUFeature.AVX512BW, null, null, EVEXFeatureAssertion.AVX512F_BW_ALL, CPU_OR_MASK, null, CPU_OR_MASK, null),
        AVX512F_MASK(AMD64.CPUFeature.AVX512F, null, null, null, AMD64.MASK, AMD64.MASK, AMD64.MASK, null),
        AVX512DQ_MASK(AMD64.CPUFeature.AVX512DQ, null, null, null, AMD64.MASK, AMD64.MASK, AMD64.MASK, null),
        AVX512BW_MASK(AMD64.CPUFeature.AVX512BW, null, null, null, AMD64.MASK, AMD64.MASK, AMD64.MASK, null),
        MASK_XMM_XMM_AVX512BW_VL(AMD64.CPUFeature.AVX512VL, AMD64.CPUFeature.AVX512VL, null, EVEXFeatureAssertion.AVX512F_BW_VL, AMD64.MASK, AMD64.XMM, AMD64.XMM, null),
        MASK_NULL_XMM_AVX512BW_VL(AMD64.CPUFeature.AVX512VL, AMD64.CPUFeature.AVX512VL, null, EVEXFeatureAssertion.AVX512F_BW_VL, AMD64.MASK, null, AMD64.XMM, null),
        MASK_NULL_XMM_AVX512DQ_VL(AMD64.CPUFeature.AVX512VL, AMD64.CPUFeature.AVX512VL, null, EVEXFeatureAssertion.AVX512F_DQ_VL, AMD64.MASK, null, AMD64.XMM, null),
        MASK_NULL_XMM_AVX512DQ(AMD64.CPUFeature.AVX512DQ, AMD64.CPUFeature.AVX512DQ, null, EVEXFeatureAssertion.AVX512F_DQ_ALL, AMD64.MASK, null, AMD64.XMM, null),
        MASK_XMM_XMM_AVX512F_VL(AMD64.CPUFeature.AVX512VL, AMD64.CPUFeature.AVX512VL, null, EVEXFeatureAssertion.AVX512F_VL, AMD64.MASK, AMD64.XMM, AMD64.XMM, null),
        AVX1_128ONLY_CLMUL(AMD64.CPUFeature.AVX, null, AMD64.CPUFeature.CLMUL, null, AMD64.XMM, AMD64.XMM, AMD64.XMM, AMD64.XMM),
        AVX1_128ONLY_AES(AMD64.CPUFeature.AVX, null, AMD64.CPUFeature.AES, null, AMD64.XMM, AMD64.XMM, AMD64.XMM, AMD64.XMM),
        AVX1_GFNI_AVX512F_VL(AMD64.CPUFeature.GFNI, AMD64.CPUFeature.GFNI, AMD64.CPUFeature.AVX, EVEXFeatureAssertion.AVX512F_VL, AMD64.XMM, AMD64.XMM, AMD64.XMM, null),
        F16C_AVX512F_VL(AMD64.CPUFeature.F16C, AMD64.CPUFeature.F16C, null, EVEXFeatureAssertion.AVX512F_VL, AMD64.XMM, AMD64.XMM, AMD64.XMM, null);

        private final AMD64.CPUFeature l128feature;
        private final AMD64.CPUFeature l256feature;
        private final AMD64.CPUFeature extendedFeature;
        private final EVEXFeatureAssertion l512features;
        private final Register.RegisterCategory rCategory;
        private final Register.RegisterCategory vCategory;
        private final Register.RegisterCategory mCategory;
        private final Register.RegisterCategory imm8Category;

        private VEXOpAssertion(AMD64.CPUFeature l128feature, AMD64.CPUFeature l256feature, EVEXFeatureAssertion l512features) {
            this(l128feature, l256feature, null, l512features, AMD64.XMM, AMD64.XMM, AMD64.XMM, AMD64.XMM);
        }

        private VEXOpAssertion(AMD64.CPUFeature l128feature, AMD64.CPUFeature l256feature, AMD64.CPUFeature extendedFeature, EVEXFeatureAssertion l512features, Register.RegisterCategory rCategory, Register.RegisterCategory vCategory, Register.RegisterCategory mCategory, Register.RegisterCategory imm8Category) {
            this.l128feature = l128feature;
            this.l256feature = l256feature;
            this.extendedFeature = extendedFeature;
            this.l512features = l512features;
            this.rCategory = rCategory;
            this.vCategory = vCategory;
            this.mCategory = mCategory;
            this.imm8Category = imm8Category;
        }

        public boolean check(EnumSet<AMD64.CPUFeature> features, AVXKind.AVXSize size, Register r, Register v, Register m) {
            return this.check(features, AMD64BaseAssembler.getLFlag(size), r, v, m, null);
        }

        public boolean check(EnumSet<AMD64.CPUFeature> features, AVXKind.AVXSize size, Register r, Register v, Register m, Register imm8) {
            return this.check(features, AMD64BaseAssembler.getLFlag(size), r, v, m, imm8);
        }

        public boolean check(EnumSet<AMD64.CPUFeature> features, int l, Register r, Register v, Register m, Register imm8) {
            if (AMD64BaseAssembler.isAVX512Register(r) || AMD64BaseAssembler.isAVX512Register(v) || AMD64BaseAssembler.isAVX512Register(m) || l == 2) {
                GraalError.guarantee(this.l512features != null && this.l512features.check(features, l), "emitting illegal 512 bit instruction, required features: %s", (Object)this.l512features);
            } else if (l == 0) {
                GraalError.guarantee(this.l128feature != null && features.contains(this.l128feature), "emitting illegal 128 bit instruction, required feature: %s", (Object)this.l128feature);
            } else if (l == 1) {
                GraalError.guarantee(this.l256feature != null && features.contains(this.l256feature), "emitting illegal 256 bit instruction, required feature: %s", (Object)this.l256feature);
            }
            if (r != null) {
                GraalError.guarantee(AMD64Assembler.categoryContains(this.rCategory, r), "expected r in category %s, got %s", (Object)this.rCategory, (Object)r);
            }
            if (v != null) {
                GraalError.guarantee(AMD64Assembler.categoryContains(this.vCategory, v), "expected v in category %s, got %s", (Object)this.vCategory, (Object)v);
            }
            if (m != null) {
                GraalError.guarantee(AMD64Assembler.categoryContains(this.mCategory, m), "expected m in category %s, got %s", (Object)this.mCategory, (Object)m);
            }
            if (imm8 != null) {
                GraalError.guarantee(imm8.getRegisterCategory().equals((Object)this.imm8Category), "expected imm8 in category %s, got %s", (Object)this.imm8Category, (Object)imm8);
            }
            if (this.extendedFeature != null) {
                GraalError.guarantee(features.contains(this.extendedFeature), "emitting illegal instruction, required extended feature: %s", (Object)this.extendedFeature);
            }
            return true;
        }

        public boolean supports(EnumSet<AMD64.CPUFeature> features, AVXKind.AVXSize avxSize, boolean useZMMRegisters) {
            boolean extendedFeatureCheck;
            boolean bl = extendedFeatureCheck = this.extendedFeature != null ? features.contains(this.extendedFeature) : true;
            if (useZMMRegisters || avxSize == AVXKind.AVXSize.ZMM) {
                return this.l512features != null && this.l512features.supports(features, avxSize) && extendedFeatureCheck;
            }
            if (avxSize == AVXKind.AVXSize.XMM) {
                return this.l128feature != null && features.contains(this.l128feature) && extendedFeatureCheck;
            }
            if (avxSize == AVXKind.AVXSize.YMM) {
                return this.l256feature != null && features.contains(this.l256feature) && extendedFeatureCheck;
            }
            throw GraalError.shouldNotReachHereUnexpectedValue(avxSize);
        }
    }

    private static enum EVEXFeatureAssertion {
        AVX512F_ALL(EnumSet.of(AMD64.CPUFeature.AVX512F), EnumSet.of(AMD64.CPUFeature.AVX512F), EnumSet.of(AMD64.CPUFeature.AVX512F)),
        AVX512F_128ONLY(EnumSet.of(AMD64.CPUFeature.AVX512F), null, null),
        AVX512F_VL(EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512VL), EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512VL), EnumSet.of(AMD64.CPUFeature.AVX512F)),
        AVX512F_CD_VL(EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512CD, AMD64.CPUFeature.AVX512VL), EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512CD, AMD64.CPUFeature.AVX512VL), EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512CD)),
        AVX512F_DQ_ALL(EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512DQ), EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512DQ), EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512DQ)),
        AVX512F_DQ_VL(EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512DQ, AMD64.CPUFeature.AVX512VL), EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512DQ, AMD64.CPUFeature.AVX512VL), EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512DQ)),
        AVX512F_BW_ALL(EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512BW), EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512BW), EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512BW)),
        AVX512F_BW_VL(EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512BW, AMD64.CPUFeature.AVX512VL), EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512BW, AMD64.CPUFeature.AVX512VL), EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512BW)),
        AVX512F_VL_256_512(null, EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512VL), EnumSet.of(AMD64.CPUFeature.AVX512F)),
        AVX512F_DQ_VL_256_512(null, EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512DQ, AMD64.CPUFeature.AVX512VL), EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512DQ)),
        AVX512F_DQ_512ONLY(null, null, EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512DQ)),
        AVX512F_512ONLY(null, null, EnumSet.of(AMD64.CPUFeature.AVX512F));

        private final EnumSet<AMD64.CPUFeature> l128features;
        private final EnumSet<AMD64.CPUFeature> l256features;
        private final EnumSet<AMD64.CPUFeature> l512features;

        private EVEXFeatureAssertion(EnumSet<AMD64.CPUFeature> l128features, EnumSet<AMD64.CPUFeature> l256features, EnumSet<AMD64.CPUFeature> l512features) {
            this.l128features = l128features;
            this.l256features = l256features;
            this.l512features = l512features;
        }

        public boolean check(EnumSet<AMD64.CPUFeature> features, int l) {
            switch (l) {
                case 0: {
                    GraalError.guarantee(this.l128features != null && features.containsAll(this.l128features), "emitting illegal 128 bit instruction, required features: %s", this.l128features);
                    break;
                }
                case 1: {
                    GraalError.guarantee(this.l256features != null && features.containsAll(this.l256features), "emitting illegal 256 bit instruction, required features: %s", this.l256features);
                    break;
                }
                case 2: {
                    GraalError.guarantee(this.l512features != null && features.containsAll(this.l512features), "emitting illegal 512 bit instruction, required features: %s", this.l512features);
                }
            }
            return true;
        }

        public boolean supports(EnumSet<AMD64.CPUFeature> features, AVXKind.AVXSize avxSize) {
            switch (avxSize) {
                case XMM: {
                    return this.l128features != null && features.containsAll(this.l128features);
                }
                case YMM: {
                    return this.l256features != null && features.containsAll(this.l256features);
                }
                case ZMM: {
                    return this.l512features != null && features.containsAll(this.l512features);
                }
            }
            throw GraalError.shouldNotReachHereUnexpectedValue(avxSize);
        }
    }

    public static final class AMD64Z0Op
    extends AMD64Op {
        public static final AMD64Z0Op PUSHFQ = new AMD64Z0Op("PUSHFQ", 156);

        protected AMD64Z0Op(String opcode, int op) {
            this(opcode, 0, 0, op, null);
        }

        protected AMD64Z0Op(String opcode, int prefix1, int prefix2, int op, AMD64.CPUFeature feature) {
            super(opcode, prefix1, prefix2, op, OpAssertion.NoOperandAssertion, feature);
        }

        public void emit(AMD64Assembler asm) {
            this.emitOpcode(asm, AMD64BaseAssembler.OperandSize.BYTE, AMD64BaseAssembler.getRXB(null, (Register)null), 0, 0);
        }
    }

    private static enum PreferredNDS {
        NONE,
        DST,
        SRC;


        public Register getNds(Register reg, AMD64Address address) {
            switch (this.ordinal()) {
                case 1: 
                case 2: {
                    return reg;
                }
            }
            return Register.None;
        }

        public Register getNds(Register dst, Register src) {
            switch (this.ordinal()) {
                case 1: {
                    return dst;
                }
                case 2: {
                    return src;
                }
            }
            return Register.None;
        }
    }

    public static abstract class AMD64RROp
    extends AMD64Op {
        protected AMD64RROp(String opcode, int prefix1, int prefix2, int op, OpAssertion assertion, AMD64.CPUFeature feature) {
            super(opcode, prefix1, prefix2, op, assertion, feature);
        }

        protected AMD64RROp(String opcode, int prefix1, int prefix2, int op, boolean dstIsByte, boolean srcIsByte, OpAssertion assertion, AMD64.CPUFeature feature) {
            super(opcode, prefix1, prefix2, op, dstIsByte, srcIsByte, assertion, feature);
        }

        public abstract void emit(AMD64Assembler var1, AMD64BaseAssembler.OperandSize var2, Register var3, Register var4);
    }

    public static class AMD64ImmOp
    extends AMD64Op {
        private final boolean immIsByte;

        protected AMD64ImmOp(String opcode, boolean immIsByte, int prefix, int op, OpAssertion assertion) {
            this(opcode, immIsByte, prefix, op, assertion, null);
        }

        protected AMD64ImmOp(String opcode, boolean immIsByte, int prefix, int op, OpAssertion assertion, AMD64.CPUFeature feature) {
            super(opcode, 0, prefix, op, assertion, feature);
            this.immIsByte = immIsByte;
        }

        protected final void emitImmediate(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, int imm) {
            if (this.immIsByte) {
                assert (imm == (byte)imm) : imm;
                asm.emitByte(imm);
            } else {
                size.emitImmediate(asm, imm);
            }
        }

        public final int immediateSize(AMD64BaseAssembler.OperandSize size) {
            if (this.immIsByte) {
                return 1;
            }
            return size.immediateSize();
        }
    }

    public static class AMD64Op {
        private final String opcode;
        protected final int prefix1;
        protected final int prefix2;
        protected final int op;
        final boolean dstIsByte;
        final boolean srcIsByte;
        private final OpAssertion assertion;
        private final AMD64.CPUFeature feature;

        protected AMD64Op(String opcode, int prefix1, int prefix2, int op, OpAssertion assertion, AMD64.CPUFeature feature) {
            this(opcode, prefix1, prefix2, op, assertion == OpAssertion.ByteAssertion, assertion == OpAssertion.ByteAssertion, assertion, feature);
        }

        protected AMD64Op(String opcode, int prefix1, int prefix2, int op, boolean dstIsByte, boolean srcIsByte, OpAssertion assertion, AMD64.CPUFeature feature) {
            this.opcode = opcode;
            this.prefix1 = prefix1;
            this.prefix2 = prefix2;
            this.op = op;
            this.dstIsByte = dstIsByte;
            this.srcIsByte = srcIsByte;
            this.assertion = assertion;
            this.feature = feature;
        }

        protected final void emitOpcode(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, int rxb, int dstEnc, int srcEnc) {
            if (this.prefix1 != 0) {
                asm.emitByte(this.prefix1);
            }
            if (size.getSizePrefix() != 0) {
                asm.emitByte(size.getSizePrefix());
            }
            int rexPrefix = 0x40 | rxb;
            if (size == AMD64BaseAssembler.OperandSize.QWORD) {
                rexPrefix |= 8;
            }
            if (rexPrefix != 64 || this.dstIsByte && dstEnc >= 4 || this.srcIsByte && srcEnc >= 4) {
                asm.emitByte(rexPrefix);
            }
            if (this.prefix2 > 255) {
                asm.emitShort(this.prefix2);
            } else if (this.prefix2 > 0) {
                asm.emitByte(this.prefix2);
            }
            asm.emitByte(this.op);
        }

        protected final boolean verify(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register resultReg, Register inputReg) {
            assert (this.feature == null || asm.supports(this.feature)) : String.format("unsupported feature %s required for %s", this.feature, this.opcode);
            assert (this.assertion.checkOperands(this, size, resultReg, inputReg)) : "Operands must verify for " + String.valueOf(inputReg) + " " + String.valueOf(resultReg);
            return true;
        }

        public AMD64BaseAssembler.OperandSize[] getAllowedSizes() {
            return this.assertion.allowedSizes;
        }

        protected final boolean isSSEInstruction() {
            if (this.feature == null) {
                return false;
            }
            switch (this.feature) {
                case SSE: 
                case SSE2: 
                case SSE3: 
                case SSSE3: 
                case SSE4A: 
                case SSE4_1: 
                case SSE4_2: {
                    return true;
                }
            }
            return false;
        }

        public final OpAssertion getAssertion() {
            return this.assertion;
        }

        public String toString() {
            return this.opcode;
        }
    }

    private static final class OpAssertion
    extends Enum<OpAssertion> {
        public static final /* enum */ OpAssertion NoOperandAssertion = new OpAssertion(null, null, new AMD64BaseAssembler.OperandSize[0]);
        public static final /* enum */ OpAssertion ByteAssertion = new OpAssertion(AMD64.CPU, AMD64.CPU, AMD64BaseAssembler.OperandSize.BYTE);
        public static final /* enum */ OpAssertion ByteOrLargerAssertion = new OpAssertion(AMD64.CPU, AMD64.CPU, AMD64BaseAssembler.OperandSize.BYTE, AMD64BaseAssembler.OperandSize.WORD, AMD64BaseAssembler.OperandSize.DWORD, AMD64BaseAssembler.OperandSize.QWORD);
        public static final /* enum */ OpAssertion WordOrLargerAssertion = new OpAssertion(AMD64.CPU, AMD64.CPU, AMD64BaseAssembler.OperandSize.WORD, AMD64BaseAssembler.OperandSize.DWORD, AMD64BaseAssembler.OperandSize.QWORD);
        public static final /* enum */ OpAssertion DwordOrLargerAssertion = new OpAssertion(AMD64.CPU, AMD64.CPU, AMD64BaseAssembler.OperandSize.DWORD, AMD64BaseAssembler.OperandSize.QWORD);
        public static final /* enum */ OpAssertion WordOrQwordAssertion = new OpAssertion(AMD64.CPU, AMD64.CPU, AMD64BaseAssembler.OperandSize.WORD, AMD64BaseAssembler.OperandSize.QWORD);
        public static final /* enum */ OpAssertion QwordAssertion = new OpAssertion(AMD64.CPU, AMD64.CPU, AMD64BaseAssembler.OperandSize.QWORD);
        public static final /* enum */ OpAssertion FloatAssertion = new OpAssertion(AMD64.XMM, AMD64.XMM, AMD64BaseAssembler.OperandSize.SS, AMD64BaseAssembler.OperandSize.SD, AMD64BaseAssembler.OperandSize.PS, AMD64BaseAssembler.OperandSize.PD);
        public static final /* enum */ OpAssertion ScalarFloatAssertion = new OpAssertion(AMD64.XMM, AMD64.XMM, AMD64BaseAssembler.OperandSize.SS, AMD64BaseAssembler.OperandSize.SD);
        public static final /* enum */ OpAssertion PackedFloatAssertion = new OpAssertion(AMD64.XMM, AMD64.XMM, AMD64BaseAssembler.OperandSize.PS, AMD64BaseAssembler.OperandSize.PD);
        public static final /* enum */ OpAssertion SingleAssertion = new OpAssertion(AMD64.XMM, AMD64.XMM, AMD64BaseAssembler.OperandSize.SS);
        public static final /* enum */ OpAssertion DoubleAssertion = new OpAssertion(AMD64.XMM, AMD64.XMM, AMD64BaseAssembler.OperandSize.SD);
        public static final /* enum */ OpAssertion PackedSingleAssertion = new OpAssertion(AMD64.XMM, AMD64.XMM, AMD64BaseAssembler.OperandSize.PS);
        public static final /* enum */ OpAssertion PackedDoubleAssertion = new OpAssertion(AMD64.XMM, AMD64.XMM, AMD64BaseAssembler.OperandSize.PD);
        public static final /* enum */ OpAssertion IntToFloatAssertion = new OpAssertion(AMD64.XMM, AMD64.CPU, AMD64BaseAssembler.OperandSize.DWORD, AMD64BaseAssembler.OperandSize.QWORD);
        public static final /* enum */ OpAssertion DwordToFloatAssertion = new OpAssertion(AMD64.XMM, AMD64.CPU, AMD64BaseAssembler.OperandSize.DWORD);
        public static final /* enum */ OpAssertion QwordToFloatAssertion = new OpAssertion(AMD64.XMM, AMD64.CPU, AMD64BaseAssembler.OperandSize.QWORD);
        public static final /* enum */ OpAssertion FloatToIntAssertion = new OpAssertion(AMD64.CPU, AMD64.XMM, AMD64BaseAssembler.OperandSize.DWORD, AMD64BaseAssembler.OperandSize.QWORD);
        private final Register.RegisterCategory resultCategory;
        private final Register.RegisterCategory inputCategory;
        private final AMD64BaseAssembler.OperandSize[] allowedSizes;
        private static final /* synthetic */ OpAssertion[] $VALUES;

        public static OpAssertion[] values() {
            return (OpAssertion[])$VALUES.clone();
        }

        public static OpAssertion valueOf(String name) {
            return Enum.valueOf(OpAssertion.class, name);
        }

        private OpAssertion(Register.RegisterCategory resultCategory, Register.RegisterCategory inputCategory, AMD64BaseAssembler.OperandSize ... allowedSizes) {
            this.resultCategory = resultCategory;
            this.inputCategory = inputCategory;
            this.allowedSizes = allowedSizes;
        }

        protected boolean checkOperands(AMD64Op op, AMD64BaseAssembler.OperandSize size, Register resultReg, Register inputReg) {
            assert (resultReg == null || this.resultCategory.equals((Object)resultReg.getRegisterCategory())) : "invalid result register " + String.valueOf(resultReg) + " used in " + String.valueOf(op);
            assert (inputReg == null || this.inputCategory.equals((Object)inputReg.getRegisterCategory())) : "invalid input register " + String.valueOf(inputReg) + " used in " + String.valueOf(op);
            for (AMD64BaseAssembler.OperandSize s : this.allowedSizes) {
                if (size != s) continue;
                return true;
            }
            assert (false) : "invalid operand size " + String.valueOf((Object)size) + " used in " + String.valueOf(op);
            return false;
        }

        private static /* synthetic */ OpAssertion[] $values() {
            return new OpAssertion[]{NoOperandAssertion, ByteAssertion, ByteOrLargerAssertion, WordOrLargerAssertion, DwordOrLargerAssertion, WordOrQwordAssertion, QwordAssertion, FloatAssertion, ScalarFloatAssertion, PackedFloatAssertion, SingleAssertion, DoubleAssertion, PackedSingleAssertion, PackedDoubleAssertion, IntToFloatAssertion, DwordToFloatAssertion, QwordToFloatAssertion, FloatToIntAssertion};
        }

        static {
            $VALUES = OpAssertion.$values();
        }
    }
}

