/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.bytecode;

import jdk.graal.compiler.bytecode.BytecodeStream;

public abstract class BytecodeSwitch {
    protected final BytecodeStream stream;
    protected final int bci;
    protected final int alignedBci;

    public BytecodeSwitch(BytecodeStream stream, int bci) {
        this.stream = stream;
        this.bci = bci;
        this.alignedBci = bci + 4 & 0xFFFFFFFC;
    }

    public int bci() {
        return this.bci;
    }

    public int targetAt(int i) {
        return this.bci + this.offsetAt(i);
    }

    public int defaultTarget() {
        return this.bci + this.defaultOffset();
    }

    public int defaultOffset() {
        return this.stream.readInt(this.alignedBci);
    }

    public abstract int keyAt(int var1);

    public abstract int offsetAt(int var1);

    public abstract int numberOfCases();

    public abstract int size();
}

