/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Formatter;
import java.util.Map;
import jdk.graal.compiler.core.GraalCompilerOptions;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.DebugOptions;
import jdk.graal.compiler.debug.DiagnosticsOutputDirectory;
import jdk.graal.compiler.debug.PathUtilities;
import jdk.graal.compiler.debug.TTY;
import jdk.graal.compiler.options.EnumOptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.serviceprovider.GlobalAtomicLong;
import jdk.vm.ci.code.BailoutException;

public abstract class CompilationWrapper<T> {
    private final DiagnosticsOutputDirectory outputDirectory;
    private final Map<ExceptionAction, Integer> problemsHandledPerAction;
    private static final GlobalAtomicLong totalCompilations = new GlobalAtomicLong(0L);
    private static final GlobalAtomicLong failedCompilations = new GlobalAtomicLong(0L);
    private static final GlobalAtomicLong compilationPeriodStart = new GlobalAtomicLong(0L);
    private static final int COMPILATION_FAILURE_DETECTION_PERIOD_MS = 2000;
    private static final int MIN_COMPILATIONS_FOR_FAILURE_DETECTION = 25;

    public CompilationWrapper(DiagnosticsOutputDirectory outputDirectory, Map<ExceptionAction, Integer> problemsHandledPerAction) {
        this.outputDirectory = outputDirectory;
        this.problemsHandledPerAction = problemsHandledPerAction;
    }

    protected abstract T handleException(Throwable var1);

    protected ExceptionAction lookupAction(OptionValues options, Throwable cause) {
        if (CompilationWrapper.isNonFailureBailout(options, cause)) {
            return ExceptionAction.Silent;
        }
        return (ExceptionAction)((Object)GraalCompilerOptions.CompilationFailureAction.getValue(options));
    }

    private static boolean isNonFailureBailout(OptionValues options, Throwable cause) {
        return cause instanceof BailoutException && GraalCompilerOptions.CompilationBailoutAsFailure.getValue(options) == false;
    }

    protected abstract T performCompilation(DebugContext var1);

    protected void dumpOnError(DebugContext errorContext, Throwable cause) {
    }

    public abstract String toString();

    protected abstract DebugContext createRetryDebugContext(DebugContext var1, OptionValues var2, PrintStream var3);

    protected T onCompilationFailure(Failure failure) {
        return failure.handle(false);
    }

    public final T run(DebugContext initialDebug) {
        try {
            totalCompilations.incrementAndGet();
            return this.performCompilation(initialDebug);
        }
        catch (Throwable cause) {
            return this.onCompilationFailure(new Failure(cause, initialDebug));
        }
    }

    private static void printCompilationFailureActionAlternatives(PrintStream ps, ExceptionAction ... alternatives) {
        if (alternatives.length > 0) {
            ps.printf("If in an environment where setting system properties is possible, the following%n", new Object[0]);
            ps.printf("properties are available to change compilation failure reporting:%n", new Object[0]);
            for (ExceptionAction action : alternatives) {
                String option = GraalCompilerOptions.CompilationFailureAction.getName();
                if (action == ExceptionAction.Silent) {
                    ps.printf("- To disable compilation failure notifications, set %s to %s (e.g., -Djdk.graal.%s=%s).%n", new Object[]{option, action, option, action});
                    continue;
                }
                if (action == ExceptionAction.Print) {
                    ps.printf("- To print a message for a compilation failure without retrying the compilation, set %s to %s (e.g., -Djdk.graal.%s=%s).%n", new Object[]{option, action, option, action});
                    continue;
                }
                if (action != ExceptionAction.Diagnose) continue;
                ps.printf("- To capture more information for diagnosing or reporting a compilation failure, set %s to %s or %s (e.g., -Djdk.graal.%s=%s).%n", new Object[]{option, action, ExceptionAction.ExitVM, option, action});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected T handleFailure(DebugContext initialDebug, Throwable cause) {
        OptionValues initialOptions = initialDebug.getOptions();
        EnumOptionKey<ExceptionAction> enumOptionKey = GraalCompilerOptions.CompilationFailureAction;
        synchronized (enumOptionKey) {
            String message;
            ExceptionAction action = this.lookupAction(initialOptions, cause);
            action = this.adjustAction(initialOptions, action, cause);
            if (action == ExceptionAction.Silent) {
                return this.handleException(cause);
            }
            if (action == ExceptionAction.Print) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try (PrintStream ps = new PrintStream(baos);){
                    ps.printf("%s: Compilation of %s failed: ", Thread.currentThread(), this);
                    cause.printStackTrace(ps);
                    CompilationWrapper.printCompilationFailureActionAlternatives(ps, ExceptionAction.Silent, ExceptionAction.Diagnose);
                }
                TTY.print(baos.toString());
                return this.handleException(cause);
            }
            if (DebugOptions.Dump.hasBeenSet(initialOptions)) {
                return this.handleException(cause);
            }
            String dumpPath = null;
            try {
                String dir = this.outputDirectory.getPath();
                if (dir != null) {
                    String dumpName = PathUtilities.sanitizeFileName(this.toString());
                    dumpPath = PathUtilities.createDirectories(PathUtilities.getPath(dir, dumpName));
                }
            }
            catch (Throwable t) {
                TTY.println("Warning: could not create Graal diagnostics directory");
                t.printStackTrace(TTY.out);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (PrintStream ps = new PrintStream(baos);){
                ps.println("[[[Graal compilation failure]]]");
                ps.printf("%s: Compilation of %s failed:%n", Thread.currentThread(), this);
                cause.printStackTrace(ps);
                CompilationWrapper.printCompilationFailureActionAlternatives(ps, ExceptionAction.Silent, ExceptionAction.Print);
                if (dumpPath != null) {
                    ps.println("Retrying compilation of " + String.valueOf(this));
                } else {
                    ps.println("Not retrying compilation of " + String.valueOf(this) + " as the dump path could not be created.");
                }
                message = baos.toString();
            }
            TTY.print(message);
            if (dumpPath == null) {
                return this.handleException(cause);
            }
            String retryLogFile = PathUtilities.getPath(dumpPath, "retry.log");
            try (PrintStream ps = new PrintStream(PathUtilities.openOutputStream(retryLogFile));){
                ps.print(message);
            }
            catch (IOException ioe) {
                TTY.printf("Error writing to %s: %s%n", retryLogFile, ioe);
            }
            Object diagnoseLevel = DebugOptions.DiagnoseDumpLevel.getValue(initialOptions);
            boolean isOldLevel = ((String)diagnoseLevel).matches("-?\\d+");
            if (isOldLevel) {
                diagnoseLevel = ":" + (String)diagnoseLevel;
            }
            OptionValues retryOptions = new OptionValues(initialOptions, DebugOptions.Dump, diagnoseLevel, DebugOptions.MethodFilter, null, DebugOptions.Count, "", DebugOptions.Time, "", DebugOptions.DumpPath, dumpPath, DebugOptions.PrintBackendCFG, true, GraalOptions.TrackNodeSourcePosition, true);
            ByteArrayOutputStream logBaos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(logBaos);
            try {
                T res;
                DebugContext retryDebug = this.createRetryDebugContext(initialDebug, retryOptions, ps);
                this.dumpOnError(retryDebug, cause);
                try {
                    res = this.performCompilation(retryDebug);
                }
                finally {
                    ps.println("<Metrics>");
                    retryDebug.printMetrics(initialDebug.getDescription(), ps, true);
                    ps.println("</Metrics>");
                }
                ps.println("There was no exception during retry.");
                CompilationWrapper.finalizeRetryLog(retryLogFile, logBaos, ps);
                T t = this.postRetry(action, res);
                return t;
                finally {
                    if (retryDebug != null) {
                        retryDebug.close();
                    }
                }
            }
            catch (Throwable e) {
                ps.println("Exception during retry:");
                e.printStackTrace(ps);
                CompilationWrapper.finalizeRetryLog(retryLogFile, logBaos, ps);
                return this.postRetry(action, this.handleException(cause));
            }
        }
    }

    private T postRetry(ExceptionAction action, T res) {
        this.maybeExitVM(action);
        return res;
    }

    private static void finalizeRetryLog(String retryLogFile, ByteArrayOutputStream logBaos, PrintStream ps) {
        ps.close();
        try (OutputStream fos = PathUtilities.openOutputStream(retryLogFile, true);){
            fos.write(logBaos.toByteArray());
        }
        catch (Throwable e) {
            TTY.printf("Error writing to %s: %s%n", retryLogFile, e);
        }
    }

    protected abstract void exitHostVM(int var1);

    private void maybeExitVM(ExceptionAction action) {
        if (action == ExceptionAction.ExitVM) {
            TTY.println("Exiting VM after retry compilation of " + String.valueOf(this));
            this.exitHostVM(-1);
        }
    }

    private static long getCompilationPeriodStart(long initialValue) {
        long start = compilationPeriodStart.get();
        if (start == 0L) {
            start = compilationPeriodStart.compareAndSet(start, initialValue) ? initialValue : compilationPeriodStart.get();
        }
        return start;
    }

    private static boolean detectCompilationFailureRateTooHigh(OptionValues options, Throwable cause) {
        boolean periodExpired;
        long start;
        if (CompilationWrapper.isNonFailureBailout(options, cause)) {
            return false;
        }
        long failed = failedCompilations.incrementAndGet();
        long total = totalCompilations.get();
        if (total == 0L) {
            return false;
        }
        int rate = (int)(failed * 100L / total);
        int maxRateValue = GraalCompilerOptions.SystemicCompilationFailureRate.getValue(options);
        if (maxRateValue == 0) {
            return false;
        }
        int maxRate = Math.min(100, Math.abs(maxRateValue));
        long now = System.currentTimeMillis();
        long period = now - (start = CompilationWrapper.getCompilationPeriodStart(now));
        boolean bl = periodExpired = period > 2000L;
        if (rate > maxRate && (periodExpired || total > 25L)) {
            Formatter msg = new Formatter();
            String option = GraalCompilerOptions.SystemicCompilationFailureRate.getName();
            msg.format("Warning: Systemic Graal compilation failure detected: %d of %d (%d%%) of compilations failed during last %d ms [max rate set by %s is %d%%]. ", failed, total, rate, period, option, maxRateValue);
            msg.format("To mitigate systemic compilation failure detection, set %s to a higher value. ", option);
            msg.format("To disable systemic compilation failure detection, set %s to 0. ", option);
            msg.format("To get more information on compilation failures, set %s to Print or Diagnose. ", GraalCompilerOptions.CompilationFailureAction.getName());
            TTY.println(msg.toString());
            if (maxRateValue < 0) {
                return true;
            }
            periodExpired = true;
        }
        if (periodExpired && compilationPeriodStart.compareAndSet(start, now)) {
            failedCompilations.set(0L);
            totalCompilations.set(0L);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExceptionAction adjustAction(OptionValues initialOptions, ExceptionAction initialAction, Throwable cause) {
        ExceptionAction action;
        int maxProblems = GraalCompilerOptions.MaxCompilationProblemsPerAction.getValue(initialOptions);
        if (action != ExceptionAction.ExitVM) {
            if (CompilationWrapper.detectCompilationFailureRateTooHigh(initialOptions, cause)) {
                return ExceptionAction.ExitVM;
            }
            Map<ExceptionAction, Integer> map = this.problemsHandledPerAction;
            synchronized (map) {
                int problems;
                for (action = initialAction; action != ExceptionAction.Silent && (problems = this.problemsHandledPerAction.getOrDefault((Object)action, 0).intValue()) >= maxProblems; action = action.quieter()) {
                    if (problems != maxProblems) continue;
                    TTY.printf("Warning: adjusting %s from %s to %s after %s (%d) failed compilations%n", new Object[]{GraalCompilerOptions.CompilationFailureAction, action, action.quieter(), GraalCompilerOptions.MaxCompilationProblemsPerAction, maxProblems});
                    this.problemsHandledPerAction.put(action, problems + 1);
                }
                this.problemsHandledPerAction.put(action, this.problemsHandledPerAction.getOrDefault((Object)action, 0) + 1);
            }
        }
        return action;
    }

    public static final class ExceptionAction
    extends Enum<ExceptionAction> {
        public static final /* enum */ ExceptionAction Silent = new ExceptionAction();
        public static final /* enum */ ExceptionAction Print = new ExceptionAction();
        public static final /* enum */ ExceptionAction Diagnose = new ExceptionAction();
        public static final /* enum */ ExceptionAction ExitVM = new ExceptionAction();
        private static final ExceptionAction[] VALUES;
        private static final /* synthetic */ ExceptionAction[] $VALUES;

        public static ExceptionAction[] values() {
            return (ExceptionAction[])$VALUES.clone();
        }

        public static ExceptionAction valueOf(String name) {
            return Enum.valueOf(ExceptionAction.class, name);
        }

        ExceptionAction quieter() {
            assert (Silent.ordinal() == 0) : "Silent must be first";
            int index = Math.max(this.ordinal() - 1, 0);
            return VALUES[index];
        }

        private static /* synthetic */ ExceptionAction[] $values() {
            return new ExceptionAction[]{Silent, Print, Diagnose, ExitVM};
        }

        static {
            $VALUES = ExceptionAction.$values();
            VALUES = ExceptionAction.values();
        }
    }

    public final class Failure {
        public final Throwable cause;
        private final DebugContext debug;

        Failure(Throwable cause, DebugContext debug) {
            this.cause = cause;
            this.debug = debug;
        }

        public T handle(boolean silent) {
            if (silent) {
                return CompilationWrapper.this.handleException(this.cause);
            }
            return CompilationWrapper.this.handleFailure(this.debug, this.cause);
        }
    }
}

