/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core;

import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.core.GraalCompilerOptions;
import jdk.graal.compiler.core.common.PermanentBailoutException;
import jdk.graal.compiler.core.common.RetryableBailoutException;
import jdk.graal.compiler.core.common.util.CompilationAlarm;
import jdk.graal.compiler.core.target.Backend;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.DebugOptions;
import jdk.graal.compiler.debug.MemUseTrackerKey;
import jdk.graal.compiler.debug.MethodFilter;
import jdk.graal.compiler.debug.TTY;
import jdk.graal.compiler.debug.TimerKey;
import jdk.graal.compiler.lir.asm.CompilationResultBuilderFactory;
import jdk.graal.compiler.lir.asm.EntryPointDecorator;
import jdk.graal.compiler.lir.phases.LIRSuites;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.phases.OptimisticOptimizations;
import jdk.graal.compiler.phases.PhaseSuite;
import jdk.graal.compiler.phases.common.DeadCodeEliminationPhase;
import jdk.graal.compiler.phases.tiers.HighTierContext;
import jdk.graal.compiler.phases.tiers.LowTierContext;
import jdk.graal.compiler.phases.tiers.MidTierContext;
import jdk.graal.compiler.phases.tiers.Suites;
import jdk.graal.compiler.phases.tiers.TargetProvider;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class GraalCompiler {
    private static final TimerKey CompilerTimer = DebugContext.timer("GraalCompiler").doc("Time spent in compilation (excludes code installation).");
    private static final MemUseTrackerKey CompilerMemory = DebugContext.memUseTracker("GraalCompiler");
    private static final TimerKey FrontEnd = DebugContext.timer("FrontEnd").doc("Time spent processing HIR.");

    public static <T extends CompilationResult> T compileGraph(StructuredGraph graph, ResolvedJavaMethod installedCodeOwner, Providers providers, Backend backend, PhaseSuite<HighTierContext> graphBuilderSuite, OptimisticOptimizations optimisticOpts, ProfilingInfo profilingInfo, Suites suites, LIRSuites lirSuites, T compilationResult, CompilationResultBuilderFactory factory, boolean verifySourcePositions) {
        return GraalCompiler.compile(new Request<T>(graph, installedCodeOwner, providers, backend, graphBuilderSuite, optimisticOpts, profilingInfo, suites, lirSuites, compilationResult, factory, null, verifySourcePositions));
    }

    public static <T extends CompilationResult> T compileGraph(StructuredGraph graph, ResolvedJavaMethod installedCodeOwner, Providers providers, Backend backend, PhaseSuite<HighTierContext> graphBuilderSuite, OptimisticOptimizations optimisticOpts, ProfilingInfo profilingInfo, Suites suites, LIRSuites lirSuites, T compilationResult, CompilationResultBuilderFactory factory, EntryPointDecorator entryPointDecorator, boolean verifySourcePositions) {
        return GraalCompiler.compile(new Request<T>(graph, installedCodeOwner, providers, backend, graphBuilderSuite, optimisticOpts, profilingInfo, suites, lirSuites, compilationResult, factory, entryPointDecorator, verifySourcePositions));
    }

    public static <T extends CompilationResult> T compile(Request<T> r) {
        DebugContext debug = r.graph.getDebug();
        try (CompilationAlarm alarm = CompilationAlarm.trackCompilationPeriod(r.graph.getOptions());){
            assert (!r.graph.isFrozen());
            try (DebugContext.Scope s0 = debug.scope("GraalCompiler", r.graph, r.providers.getCodeCache());
                 DebugCloseable a = CompilerTimer.start(debug);
                 DebugCloseable b = CompilerMemory.start(debug);){
                GraalCompiler.emitFrontEnd(r.providers, r.backend, r.graph, r.graphBuilderSuite, r.optimisticOpts, r.profilingInfo, r.suites);
                r.backend.emitBackEnd(r.graph, null, r.installedCodeOwner, (CompilationResult)r.compilationResult, r.factory, r.entryPointDecorator, null, r.lirSuites);
                if (r.verifySourcePositions) assert (r.graph.verifySourcePositions(true));
                GraalCompiler.checkForRequestedCrash(r.graph);
            }
            catch (Throwable e) {
                throw debug.handle(e);
            }
            GraalCompiler.checkForRequestedDelay(r.graph);
            Object t = r.compilationResult;
            return t;
        }
    }

    private static void checkForRequestedCrash(StructuredGraph graph) {
        String value = GraalCompilerOptions.CrashAt.getValue(graph.getOptions());
        if (value != null) {
            String crashMessage;
            boolean bailout = false;
            boolean permanentBailout = false;
            String methodPattern = value;
            if (value.endsWith(":Bailout")) {
                methodPattern = value.substring(0, value.length() - ":Bailout".length());
                bailout = true;
            } else if (value.endsWith(":PermanentBailout")) {
                methodPattern = value.substring(0, value.length() - ":PermanentBailout".length());
                permanentBailout = true;
            }
            String matchedLabel = GraalCompiler.match(graph, methodPattern);
            if (matchedLabel != null && GraalCompiler.notifyCrash(crashMessage = "Forced crash after compiling " + matchedLabel)) {
                if (permanentBailout) {
                    throw new PermanentBailoutException(crashMessage);
                }
                if (bailout) {
                    throw new RetryableBailoutException(crashMessage);
                }
                throw new RuntimeException(crashMessage);
            }
        }
    }

    private static void checkForRequestedDelay(StructuredGraph graph) {
        String methodPattern;
        String matchedLabel;
        long delay = Math.max(0, GraalCompilerOptions.InjectedCompilationDelay.getValue(graph.getOptions())) * 1000;
        if (delay != 0L && (matchedLabel = GraalCompiler.match(graph, methodPattern = DebugOptions.MethodFilter.getValue(graph.getOptions()))) != null) {
            long start = System.currentTimeMillis();
            TTY.printf("[%s] delaying compilation of %s for %d ms%n", Thread.currentThread().getName(), matchedLabel, delay);
            while (System.currentTimeMillis() - start < delay) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static String match(StructuredGraph graph, String methodPattern) {
        if (methodPattern == null) {
            return graph.name != null ? graph.name : graph.method().format("%H.%n(%p)");
        }
        String label = null;
        if (graph.name != null && graph.name.contains(methodPattern)) {
            label = graph.name;
        }
        if (label == null) {
            ResolvedJavaMethod method = graph.method();
            MethodFilter filter = MethodFilter.parse(methodPattern);
            if (filter.matches((JavaMethod)method)) {
                label = method.format("%H.%n(%p)");
            }
        }
        return label;
    }

    private static boolean notifyCrash(String crashMessage) {
        return true;
    }

    public static void emitFrontEnd(Providers providers, TargetProvider target, StructuredGraph graph, PhaseSuite<HighTierContext> graphBuilderSuite, OptimisticOptimizations optimisticOpts, ProfilingInfo profilingInfo, Suites suites) {
        DebugContext debug = graph.getDebug();
        try (DebugContext.Scope s = debug.scope("FrontEnd");
             DebugCloseable a = FrontEnd.start(debug);){
            HighTierContext highTierContext = new HighTierContext(providers, graphBuilderSuite, optimisticOpts);
            if (graph.start().next() == null) {
                try (DebugContext.CompilerPhaseScope cps = debug.enterCompilerPhase("Parsing");){
                    graphBuilderSuite.apply(graph, highTierContext);
                    new DeadCodeEliminationPhase(DeadCodeEliminationPhase.Optionality.Optional).apply(graph);
                    debug.dump(1, graph, "After parsing");
                }
            } else {
                debug.dump(2, graph, "initial state");
            }
            suites.getHighTier().apply(graph, highTierContext);
            graph.maybeCompress();
            debug.dump(1, graph, "After high tier");
            MidTierContext midTierContext = new MidTierContext(providers, target, optimisticOpts, profilingInfo);
            suites.getMidTier().apply(graph, midTierContext);
            graph.maybeCompress();
            debug.dump(1, graph, "After mid tier");
            LowTierContext lowTierContext = new LowTierContext(providers, target);
            suites.getLowTier().apply(graph, lowTierContext);
            debug.dump(1, graph, "After low tier");
            debug.dump(1, graph.getLastSchedule(), "Final HIR schedule");
            graph.logInliningTree();
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
        finally {
            graph.checkCancellation();
        }
    }

    public static class Request<T extends CompilationResult> {
        public final StructuredGraph graph;
        public final ResolvedJavaMethod installedCodeOwner;
        public final Providers providers;
        public final Backend backend;
        public final PhaseSuite<HighTierContext> graphBuilderSuite;
        public final OptimisticOptimizations optimisticOpts;
        public final ProfilingInfo profilingInfo;
        public final Suites suites;
        public final LIRSuites lirSuites;
        public final T compilationResult;
        public final CompilationResultBuilderFactory factory;
        public final EntryPointDecorator entryPointDecorator;
        public final boolean verifySourcePositions;

        public Request(StructuredGraph graph, ResolvedJavaMethod installedCodeOwner, Providers providers, Backend backend, PhaseSuite<HighTierContext> graphBuilderSuite, OptimisticOptimizations optimisticOpts, ProfilingInfo profilingInfo, Suites suites, LIRSuites lirSuites, T compilationResult, CompilationResultBuilderFactory factory, EntryPointDecorator entryPointDecorator, boolean verifySourcePositions) {
            this.graph = graph;
            this.installedCodeOwner = installedCodeOwner;
            this.providers = providers;
            this.backend = backend;
            this.graphBuilderSuite = graphBuilderSuite;
            this.optimisticOpts = optimisticOpts;
            this.profilingInfo = profilingInfo;
            this.suites = suites;
            this.lirSuites = lirSuites;
            this.compilationResult = compilationResult;
            this.factory = factory;
            this.entryPointDecorator = entryPointDecorator;
            this.verifySourcePositions = verifySourcePositions;
        }

        public T execute() {
            return GraalCompiler.compile(this);
        }
    }
}

