/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.aarch64;

import jdk.graal.compiler.asm.aarch64.AArch64Address;
import jdk.graal.compiler.core.aarch64.AArch64AddressNode;
import jdk.graal.compiler.core.aarch64.AArch64LIRKindTool;
import jdk.graal.compiler.core.aarch64.AArch64PointerAddNode;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.AddNode;
import jdk.graal.compiler.nodes.calc.LeftShiftNode;
import jdk.graal.compiler.nodes.calc.ZeroExtendNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.memory.address.OffsetAddressNode;
import jdk.graal.compiler.phases.common.AddressLoweringByUsePhase;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.meta.JavaConstant;

public class AArch64AddressLoweringByUse
extends AddressLoweringByUsePhase.AddressLoweringByUse {
    private AArch64LIRKindTool kindtool;
    private boolean supportsDerivedReference;

    public AArch64AddressLoweringByUse(AArch64LIRKindTool kindtool, boolean supportsDerivedReference) {
        this.kindtool = kindtool;
        this.supportsDerivedReference = supportsDerivedReference;
    }

    @Override
    public AddressNode lower(ValueNode use, Stamp stamp, AddressNode address) {
        if (address instanceof OffsetAddressNode) {
            OffsetAddressNode offsetAddress = (OffsetAddressNode)address;
            return this.doLower(stamp, offsetAddress.getBase(), offsetAddress.getOffset());
        }
        return address;
    }

    @Override
    public AddressNode lower(AddressNode address) {
        return this.lower(null, null, address);
    }

    private AddressNode doLower(Stamp stamp, ValueNode base, ValueNode index) {
        boolean changed;
        AArch64Kind aarch64Kind = stamp == null ? null : this.getAArch64Kind(stamp);
        int bitMemoryTransferSize = aarch64Kind == null ? -1 : aarch64Kind.getSizeInBytes() * 8;
        AArch64AddressNode ret = new AArch64AddressNode(bitMemoryTransferSize, base, index);
        while (changed = this.improve(aarch64Kind, ret)) {
        }
        return base.graph().unique(ret);
    }

    private boolean improve(AArch64Kind kind, AArch64AddressNode ret) {
        long disp;
        JavaConstant javaConstant;
        AArch64Address.AddressingMode mode = ret.getAddressingMode();
        if (AArch64AddressLoweringByUse.isDisplacementMode(mode) || AArch64AddressLoweringByUse.isBaseOnlyMode(mode)) {
            return false;
        }
        ValueNode base = ret.getBase();
        ValueNode index = ret.getIndex();
        if (base == null) {
            ret.setBase(index);
            ret.setIndex(base);
            return true;
        }
        if (base.isJavaConstant() && base.asJavaConstant().getJavaKind().isNumericInteger() && index != null && !index.isJavaConstant()) {
            ret.setBase(index);
            ret.setIndex(base);
            return true;
        }
        if (index == null && base instanceof AddNode) {
            AddNode add = (AddNode)base;
            ret.setBase(add.getX());
            ret.setIndex(add.getY());
            return true;
        }
        if (index != null && index.isJavaConstant() && (javaConstant = index.asJavaConstant()).getJavaKind().isNumericInteger() && AArch64AddressLoweringByUse.isDisplacementMode(mode = AArch64AddressLoweringByUse.immediateMode(kind, disp = javaConstant.asLong()))) {
            index = null;
            boolean tryNextBase = base instanceof AddNode;
            while (tryNextBase) {
                AArch64Address.AddressingMode newMode;
                long newDisp;
                AddNode add = (AddNode)base;
                tryNextBase = false;
                ValueNode child = add.getX();
                if (child.isJavaConstant() && child.asJavaConstant().getJavaKind().isNumericInteger()) {
                    newDisp = disp + child.asJavaConstant().asLong();
                    newMode = AArch64AddressLoweringByUse.immediateMode(kind, newDisp);
                    if (newMode == AArch64Address.AddressingMode.REGISTER_OFFSET) continue;
                    disp = newDisp;
                    mode = newMode;
                    base = add.getY();
                    ret.setBase(base);
                    tryNextBase = base instanceof AddNode;
                    continue;
                }
                child = add.getY();
                if (!child.isJavaConstant() || !child.asJavaConstant().getJavaKind().isNumericInteger() || (newMode = AArch64AddressLoweringByUse.immediateMode(kind, newDisp = disp + child.asJavaConstant().asLong())) == AArch64Address.AddressingMode.REGISTER_OFFSET) continue;
                disp = newDisp;
                mode = newMode;
                base = add.getX();
                ret.setBase(base);
                tryNextBase = base instanceof AddNode;
            }
            if (disp != 0L) {
                ret.setIndex(null);
                int scaleFactor = AArch64AddressLoweringByUse.computeScaleFactor(kind, mode);
                ret.setDisplacement(disp, scaleFactor, mode);
            } else {
                ret.setIndex(null);
                ret.setDisplacement(0L, 1, AArch64Address.AddressingMode.BASE_REGISTER_ONLY);
            }
            return true;
        }
        if (this.supportsDerivedReference && index != null && index instanceof AddNode && index.getStackKind().isNumericInteger()) {
            ValueNode x = ((AddNode)index).getX();
            ValueNode y = ((AddNode)index).getY();
            ValueNode objHeadOffset = null;
            ValueNode scaledIndex = null;
            if (x.isConstant()) {
                objHeadOffset = x;
                scaledIndex = y;
            } else if (y.isConstant()) {
                objHeadOffset = y;
                scaledIndex = x;
            }
            if (scaledIndex == null || objHeadOffset == null) {
                return false;
            }
            ZeroExtendNode wordIndex = null;
            if (scaledIndex instanceof LeftShiftNode) {
                int s;
                ValueNode var = ((LeftShiftNode)scaledIndex).getX();
                ValueNode amount = ((LeftShiftNode)scaledIndex).getY();
                if (amount.isConstant() && var instanceof ZeroExtendNode && (s = amount.asJavaConstant().asInt()) >= 0 && s <= 4) {
                    wordIndex = (ZeroExtendNode)var;
                }
            } else if (scaledIndex instanceof ZeroExtendNode) {
                wordIndex = (ZeroExtendNode)scaledIndex;
            }
            if (wordIndex != null) {
                AArch64PointerAddNode addP = base.graph().unique(new AArch64PointerAddNode(base, scaledIndex));
                ret.setBase(addP);
                ret.setIndex(objHeadOffset);
                return true;
            }
        }
        return false;
    }

    private AArch64Kind getAArch64Kind(Stamp stamp) {
        LIRKind lirKind = stamp.getLIRKind(this.kindtool);
        if (!(lirKind.isValue() || lirKind.isReference(0) && lirKind.getReferenceCount() == 1)) {
            return null;
        }
        return (AArch64Kind)lirKind.getPlatformKind();
    }

    private static AArch64Address.AddressingMode immediateMode(AArch64Kind kind, long immediate) {
        int bitMemoryTransferSize;
        if (kind != null && NumUtil.isInt(immediate) && AArch64Address.isValidImmediateAddress(bitMemoryTransferSize = kind.getSizeInBytes() * 8, AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED, NumUtil.safeToInt(immediate))) {
            return AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED;
        }
        if (NumUtil.isSignedNbit(9, immediate)) {
            return AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED;
        }
        return AArch64Address.AddressingMode.REGISTER_OFFSET;
    }

    private static int computeScaleFactor(AArch64Kind kind, AArch64Address.AddressingMode mode) {
        if (mode == AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED) {
            return kind.getSizeInBytes();
        }
        return 1;
    }

    private static boolean isBaseOnlyMode(AArch64Address.AddressingMode addressingMode) {
        return addressingMode == AArch64Address.AddressingMode.BASE_REGISTER_ONLY;
    }

    private static boolean isDisplacementMode(AArch64Address.AddressingMode addressingMode) {
        switch (addressingMode) {
            case IMMEDIATE_POST_INDEXED: 
            case IMMEDIATE_PRE_INDEXED: 
            case IMMEDIATE_UNSIGNED_SCALED: 
            case IMMEDIATE_SIGNED_UNSCALED: {
                return true;
            }
        }
        return false;
    }
}

