/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.aarch64;

import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.spi.LIRKindTool;
import jdk.graal.compiler.debug.GraalError;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.meta.PlatformKind;

public class AArch64LIRKindTool
implements LIRKindTool {
    @Override
    public LIRKind getIntegerKind(int bits) {
        if (bits <= 8) {
            return LIRKind.value((PlatformKind)AArch64Kind.BYTE);
        }
        if (bits <= 16) {
            return LIRKind.value((PlatformKind)AArch64Kind.WORD);
        }
        if (bits <= 32) {
            return LIRKind.value((PlatformKind)AArch64Kind.DWORD);
        }
        assert (bits <= 64) : bits;
        return LIRKind.value((PlatformKind)AArch64Kind.QWORD);
    }

    @Override
    public LIRKind getFloatingKind(int bits) {
        switch (bits) {
            case 32: {
                return LIRKind.value((PlatformKind)AArch64Kind.SINGLE);
            }
            case 64: {
                return LIRKind.value((PlatformKind)AArch64Kind.DOUBLE);
            }
        }
        throw GraalError.shouldNotReachHereUnexpectedValue(bits);
    }

    @Override
    public LIRKind getObjectKind() {
        return LIRKind.reference((PlatformKind)AArch64Kind.QWORD);
    }

    @Override
    public LIRKind getWordKind() {
        return LIRKind.value((PlatformKind)AArch64Kind.QWORD);
    }

    @Override
    public LIRKind getNarrowOopKind() {
        return LIRKind.compressedReference((PlatformKind)AArch64Kind.DWORD);
    }

    @Override
    public LIRKind getNarrowPointerKind() {
        return LIRKind.value((PlatformKind)AArch64Kind.DWORD);
    }
}

