/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.aarch64;

import jdk.graal.compiler.core.common.memory.MemoryExtendKind;
import jdk.graal.compiler.nodes.memory.ExtendableMemoryAccess;
import jdk.graal.compiler.nodes.memory.ReadNode;
import jdk.graal.compiler.nodes.spi.LoweringProvider;

public interface AArch64LoweringProviderMixin
extends LoweringProvider {
    @Override
    default public boolean divisionOverflowIsJVMSCompliant() {
        return true;
    }

    @Override
    default public Integer smallestCompareWidth() {
        return 32;
    }

    @Override
    default public boolean supportsBulkZeroing() {
        return true;
    }

    @Override
    default public boolean supportsRounding() {
        return true;
    }

    @Override
    default public boolean writesStronglyOrdered() {
        return false;
    }

    @Override
    default public boolean narrowsUseCastValue() {
        return true;
    }

    @Override
    default public boolean supportsFoldingExtendIntoAccess(ExtendableMemoryAccess access, MemoryExtendKind extendKind) {
        if (!access.isCompatibleWithExtend(extendKind)) {
            return false;
        }
        boolean supportsSigned = false;
        boolean supportsZero = false;
        if (access instanceof ReadNode) {
            supportsZero = true;
            supportsSigned = !((ReadNode)access).ordersMemoryAccesses();
        }
        switch (extendKind) {
            case ZERO_16: 
            case ZERO_32: 
            case ZERO_64: {
                return supportsZero;
            }
            case SIGN_16: 
            case SIGN_32: 
            case SIGN_64: {
                return supportsSigned;
            }
        }
        return false;
    }
}

