/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.amd64;

import jdk.graal.compiler.asm.amd64.AMD64BaseAssembler;
import jdk.graal.compiler.lir.VirtualStackSlot;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.amd64.AMD64Move;
import jdk.graal.compiler.lir.gen.MoveFactory;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.meta.AllocatableValue;

public abstract class AMD64MoveFactoryBase
extends MoveFactory {
    private final MoveFactory.BackupSlotProvider backupSlotProvider;

    public AMD64MoveFactoryBase(MoveFactory.BackupSlotProvider backupSlotProvider) {
        this.backupSlotProvider = backupSlotProvider;
    }

    @Override
    public final AMD64LIRInstruction createStackMove(AllocatableValue result, AllocatableValue input) {
        AMD64Kind kind = (AMD64Kind)result.getPlatformKind();
        switch (kind.getSizeInBytes()) {
            case 2: {
                return new AMD64Move.AMD64PushPopStackMove(AMD64BaseAssembler.OperandSize.WORD, result, input);
            }
            case 8: {
                return new AMD64Move.AMD64PushPopStackMove(AMD64BaseAssembler.OperandSize.QWORD, result, input);
            }
        }
        MoveFactory.RegisterBackupPair backup = this.backupSlotProvider.getScratchRegister(input.getPlatformKind());
        Register scratchRegister = backup.register;
        VirtualStackSlot backupSlot = backup.backupSlot;
        return this.createStackMove(result, input, scratchRegister, backupSlot);
    }

    public abstract AMD64LIRInstruction createStackMove(AllocatableValue var1, AllocatableValue var2, Register var3, AllocatableValue var4);
}

