/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.common.cfg;

import java.util.Collection;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.core.common.cfg.BasicBlockSet;
import jdk.graal.compiler.core.common.cfg.Loop;

public interface AbstractControlFlowGraph<T extends BasicBlock<T>> {
    public static final int INVALID_BLOCK_ID = Integer.MAX_VALUE;
    public static final int LAST_VALID_BLOCK_INDEX = 0x7FFFFFFE;

    public T[] getBlocks();

    public Collection<Loop<T>> getLoops();

    public T getStartBlock();

    public static boolean dominates(BasicBlock<?> a, BasicBlock<?> b) {
        if (!1.$assertionsDisabled && a == null) {
            throw new AssertionError();
        }
        if (!1.$assertionsDisabled && b == null) {
            throw new AssertionError();
        }
        int domNumberA = a.getDominatorNumber();
        int domNumberB = b.getDominatorNumber();
        return domNumberB >= domNumberA && domNumberB <= a.getMaxChildDominatorNumber();
    }

    public static boolean strictlyDominates(BasicBlock<?> a, BasicBlock<?> b) {
        return a != b && AbstractControlFlowGraph.dominates(a, b);
    }

    public static BasicBlock<?> commonDominator(BasicBlock<?> a, BasicBlock<?> b) {
        BasicBlock<?> bTemp;
        BasicBlock<?> aTemp;
        int bDomDepth;
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a == b) {
            return a;
        }
        int aDomDepth = a.getDominatorDepth();
        if (aDomDepth > (bDomDepth = b.getDominatorDepth())) {
            aTemp = a;
            bTemp = b;
        } else {
            aTemp = b;
            bTemp = a;
        }
        return AbstractControlFlowGraph.commonDominatorHelper(aTemp, bTemp);
    }

    public static BasicBlock<?> commonDominatorHelper(BasicBlock<?> a, BasicBlock<?> b) {
        int domNumberA = a.getDominatorNumber();
        BasicBlock<?> result = b;
        while (domNumberA < result.getDominatorNumber()) {
            result = result.getDominator();
        }
        while (domNumberA > result.getMaxChildDominatorNumber()) {
            result = result.getDominator();
        }
        return result;
    }

    public static <T extends BasicBlock<T>> T commonDominatorTyped(T a, T b) {
        return (T)AbstractControlFlowGraph.commonDominator(a, b);
    }

    public static boolean blockIsDeletedOrNew(int blockId) {
        return blockId == Integer.MAX_VALUE;
    }

    default public BasicBlockSet createBasicBlockSet() {
        return new BasicBlockSet(this);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

