/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.common.cfg;

import java.util.ArrayDeque;
import jdk.graal.compiler.core.common.cfg.AbstractControlFlowGraph;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.core.common.cfg.BlockMap;
import jdk.graal.compiler.core.common.cfg.Loop;
import jdk.graal.compiler.debug.Assertions;

public class CFGVerifier {
    public static <T extends BasicBlock<T>, C extends AbstractControlFlowGraph<T>> boolean verify(C cfg) {
        for (BasicBlock block : cfg.getBlocks()) {
            int i;
            assert (block.getId() <= 0x7FFFFFFE) : block.getId();
            assert (cfg.getBlocks()[block.getId()] == block) : Assertions.errorMessageContext("block", block, "cfgBlockId", cfg.getBlocks()[block.getId()]);
            for (i = 0; i < block.getPredecessorCount(); ++i) {
                BasicBlock pred = block.getPredecessorAt(i);
                assert (pred.containsSucc((BasicBlock)block));
                assert (pred.getId() < block.getId() || pred.isLoopEnd());
            }
            for (i = 0; i < block.getSuccessorCount(); ++i) {
                BasicBlock sux = block.getSuccessorAt(i);
                assert (sux.containsPred((BasicBlock)block));
                assert (sux.getId() > block.getId() || sux.isLoopHeader());
            }
            if (block.getDominator() != null) {
                T domChild;
                assert (((BasicBlock)block.getDominator()).getId() < block.getId()) : Assertions.errorMessage(block, block.getDominator());
                for (domChild = ((BasicBlock)block.getDominator()).getFirstDominated(); domChild != null && domChild != block; domChild = ((BasicBlock)domChild).getDominatedSibling()) {
                }
                assert (domChild != null) : "dominators must contain block";
            }
            for (Object dominated = block.getFirstDominated(); dominated != null; dominated = ((BasicBlock)dominated).getDominatedSibling()) {
                assert (((BasicBlock)dominated).getId() > block.getId()) : Assertions.errorMessageContext("dominated", dominated, "block", block);
                assert (((BasicBlock)dominated).getDominator() == block) : Assertions.errorMessageContext("domianted", dominated, "dominated.dom", ((BasicBlock)dominated).getDominator(), "block", block);
            }
            Object postDominatorBlock = block.getPostdominator();
            if (postDominatorBlock != null) {
                assert (block.getSuccessorCount() > 0) : "block has post-dominator block, but no successors";
                BlockMap<Boolean> visitedBlocks = new BlockMap<Boolean>(cfg);
                visitedBlocks.put(block, true);
                ArrayDeque stack = new ArrayDeque();
                for (int i2 = 0; i2 < block.getSuccessorCount(); ++i2) {
                    Object sux = block.getSuccessorAt(i2);
                    visitedBlocks.put((BasicBlock<?>)sux, true);
                    stack.push(sux);
                }
                while (stack.size() > 0) {
                    BasicBlock tos = (BasicBlock)stack.pop();
                    assert (tos.getId() <= ((BasicBlock)postDominatorBlock).getId()) : Assertions.errorMessageContext("tos", tos, "tos.getid", tos.getId(), "postDom", postDominatorBlock, "postDomId", ((BasicBlock)postDominatorBlock).getId());
                    if (tos == postDominatorBlock) continue;
                    assert (tos.getSuccessorCount() > 0) : "no path found";
                    for (int i3 = 0; i3 < tos.getSuccessorCount(); ++i3) {
                        Object sux = tos.getSuccessorAt(i3);
                        if (visitedBlocks.get((BasicBlock<?>)sux) != null) continue;
                        visitedBlocks.put((BasicBlock<?>)sux, true);
                        stack.push(sux);
                    }
                }
            }
            assert (cfg.getLoops() == null || !block.isLoopHeader() || block.getLoop().getHeader() == block) : Assertions.errorMessage(block, block.getLoop());
        }
        if (cfg.getLoops() != null) {
            for (Loop loop : cfg.getLoops()) {
                Loop blockLoop;
                assert (((BasicBlock)loop.getHeader()).isLoopHeader()) : "LoopHeader block must be loop header " + Assertions.errorMessageContext("loop", loop, "loop.getheader", loop.getHeader());
                for (BasicBlock block : loop.getBlocks()) {
                    assert (block.getId() >= ((BasicBlock)loop.getHeader()).getId()) : Assertions.errorMessageContext("block", block, "loop.getheader", loop.getHeader());
                    for (blockLoop = block.getLoop(); blockLoop != loop; blockLoop = blockLoop.getParent()) {
                        assert (blockLoop != null);
                    }
                    if (block.isLoopHeader() && block.getLoop() == loop) continue;
                    for (int i = 0; i < block.getPredecessorCount(); ++i) {
                        Object pred = block.getPredecessorAt(i);
                        if (loop.getBlocks().contains(pred)) continue;
                        assert (false) : "Loop " + String.valueOf(loop) + " does not contain " + String.valueOf(pred);
                        return false;
                    }
                }
                for (BasicBlock block : loop.getLoopExits()) {
                    assert (block.getId() >= ((BasicBlock)loop.getHeader()).getId()) : Assertions.errorMessageContext("block", block, "loop", loop, "loop.gethead", loop.getHeader());
                    for (blockLoop = block.getLoop(); blockLoop != null; blockLoop = blockLoop.getParent()) {
                        assert (blockLoop != loop) : "Parent loop must be different than loop that is exitted " + Assertions.errorMessageContext("blockLoop", blockLoop, "loop", loop);
                    }
                }
            }
        }
        return true;
    }
}

