/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.common.type;

import jdk.graal.compiler.core.common.type.ArithmeticOpTable;
import jdk.graal.compiler.core.common.type.ArithmeticStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.serviceprovider.SpeculationReasonGroup;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MemoryAccessProvider;

public abstract class PrimitiveStamp
extends ArithmeticStamp {
    private final int bits;

    protected PrimitiveStamp(int bits, ArithmeticOpTable ops) {
        super(ops);
        this.bits = bits;
    }

    @Override
    public void accept(SpeculationReasonGroup.SpeculationContextObject.Visitor v) {
        v.visitInt(this.bits);
    }

    public int getBits() {
        return this.bits;
    }

    public static int getBits(Stamp stamp) {
        if (stamp instanceof PrimitiveStamp) {
            return ((PrimitiveStamp)stamp).getBits();
        }
        return 0;
    }

    private static boolean isAligned(long displacement, int numBits) {
        GraalError.guarantee((numBits & 7) == 0, "numBits not a multiple of 8: %d", (Object)numBits);
        int numBytes = numBits / 8;
        return displacement % (long)numBytes == 0L;
    }

    @Override
    public Constant readConstant(MemoryAccessProvider provider, Constant base, long displacement) {
        return this.readJavaConstant(provider, base, displacement, this.getBits());
    }

    protected JavaConstant readJavaConstant(MemoryAccessProvider provider, Constant base, long displacement, int accessBits) {
        if (!PrimitiveStamp.isAligned(displacement, accessBits)) {
            return null;
        }
        try {
            return provider.readPrimitiveConstant(this.getStackKind(), base, displacement, accessBits);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.bits;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PrimitiveStamp)) {
            return false;
        }
        PrimitiveStamp other = (PrimitiveStamp)obj;
        if (this.bits != other.bits) {
            return false;
        }
        return super.equals(obj);
    }
}

