/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.common.type;

import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.ResolvedJavaType;

public final class TypeReference {
    private final ResolvedJavaType type;
    private final boolean exactReference;

    private TypeReference(ResolvedJavaType type, boolean exactReference) {
        this.type = type;
        this.exactReference = exactReference;
    }

    public static TypeReference createExactTrusted(ResolvedJavaType type) {
        if (type == null) {
            return null;
        }
        return new TypeReference(type, true);
    }

    public static TypeReference createWithoutAssumptions(ResolvedJavaType type) {
        return TypeReference.create(null, type);
    }

    public static TypeReference createTrustedWithoutAssumptions(ResolvedJavaType type) {
        return TypeReference.createTrusted(null, type);
    }

    public static TypeReference create(Assumptions assumptions, ResolvedJavaType type) {
        return TypeReference.createTrusted(assumptions, TypeReference.filterInterfaceTypesOut(type));
    }

    public static TypeReference createTrusted(Assumptions assumptions, ResolvedJavaType type) {
        Assumptions.AssumptionResult leafConcreteSubtype;
        ResolvedJavaType exactType;
        if (type == null) {
            return null;
        }
        Object object = exactType = type.isLeaf() ? type : null;
        if (exactType == null && (leafConcreteSubtype = type.findLeafConcreteSubtype()) != null && leafConcreteSubtype.canRecordTo(assumptions)) {
            leafConcreteSubtype.recordTo(assumptions);
            exactType = (ResolvedJavaType)leafConcreteSubtype.getResult();
        }
        if (exactType == null) {
            return new TypeReference(type, false);
        }
        return new TypeReference(exactType, true);
    }

    public ResolvedJavaType getType() {
        return this.type;
    }

    public boolean isExact() {
        return this.exactReference;
    }

    public TypeReference asExactReference() {
        if (this.isExact()) {
            return this;
        }
        return new TypeReference(this.type, true);
    }

    private static ResolvedJavaType filterInterfaceTypesOut(ResolvedJavaType type) {
        if (type != null) {
            if (type.isArray()) {
                ResolvedJavaType componentType = TypeReference.filterInterfaceTypesOut(type.getComponentType());
                if (componentType != null) {
                    return componentType.getArrayClass();
                }
                return type.getSuperclass().getArrayClass();
            }
            if (type.isInterface()) {
                return null;
            }
        }
        return type;
    }

    public String toString() {
        return (this.isExact() ? "#" : "") + String.valueOf(this.type);
    }
}

