/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.common.util;

import jdk.graal.compiler.core.common.util.UnsafeArrayTypeReader;
import jdk.graal.compiler.serviceprovider.GraalUnsafeAccess;
import sun.misc.Unsafe;

class AlignedUnsafeArrayTypeReader
extends UnsafeArrayTypeReader {
    private static final Unsafe UNSAFE = GraalUnsafeAccess.getUnsafe();

    protected static int getS2(byte[] data, long byteIndex) {
        long offset = AlignedUnsafeArrayTypeReader.readOffset(data, byteIndex, 2);
        return (UNSAFE.getByte(data, offset + 0L) & 0xFF) << 0 | UNSAFE.getByte(data, offset + 1L) << 8;
    }

    protected static int getS4(byte[] data, long byteIndex) {
        long offset = AlignedUnsafeArrayTypeReader.readOffset(data, byteIndex, 4);
        return (UNSAFE.getByte(data, offset + 0L) & 0xFF) << 0 | (UNSAFE.getByte(data, offset + 1L) & 0xFF) << 8 | (UNSAFE.getByte(data, offset + 2L) & 0xFF) << 16 | UNSAFE.getByte(data, offset + 3L) << 24;
    }

    protected static long getS8(byte[] data, long byteIndex) {
        long offset = AlignedUnsafeArrayTypeReader.readOffset(data, byteIndex, 8);
        return (long)(UNSAFE.getByte(data, offset + 0L) & 0xFF) << 0 | (long)(UNSAFE.getByte(data, offset + 1L) & 0xFF) << 8 | (long)(UNSAFE.getByte(data, offset + 2L) & 0xFF) << 16 | (long)(UNSAFE.getByte(data, offset + 3L) & 0xFF) << 24 | (long)(UNSAFE.getByte(data, offset + 4L) & 0xFF) << 32 | (long)(UNSAFE.getByte(data, offset + 5L) & 0xFF) << 40 | (long)(UNSAFE.getByte(data, offset + 6L) & 0xFF) << 48 | (long)UNSAFE.getByte(data, offset + 7L) << 56;
    }

    protected AlignedUnsafeArrayTypeReader(byte[] data, long byteIndex) {
        super(data, byteIndex);
    }

    @Override
    public int getS2() {
        int result = AlignedUnsafeArrayTypeReader.getS2(this.data, this.byteIndex);
        this.byteIndex += 2L;
        return result;
    }

    @Override
    public int getS4() {
        int result = AlignedUnsafeArrayTypeReader.getS4(this.data, this.byteIndex);
        this.byteIndex += 4L;
        return result;
    }

    @Override
    public long getS8() {
        long result = AlignedUnsafeArrayTypeReader.getS8(this.data, this.byteIndex);
        this.byteIndex += 8L;
        return result;
    }
}

