/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.common.util;

import java.util.Arrays;
import jdk.graal.compiler.core.common.PermanentBailoutException;
import jdk.graal.compiler.core.common.util.EventCounter;
import jdk.graal.compiler.core.common.util.Util;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;

public final class CompilationAlarm
implements AutoCloseable {
    private static final boolean LOG_PROGRESS_DETECTION = false;
    private static final ThreadLocal<CompilationAlarm> currentAlarm = new ThreadLocal();
    private static final CompilationAlarm NEVER_EXPIRES = new CompilationAlarm(0L);
    private final long expiration;
    public static final int CHECK_BAILOUT_COUNTER = 4096;
    private static final ThreadLocal<StackTraceElement[]> lastStackTraceForThread = new ThreadLocal();
    private static final ThreadLocal<Long> lastUniqueStackTraceForThread = new ThreadLocal();
    private static final ThreadLocal<EventCounter> lastCounterForThread = new ThreadLocal();
    private static final ThreadLocal<Double> noProgressStartPeriod = new ThreadLocal();

    private CompilationAlarm(long expiration) {
        this.expiration = expiration;
    }

    public static CompilationAlarm current() {
        CompilationAlarm alarm = currentAlarm.get();
        return alarm == null ? NEVER_EXPIRES : alarm;
    }

    public boolean hasExpired() {
        return this != NEVER_EXPIRES && System.currentTimeMillis() > this.expiration;
    }

    @Override
    public void close() {
        if (this != NEVER_EXPIRES) {
            currentAlarm.set(null);
            CompilationAlarm.resetProgressDetection();
        }
    }

    public static CompilationAlarm trackCompilationPeriod(OptionValues options) {
        double period = Options.CompilationExpirationPeriod.getValue(options);
        if (period > 0.0) {
            CompilationAlarm current;
            if (Assertions.assertionsEnabled()) {
                period *= 2.0;
            }
            if (Assertions.detailedAssertionsEnabled(options)) {
                period *= 2.0;
            }
            if ((current = currentAlarm.get()) == null) {
                long expiration = System.currentTimeMillis() + (long)(period * 1000.0);
                current = new CompilationAlarm(expiration);
                currentAlarm.set(current);
                return current;
            }
        }
        return null;
    }

    public static void checkProgress(Graph graph) {
        if (graph == null) {
            return;
        }
        if (graph.eventCounterOverflows(4096)) {
            CompilationAlarm.overflowAction(graph.getOptions(), graph);
        }
    }

    public static boolean checkProgress(OptionValues opt, EventCounter eventCounter) {
        if (opt == null) {
            return false;
        }
        if (eventCounter.eventCounterOverflows(4096)) {
            CompilationAlarm.overflowAction(opt, eventCounter);
            return true;
        }
        return false;
    }

    private static void overflowAction(OptionValues opt, EventCounter counter) {
        if (CompilationAlarm.current().hasExpired()) {
            CompilationAlarm.compilationAlarmExpired(opt);
        } else {
            CompilationAlarm.assertProgress(opt, counter);
        }
    }

    private static void assertProgress(OptionValues opt, EventCounter counter) {
        EventCounter lastCounter = lastCounterForThread.get();
        if (lastCounter != null && !lastCounter.equals(counter)) {
            CompilationAlarm.resetProgressDetection();
            return;
        }
        Object[] lastStackTrace = lastStackTraceForThread.get();
        if (lastStackTrace == null) {
            boolean noProgressForPeriodStartDetection;
            Long lastUniqueStackTraceTimeStamp = lastUniqueStackTraceForThread.get();
            if (lastUniqueStackTraceTimeStamp == null) {
                CompilationAlarm.assertProgressNoTracking(opt, counter);
                return;
            }
            double noProgressStartDetectionPeriod = noProgressStartPeriod.get() * 1000.0;
            long currentTimeStamp = System.currentTimeMillis();
            long timeDiff = currentTimeStamp - lastUniqueStackTraceTimeStamp;
            boolean bl = noProgressForPeriodStartDetection = (double)timeDiff > noProgressStartDetectionPeriod;
            if (!noProgressForPeriodStartDetection) {
                return;
            }
        }
        Object[] currentStackTrace = Thread.currentThread().getStackTrace();
        if (lastStackTrace == null || lastStackTrace.length != currentStackTrace.length || !Arrays.equals(lastStackTrace, currentStackTrace)) {
            lastStackTraceForThread.set((StackTraceElement[])currentStackTrace);
            lastUniqueStackTraceForThread.set(System.currentTimeMillis());
            lastCounterForThread.set(counter);
        } else {
            CompilationAlarm.assertProgressSlowPath(opt, (StackTraceElement[])lastStackTrace, lastCounter, (StackTraceElement[])currentStackTrace);
        }
    }

    private static void assertProgressNoTracking(OptionValues opt, EventCounter counter) {
        lastUniqueStackTraceForThread.set(System.currentTimeMillis());
        lastCounterForThread.set(counter);
        noProgressStartPeriod.set(Options.CompilationNoProgressStartTrackingProgressPeriod.getValue(opt));
    }

    private static void assertProgressSlowPath(OptionValues opt, StackTraceElement[] lastStackTrace, EventCounter lastCounter, StackTraceElement[] currentStackTrace) {
        boolean noProgressForPeriod;
        double maxNoProgressPeriod = Options.CompilationNoProgressPeriod.getValue(opt) * 1000.0;
        if (maxNoProgressPeriod == 0.0) {
            return;
        }
        assert (Arrays.equals(lastStackTrace, currentStackTrace)) : "Must only enter this branch if no progress was made";
        long lastUniqueStackTraceTimeStamp = lastUniqueStackTraceForThread.get();
        long currentTimeStamp = System.currentTimeMillis();
        long timeDiff = currentTimeStamp - lastUniqueStackTraceTimeStamp;
        boolean bl = noProgressForPeriod = (double)timeDiff > maxNoProgressPeriod;
        if (noProgressForPeriod) {
            throw new PermanentBailoutException("Observed identical stack traces for %d seconds, indicating a stuck compilation, counter = %s, stack is %n%s", timeDiff / 1000L, lastCounter, Util.toString(lastStackTrace));
        }
    }

    public static void resetProgressDetection() {
        lastStackTraceForThread.set(null);
        lastUniqueStackTraceForThread.set(null);
        lastCounterForThread.set(null);
        noProgressStartPeriod.set(null);
    }

    public static void compilationAlarmExpired(Graph graph) {
        CompilationAlarm.compilationAlarmExpired(graph.getOptions());
    }

    public static void compilationAlarmExpired(OptionValues options) {
        double period = Options.CompilationExpirationPeriod.getValue(options);
        throw new PermanentBailoutException("Compilation exceeded %f seconds during CFG traversal", period);
    }

    public static class Options {
        public static final OptionKey<Double> CompilationExpirationPeriod = new OptionKey<Double>(300.0);
        public static final OptionKey<Double> CompilationNoProgressPeriod = new OptionKey<Double>(30.0);
        public static final OptionKey<Double> CompilationNoProgressStartTrackingProgressPeriod = new OptionKey<Double>(10.0);
    }
}

