/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.common.util;

import jdk.graal.compiler.core.common.util.UnsafeArrayTypeReader;
import jdk.graal.compiler.serviceprovider.GraalUnsafeAccess;
import sun.misc.Unsafe;

final class UnalignedUnsafeArrayTypeReader
extends UnsafeArrayTypeReader {
    private static final Unsafe UNSAFE = GraalUnsafeAccess.getUnsafe();

    protected static int getS2(byte[] data, long byteIndex) {
        return UNSAFE.getShort(data, UnalignedUnsafeArrayTypeReader.readOffset(data, byteIndex, 2));
    }

    protected static int getS4(byte[] data, long byteIndex) {
        return UNSAFE.getInt(data, UnalignedUnsafeArrayTypeReader.readOffset(data, byteIndex, 4));
    }

    protected static long getS8(byte[] data, long byteIndex) {
        return UNSAFE.getLong(data, UnalignedUnsafeArrayTypeReader.readOffset(data, byteIndex, 8));
    }

    protected UnalignedUnsafeArrayTypeReader(byte[] data, long byteIndex) {
        super(data, byteIndex);
    }

    @Override
    public int getS2() {
        int result = UnalignedUnsafeArrayTypeReader.getS2(this.data, this.byteIndex);
        this.byteIndex += 2L;
        return result;
    }

    @Override
    public int getS4() {
        int result = UnalignedUnsafeArrayTypeReader.getS4(this.data, this.byteIndex);
        this.byteIndex += 4L;
        return result;
    }

    @Override
    public long getS8() {
        long result = UnalignedUnsafeArrayTypeReader.getS8(this.data, this.byteIndex);
        this.byteIndex += 8L;
        return result;
    }
}

