/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.common.util;

import jdk.graal.compiler.core.common.util.AbstractTypeReader;
import jdk.graal.compiler.core.common.util.AlignedUnsafeArrayTypeReader;
import jdk.graal.compiler.core.common.util.UnalignedUnsafeArrayTypeReader;
import jdk.graal.compiler.serviceprovider.GraalUnsafeAccess;
import sun.misc.Unsafe;

public abstract class UnsafeArrayTypeReader
extends AbstractTypeReader {
    private static final Unsafe UNSAFE = GraalUnsafeAccess.getUnsafe();
    protected final byte[] data;
    protected long byteIndex;

    public static int getS1(byte[] data, long byteIndex) {
        return UNSAFE.getByte(data, UnsafeArrayTypeReader.readOffset(data, byteIndex, 1));
    }

    public static int getU1(byte[] data, long byteIndex) {
        return UNSAFE.getByte(data, UnsafeArrayTypeReader.readOffset(data, byteIndex, 1)) & 0xFF;
    }

    public static int getS2(byte[] data, long byteIndex, boolean supportsUnalignedMemoryAccess) {
        if (supportsUnalignedMemoryAccess) {
            return UnalignedUnsafeArrayTypeReader.getS2(data, byteIndex);
        }
        return AlignedUnsafeArrayTypeReader.getS2(data, byteIndex);
    }

    public static int getU2(byte[] data, long byteIndex, boolean supportsUnalignedMemoryAccess) {
        return UnsafeArrayTypeReader.getS2(data, byteIndex, supportsUnalignedMemoryAccess) & 0xFFFF;
    }

    public static int getS4(byte[] data, long byteIndex, boolean supportsUnalignedMemoryAccess) {
        if (supportsUnalignedMemoryAccess) {
            return UnalignedUnsafeArrayTypeReader.getS4(data, byteIndex);
        }
        return AlignedUnsafeArrayTypeReader.getS4(data, byteIndex);
    }

    public static long getU4(byte[] data, long byteIndex, boolean supportsUnalignedMemoryAccess) {
        return (long)UnsafeArrayTypeReader.getS4(data, byteIndex, supportsUnalignedMemoryAccess) & 0xFFFFFFFFL;
    }

    public static long getS8(byte[] data, long byteIndex, boolean supportsUnalignedMemoryAccess) {
        if (supportsUnalignedMemoryAccess) {
            return UnalignedUnsafeArrayTypeReader.getS8(data, byteIndex);
        }
        return AlignedUnsafeArrayTypeReader.getS8(data, byteIndex);
    }

    protected static long readOffset(byte[] data, long byteIndex, int numBytes) {
        assert (byteIndex >= 0L) : "(no detailed message because code must be allocation free)";
        assert (numBytes > 0) : "(no detailed message because code must be allocation free)";
        assert (byteIndex + (long)numBytes <= (long)data.length) : "(no detailed message because code must be allocation free)";
        assert (Unsafe.ARRAY_BYTE_INDEX_SCALE == 1) : "(no detailed message because code must be allocation free)";
        return byteIndex + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET;
    }

    public static UnsafeArrayTypeReader create(byte[] data, long byteIndex, boolean supportsUnalignedMemoryAccess) {
        if (supportsUnalignedMemoryAccess) {
            return new UnalignedUnsafeArrayTypeReader(data, byteIndex);
        }
        return new AlignedUnsafeArrayTypeReader(data, byteIndex);
    }

    protected UnsafeArrayTypeReader(byte[] data, long byteIndex) {
        this.data = data;
        this.byteIndex = byteIndex;
    }

    @Override
    public long getByteIndex() {
        return this.byteIndex;
    }

    @Override
    public void setByteIndex(long byteIndex) {
        this.byteIndex = byteIndex;
    }

    @Override
    public final int getS1() {
        int result = UnsafeArrayTypeReader.getS1(this.data, this.byteIndex);
        ++this.byteIndex;
        return result;
    }

    @Override
    public final int getU1() {
        int result = UnsafeArrayTypeReader.getU1(this.data, this.byteIndex);
        ++this.byteIndex;
        return result;
    }

    @Override
    public final int getU2() {
        return this.getS2() & 0xFFFF;
    }

    @Override
    public final long getU4() {
        return (long)this.getS4() & 0xFFFFFFFFL;
    }
}

