/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.match;

import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.core.gen.NodeMatchRules;
import jdk.graal.compiler.core.match.MatchStatement;
import jdk.graal.compiler.core.match.MatchStatementSet;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.DebugOptions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.InputEdges;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.Position;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.serviceprovider.GraalServices;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;

public class MatchRuleRegistry {
    private static final EconomicMap<Class<? extends NodeMatchRules>, EconomicMap<Class<? extends Node>, List<MatchStatement>>> registry = EconomicMap.create((Equivalence)Equivalence.IDENTITY);

    public static Position[] findPositions(NodeClass<? extends Node> nodeClass, String[] names) {
        Position[] result = new Position[names.length];
        for (int i = 0; i < names.length; ++i) {
            InputEdges edges = nodeClass.getInputEdges();
            for (int e = 0; e < edges.getDirectCount(); ++e) {
                if (!names[i].equals(edges.getName(e))) continue;
                result[i] = new Position(edges, e, -1);
            }
            if (result[i] != null) continue;
            throw new GraalError("unknown field \"%s\" in class %s", names[i], nodeClass);
        }
        return result;
    }

    public static synchronized EconomicMap<Class<? extends Node>, List<MatchStatement>> lookup(Class<? extends NodeMatchRules> theClass, OptionValues options, DebugContext debug) {
        EconomicMap<Class<? extends Node>, List<MatchStatement>> result = (EconomicMap<Class<? extends Node>, List<MatchStatement>>)registry.get(theClass);
        if (result == null) {
            EconomicMap<Class<? extends Node>, List<MatchStatement>> rules = MatchRuleRegistry.createRules(theClass);
            registry.put(theClass, rules);
            assert (registry.get(theClass) == rules) : Assertions.errorMessage(registry.get(theClass), rules);
            result = rules;
            if (DebugOptions.LogVerbose.getValue(options).booleanValue()) {
                try (DebugContext.Scope s = debug.scope("MatchComplexExpressions");){
                    debug.log("Match rules for %s", (Object)theClass.getSimpleName());
                    MapCursor cursor = result.getEntries();
                    while (cursor.advance()) {
                        debug.log("  For node class: %s", cursor.getKey());
                        for (MatchStatement statement : (List)cursor.getValue()) {
                            debug.log("    %s", statement.getPattern());
                        }
                    }
                }
            }
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    public static EconomicMap<Class<? extends Node>, List<MatchStatement>> createRules(Class<? extends NodeMatchRules> theClass) {
        EconomicMap matchSets = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        Iterable<MatchStatementSet> sl = GraalServices.load(MatchStatementSet.class);
        for (MatchStatementSet rules : sl) {
            matchSets.put(rules.forClass(), (Object)rules);
        }
        EconomicMap rules = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        Class<? extends NodeMatchRules> currentClass = theClass;
        do {
            MatchStatementSet matchSet;
            if ((matchSet = (MatchStatementSet)matchSets.get(currentClass)) == null) continue;
            List<MatchStatement> statements = matchSet.statements();
            for (MatchStatement statement : statements) {
                Class<? extends Node> nodeClass = statement.getPattern().nodeClass();
                ArrayList<MatchStatement> current = (ArrayList<MatchStatement>)rules.get(nodeClass);
                if (current == null) {
                    current = new ArrayList<MatchStatement>();
                    rules.put(nodeClass, current);
                }
                current.add(statement);
            }
        } while ((currentClass = currentClass.getSuperclass()) != NodeMatchRules.class);
        return rules;
    }
}

