/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.phases;

import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.TimerKey;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.loop.DefaultLoopPolicies;
import jdk.graal.compiler.nodes.loop.LoopPolicies;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.PhaseSuite;
import jdk.graal.compiler.serviceprovider.GraalServices;

public class BaseTier<C>
extends PhaseSuite<C> {
    public static final TimerKey HIRHintedGC = DebugContext.timer("HIRHintedGC").doc("Time spent in hinted GC performed before each HIR phase.");

    public LoopPolicies createLoopPolicies(OptionValues options) {
        return new DefaultLoopPolicies();
    }

    @Override
    protected void run(StructuredGraph graph, C context) {
        for (BasePhase<C> phase : this.getPhases()) {
            try (DebugCloseable timer = HIRHintedGC.start(graph.getDebug());){
                GraalServices.notifyLowMemoryPoint(false);
            }
            phase.apply(graph, context);
        }
    }
}

