/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.phases;

import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.SpectrePHTMitigations;
import jdk.graal.compiler.core.phases.BaseTier;
import jdk.graal.compiler.loop.phases.LoopFullUnrollPhase;
import jdk.graal.compiler.loop.phases.LoopPartialUnrollPhase;
import jdk.graal.compiler.loop.phases.LoopPredicationPhase;
import jdk.graal.compiler.loop.phases.LoopSafepointEliminationPhase;
import jdk.graal.compiler.loop.phases.SpeculativeGuardMovementPhase;
import jdk.graal.compiler.nodes.loop.DefaultLoopPolicies;
import jdk.graal.compiler.nodes.loop.LoopPolicies;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.DeoptimizationGroupingPhase;
import jdk.graal.compiler.phases.common.FloatingReadPhase;
import jdk.graal.compiler.phases.common.FrameStateAssignmentPhase;
import jdk.graal.compiler.phases.common.GuardLoweringPhase;
import jdk.graal.compiler.phases.common.InsertGuardFencesPhase;
import jdk.graal.compiler.phases.common.IterativeConditionalEliminationPhase;
import jdk.graal.compiler.phases.common.LockEliminationPhase;
import jdk.graal.compiler.phases.common.LoopSafepointInsertionPhase;
import jdk.graal.compiler.phases.common.MidTierLoweringPhase;
import jdk.graal.compiler.phases.common.OptimizeDivPhase;
import jdk.graal.compiler.phases.common.ReassociationPhase;
import jdk.graal.compiler.phases.common.RemoveValueProxyPhase;
import jdk.graal.compiler.phases.common.VerifyHeapAtReturnPhase;
import jdk.graal.compiler.phases.common.WriteBarrierAdditionPhase;
import jdk.graal.compiler.phases.tiers.MidTierContext;

public class MidTier
extends BaseTier<MidTierContext> {
    public MidTier(OptionValues options) {
        CanonicalizerPhase canonicalizer = CanonicalizerPhase.create();
        this.appendPhase(new LockEliminationPhase());
        if (GraalOptions.OptFloatingReads.getValue(options).booleanValue()) {
            this.appendPhase(new FloatingReadPhase(canonicalizer));
        }
        if (GraalOptions.ConditionalElimination.getValue(options).booleanValue()) {
            this.appendPhase(new IterativeConditionalEliminationPhase(canonicalizer, true));
        }
        if (GraalOptions.LoopPredication.getValue(options).booleanValue() && !GraalOptions.SpeculativeGuardMovement.getValue(options).booleanValue()) {
            this.appendPhase(new LoopPredicationPhase(canonicalizer));
        }
        this.appendPhase(new LoopSafepointEliminationPhase());
        if (GraalOptions.SpeculativeGuardMovement.getValue(options).booleanValue()) {
            this.appendPhase(new SpeculativeGuardMovementPhase(canonicalizer));
        }
        this.appendPhase(new GuardLoweringPhase());
        if (SpectrePHTMitigations.Options.SpectrePHTBarriers.getValue(options) == SpectrePHTMitigations.GuardTargets || SpectrePHTMitigations.Options.SpectrePHTBarriers.getValue(options) == SpectrePHTMitigations.NonDeoptGuardTargets) {
            this.appendPhase(new InsertGuardFencesPhase());
        }
        if (GraalOptions.VerifyHeapAtReturn.getValue(options).booleanValue()) {
            this.appendPhase(new VerifyHeapAtReturnPhase());
        }
        this.appendPhase(new LoopFullUnrollPhase(canonicalizer, this.createLoopPolicies(options)));
        this.appendPhase(new RemoveValueProxyPhase(canonicalizer));
        this.appendPhase(new LoopSafepointInsertionPhase());
        this.appendPhase(new MidTierLoweringPhase(canonicalizer));
        if (GraalOptions.ConditionalElimination.getValue(options).booleanValue()) {
            this.appendPhase(new IterativeConditionalEliminationPhase(canonicalizer, false));
        }
        this.appendPhase(new OptimizeDivPhase(canonicalizer));
        this.appendPhase(new FrameStateAssignmentPhase());
        if (GraalOptions.PartialUnroll.getValue(options).booleanValue()) {
            LoopPolicies loopPolicies = this.createLoopPolicies(options);
            this.appendPhase(new LoopPartialUnrollPhase(loopPolicies, canonicalizer));
        }
        if (GraalOptions.ReassociateExpressions.getValue(options).booleanValue()) {
            this.appendPhase(new ReassociationPhase(canonicalizer));
        }
        if (GraalOptions.OptDeoptimizationGrouping.getValue(options).booleanValue()) {
            this.appendPhase(new DeoptimizationGroupingPhase());
        }
        this.appendPhase(canonicalizer);
        this.appendPhase(new WriteBarrierAdditionPhase());
    }

    @Override
    public LoopPolicies createLoopPolicies(OptionValues options) {
        return new DefaultLoopPolicies();
    }
}

