/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.phases.fuzzing;

import java.util.Optional;
import jdk.graal.compiler.core.phases.fuzzing.AbstractTierPlan;
import jdk.graal.compiler.core.phases.fuzzing.PhasePlanSerializer;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.schedule.SchedulePhase;
import jdk.graal.compiler.phases.tiers.HighTierContext;
import jdk.graal.compiler.phases.tiers.LowTierContext;
import jdk.graal.compiler.phases.tiers.MidTierContext;
import jdk.graal.compiler.phases.tiers.Suites;

public abstract class AbstractCompilationPlan {
    private final AbstractTierPlan<HighTierContext> highTier;
    private final AbstractTierPlan<MidTierContext> midTier;
    private final AbstractTierPlan<LowTierContext> lowTier;
    private final GraphState.MandatoryStages mandatoryStages;

    protected AbstractCompilationPlan(AbstractTierPlan<HighTierContext> highTier, AbstractTierPlan<MidTierContext> midTier, AbstractTierPlan<LowTierContext> lowTier, GraphState graphState, GraphState.MandatoryStages mandatoryStages) {
        this(highTier, midTier, lowTier, mandatoryStages);
        if (!this.isSchedulePhaseLast()) {
            this.lowTier.getPhaseSuite().appendPhase(new SchedulePhase(SchedulePhase.SchedulingStrategy.LATEST_OUT_OF_LOOPS));
        }
    }

    protected AbstractCompilationPlan(AbstractTierPlan<HighTierContext> highTier, AbstractTierPlan<MidTierContext> midTier, AbstractTierPlan<LowTierContext> lowTier, GraphState.MandatoryStages mandatoryStages) {
        this.highTier = highTier;
        this.midTier = midTier;
        this.lowTier = lowTier;
        this.mandatoryStages = mandatoryStages;
    }

    public void verifyCompilationPlan(GraphState graphState) {
        GraphState simulationGraphState = graphState.copy();
        AbstractCompilationPlan.addInitialRequiredStages(simulationGraphState);
        Optional<BasePhase.NotApplicable> tierNotApplicable = this.highTier.getPhaseSuite().notApplicableTo(simulationGraphState);
        GraalError.guarantee(tierNotApplicable.isEmpty(), "Cannot apply the high tier of this compilation plan because %s.%n%s", tierNotApplicable.orElse(null), (Object)this);
        this.highTier.updateGraphState(simulationGraphState);
        tierNotApplicable = this.midTier.getPhaseSuite().notApplicableTo(simulationGraphState);
        GraalError.guarantee(tierNotApplicable.isEmpty(), "Cannot apply the mid tier of this compilation plan because %s.%n%s", tierNotApplicable.orElse(null), (Object)this);
        this.midTier.updateGraphState(simulationGraphState);
        tierNotApplicable = this.lowTier.getPhaseSuite().notApplicableTo(simulationGraphState);
        GraalError.guarantee(tierNotApplicable.isEmpty(), "Cannot apply the low tier of this compilation plan because %s.%n%s", tierNotApplicable.orElse(null), (Object)this);
        this.lowTier.updateGraphState(simulationGraphState);
        GraalError.guarantee(simulationGraphState.hasAllMandatoryStages(this.getMandatoryStages()), "This compilation plan does not apply all mandatory stages.%n%s", (Object)this);
        GraalError.guarantee(!simulationGraphState.requiresFutureStages(), "This compilation plan:%n%s%nhas remaining requirements: %s", (Object)this, simulationGraphState.getFutureRequiredStages());
        GraalError.guarantee(this.isSchedulePhaseLast(), "Low tier should end with a %s.%n%s", (Object)SchedulePhase.class.getName(), (Object)this);
    }

    protected static void addInitialRequiredStages(GraphState graphState) {
        for (GraphState.StageFlag flag : GraphState.INITIAL_REQUIRED_STAGES) {
            graphState.addFutureStageRequirement(flag);
        }
    }

    private boolean isSchedulePhaseLast() {
        return this.lowTier.getPhaseSuite().findLastPhase().previous() instanceof SchedulePhase;
    }

    public AbstractTierPlan<HighTierContext> getHighTier() {
        return this.highTier;
    }

    public AbstractTierPlan<MidTierContext> getMidTier() {
        return this.midTier;
    }

    public AbstractTierPlan<LowTierContext> getLowTier() {
        return this.lowTier;
    }

    public Suites getSuites() {
        return new Suites(this.highTier.getPhaseSuite(), this.midTier.getPhaseSuite(), this.lowTier.getPhaseSuite());
    }

    public GraphState.MandatoryStages getMandatoryStages() {
        return this.mandatoryStages;
    }

    public void saveCompilationPlan(String dumpPath) {
        PhasePlanSerializer.savePhasePlan(dumpPath + ".phaseplan", this.getSuites());
    }

    public String toString() {
        return String.format("%s%n%s%n%s", this.highTier.toString(), this.midTier.toString(), this.lowTier.toString());
    }

    static class PrintingUtils {
        static final String INDENT = "\t";

        PrintingUtils() {
        }

        static String indent(String string) {
            return String.format("%s%s%n", INDENT, String.join((CharSequence)(System.lineSeparator() + INDENT), string.split(System.lineSeparator())));
        }

        static String printFailing(String phasePlan) {
            if (phasePlan.contains("FAILURE")) {
                return "failing ";
            }
            return "";
        }
    }
}

