/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.phases.fuzzing;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import jdk.graal.compiler.core.phases.fuzzing.AbstractCompilationPlan;
import jdk.graal.compiler.core.phases.fuzzing.AbstractTierPlan;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.PhaseSuite;

class MinimalFuzzedTierPlan<C>
extends AbstractTierPlan<C> {
    private final Set<BasePhase<? super C>> ignoredPhases;
    private final long randomSeed;

    private MinimalFuzzedTierPlan(List<BasePhase<? super C>> originalPhases, GraphState graphState, EnumSet<GraphState.StageFlag> mandatoryStages, long randomSeed, String tierName) {
        super(originalPhases, tierName);
        this.ignoredPhases = new HashSet<BasePhase<? super C>>();
        this.randomSeed = randomSeed;
        this.computeMinimalFuzzedTierPlan(graphState, mandatoryStages);
    }

    protected MinimalFuzzedTierPlan(List<BasePhase<? super C>> singleApplyPhases, List<BasePhase<? super C>> multiApplyPhases, Set<BasePhase<? super C>> ignoredPhases, PhaseSuite<C> minimalPhaseSuite, long randomSeed, String tierName) {
        super(singleApplyPhases, multiApplyPhases, minimalPhaseSuite, tierName);
        this.ignoredPhases = ignoredPhases;
        this.randomSeed = randomSeed;
    }

    protected static <C> MinimalFuzzedTierPlan<C> create(List<BasePhase<? super C>> originalPhases, GraphState graphState, EnumSet<GraphState.StageFlag> mandatoryStages, long seed, String tierName) {
        return new MinimalFuzzedTierPlan<C>(originalPhases, graphState, mandatoryStages, seed, tierName);
    }

    private void computeMinimalFuzzedTierPlan(GraphState graphState, EnumSet<GraphState.StageFlag> mandatoryStages) {
        Random random = new Random(this.getRandomSeed());
        this.insertPhasesThatMustApply(graphState);
        GraphState graphStateCopy = graphState.copy();
        MinimalFuzzedTierPlan.updateGraphState(this.getPhaseSuite(), graphStateCopy);
        ArrayList minimalPhases = new ArrayList(this.getSingleApplyPhases());
        minimalPhases.removeIf(phase -> {
            GraphState graphStateWithThisPhase = graphState.copy();
            MinimalFuzzedTierPlan.updateGraphState(phase, graphStateWithThisPhase);
            return graphStateWithThisPhase.countMissingStages(mandatoryStages) >= graphState.countMissingStages(mandatoryStages);
        });
        Collections.shuffle(minimalPhases, random);
        ListIterator phasesIterator = minimalPhases.listIterator();
        int maxAttempts = minimalPhases.size();
        int currAttempt = 0;
        block0: while (!graphStateCopy.isAfterStages(mandatoryStages)) {
            if (!phasesIterator.hasNext()) {
                if (++currAttempt > maxAttempts) {
                    EnumSet<GraphState.StageFlag> unreachedStages = EnumSet.copyOf(mandatoryStages);
                    unreachedStages.removeAll(graphStateCopy.getStageFlags());
                    Formatter errorMsg = new Formatter();
                    errorMsg.format("The given phases cannot fulfill the requirements.%n", new Object[0]);
                    errorMsg.format("Current random seed:%s%n", this.getRandomSeed());
                    errorMsg.format("Current plan:%n", new Object[0]);
                    errorMsg.format("%s%n", this);
                    errorMsg.format("%s%n", this.ignoredPhasesToString());
                    errorMsg.format("Given mandatory stages:%n", new Object[0]);
                    errorMsg.format("%s%n", mandatoryStages);
                    errorMsg.format("Stages that can be reached with the current plan:%n", new Object[0]);
                    errorMsg.format("%s%n", graphStateCopy.getStageFlags());
                    errorMsg.format("Mandatory stages that are not reached:%n", new Object[0]);
                    errorMsg.format("%s%n", unreachedStages);
                    GraalError.shouldNotReachHere(errorMsg.toString());
                }
                Collections.shuffle(minimalPhases, random);
                phasesIterator = minimalPhases.listIterator();
                continue;
            }
            BasePhase phase2 = (BasePhase)phasesIterator.next();
            for (int i = 0; i <= this.getPhaseSuite().getPhases().size(); ++i) {
                if (!this.insertPhaseAtIndex(phase2, i, graphState)) continue;
                phasesIterator.remove();
                GraphState newGraphState = graphState.copy();
                this.updateGraphState(newGraphState);
                graphStateCopy = newGraphState;
                continue block0;
            }
        }
        this.insertPhasesThatMustApply(graphState);
    }

    protected void insertPhasesThatMustApply(GraphState graphState) {
        ArrayDeque phases = new ArrayDeque(this.getSingleApplyPhases());
        phases.addAll(this.getMultiApplyPhases());
        Supplier<BasePhase> phaseThatMustApplySupplier = () -> phases.stream().filter(p -> this.mustApplyAfterSuite(p, graphState)).findFirst().orElse(null);
        BasePhase phaseThatMustApply = phaseThatMustApplySupplier.get();
        long maxAttempts = phases.size();
        maxAttempts = (double)maxAttempts > Math.sqrt(9.223372036854776E18) ? Long.MAX_VALUE : maxAttempts * (maxAttempts + 1L) / 2L;
        int currAttempt = 0;
        while (phaseThatMustApply != null && (long)currAttempt < maxAttempts) {
            for (int i = this.getPhaseSuite().getPhases().size(); i >= 0; --i) {
                GraphState currGraphState = graphState.copy();
                this.updateGraphStateUntilPhaseIndex(currGraphState, i);
                if (!phaseThatMustApply.mustApply(currGraphState) || this.insertPhaseAtIndex(phaseThatMustApply, i, graphState)) break;
            }
            phases.remove(phaseThatMustApply);
            phases.add(phaseThatMustApply);
            phaseThatMustApply = phaseThatMustApplySupplier.get();
            ++currAttempt;
        }
    }

    protected boolean insertPhaseAtIndex(BasePhase<? super C> phase, int index, GraphState graphState) {
        PhaseSuite<? super C> newFuzzedPhaseSuite = this.getPhaseSuite().copy();
        newFuzzedPhaseSuite.insertAtIndex(index, phase);
        Optional<BasePhase.NotApplicable> suiteNotApplicable = newFuzzedPhaseSuite.notApplicableTo(graphState.copy());
        if (suiteNotApplicable.isEmpty()) {
            this.getIgnoredPhases().remove(phase);
            this.setPhaseSuite(newFuzzedPhaseSuite);
            return true;
        }
        return false;
    }

    protected Set<BasePhase<? super C>> getIgnoredPhases() {
        return this.ignoredPhases;
    }

    public long getRandomSeed() {
        return this.randomSeed;
    }

    protected String ignoredPhasesToString() {
        if (this.getIgnoredPhases().isEmpty()) {
            return "Every phase that was given is in the resulting tier plan.";
        }
        Formatter formatter = new Formatter();
        formatter.format("Phase%s in %s ignored by the fuzzer:%n", this.getIgnoredPhases().size() > 1 ? "s" : "", this.getTierName().toLowerCase());
        for (BasePhase<C> phase : this.getIgnoredPhases()) {
            if (phase instanceof PhaseSuite) {
                formatter.format("%s", AbstractCompilationPlan.PrintingUtils.indent(phase.toString()));
                continue;
            }
            formatter.format("%s", AbstractCompilationPlan.PrintingUtils.indent(phase.contractorName()));
        }
        return formatter.toString();
    }

    public MinimalFuzzedTierPlan<C> copy() {
        return new MinimalFuzzedTierPlan<C>(new ArrayList<BasePhase<? super C>>(this.getSingleApplyPhases()), new ArrayList<BasePhase<? super C>>(this.getMultiApplyPhases()), new HashSet<BasePhase<? super C>>(this.getIgnoredPhases()), this.getPhaseSuite().copy(), this.getRandomSeed(), this.getTierName());
    }
}

