/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.debug;

import java.util.Arrays;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.nodeinfo.Verbosity;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;

public class Assertions {
    public static boolean assertionsEnabled() {
        boolean enabled = false;
        if (!$assertionsDisabled) {
            enabled = true;
            if (!true) {
                throw new AssertionError((Object)"Enabling assertions");
            }
        }
        return enabled;
    }

    public static boolean detailedAssertionsEnabled(OptionValues values) {
        return Assertions.assertionsEnabled() && Options.DetailedAsserts.getValue(values) != false;
    }

    private static String formatAssertionContextArgV(Object ... args) {
        StringBuilder sb = new StringBuilder();
        assert (args.length % 2 == 0) : "Must have an equal nr of entries to format context: " + Arrays.toString(args);
        int entries = args.length / 2;
        int entriesDone = 0;
        for (int i = 0; i < args.length; i += 2) {
            Object val = args[i + 1];
            sb.append(args[i]).append("=");
            Assertions.formatObjectContext(sb, val);
            if (++entriesDone >= entries) continue;
            sb.append(";");
        }
        return sb.toString();
    }

    private static void formatObjectContext(StringBuilder sb, Object val) {
        try {
            if (val instanceof HIRBlock) {
                HIRBlock b = (HIRBlock)val;
                sb.append(b.toString(Verbosity.All));
            } else if (val instanceof ValueNode) {
                ValueNode v = (ValueNode)val;
                sb.append(v.toString(Verbosity.All));
                sb.append("/");
                Stamp stamp = v.stamp(NodeView.DEFAULT);
                sb.append(stamp).append(" ");
                sb.append(v.getStackKind());
                sb.append("\\");
            } else {
                sb.append(val);
            }
        }
        catch (Throwable e) {
            sb.append("Error calling toString on object ").append(e.getMessage());
        }
    }

    public static String errorMessage(Object ... args) {
        StringBuilder sb = new StringBuilder();
        int entries = args.length;
        int entriesDone = 0;
        for (int i = 0; i < args.length; ++i) {
            Object val = args[i];
            sb.append("[").append(i).append("]=");
            Assertions.formatObjectContext(sb, val);
            if (++entriesDone >= entries) continue;
            sb.append(";");
        }
        return sb.toString();
    }

    public static String errorMessageContext(String s1, Object o1) {
        return Assertions.formatAssertionContextArgV(s1, o1);
    }

    public static String errorMessageContext(String s1, Object o1, String s2, Object o2) {
        return Assertions.formatAssertionContextArgV(s1, o1, s2, o2);
    }

    public static String errorMessageContext(String s1, Object o1, String s2, Object o2, String s3, Object o3) {
        return Assertions.formatAssertionContextArgV(s1, o1, s2, o2, s3, o3);
    }

    public static String errorMessageContext(String s1, Object o1, String s2, Object o2, String s3, Object o3, String s4, Object o4) {
        return Assertions.formatAssertionContextArgV(s1, o1, s2, o2, s3, o3, s4, o4);
    }

    public static String errorMessageContext(String s1, Object o1, String s2, Object o2, String s3, Object o3, String s4, Object o4, String s5, Object o5) {
        return Assertions.formatAssertionContextArgV(s1, o1, s2, o2, s3, o3, s4, o4, s5, o5);
    }

    public static String errorMessageContext(String s1, Object o1, String s2, Object o2, String s3, Object o3, String s4, Object o4, String s5, Object o5, String s6, Object o6) {
        return Assertions.formatAssertionContextArgV(s1, o1, s2, o2, s3, o3, s4, o4, s5, o5, s6, o6);
    }

    public static String errorMessageContext(String s1, Object o1, String s2, Object o2, String s3, Object o3, String s4, Object o4, String s5, Object o5, String s6, Object o6, String s7, Object o7) {
        return Assertions.formatAssertionContextArgV(s1, o1, s2, o2, s3, o3, s4, o4, s5, o5, s6, o6, s7, o7);
    }

    public static class Options {
        public static final OptionKey<Boolean> DetailedAsserts = new OptionKey<Boolean>(false);
    }
}

