/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.debug;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.DebugDumpHandler;
import jdk.graal.compiler.debug.DebugVerifyHandler;
import jdk.graal.compiler.debug.JavaMethodContext;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.meta.JavaMethod;

public interface DebugConfig {
    public OptionValues getOptions();

    public int getLogLevel(DebugContext.Scope var1);

    public int getDumpLevel(DebugContext.Scope var1);

    public boolean isLogEnabledForMethod(DebugContext.Scope var1);

    public boolean isCountEnabled(DebugContext.Scope var1);

    public boolean isMemUseTrackingEnabled(DebugContext.Scope var1);

    public boolean isDumpEnabledForMethod(DebugContext.Scope var1);

    public boolean isVerifyEnabled(DebugContext.Scope var1);

    public boolean isTimeEnabled(DebugContext.Scope var1);

    public boolean methodFilterMatchesCurrentMethod(DebugContext.Scope var1);

    public RuntimeException interceptException(DebugContext var1, Throwable var2);

    public Collection<DebugDumpHandler> dumpHandlers();

    public PrintStream output();

    public Collection<DebugVerifyHandler> verifyHandlers();

    default public void closeDumpHandlers(boolean ignoreErrors) {
        block4: {
            Iterator<DebugDumpHandler> iterator = this.dumpHandlers().iterator();
            while (true) {
                DebugDumpHandler handler = iterator.next();
                handler.close();
                continue;
                break;
            }
            finally {
                if (!iterator.hasNext()) break block4;
            }
        }
    }

    public static JavaMethod asJavaMethod(Object context) {
        if (context instanceof JavaMethodContext) {
            return ((JavaMethodContext)context).asJavaMethod();
        }
        if (context instanceof JavaMethod) {
            return (JavaMethod)context;
        }
        return null;
    }
}

