/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.debug;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import jdk.graal.compiler.debug.DebugConfigImpl;
import jdk.graal.compiler.debug.PathUtilities;
import jdk.graal.compiler.debug.TTY;
import jdk.graal.compiler.options.EnumMultiOptionKey;
import jdk.graal.compiler.options.EnumOptionKey;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.serviceprovider.GraalServices;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;

public class DebugOptions {
    public static final OptionKey<String> Timers = new OptionKey<Object>(null);
    public static final OptionKey<String> Counters = new OptionKey<Object>(null);
    public static final OptionKey<String> MemUseTrackers = new OptionKey<Object>(null);
    public static final OptionKey<String> Count = new OptionKey<Object>(null);
    public static final OptionKey<String> TrackMemUse = new OptionKey<Object>(null);
    public static final OptionKey<String> Time = new OptionKey<Object>(null);
    public static final OptionKey<String> Verify = new OptionKey<Object>(null);
    public static final OptionKey<String> Dump = new OptionKey<Object>(null);
    public static final OptionKey<String> Log = new OptionKey<Object>(null);
    public static final OptionKey<String> MethodFilter = new OptionKey<Object>(null);
    public static final OptionKey<Boolean> MethodFilterRootOnly = new OptionKey<Boolean>(false);
    public static final OptionKey<String> DumpOnPhaseChange = new OptionKey<Object>(null);
    public static final OptionKey<Boolean> ListMetrics = new OptionKey<Boolean>(false);
    public static final OptionKey<String> MetricsFile = new OptionKey<Object>(null);
    public static final OptionKey<String> AggregatedMetricsFile = new OptionKey<Object>(null);
    public static final OptionKey<Boolean> DebugStubsAndSnippets = new OptionKey<Boolean>(false);
    public static final OptionKey<Boolean> DumpOnError = new OptionKey<Boolean>(false);
    public static final OptionKey<String> DiagnoseDumpLevel = new OptionKey<String>(":3");
    public static final OptionKey<Boolean> DisableIntercept = new OptionKey<Boolean>(false);
    public static final OptionKey<Boolean> InterceptBailout = new OptionKey<Boolean>(false);
    public static final OptionKey<Boolean> LogVerbose = new OptionKey<Boolean>(false);
    public static final OptionKey<String> DumpPath = new OptionKey<String>("graal_dumps");
    public static final OptionKey<Boolean> ShowDumpFiles = new OptionKey<Boolean>(false);
    public static final OptionKey<Boolean> PrintBackendCFG = new OptionKey<Boolean>(false);
    public static final OptionKey<Boolean> PrintBlockMapping = new OptionKey<Boolean>(false);
    public static final OptionKey<Boolean> PrintBBInfo = new OptionKey<Boolean>(false);
    public static final EnumOptionKey<PrintGraphTarget> PrintGraph = new EnumOptionKey<PrintGraphTarget>(PrintGraphTarget.File);
    public static final OptionKey<Boolean> PrintUnmodifiedGraphs = new OptionKey<Boolean>(true);
    public static final OptionKey<Boolean> PrintGraphFile = new OptionKey<Boolean>(Boolean.valueOf(true)){

        @Override
        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
            PrintGraphTarget v = (PrintGraphTarget)((Object)PrintGraph.getValueOrDefault((UnmodifiableEconomicMap<OptionKey<?>, Object>)values));
            if (newValue.booleanValue()) {
                if (v != PrintGraphTarget.File) {
                    PrintGraph.update(values, (Object)PrintGraphTarget.File);
                }
            } else if (v != PrintGraphTarget.Network) {
                PrintGraph.update(values, (Object)PrintGraphTarget.Network);
            }
        }
    };
    public static final OptionKey<String> PrintGraphHost = new OptionKey<String>("127.0.0.1");
    public static final OptionKey<Integer> PrintGraphPort = new OptionKey<Integer>(4445);
    public static final OptionKey<Boolean> PrintGraphWithSchedule = new OptionKey<Boolean>(false);
    public static final OptionKey<Boolean> DumpingErrorsAreFatal = new OptionKey<Boolean>(false);
    public static final OptionKey<Boolean> PrintCanonicalGraphStrings = new OptionKey<Boolean>(false);
    public static final OptionKey<Integer> PrintCanonicalGraphStringFlavor = new OptionKey<Integer>(0);
    public static final OptionKey<Boolean> CanonicalGraphStringsExcludeVirtuals = new OptionKey<Boolean>(true);
    public static final OptionKey<Boolean> CanonicalGraphStringsCheckConstants = new OptionKey<Boolean>(false);
    public static final OptionKey<Boolean> CanonicalGraphStringsRemoveIdentities = new OptionKey<Boolean>(true);
    public static final OptionKey<Boolean> ClearMetricsAfterBootstrap = new OptionKey<Boolean>(false);
    public static final OptionKey<Boolean> BootstrapInitializeOnly = new OptionKey<Boolean>(false);
    public static final EnumMultiOptionKey<OptimizationLogTarget> OptimizationLog = new EnumMultiOptionKey<OptimizationLogTarget>(OptimizationLogTarget.class, null);
    public static final OptionKey<String> OptimizationLogPath = new OptionKey<Object>(null);
    private static final String DUMP_DIRECTORY_MESSAGE_FORMAT = "Dumping debug output in '%s'";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getDumpDirectory(OptionValues options) throws IOException {
        String dumpDir = DebugOptions.getDumpDirectoryName(options);
        if (PathUtilities.exists(dumpDir)) return dumpDir;
        Class<DebugConfigImpl> clazz = DebugConfigImpl.class;
        synchronized (DebugConfigImpl.class) {
            if (PathUtilities.exists(dumpDir)) return dumpDir;
            PathUtilities.createDirectories(dumpDir);
            if (!ShowDumpFiles.getValue(options).booleanValue()) return dumpDir;
            TTY.println(DUMP_DIRECTORY_MESSAGE_FORMAT, dumpDir);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return dumpDir;
        }
    }

    public static String getDumpDirectoryName(OptionValues options) {
        String dumpDir;
        if (DumpPath.hasBeenSet(options)) {
            dumpDir = PathUtilities.getPath(DumpPath.getValue(options), new String[0]);
        } else {
            Date date = new Date(GraalServices.getGlobalTimeStamp());
            SimpleDateFormat formatter = new SimpleDateFormat("YYYY.MM.dd.HH.mm.ss.SSS");
            dumpDir = PathUtilities.getPath(DumpPath.getValue(options), formatter.format(date));
        }
        dumpDir = PathUtilities.getAbsolutePath(dumpDir);
        return dumpDir;
    }

    public static enum PrintGraphTarget {
        File,
        Network,
        Disable;

    }

    public static enum OptimizationLogTarget {
        Directory,
        Stdout,
        Dump;

    }
}

