/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.debug;

import java.io.IOException;
import jdk.graal.compiler.debug.DebugOptions;
import jdk.graal.compiler.debug.PathUtilities;
import jdk.graal.compiler.debug.TTY;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.serviceprovider.GraalServices;
import jdk.graal.compiler.serviceprovider.IsolateUtil;

public class DiagnosticsOutputDirectory {
    private static final String CLOSED = "\u0000";
    private final OptionValues options;
    private String path;

    public DiagnosticsOutputDirectory(OptionValues options) {
        this.options = options;
    }

    public String getPath() {
        return this.getPath(true);
    }

    private synchronized String getPath(boolean createIfNull) {
        if (this.path == null && createIfNull) {
            this.path = this.createPath();
            String dir = PathUtilities.getAbsolutePath(this.path);
            if (!PathUtilities.exists(dir)) {
                try {
                    PathUtilities.createDirectories(dir);
                }
                catch (IOException e) {
                    TTY.println("Warning: could not create Graal diagnostic directory " + dir + ": " + String.valueOf(e));
                    return null;
                }
            }
        }
        if (CLOSED.equals(this.path)) {
            TTY.println("Warning: Graal diagnostic directory already closed");
            return null;
        }
        return this.path;
    }

    protected String createPath() {
        String baseDir;
        try {
            baseDir = DebugOptions.getDumpDirectory(this.options);
        }
        catch (IOException e) {
            baseDir = ".";
        }
        return PathUtilities.getPath(baseDir, "graal_diagnostics_" + GraalServices.getExecutionID() + "@" + IsolateUtil.getIsolateID());
    }

    public void close() {
        this.archiveAndDelete();
    }

    private synchronized void archiveAndDelete() {
        String outDir = this.getPath(false);
        if (outDir != null) {
            this.path = CLOSED;
            try {
                String zip = outDir + ".zip";
                PathUtilities.archiveAndDelete(outDir, zip);
            }
            catch (IOException e) {
                TTY.println(e.getMessage());
                TTY.println("Cause: " + String.valueOf(e.getCause()));
            }
        }
    }
}

