/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.debug;

import java.util.ArrayList;
import java.util.Locale;
import jdk.vm.ci.code.Architecture;

public class GraalError
extends Error {
    private static final long serialVersionUID = 531632331813456233L;
    private final ArrayList<String> context = new ArrayList();

    public static RuntimeException unimplemented(String msg) {
        throw new GraalError("unimplemented: %s", msg);
    }

    public static RuntimeException unimplementedOverride() {
        throw new GraalError("unimplemented override");
    }

    public static RuntimeException unimplementedParent() {
        throw new GraalError("unimplemented method in parent class, should be overridden");
    }

    public static RuntimeException unsupportedArchitecture(Architecture arch) {
        throw new GraalError("unsupported architecture: %s", arch);
    }

    public static RuntimeException shouldNotReachHere(String msg) {
        throw new GraalError("should not reach here: %s", msg);
    }

    public static RuntimeException shouldNotReachHereUnexpectedValue(Object obj) {
        throw new GraalError("should not reach here: unexpected value: %s", obj);
    }

    public static RuntimeException shouldNotReachHere(Throwable cause) {
        throw new GraalError(cause);
    }

    public static RuntimeException shouldNotReachHere(Throwable cause, String msg) {
        throw new GraalError(cause, "should not reach here: %s", msg);
    }

    public static void guarantee(boolean condition, String msg) {
        if (!condition) {
            throw new GraalError("failed guarantee: " + msg);
        }
    }

    public static void guarantee(boolean condition, String msg, Object arg) {
        if (!condition) {
            throw new GraalError("failed guarantee: " + msg, arg);
        }
    }

    public static void guarantee(boolean condition, String msg, Object arg1, Object arg2) {
        if (!condition) {
            throw new GraalError("failed guarantee: " + msg, arg1, arg2);
        }
    }

    public static void guarantee(boolean condition, String msg, Object arg1, Object arg2, Object arg3) {
        if (!condition) {
            throw new GraalError("failed guarantee: " + msg, arg1, arg2, arg3);
        }
    }

    public static void guarantee(boolean condition, String msg, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (!condition) {
            throw new GraalError("failed guarantee: " + msg, arg1, arg2, arg3, arg4);
        }
    }

    public static void guarantee(boolean condition, String msg, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (!condition) {
            throw new GraalError("failed guarantee: " + msg, arg1, arg2, arg3, arg4, arg5);
        }
    }

    public static void guarantee(boolean condition, String msg, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        if (!condition) {
            throw new GraalError("failed guarantee: " + msg, arg1, arg2, arg3, arg4, arg5, arg6);
        }
    }

    public static void guarantee(boolean condition, String msg, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7) {
        if (!condition) {
            throw new GraalError("failed guarantee: " + msg, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
        }
    }

    @Deprecated
    public static void guarantee(boolean condition, String msg, Object ... args) {
        if (!condition) {
            throw new GraalError("failed guarantee: " + msg, args);
        }
    }

    public GraalError(String msg) {
        super(msg);
    }

    public GraalError(String msg, Object ... args) {
        super(GraalError.format(msg, args));
    }

    public GraalError(Throwable cause) {
        super(cause);
    }

    public GraalError(Throwable cause, String msg, Object ... args) {
        super(GraalError.format(msg, args), cause);
    }

    public GraalError(GraalError e) {
        super(e);
        this.context.addAll(e.context);
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(super.toString());
        str.append(this.context());
        return str.toString();
    }

    public String context() {
        StringBuilder str = new StringBuilder();
        for (String s : this.context) {
            str.append("\n\tat ").append(s);
        }
        return str.toString();
    }

    private static String format(String msg, Object ... args) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof Iterable)) continue;
                ArrayList list = new ArrayList();
                for (Object o : (Iterable)args[i]) {
                    list.add(o);
                }
                args[i] = list.toString();
            }
        }
        return String.format(Locale.ENGLISH, msg, args);
    }

    public GraalError addContext(String newContext) {
        this.context.add(newContext);
        return this;
    }

    public GraalError addContext(String name, Object obj) {
        return this.addContext(GraalError.format("%s: %s", name, obj));
    }
}

