/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.debug;

import java.util.concurrent.TimeUnit;
import jdk.graal.compiler.debug.AbstractKey;
import jdk.graal.compiler.debug.AccumulatedKey;
import jdk.graal.compiler.debug.CloseableCounter;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.TimeSource;
import jdk.graal.compiler.debug.TimerKey;
import org.graalvm.collections.Pair;

final class TimerKeyImpl
extends AccumulatedKey
implements TimerKey {
    TimerKeyImpl(String nameFormat, Object nameArg1, Object nameArg2) {
        super(new FlatTimer(nameFormat, nameArg1, nameArg2), nameFormat, nameArg1, nameArg2);
        ((FlatTimer)this.flat).accm = this;
    }

    @Override
    public DebugCloseable start(DebugContext debug) {
        if (debug.isTimerEnabled(this)) {
            Timer result = new Timer(this, debug);
            debug.currentTimer = result;
            return result;
        }
        return DebugCloseable.VOID_CLOSEABLE;
    }

    public static String valueToString(long value) {
        return String.format("%d.%d ms", value / 1000000L, value / 100000L % 10L);
    }

    @Override
    public TimerKey getFlat() {
        return (FlatTimer)this.flat;
    }

    @Override
    public String toHumanReadableFormat(long value) {
        return TimerKeyImpl.valueToString(value);
    }

    @Override
    public TimeUnit getTimeUnit() {
        return TimeUnit.NANOSECONDS;
    }

    @Override
    public Pair<String, String> toCSVFormat(long value) {
        return TimerKeyImpl.toCSVFormatHelper(value);
    }

    static Pair<String, String> toCSVFormatHelper(long value) {
        return Pair.create((Object)Long.toString(value / 1000L), (Object)"us");
    }

    @Override
    public TimerKey doc(String doc) {
        this.setDoc(doc);
        return this;
    }

    static class FlatTimer
    extends AbstractKey
    implements TimerKey {
        private TimerKeyImpl accm;

        FlatTimer(String nameFormat, Object nameArg1, Object nameArg2) {
            super(nameFormat, nameArg1, nameArg2);
        }

        @Override
        protected String createName(String format, Object arg1, Object arg2) {
            return super.createName(format, arg1, arg2) + "_Flat";
        }

        @Override
        public String toHumanReadableFormat(long value) {
            return TimerKeyImpl.valueToString(value);
        }

        @Override
        public TimeUnit getTimeUnit() {
            return this.accm.getTimeUnit();
        }

        @Override
        public DebugCloseable start(DebugContext debug) {
            return this.accm.start(debug);
        }

        @Override
        public Pair<String, String> toCSVFormat(long value) {
            return TimerKeyImpl.toCSVFormatHelper(value);
        }

        @Override
        public TimerKey doc(String doc) {
            throw new IllegalArgumentException("Cannot set documentation for derived key " + this.getName());
        }

        @Override
        public String getDocName() {
            return null;
        }
    }

    static final class Timer
    extends CloseableCounter
    implements DebugCloseable {
        final DebugContext debug;

        Timer(AccumulatedKey counter, DebugContext debug) {
            super(debug, debug.currentTimer, counter);
            this.debug = debug;
        }

        @Override
        public void close() {
            super.close();
            this.debug.currentTimer = this.parent;
        }

        @Override
        protected long getCounterValue() {
            return TimeSource.getTimeNS();
        }
    }
}

