/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.debug;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jdk.graal.compiler.debug.PathUtilities;
import jdk.vm.ci.services.Services;

public final class Versions {
    static final Versions VERSIONS;
    private final Map<Object, Object> versions;

    public Versions(String home) {
        HashMap<CallSite, String> map;
        block12: {
            map = new HashMap<CallSite, String>();
            try {
                String info = Versions.findReleaseInfo(home);
                if (info == null) break block12;
                try (InputStream in = PathUtilities.openInputStream(info);){
                    BufferedReader br = new BufferedReader(new InputStreamReader(in));
                    String line = br.readLine();
                    while (line != null) {
                        String prefix = "SOURCE=";
                        if (line.startsWith("SOURCE=")) {
                            for (String versionInfo : line.substring("SOURCE=".length()).replace('\"', ' ').split(" ")) {
                                String[] idVersion = versionInfo.split(":");
                                if (idVersion == null || idVersion.length != 2) continue;
                                map.put((CallSite)((Object)("version." + idVersion[0])), idVersion[1]);
                            }
                            break;
                        }
                        line = br.readLine();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.versions = Collections.unmodifiableMap(map);
    }

    public Map<Object, Object> withVersions(Map<Object, Object> properties) {
        if (properties == null) {
            return this.versions;
        }
        properties.putAll(this.versions);
        return properties;
    }

    private static String findReleaseInfo(String jreDir) {
        if (jreDir == null) {
            return null;
        }
        String releaseInJre = PathUtilities.getPath(jreDir, "release");
        if (PathUtilities.exists(releaseInJre)) {
            return releaseInJre;
        }
        String jdkDir = PathUtilities.getParent(jreDir);
        if (jdkDir == null) {
            return null;
        }
        String releaseInJdk = PathUtilities.getPath(jdkDir, "release");
        return PathUtilities.exists(releaseInJdk) ? releaseInJdk : null;
    }

    static {
        String home = Services.getSavedProperty((String)"java.home");
        VERSIONS = new Versions(home);
    }
}

