/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.graph;

import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodeinfo.Verbosity;

public class GraalGraphError
extends GraalError {
    private static final long serialVersionUID = -989290015525497919L;
    private Node node;
    private Graph graph;

    public GraalGraphError(String msg, Object ... args) {
        super(msg, args);
    }

    public GraalGraphError(Throwable cause) {
        super(cause);
    }

    protected GraalGraphError(GraalError e) {
        super(e);
        if (e instanceof GraalGraphError) {
            this.node = ((GraalGraphError)e).node;
            this.graph = ((GraalGraphError)e).graph;
        }
    }

    GraalGraphError addContext(Graph newGraph) {
        if (newGraph != this.graph) {
            this.addContext("graph", newGraph);
            if (this.graph == null) {
                this.graph = newGraph;
            }
        }
        return this;
    }

    public GraalGraphError addContext(Node newNode) {
        if (newNode != this.node) {
            String nodeMessage;
            try {
                nodeMessage = newNode.toString(Verbosity.Debugger);
            }
            catch (Throwable t) {
                nodeMessage = newNode.toString();
            }
            this.addContext("node", nodeMessage);
            if (this.node == null) {
                this.node = newNode;
            }
        }
        return this;
    }

    public static GraalGraphError transformAndAddContext(GraalError e, Node newNode) {
        GraalGraphError graphError = e instanceof GraalGraphError ? (GraalGraphError)e : new GraalGraphError(e);
        return graphError.addContext(newNode);
    }
}

