/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.util.CompilationAlarm;
import jdk.graal.compiler.core.common.util.EventCounter;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.CounterKey;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.debug.TimerKey;
import jdk.graal.compiler.graph.GraalGraphError;
import jdk.graal.compiler.graph.GraphNodeIterator;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeBitMap;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.NodeFlood;
import jdk.graal.compiler.graph.NodeIdAccessor;
import jdk.graal.compiler.graph.NodeMap;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.graph.NodeWorkList;
import jdk.graal.compiler.graph.TypedGraphNodeIterator;
import jdk.graal.compiler.graph.iterators.NodeIterable;
import jdk.graal.compiler.graph.iterators.NodePredicate;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.UnmodifiableEconomicMap;

public class Graph
implements EventCounter {
    public final String name;
    public final boolean verifyGraphs;
    public final boolean verifyGraphEdges;
    Node[] nodes;
    NodeSourcePosition currentNodeSourcePosition;
    protected boolean trackNodeSourcePosition;
    int nodesSize;
    int edgeModificationCount;
    private int[] nodeModCounts;
    private int[] nodeUsageModCounts;
    private final ArrayList<Node> iterableNodesFirst;
    private final ArrayList<Node> iterableNodesLast;
    private int nodesDeletedSinceLastCompression;
    private int nodesDeletedBeforeLastCompression;
    int compressions;
    NodeEventListener nodeEventListener;
    private EconomicMap<Node, Node>[] cachedLeafNodes;
    private static final Equivalence NODE_VALUE_COMPARE = new Equivalence(){

        public boolean equals(Object a, Object b) {
            if (a == b) {
                return true;
            }
            assert (a.getClass() == b.getClass()) : Assertions.errorMessageContext("a", a, "b", b);
            return ((Node)a).valueEquals((Node)b);
        }

        public int hashCode(Object k) {
            return ((Node)k).getNodeClass().valueNumber((Node)k);
        }
    };
    private FreezeState freezeState = FreezeState.Unfrozen;
    private final OptionValues options;
    private DebugContext debug;
    private int eventCounter;
    private static final int INITIAL_NODES_SIZE = 32;
    private AddInputsFilter addInputsFilter = new AddInputsFilter();
    private static final CounterKey GraphCompressions = DebugContext.counter("GraphCompressions");
    private static final TimerKey DuplicateGraph = DebugContext.timer("DuplicateGraph");

    @Override
    public boolean eventCounterOverflows(int max) {
        if (this.eventCounter++ > max) {
            this.eventCounter = 0;
            return true;
        }
        return false;
    }

    @Override
    public String eventCounterToString() {
        return this.toString() + " eventCounter=" + this.eventCounter;
    }

    public int getEventCounter() {
        return this.eventCounter;
    }

    public NodeSourcePosition currentNodeSourcePosition() {
        return this.currentNodeSourcePosition;
    }

    public DebugCloseable withNodeSourcePosition(Node node) {
        return this.withNodeSourcePosition(node.getNodeSourcePosition());
    }

    public DebugCloseable withNodeSourcePosition(NodeSourcePosition sourcePosition) {
        return this.trackNodeSourcePosition() && sourcePosition != null ? new NodeSourcePositionScope(sourcePosition) : null;
    }

    public boolean trackNodeSourcePosition() {
        return this.trackNodeSourcePosition;
    }

    public void setTrackNodeSourcePosition() {
        if (!this.trackNodeSourcePosition) {
            assert (this.getNodeCount() == 1) : "can't change the value after nodes have been added";
            this.trackNodeSourcePosition = true;
        }
    }

    public static boolean trackNodeSourcePositionDefault(OptionValues options, DebugContext debug) {
        return GraalOptions.TrackNodeSourcePosition.getValue(options) != false || debug.isDumpEnabledForMethod();
    }

    public void getDebugProperties(Map<Object, Object> properties) {
        properties.put("graph", this.toString());
    }

    public void beforeNodeDuplication(Graph sourceGraph) {
    }

    public Graph(OptionValues options, DebugContext debug) {
        this(null, options, debug, false);
    }

    public static boolean isNodeModificationCountsEnabled() {
        boolean enabled = false;
        if (!$assertionsDisabled) {
            enabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return enabled;
    }

    public Graph(String name, OptionValues options, DebugContext debug, boolean trackNodeSourcePosition) {
        this.nodes = new Node[32];
        this.iterableNodesFirst = new ArrayList(NodeClass.allocatedNodeIterabledIds());
        this.iterableNodesLast = new ArrayList(NodeClass.allocatedNodeIterabledIds());
        this.name = name;
        this.options = options;
        boolean bl = this.trackNodeSourcePosition = trackNodeSourcePosition || Graph.trackNodeSourcePositionDefault(options, debug);
        assert (debug != null);
        this.debug = debug;
        if (Graph.isNodeModificationCountsEnabled()) {
            this.nodeModCounts = new int[32];
            this.nodeUsageModCounts = new int[32];
        }
        this.verifyGraphs = Options.VerifyGraalGraphs.getValue(options);
        this.verifyGraphEdges = Options.VerifyGraalGraphEdges.getValue(options);
    }

    int extractOriginalNodeId(Node node) {
        int id = node.id;
        if (id <= -1000000000) {
            id = -1000000000 - id;
        }
        return id;
    }

    int getNodeModCount(Node node) {
        int id = this.extractOriginalNodeId(node);
        if (id >= 0 && id < this.nodeModCounts.length) {
            return this.nodeModCounts[id];
        }
        return 0;
    }

    void incNodeModCount(Node node) {
        int id = this.extractOriginalNodeId(node);
        if (id >= 0) {
            if (id >= this.nodeModCounts.length) {
                this.nodeModCounts = Arrays.copyOf(this.nodeModCounts, id * 2 + 30);
            }
            int n = id;
            this.nodeModCounts[n] = this.nodeModCounts[n] + 1;
        } else if (Assertions.assertionsEnabled()) {
            throw new AssertionError((Object)("ID must be >= 0 but is " + id + " for node " + String.valueOf(node)));
        }
    }

    int nodeUsageModCount(Node node) {
        int id = this.extractOriginalNodeId(node);
        if (id >= 0 && id < this.nodeUsageModCounts.length) {
            return this.nodeUsageModCounts[id];
        }
        return 0;
    }

    void incNodeUsageModCount(Node node) {
        int id = this.extractOriginalNodeId(node);
        if (id >= 0) {
            if (id >= this.nodeUsageModCounts.length) {
                this.nodeUsageModCounts = Arrays.copyOf(this.nodeUsageModCounts, id * 2 + 30);
            }
            int n = id;
            this.nodeUsageModCounts[n] = this.nodeUsageModCounts[n] + 1;
        } else if (Assertions.assertionsEnabled()) {
            throw new AssertionError((Object)("ID must be >= 0 but is " + id + " for node " + String.valueOf(node)));
        }
    }

    public int getEdgeModificationCount() {
        return this.edgeModificationCount;
    }

    public final Graph copy(DebugContext debugForCopy) {
        return this.copy(this.name, null, debugForCopy);
    }

    public final Graph copy(Consumer<UnmodifiableEconomicMap<Node, Node>> duplicationMapCallback, DebugContext debugForCopy) {
        return this.copy(this.name, duplicationMapCallback, debugForCopy);
    }

    protected Graph copy(String newName, Consumer<UnmodifiableEconomicMap<Node, Node>> duplicationMapCallback, DebugContext debugForCopy) {
        Graph copy = new Graph(newName, this.options, debugForCopy, this.trackNodeSourcePosition());
        EconomicMap<Node, Node> duplicates = copy.addDuplicates(this.getNodes(), this, this.getNodeCount(), (UnmodifiableEconomicMap<Node, Node>)((EconomicMap)null));
        if (duplicationMapCallback != null) {
            duplicationMapCallback.accept((UnmodifiableEconomicMap<Node, Node>)duplicates);
        }
        return copy;
    }

    public final OptionValues getOptions() {
        return this.options;
    }

    public DebugContext getDebug() {
        return this.debug;
    }

    public void resetDebug(DebugContext newDebug) {
        assert (newDebug == this.debug || !this.debug.inNestedScope()) : String.format("Cannot reset the debug context for %s while it has the nested scope \"%s\" open", this, this.debug.getCurrentScopeName());
        this.debug = newDebug;
    }

    public String toString() {
        return this.name == null ? super.toString() : "Graph " + this.name;
    }

    public int getNodeCount() {
        return this.nodesSize - this.getNodesDeletedSinceLastCompression();
    }

    public int getNodesDeletedSinceLastCompression() {
        return this.nodesDeletedSinceLastCompression;
    }

    public int getTotalNodesDeleted() {
        return this.nodesDeletedSinceLastCompression + this.nodesDeletedBeforeLastCompression;
    }

    public <T extends Node> T add(T node) {
        if (node.getNodeClass().valueNumberable()) {
            throw new IllegalStateException("Using add for value numberable node. Consider using either unique or addWithoutUnique.");
        }
        return this.addHelper(node);
    }

    public <T extends Node> T addWithoutUnique(T node) {
        return this.addHelper(node);
    }

    public <T extends Node> T addOrUnique(T node) {
        if (node.isAlive()) {
            GraalError.guarantee(node.graph() == this, "Node is alive in another graph.");
            return node;
        }
        if (node.getNodeClass().valueNumberable()) {
            return this.uniqueHelper(node, null);
        }
        return this.add(node);
    }

    public <T extends Node> T addOrUniqueWithInputs(T node) {
        return this.addOrUniqueWithInputs(node, null);
    }

    public <T extends Node> T addOrUniqueWithInputs(T node, NodePredicate predicate) {
        if (node.isAlive()) {
            GraalError.guarantee(node.graph() == this, "Node is alive in another graph.");
            return node;
        }
        assert (node.isUnregistered());
        this.addInputs(node, predicate);
        if (node.getNodeClass().valueNumberable()) {
            return this.uniqueHelper(node, predicate);
        }
        return this.add(node);
    }

    public <T extends Node> T addWithoutUniqueWithInputs(T node) {
        this.addInputs(node, null);
        return this.addHelper(node);
    }

    private <T extends Node> void addInputs(T node, NodePredicate predicate) {
        if (predicate == null) {
            node.applyInputs(this.addInputsFilter);
        } else {
            node.applyInputs(new AddInputsFilter(predicate));
        }
    }

    private <T extends Node> T addHelper(T node) {
        node.initialize(this);
        return node;
    }

    public void beforeDecodingFields(Node node) {
        if (this.nodeEventListener != null) {
            this.nodeEventListener.event(NodeEvent.BEFORE_DECODING_FIELDS, node);
        }
    }

    public void afterDecodingFields(Node node) {
        if (this.nodeEventListener != null) {
            this.nodeEventListener.event(NodeEvent.AFTER_DECODING_FIELDS, node);
        }
    }

    public NodeEventScope trackNodeEvents(NodeEventListener listener) {
        return new NodeEventScope(listener);
    }

    public <T extends Node> T unique(T node) {
        return this.uniqueHelper(node, null);
    }

    <T extends Node> T uniqueHelper(T node, NodePredicate predicate) {
        assert (node.getNodeClass().valueNumberable());
        T other = this.findDuplicate(node, predicate);
        if (other != null) {
            if (other.getNodeSourcePosition() == null) {
                other.setNodeSourcePosition(node.getNodeSourcePosition());
            }
            return other;
        }
        T result = this.addHelper(node);
        if (node.getNodeClass().isLeafNode()) {
            this.putNodeIntoCache(result);
        }
        return result;
    }

    void removeNodeFromCache(Node node) {
        assert (node.graph() == this || node.graph() == null);
        assert (node.getNodeClass().valueNumberable());
        assert (node.getNodeClass().isLeafNode()) : node.getClass();
        int leafId = node.getNodeClass().getLeafId();
        if (this.cachedLeafNodes != null && this.cachedLeafNodes.length > leafId && this.cachedLeafNodes[leafId] != null) {
            this.cachedLeafNodes[leafId].removeKey((Object)node);
        }
    }

    void putNodeIntoCache(Node node) {
        assert (node.graph() == this || node.graph() == null);
        assert (node.getNodeClass().valueNumberable());
        assert (node.getNodeClass().isLeafNode()) : node.getClass();
        int leafId = node.getNodeClass().getLeafId();
        if (this.cachedLeafNodes == null || this.cachedLeafNodes.length <= leafId) {
            EconomicMap[] newLeafNodes = new EconomicMap[leafId + 1];
            if (this.cachedLeafNodes != null) {
                System.arraycopy(this.cachedLeafNodes, 0, newLeafNodes, 0, this.cachedLeafNodes.length);
            }
            this.cachedLeafNodes = newLeafNodes;
        }
        if (this.cachedLeafNodes[leafId] == null) {
            this.cachedLeafNodes[leafId] = EconomicMap.create((Equivalence)NODE_VALUE_COMPARE);
        }
        this.cachedLeafNodes[leafId].put((Object)node, (Object)node);
    }

    Node findNodeInCache(Node node) {
        int leafId = node.getNodeClass().getLeafId();
        if (this.cachedLeafNodes == null || this.cachedLeafNodes.length <= leafId || this.cachedLeafNodes[leafId] == null) {
            return null;
        }
        Node result = (Node)this.cachedLeafNodes[leafId].get((Object)node);
        if (result != null && !result.isAlive()) {
            return null;
        }
        return result;
    }

    public <T extends Node> T findDuplicate(T node) {
        return this.findDuplicate(node, null);
    }

    public <T extends Node> T findDuplicate(T node, NodePredicate predicate) {
        NodeClass<? extends Node> nodeClass = node.getNodeClass();
        assert (nodeClass.valueNumberable());
        if (nodeClass.isLeafNode()) {
            Node cachedNode = this.findNodeInCache(node);
            if (cachedNode != null && cachedNode != node && (predicate == null || predicate.apply(cachedNode))) {
                return (T)cachedNode;
            }
            return null;
        }
        int earlyExitUsageCount = node.graph() != null ? 1 : 0;
        int minCount = Integer.MAX_VALUE;
        Node minCountNode = null;
        for (Node input : node.inputs()) {
            int usageCount = input.getUsageCount();
            if (usageCount == earlyExitUsageCount) {
                return null;
            }
            if (usageCount >= minCount) continue;
            minCount = usageCount;
            minCountNode = input;
        }
        if (minCountNode != null) {
            for (Node usage : minCountNode.usages()) {
                if (usage == node || nodeClass != usage.getNodeClass() || predicate != null && !predicate.apply(usage) || !node.valueEquals(usage) || !nodeClass.equalInputs(node, usage) || !nodeClass.equalSuccessors(node, usage)) continue;
                return (T)usage;
            }
            return null;
        }
        return null;
    }

    public boolean isNew(Mark mark, Node node) {
        return node.id >= mark.getValue();
    }

    public Mark getMark() {
        return new Mark(this);
    }

    public NodeIterable<Node> getNewNodes(Mark mark) {
        int index = mark == null ? 0 : mark.getValue();
        return () -> new GraphNodeIterator(this, index);
    }

    public NodeIterable<Node> getNodes() {
        CompilationAlarm.checkProgress(this);
        return new NodeIterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return new GraphNodeIterator(Graph.this);
            }

            @Override
            public int count() {
                return Graph.this.getNodeCount();
            }
        };
    }

    protected Object beforeNodeIdChange(Node node) {
        return null;
    }

    protected void afterNodeIdChange(Node node, Object value) {
    }

    public final boolean maybeCompress() {
        return this.compress(false);
    }

    protected boolean compress(boolean minimizeSize) {
        if (!minimizeSize && (this.debug.isDumpEnabledForMethod() || this.debug.isLogEnabledForMethod())) {
            return false;
        }
        int liveNodeCount = this.getNodeCount();
        if (!minimizeSize) {
            int liveNodePercent = liveNodeCount * 100 / this.nodesSize;
            int compressionThreshold = Options.GraphCompressionThreshold.getValue(this.options);
            if (compressionThreshold == 0 || liveNodePercent >= compressionThreshold) {
                return false;
            }
        }
        GraphCompressions.increment(this.debug);
        int nextId = 0;
        int i = 0;
        while (nextId < liveNodeCount) {
            Node n = this.nodes[i];
            if (n != null) {
                assert (n.id == i) : Assertions.errorMessage(n, i);
                if (i != nextId) {
                    assert (n.id > nextId) : n.id + " must be > " + nextId + " for " + String.valueOf(n);
                    Object value = this.beforeNodeIdChange(n);
                    n.id = nextId;
                    this.afterNodeIdChange(n, value);
                    this.nodes[nextId] = n;
                    this.nodes[i] = null;
                }
                ++nextId;
            }
            ++i;
        }
        if (Graph.isNodeModificationCountsEnabled()) {
            Arrays.fill(this.nodeModCounts, 0);
            Arrays.fill(this.nodeUsageModCounts, 0);
        }
        this.nodesSize = nextId;
        ++this.compressions;
        this.nodesDeletedBeforeLastCompression += this.nodesDeletedSinceLastCompression;
        this.nodesDeletedSinceLastCompression = 0;
        if (minimizeSize) {
            this.nodes = Graph.trimArrayToNewSize(this.nodes, nextId);
            this.recomputeIterableNodeLists();
            for (Node node : this.nodes) {
                node.extraUsages = Graph.trimArrayToNewSize(node.extraUsages, node.extraUsagesCount);
                node.getNodeClass().getInputEdges().minimizeSize(node);
                node.getNodeClass().getSuccessorEdges().minimizeSize(node);
            }
        }
        return true;
    }

    static Node[] trimArrayToNewSize(Node[] input, int newSize) {
        assert (input.getClass() == Node[].class);
        if (input.length == newSize) {
            return input;
        }
        for (int i = newSize; i < input.length; ++i) {
            GraalError.guarantee(input[i] == null, "removing non-null element");
        }
        if (newSize == 0) {
            return Node.EMPTY_ARRAY;
        }
        return (Node[])Arrays.copyOf(input, newSize, Node[].class);
    }

    public <T extends Node> NodeIterable<T> getNodes(final NodeClass<T> nodeClass) {
        return new NodeIterable<T>(this){
            final /* synthetic */ Graph this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Iterator<T> iterator() {
                return new TypedGraphNodeIterator(nodeClass, this.this$0);
            }
        };
    }

    public <T extends Node> boolean hasNode(NodeClass<T> type) {
        return this.getNodes(type).iterator().hasNext();
    }

    Node getIterableNodeStart(int iterableId) {
        if (this.iterableNodesFirst.size() <= iterableId) {
            return null;
        }
        Node start = this.iterableNodesFirst.get(iterableId);
        if (start == null || !start.isDeleted()) {
            return start;
        }
        return this.findFirstLiveIterable(iterableId, start);
    }

    private Node findFirstLiveIterable(int iterableId, Node node) {
        Node start = node;
        while (start != null && start.isDeleted()) {
            start = start.typeCacheNext;
        }
        this.iterableNodesFirst.set(iterableId, start);
        if (start == null) {
            this.iterableNodesLast.set(iterableId, start);
        }
        return start;
    }

    Node getIterableNodeNext(Node node) {
        if (node == null) {
            return null;
        }
        Node n = node;
        if (n == null || !n.isDeleted()) {
            return n;
        }
        return this.findNextLiveiterable(node);
    }

    private Node findNextLiveiterable(Node start) {
        Node n = start;
        while (n != null && n.isDeleted()) {
            n = n.typeCacheNext;
        }
        if (n == null) {
            start.typeCacheNext = null;
            int nodeClassId = start.getNodeClass().iterableId();
            assert (nodeClassId != -1) : nodeClassId;
            this.iterableNodesLast.set(nodeClassId, start);
        } else {
            start.typeCacheNext = n;
        }
        return n;
    }

    public NodeBitMap createNodeBitMap() {
        return new NodeBitMap(this);
    }

    public <T> NodeMap<T> createNodeMap() {
        return new NodeMap(this);
    }

    public NodeFlood createNodeFlood() {
        return new NodeFlood(this);
    }

    public NodeWorkList createNodeWorkList() {
        return new NodeWorkList.SingletonNodeWorkList(this);
    }

    public NodeWorkList createIterativeNodeWorkList(boolean fill, int iterationLimitPerNode) {
        return new NodeWorkList.IterativeNodeWorkList(this, fill, iterationLimitPerNode);
    }

    void register(Node node) {
        assert (!this.isFrozen());
        assert (node.id() == -1) : Assertions.errorMessage(node);
        if (this.nodes.length == this.nodesSize) {
            this.grow();
        }
        int id = this.nodesSize++;
        this.nodes[id] = node;
        node.id = id;
        if (this.currentNodeSourcePosition != null && this.trackNodeSourcePosition()) {
            node.setNodeSourcePosition(this.currentNodeSourcePosition);
        }
        if (GraalOptions.TrackNodeInsertion.getValue(this.getOptions()).booleanValue() && node.getInsertionPosition() == null) {
            node.setInsertionPosition(new Node.NodeInsertionStackTrace());
        }
        this.updateNodeCaches(node);
        if (this.nodeEventListener != null) {
            this.nodeEventListener.event(NodeEvent.NODE_ADDED, node);
        }
        this.afterRegister(node);
    }

    private void grow() {
        Node[] newNodes = new Node[this.nodesSize * 2 + 1];
        System.arraycopy(this.nodes, 0, newNodes, 0, this.nodesSize);
        this.nodes = newNodes;
    }

    protected void afterRegister(Node node) {
    }

    private void recomputeIterableNodeLists() {
        this.iterableNodesFirst.clear();
        this.iterableNodesLast.clear();
        for (Node node : this.nodes) {
            if (node == null || !node.isAlive()) continue;
            this.updateNodeCaches(node);
        }
    }

    private void updateNodeCaches(Node node) {
        int nodeClassId = node.getNodeClass().iterableId();
        if (nodeClassId != -1) {
            while (this.iterableNodesFirst.size() <= nodeClassId) {
                this.iterableNodesFirst.add(null);
                this.iterableNodesLast.add(null);
            }
            Node prev = this.iterableNodesLast.get(nodeClassId);
            if (prev != null) {
                prev.typeCacheNext = node;
            } else {
                this.iterableNodesFirst.set(nodeClassId, node);
            }
            this.iterableNodesLast.set(nodeClassId, node);
        }
    }

    void unregister(Node node) {
        assert (!this.isFrozen());
        assert (!node.isDeleted()) : node;
        if (node.getNodeClass().isLeafNode() && node.getNodeClass().valueNumberable()) {
            this.removeNodeFromCache(node);
        }
        this.nodes[node.id] = null;
        ++this.nodesDeletedSinceLastCompression;
        if (this.nodeEventListener != null) {
            this.nodeEventListener.event(NodeEvent.NODE_REMOVED, node);
        }
    }

    public boolean verify() {
        if (this.verifyGraphs) {
            for (Node node : this.getNodes()) {
                try {
                    try {
                        assert (node.verify());
                    }
                    catch (AssertionError t) {
                        throw new GraalError((Throwable)((Object)t));
                    }
                    catch (RuntimeException t) {
                        throw new GraalError(t);
                    }
                }
                catch (GraalError e) {
                    throw GraalGraphError.transformAndAddContext(e, node).addContext(this);
                }
            }
        }
        return true;
    }

    public boolean verifySourcePositions(boolean performConsistencyCheck) {
        if (this.trackNodeSourcePosition()) {
            ResolvedJavaMethod root = null;
            for (Node node : this.getNodes()) {
                NodeSourcePosition pos = node.getNodeSourcePosition();
                if (pos != null) {
                    if (root == null) {
                        root = pos.getRootMethod();
                    } else assert (pos.verifyRootMethod(root));
                }
                if (!performConsistencyCheck) continue;
            }
        }
        return true;
    }

    public Node getNode(int id) {
        return this.nodes[id];
    }

    public int nodeIdCount() {
        return this.nodesSize;
    }

    public EconomicMap<Node, Node> addDuplicates(Iterable<? extends Node> newNodes, Graph oldGraph, int estimatedNodeCount, UnmodifiableEconomicMap<Node, Node> replacementsMap) {
        MapReplacement replacements = replacementsMap == null ? null : new MapReplacement(replacementsMap);
        return this.addDuplicates(newNodes, oldGraph, estimatedNodeCount, replacements);
    }

    public EconomicMap<Node, Node> addDuplicates(Iterable<? extends Node> newNodes, Graph oldGraph, int estimatedNodeCount, DuplicationReplacement replacements) {
        try (DebugCloseable s = DuplicateGraph.start(this.getDebug());){
            EconomicMap<Node, Node> economicMap = NodeClass.addGraphDuplicate(this, oldGraph, estimatedNodeCount, newNodes, replacements);
            return economicMap;
        }
    }

    public boolean isFrozen() {
        return this.freezeState != FreezeState.Unfrozen;
    }

    public void freeze() {
        this.freezeState = FreezeState.DeepFreeze;
    }

    public void temporaryFreeze() {
        if (this.freezeState == FreezeState.DeepFreeze) {
            throw new GraalError("Graph was permanetly frozen.");
        }
        this.freezeState = FreezeState.TemporaryFreeze;
    }

    public void unfreeze() {
        if (this.freezeState == FreezeState.DeepFreeze) {
            throw new GraalError("Graph was permanetly frozen.");
        }
        this.freezeState = FreezeState.Unfrozen;
    }

    private class NodeSourcePositionScope
    implements DebugCloseable {
        private final NodeSourcePosition previous;

        NodeSourcePositionScope(NodeSourcePosition sourcePosition) {
            this.previous = Graph.this.currentNodeSourcePosition;
            Graph.this.currentNodeSourcePosition = sourcePosition;
        }

        @Override
        public DebugContext getDebug() {
            return Graph.this.debug;
        }

        @Override
        public void close() {
            Graph.this.currentNodeSourcePosition = this.previous;
        }
    }

    private static enum FreezeState {
        Unfrozen,
        TemporaryFreeze,
        DeepFreeze;

    }

    private final class AddInputsFilter
    extends Node.EdgeVisitor {
        private final NodePredicate predicate;

        AddInputsFilter(NodePredicate predicate) {
            this.predicate = predicate;
        }

        AddInputsFilter() {
            this(null);
        }

        @Override
        public Node apply(Node self, Node input) {
            if (!input.isAlive()) {
                assert (!input.isDeleted());
                return Graph.this.addOrUniqueWithInputs(input, this.predicate);
            }
            return input;
        }
    }

    public static class Options {
        public static final OptionKey<Boolean> VerifyGraalGraphs = new OptionKey<Boolean>(true);
        public static final OptionKey<Boolean> VerifyGraalGraphEdges = new OptionKey<Boolean>(false);
        public static final OptionKey<Integer> GraphCompressionThreshold = new OptionKey<Integer>(70);
    }

    public static abstract class NodeEventListener {
        final void event(NodeEvent e, Node node) {
            switch (e.ordinal()) {
                case 0: {
                    this.inputChanged(node);
                    break;
                }
                case 1: {
                    GraalError.guarantee(node.isAlive(), "must be alive");
                    this.usagesDroppedToZero(node);
                    if (node.isAlive()) break;
                    throw new GraalError("%s must not kill %s", this, node);
                }
                case 2: {
                    this.nodeAdded(node);
                    break;
                }
                case 3: {
                    this.nodeRemoved(node);
                    break;
                }
                case 4: {
                    this.beforeDecodingFields(node);
                    break;
                }
                case 5: {
                    this.afterDecodingFields(node);
                }
            }
            this.changed(e, node);
        }

        public void changed(NodeEvent e, Node node) {
        }

        public void inputChanged(Node node) {
        }

        public void beforeDecodingFields(Node node) {
        }

        public void afterDecodingFields(Node node) {
        }

        public void usagesDroppedToZero(Node node) {
        }

        public void nodeAdded(Node node) {
        }

        public void nodeRemoved(Node node) {
        }
    }

    public static enum NodeEvent {
        INPUT_CHANGED,
        ZERO_USAGES,
        NODE_ADDED,
        NODE_REMOVED,
        BEFORE_DECODING_FIELDS,
        AFTER_DECODING_FIELDS;

    }

    public final class NodeEventScope
    implements AutoCloseable {
        NodeEventScope(NodeEventListener listener) {
            Graph.this.nodeEventListener = Graph.this.nodeEventListener == null ? listener : new ChainedNodeEventListener(listener, Graph.this.nodeEventListener);
        }

        @Override
        public void close() {
            assert (Graph.this.nodeEventListener != null);
            Graph.this.nodeEventListener = Graph.this.nodeEventListener instanceof ChainedNodeEventListener ? ((ChainedNodeEventListener)Graph.this.nodeEventListener).next : null;
        }
    }

    public static class Mark
    extends NodeIdAccessor {
        private final int value;

        Mark(Graph graph) {
            super(graph);
            this.value = graph.nodeIdCount();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Mark) {
                Mark other = (Mark)obj;
                return other.getValue() == this.getValue() && other.getGraph() == this.getGraph();
            }
            return false;
        }

        public int hashCode() {
            return this.value ^ this.epoch + 11;
        }

        int getValue() {
            return this.value;
        }

        public boolean isCurrent() {
            return this.value == this.graph.nodeIdCount();
        }
    }

    private static final class MapReplacement
    implements DuplicationReplacement {
        private final UnmodifiableEconomicMap<Node, Node> map;

        MapReplacement(UnmodifiableEconomicMap<Node, Node> map) {
            this.map = map;
        }

        @Override
        public Node replacement(Node original) {
            Node replacement = (Node)this.map.get((Object)original);
            return replacement != null ? replacement : original;
        }
    }

    public static interface DuplicationReplacement {
        public Node replacement(Node var1);
    }

    private static class ChainedNodeEventListener
    extends NodeEventListener {
        NodeEventListener head;
        NodeEventListener next;

        ChainedNodeEventListener(NodeEventListener head, NodeEventListener next) {
            this.head = head;
            this.next = next;
        }

        @Override
        public void changed(NodeEvent e, Node node) {
            this.head.event(e, node);
            this.next.event(e, node);
        }
    }
}

