/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.graph;

import jdk.graal.compiler.graph.GraalGraphError;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.Node;

class NodeIdAccessor {
    final Graph graph;
    final int epoch;

    NodeIdAccessor(Graph graph) {
        this.graph = graph;
        this.epoch = graph.compressions;
    }

    Graph getGraph() {
        return this.graph;
    }

    boolean verifyIdsAreStable() {
        int compressions = this.graph.compressions - this.epoch;
        if (compressions != 0) {
            throw new GraalGraphError("accessing node id in %s across %d graph compression%s", this.graph, compressions, compressions == 1 ? "" : "s");
        }
        return true;
    }

    int getNodeId(Node node) {
        assert (this.verifyIdsAreStable());
        if (!node.isAlive()) {
            throw new InternalError(node.toString());
        }
        return node.id();
    }
}

