/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.graphio;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import jdk.graal.compiler.debug.Assertions;

abstract class GraphProtocol<Graph, Node, NodeClass, Edges, Block, ResolvedJavaMethod, ResolvedJavaField, Signature, NodeSourcePosition, Location>
implements Closeable {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final int CONSTANT_POOL_MAX_SIZE = 8000;
    private static final int BEGIN_GROUP = 0;
    private static final int BEGIN_GRAPH = 1;
    private static final int CLOSE_GROUP = 2;
    private static final int BEGIN_DOCUMENT = 3;
    private static final int POOL_NEW = 0;
    private static final int POOL_STRING = 1;
    private static final int POOL_ENUM = 2;
    private static final int POOL_CLASS = 3;
    private static final int POOL_METHOD = 4;
    private static final int POOL_NULL = 5;
    private static final int POOL_NODE_CLASS = 6;
    private static final int POOL_FIELD = 7;
    private static final int POOL_SIGNATURE = 8;
    private static final int POOL_NODE_SOURCE_POSITION = 9;
    private static final int POOL_NODE = 10;
    private static final int PROPERTY_POOL = 0;
    private static final int PROPERTY_INT = 1;
    private static final int PROPERTY_LONG = 2;
    private static final int PROPERTY_DOUBLE = 3;
    private static final int PROPERTY_FLOAT = 4;
    private static final int PROPERTY_TRUE = 5;
    private static final int PROPERTY_FALSE = 6;
    private static final int PROPERTY_ARRAY = 7;
    private static final int PROPERTY_SUBGRAPH = 8;
    private static final int KLASS = 0;
    private static final int ENUM_KLASS = 1;
    private static final byte[] MAGIC_BYTES = new byte[]{66, 73, 71, 86};
    private static final int MAJOR_VERSION = 8;
    private static final int MINOR_VERSION = 0;
    private final ConstantPool constantPool;
    private final ByteBuffer buffer;
    private final WritableByteChannel channel;
    private final boolean embedded;
    final int versionMajor;
    final int versionMinor;
    private boolean printing;
    private static HashSet<Class<?>> badToString;

    GraphProtocol(WritableByteChannel channel, int major, int minor, boolean embedded) throws IOException {
        if (major > 8 || major == 8 && minor > 0) {
            throw new IllegalArgumentException("Unrecognized version " + major + "." + minor);
        }
        this.versionMajor = major;
        this.versionMinor = minor;
        this.constantPool = new ConstantPool();
        this.buffer = ByteBuffer.allocateDirect(262144);
        this.channel = channel;
        this.embedded = embedded;
        if (!embedded) {
            this.writeVersion();
            this.flushEmbedded();
        }
    }

    GraphProtocol(GraphProtocol<?, ?, ?, ?, ?, ?, ?, ?, ?, ?> parent) {
        this.versionMajor = parent.versionMajor;
        this.versionMinor = parent.versionMinor;
        this.constantPool = parent.constantPool;
        this.buffer = parent.buffer;
        this.channel = parent.channel;
        this.embedded = parent.embedded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void print(Graph graph, Map<? extends Object, ? extends Object> properties, int id, String format, Object ... args) throws IOException {
        this.printing = true;
        try {
            this.writeByte(1);
            if (this.versionMajor >= 3) {
                this.writeInt(id);
                this.writeString(format);
                this.writeInt(args.length);
                for (Object a : args) {
                    this.writePropertyObject(graph, a);
                }
            } else {
                this.writePoolObject(this.formatTitle(graph, id, format, args));
            }
            this.writeGraph(graph, properties);
            this.flushEmbedded();
            this.flush();
        }
        finally {
            this.printing = false;
        }
    }

    public final void startDocument(Map<? extends Object, ? extends Object> documentProperties) throws IOException {
        if (this.versionMajor < 7) {
            throw new IllegalStateException("Dump properties unsupported in format v." + this.versionMajor);
        }
        this.printing = true;
        try {
            this.writeByte(3);
            this.writeProperties(null, documentProperties);
        }
        finally {
            this.printing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void beginGroup(Graph noGraph, String name, String shortName, ResolvedJavaMethod method, int bci, Map<? extends Object, ? extends Object> properties) throws IOException {
        this.printing = true;
        try {
            this.writeByte(0);
            this.writePoolObject(name);
            this.writePoolObject(shortName);
            this.writePoolObject(method);
            this.writeInt(bci);
            this.writeProperties(noGraph, properties);
            this.flushEmbedded();
        }
        finally {
            this.printing = false;
        }
    }

    public final void endGroup() throws IOException {
        this.printing = true;
        try {
            this.writeByte(2);
            this.flushEmbedded();
        }
        finally {
            this.printing = false;
        }
    }

    final int write(ByteBuffer src) throws IOException {
        if (this.printing) {
            throw new IllegalStateException("Trying to write during graph print.");
        }
        this.constantPool.reset();
        return this.writeBytesRaw(src);
    }

    final boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public final void close() {
        try {
            this.flush();
            this.channel.close();
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }

    protected abstract Graph findGraph(Graph var1, Object var2);

    protected abstract ResolvedJavaMethod findMethod(Object var1);

    protected abstract Node findNode(Object var1);

    protected abstract NodeClass findNodeClass(Object var1);

    protected abstract NodeClass findClassForNode(Node var1);

    protected abstract Object findJavaClass(NodeClass var1);

    protected abstract Object findEnumClass(Object var1);

    protected abstract String findNameTemplate(NodeClass var1);

    protected abstract Edges findClassEdges(NodeClass var1, boolean var2);

    protected abstract int findNodeId(Node var1);

    protected abstract boolean hasPredecessor(Node var1);

    protected abstract int findNodesCount(Graph var1);

    protected abstract Iterable<? extends Node> findNodes(Graph var1);

    protected abstract void findNodeProperties(Node var1, Map<String, Object> var2, Graph var3);

    protected abstract Collection<? extends Node> findBlockNodes(Graph var1, Block var2);

    protected abstract int findBlockId(Block var1);

    protected abstract Collection<? extends Block> findBlocks(Graph var1);

    protected abstract Collection<? extends Block> findBlockSuccessors(Block var1);

    protected abstract String formatTitle(Graph var1, int var2, String var3, Object ... var4);

    protected abstract int findSize(Edges var1);

    protected abstract boolean isDirect(Edges var1, int var2);

    protected abstract String findName(Edges var1, int var2);

    protected abstract Object findType(Edges var1, int var2);

    protected abstract Collection<? extends Node> findNodes(Graph var1, Node var2, Edges var3, int var4);

    protected abstract int findEnumOrdinal(Object var1);

    protected abstract String[] findEnumTypeValues(Object var1);

    protected abstract String findJavaTypeName(Object var1);

    protected abstract byte[] findMethodCode(ResolvedJavaMethod var1);

    protected abstract int findMethodModifiers(ResolvedJavaMethod var1);

    protected abstract Signature findMethodSignature(ResolvedJavaMethod var1);

    protected abstract String findMethodName(ResolvedJavaMethod var1);

    protected abstract Object findMethodDeclaringClass(ResolvedJavaMethod var1);

    protected abstract int findFieldModifiers(ResolvedJavaField var1);

    protected abstract String findFieldTypeName(ResolvedJavaField var1);

    protected abstract String findFieldName(ResolvedJavaField var1);

    protected abstract Object findFieldDeclaringClass(ResolvedJavaField var1);

    protected abstract ResolvedJavaField findJavaField(Object var1);

    protected abstract Signature findSignature(Object var1);

    protected abstract int findSignatureParameterCount(Signature var1);

    protected abstract String findSignatureParameterTypeName(Signature var1, int var2);

    protected abstract String findSignatureReturnTypeName(Signature var1);

    protected abstract NodeSourcePosition findNodeSourcePosition(Object var1);

    protected abstract ResolvedJavaMethod findNodeSourcePositionMethod(NodeSourcePosition var1);

    protected abstract NodeSourcePosition findNodeSourcePositionCaller(NodeSourcePosition var1);

    protected abstract int findNodeSourcePositionBCI(NodeSourcePosition var1);

    protected abstract Iterable<Location> findLocation(ResolvedJavaMethod var1, int var2, NodeSourcePosition var3);

    protected abstract String findLocationFile(Location var1) throws IOException;

    protected abstract int findLocationLine(Location var1);

    protected abstract URI findLocationURI(Location var1) throws URISyntaxException;

    protected abstract String findLocationLanguage(Location var1);

    protected abstract int findLocationStart(Location var1);

    protected abstract int findLocationEnd(Location var1);

    private void writeVersion() throws IOException {
        this.writeBytesRaw(MAGIC_BYTES);
        this.writeByte(this.versionMajor);
        this.writeByte(this.versionMinor);
    }

    private void flushEmbedded() throws IOException {
        if (this.embedded) {
            this.flush();
            this.constantPool.reset();
        }
    }

    private void flush() throws IOException {
        this.buffer.flip();
        boolean interrupted = Thread.interrupted();
        try {
            this.channel.write(this.buffer);
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        this.buffer.compact();
    }

    private void ensureAvailable(int i) throws IOException {
        assert (this.buffer.capacity() >= i) : "Can not make " + i + " bytes available, buffer is too small";
        while (this.buffer.remaining() < i) {
            this.flush();
        }
    }

    private void writeByte(int b) throws IOException {
        this.ensureAvailable(1);
        this.buffer.put((byte)b);
    }

    private void writeInt(int b) throws IOException {
        this.ensureAvailable(4);
        this.buffer.putInt(b);
    }

    private void writeLong(long b) throws IOException {
        this.ensureAvailable(8);
        this.buffer.putLong(b);
    }

    private void writeDouble(double b) throws IOException {
        this.ensureAvailable(8);
        this.buffer.putDouble(b);
    }

    private void writeFloat(float b) throws IOException {
        this.ensureAvailable(4);
        this.buffer.putFloat(b);
    }

    private void writeShort(char b) throws IOException {
        this.ensureAvailable(2);
        this.buffer.putChar(b);
    }

    private void writeString(String str) throws IOException {
        byte[] bytes = str.getBytes(UTF8);
        this.writeBytes(bytes);
    }

    private void writeBytes(byte[] b) throws IOException {
        if (b == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(b.length);
            this.writeBytesRaw(b);
        }
    }

    private void writeBytesRaw(byte[] b) throws IOException {
        int toWrite;
        for (int bytesWritten = 0; bytesWritten < b.length; bytesWritten += toWrite) {
            toWrite = Math.min(b.length - bytesWritten, this.buffer.capacity());
            this.ensureAvailable(toWrite);
            this.buffer.put(b, bytesWritten, toWrite);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeBytesRaw(ByteBuffer b) throws IOException {
        int limit = b.limit();
        int written = 0;
        while (b.position() < limit) {
            int toWrite = Math.min(limit - b.position(), this.buffer.capacity());
            this.ensureAvailable(toWrite);
            b.limit(b.position() + toWrite);
            try {
                this.buffer.put(b);
                written += toWrite;
            }
            finally {
                b.limit(limit);
            }
        }
        return written;
    }

    private void writeInts(int[] b) throws IOException {
        if (b == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(b.length);
            int sizeInBytes = b.length * 4;
            this.ensureAvailable(sizeInBytes);
            this.buffer.asIntBuffer().put(b);
            this.buffer.position(this.buffer.position() + sizeInBytes);
        }
    }

    private void writeDoubles(double[] b) throws IOException {
        if (b == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(b.length);
            int sizeInBytes = b.length * 8;
            this.ensureAvailable(sizeInBytes);
            this.buffer.asDoubleBuffer().put(b);
            this.buffer.position(this.buffer.position() + sizeInBytes);
        }
    }

    private void writePoolObject(Object obj) throws IOException {
        Object object = obj;
        if (object == null) {
            this.writeByte(5);
            return;
        }
        Object[] found = new Object[1];
        int type = this.findPoolType(object, found);
        Character id = this.constantPool.get(object, type);
        if (id == null) {
            this.addPoolEntry(object, type, found);
        } else {
            this.writeByte(type);
            this.writeShort(id.charValue());
        }
    }

    private int findPoolType(Object obj, Object[] found) throws IOException {
        Object object = obj;
        if (object == null) {
            return 5;
        }
        if (GraphProtocol.isFound(this.findJavaField(object), found)) {
            return 7;
        }
        if (GraphProtocol.isFound(this.findSignature(object), found)) {
            return 8;
        }
        if (this.versionMajor >= 4 && GraphProtocol.isFound(this.findNodeSourcePosition(object), found)) {
            return 9;
        }
        Node node = this.findNode(object);
        if (this.versionMajor == 4 && node != null) {
            object = this.classForNode(node);
        }
        if (GraphProtocol.isFound(this.findNodeClass(object), found)) {
            return 6;
        }
        if (this.versionMajor >= 5 && GraphProtocol.isFound(node, found)) {
            return 10;
        }
        if (GraphProtocol.isFound(this.findMethod(object), found)) {
            return 4;
        }
        if (object instanceof Enum) {
            if (found != null) {
                found[0] = ((Enum)object).ordinal();
            }
            return 2;
        }
        int val = this.findEnumOrdinal(object);
        if (val >= 0) {
            if (found != null) {
                found[0] = val;
            }
            return 2;
        }
        if (object instanceof Class) {
            if (found != null) {
                found[0] = ((Class)object).getName();
            }
            return 3;
        }
        if (GraphProtocol.isFound(this.findJavaTypeName(object), found)) {
            return 3;
        }
        return 1;
    }

    private void writeGraph(Graph graph, Map<? extends Object, ? extends Object> properties) throws IOException {
        this.writeProperties(graph, properties);
        this.writeNodes(graph);
        this.writeBlocks(this.findBlocks(graph), graph);
    }

    private void writeNodes(Graph info) throws IOException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        int size = this.findNodesCount(info);
        this.writeInt(size);
        int cnt = 0;
        for (Node node : this.findNodes(info)) {
            NodeClass nodeClass = this.classForNode(node);
            this.findNodeProperties(node, props, info);
            this.writeInt(this.findNodeId(node));
            this.writePoolObject(nodeClass);
            this.writeByte(this.hasPredecessor(node) ? 1 : 0);
            this.writeProperties(info, props);
            this.writeEdges(info, node, true);
            this.writeEdges(info, node, false);
            props.clear();
            ++cnt;
        }
        if (size != cnt) {
            throw new IOException("Expecting " + size + " nodes, but found " + cnt);
        }
    }

    private void writeEdges(Graph graph, Node node, boolean dumpInputs) throws IOException {
        NodeClass clazz = this.classForNode(node);
        Edges edges = this.findClassEdges(clazz, dumpInputs);
        int size = this.findSize(edges);
        for (int i = 0; i < size; ++i) {
            Collection<Node> list = this.findNodes(graph, node, edges, i);
            if (this.isDirect(edges, i)) {
                if (list != null && list.size() != 1) {
                    throw new IOException("Edge " + i + " in " + String.valueOf(edges) + " is direct, but list isn't singleton: " + String.valueOf(list));
                }
                Node n = null;
                if (list != null && !list.isEmpty()) {
                    n = list.iterator().next();
                }
                this.writeNodeRef(n);
                continue;
            }
            if (list == null) {
                this.writeShort('\u0000');
                continue;
            }
            int listSize = list.size();
            assert (listSize == (char)listSize) : Assertions.errorMessage(listSize);
            this.writeShort((char)listSize);
            for (Node edge : list) {
                this.writeNodeRef(edge);
            }
        }
    }

    private NodeClass classForNode(Node node) throws IOException {
        NodeClass clazz = this.findClassForNode(node);
        if (clazz == null) {
            throw new IOException("No class for " + String.valueOf(node));
        }
        return clazz;
    }

    private void writeNodeRef(Node node) throws IOException {
        this.writeInt(this.findNodeId(node));
    }

    private void writeBlocks(Collection<? extends Block> blocks, Graph info) throws IOException {
        if (blocks != null) {
            Collection<Node> nodes;
            for (Block block : blocks) {
                nodes = this.findBlockNodes(info, block);
                if (nodes != null) continue;
                this.writeInt(0);
                return;
            }
            this.writeInt(blocks.size());
            for (Block block : blocks) {
                nodes = this.findBlockNodes(info, block);
                this.writeInt(this.findBlockId(block));
                this.writeInt(nodes.size());
                for (Node node : nodes) {
                    this.writeInt(this.findNodeId(node));
                }
                Collection<Block> successors = this.findBlockSuccessors(block);
                this.writeInt(successors.size());
                for (Block sux : successors) {
                    this.writeInt(this.findBlockId(sux));
                }
            }
        } else {
            this.writeInt(0);
        }
    }

    private void writeEdgesInfo(NodeClass nodeClass, boolean dumpInputs) throws IOException {
        Edges edges = this.findClassEdges(nodeClass, dumpInputs);
        int size = this.findSize(edges);
        this.writeShort((char)size);
        for (int i = 0; i < size; ++i) {
            this.writeByte(this.isDirect(edges, i) ? 0 : 1);
            this.writePoolObject(this.findName(edges, i));
            if (!dumpInputs) continue;
            this.writePoolObject(this.findType(edges, i));
        }
    }

    private void addPoolEntry(Object obj, int type, Object[] found) throws IOException {
        Object object = obj;
        char index = this.constantPool.add(object, type);
        this.writeByte(0);
        this.writeShort(index);
        this.writeByte(type);
        switch (type) {
            case 7: {
                Object field = found[0];
                Objects.requireNonNull(field);
                this.writePoolObject(this.findFieldDeclaringClass(field));
                this.writePoolObject(this.findFieldName(field));
                this.writePoolObject(this.findFieldTypeName(field));
                this.writeInt(this.findFieldModifiers(field));
                break;
            }
            case 8: {
                Object signature = found[0];
                int args = this.findSignatureParameterCount(signature);
                this.writeShort((char)args);
                for (int i = 0; i < args; ++i) {
                    this.writePoolObject(this.findSignatureParameterTypeName(signature, i));
                }
                this.writePoolObject(this.findSignatureReturnTypeName(signature));
                break;
            }
            case 9: {
                Object pos = found[0];
                Objects.requireNonNull(pos);
                ResolvedJavaMethod method = this.findNodeSourcePositionMethod(pos);
                this.writePoolObject(method);
                int bci = this.findNodeSourcePositionBCI(pos);
                this.writeInt(bci);
                Iterator<Location> ste = this.findLocation(method, bci, pos).iterator();
                if (this.versionMajor >= 6) {
                    while (ste.hasNext()) {
                        String l;
                        URI uri;
                        Location loc = ste.next();
                        try {
                            uri = this.findLocationURI(loc);
                        }
                        catch (URISyntaxException ex) {
                            throw new IOException(ex);
                        }
                        if (uri == null || (l = this.findLocationLanguage(loc)) == null) continue;
                        this.writePoolObject(uri.toString());
                        this.writeString(l);
                        this.writeInt(this.findLocationLine(loc));
                        this.writeInt(this.findLocationStart(loc));
                        this.writeInt(this.findLocationEnd(loc));
                    }
                    this.writePoolObject(null);
                } else {
                    String fileName;
                    Location first = ste.hasNext() ? (Location)ste.next() : null;
                    String string = fileName = first != null ? this.findLocationFile(first) : null;
                    if (fileName != null) {
                        this.writePoolObject(fileName);
                        this.writeInt(this.findLocationLine(first));
                    } else {
                        this.writePoolObject(null);
                    }
                }
                this.writePoolObject(this.findNodeSourcePositionCaller(pos));
                break;
            }
            case 10: {
                Object node = found[0];
                Objects.requireNonNull(node);
                this.writeInt(this.findNodeId(node));
                this.writePoolObject(this.classForNode(node));
                break;
            }
            case 6: {
                Object nodeClass = found[0];
                Object clazz = this.findJavaClass(nodeClass);
                if (this.versionMajor >= 3) {
                    this.writePoolObject(clazz);
                    this.writeString(this.findNameTemplate(nodeClass));
                } else {
                    this.writeString(((Class)clazz).getSimpleName());
                    String nameTemplate = this.findNameTemplate(nodeClass);
                    this.writeString(nameTemplate);
                }
                this.writeEdgesInfo(nodeClass, true);
                this.writeEdgesInfo(nodeClass, false);
                break;
            }
            case 3: {
                String typeName = (String)found[0];
                Objects.requireNonNull(typeName);
                this.writeString(typeName);
                String[] enumValueNames = this.findEnumTypeValues(object);
                if (enumValueNames != null) {
                    this.writeByte(1);
                    this.writeInt(enumValueNames.length);
                    for (String o : enumValueNames) {
                        this.writePoolObject(o);
                    }
                    break;
                }
                this.writeByte(0);
                break;
            }
            case 4: {
                Object method = found[0];
                Objects.requireNonNull(method);
                this.writePoolObject(this.findMethodDeclaringClass(method));
                this.writePoolObject(this.findMethodName(method));
                Signature methodSignature = this.findMethodSignature(method);
                if (this.findSignature(methodSignature) == null) {
                    throw new IOException("Should be recognized as signature: " + String.valueOf(methodSignature) + " for " + String.valueOf(method));
                }
                this.writePoolObject(methodSignature);
                this.writeInt(this.findMethodModifiers(method));
                this.writeBytes(this.findMethodCode(method));
                break;
            }
            case 2: {
                int enumOrdinal = (Integer)found[0];
                this.writePoolObject(this.findEnumClass(object));
                this.writeInt(enumOrdinal);
                break;
            }
            case 1: {
                this.writeString(object.toString());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void writePropertyObject(Graph graph, Object obj) throws IOException {
        if (obj instanceof Integer) {
            this.writeByte(1);
            this.writeInt((Integer)obj);
        } else if (obj instanceof Long) {
            this.writeByte(2);
            this.writeLong((Long)obj);
        } else if (obj instanceof Double) {
            this.writeByte(3);
            this.writeDouble((Double)obj);
        } else if (obj instanceof Float) {
            this.writeByte(4);
            this.writeFloat(((Float)obj).floatValue());
        } else if (obj instanceof Boolean) {
            if (((Boolean)obj).booleanValue()) {
                this.writeByte(5);
            } else {
                this.writeByte(6);
            }
        } else if (obj != null && obj.getClass().isArray()) {
            Class<?> componentType = obj.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                if (componentType == Double.TYPE) {
                    this.writeByte(7);
                    this.writeByte(3);
                    this.writeDoubles((double[])obj);
                } else if (componentType == Integer.TYPE) {
                    this.writeByte(7);
                    this.writeByte(1);
                    this.writeInts((int[])obj);
                } else {
                    this.writeByte(0);
                    this.writePoolObject(obj);
                }
            } else {
                this.writeByte(7);
                this.writeByte(0);
                Object[] array = (Object[])obj;
                this.writeInt(array.length);
                for (Object o : array) {
                    this.writePoolObject(o);
                }
            }
        } else {
            Graph g = this.findGraph(graph, obj);
            if (g == null) {
                this.writeByte(0);
                this.writePoolObject(obj);
            } else {
                this.writeByte(8);
                this.writeGraph(g, null);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeProperties(Graph graph, Map<? extends Object, ? extends Object> props) throws IOException {
        if (props == null) {
            this.writeShort('\u0000');
            return;
        }
        int size = props.size();
        if (size >= 65535) {
            if (this.versionMajor <= 7) throw new IllegalArgumentException("Property count is too big. Properties can contain only 65534 in version < 8.");
            this.writeShort('\uffff');
            this.writeInt(size);
        } else {
            this.writeShort((char)size);
        }
        int cnt = 0;
        for (Map.Entry<? extends Object, ? extends Object> entry : props.entrySet()) {
            String key = entry.getKey().toString();
            this.writePoolObject(key);
            this.writePropertyObject(graph, entry.getValue());
            ++cnt;
        }
        if (size == cnt) return;
        throw new IOException("Expecting " + size + " properties, but found only " + cnt);
    }

    private static boolean isFound(Object obj, Object[] found) {
        if (obj == null) {
            return false;
        }
        if (found != null) {
            found[0] = obj;
        }
        return true;
    }

    private static synchronized void reportBadToString(Object lookupKey, Object value) {
        if (badToString == null) {
            badToString = new HashSet();
        }
        if (badToString.add(lookupKey.getClass())) {
            System.err.println("GraphProtocol: toString mismatch for " + String.valueOf(lookupKey.getClass()) + ": " + String.valueOf(value) + " != " + lookupKey.toString());
        }
    }

    private static boolean checkToString(Object lookupKey, Object value) {
        if (!lookupKey.toString().equals(value)) {
            GraphProtocol.reportBadToString(lookupKey, value);
        }
        return true;
    }

    private static final class ConstantPool {
        private char nextId;
        private final WeakHashMap<Object, Object> map = new WeakHashMap();
        private final Object[] keys = new Object[8000];

        ConstantPool() {
        }

        private static Object getLookupKey(Object key) {
            return key instanceof Collection ? key.toString() : key;
        }

        Character get(Object initialKey, int type) {
            String string;
            Character id;
            Object key = ConstantPool.getLookupKey(initialKey);
            Object value = this.map.get(key);
            if (value instanceof String) {
                id = (Character)this.map.get(value);
                if (id != null && this.keys[id.charValue()].equals(value)) {
                    assert (GraphProtocol.checkToString(key, value));
                    return id;
                }
                value = null;
            }
            if ((id = (Character)value) != null && this.keys[id.charValue()].equals(key)) {
                return id;
            }
            if (type == 1 && !(key instanceof String) && (id = this.get(string = key.toString(), type)) != null) {
                this.map.put(key, string);
                return id;
            }
            return null;
        }

        char add(Object initialKey, int type) {
            char c = this.nextId;
            this.nextId = (char)(c + '\u0001');
            char id = c;
            if (this.nextId == '\u1f40') {
                this.nextId = '\u0000';
            }
            if (this.keys[id] != null) {
                this.map.remove(this.keys[id]);
            }
            Object key = ConstantPool.getLookupKey(initialKey);
            if (type == 1 && !(key instanceof String)) {
                String string = key.toString();
                this.map.put(key, string);
                this.map.put(string, Character.valueOf(id));
                this.keys[id] = string;
            } else {
                this.map.put(key, Character.valueOf(id));
                this.keys[id] = key;
            }
            return id;
        }

        void reset() {
            this.map.clear();
            Arrays.fill(this.keys, null);
            this.nextId = '\u0000';
        }
    }
}

