/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hightiercodegen;

import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.iterators.NodeIterable;
import jdk.graal.compiler.hightiercodegen.CodeGenTool;
import jdk.graal.compiler.hightiercodegen.variables.ResolvedVar;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.DeadEndNode;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.GuardPhiNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.InvokeNode;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.LogicNegationNode;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.ReturnNode;
import jdk.graal.compiler.nodes.ShortCircuitOrNode;
import jdk.graal.compiler.nodes.UnwindNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValueProxyNode;
import jdk.graal.compiler.nodes.calc.AbsNode;
import jdk.graal.compiler.nodes.calc.BinaryArithmeticNode;
import jdk.graal.compiler.nodes.calc.CompareNode;
import jdk.graal.compiler.nodes.calc.ConditionalNode;
import jdk.graal.compiler.nodes.calc.FloatConvertNode;
import jdk.graal.compiler.nodes.calc.IntegerDivRemNode;
import jdk.graal.compiler.nodes.calc.IntegerTestNode;
import jdk.graal.compiler.nodes.calc.IsNullNode;
import jdk.graal.compiler.nodes.calc.NarrowNode;
import jdk.graal.compiler.nodes.calc.NegateNode;
import jdk.graal.compiler.nodes.calc.NotNode;
import jdk.graal.compiler.nodes.calc.ObjectEqualsNode;
import jdk.graal.compiler.nodes.calc.ReinterpretNode;
import jdk.graal.compiler.nodes.calc.RoundNode;
import jdk.graal.compiler.nodes.calc.ShiftNode;
import jdk.graal.compiler.nodes.calc.SignExtendNode;
import jdk.graal.compiler.nodes.calc.SignumNode;
import jdk.graal.compiler.nodes.calc.SqrtNode;
import jdk.graal.compiler.nodes.calc.ZeroExtendNode;
import jdk.graal.compiler.nodes.debug.BlackholeNode;
import jdk.graal.compiler.nodes.extended.BoxNode;
import jdk.graal.compiler.nodes.extended.BytecodeExceptionNode;
import jdk.graal.compiler.nodes.extended.ForeignCall;
import jdk.graal.compiler.nodes.extended.GetClassNode;
import jdk.graal.compiler.nodes.extended.JavaReadNode;
import jdk.graal.compiler.nodes.extended.JavaWriteNode;
import jdk.graal.compiler.nodes.extended.LoadArrayComponentHubNode;
import jdk.graal.compiler.nodes.extended.LoadHubNode;
import jdk.graal.compiler.nodes.extended.ObjectIsArrayNode;
import jdk.graal.compiler.nodes.extended.RawLoadNode;
import jdk.graal.compiler.nodes.extended.RawStoreNode;
import jdk.graal.compiler.nodes.extended.StateSplitProxyNode;
import jdk.graal.compiler.nodes.extended.UnboxNode;
import jdk.graal.compiler.nodes.extended.UnsafeMemoryLoadNode;
import jdk.graal.compiler.nodes.extended.UnsafeMemoryStoreNode;
import jdk.graal.compiler.nodes.java.AbstractUnsafeCompareAndSwapNode;
import jdk.graal.compiler.nodes.java.ArrayLengthNode;
import jdk.graal.compiler.nodes.java.AtomicReadAndAddNode;
import jdk.graal.compiler.nodes.java.AtomicReadAndWriteNode;
import jdk.graal.compiler.nodes.java.ClassIsAssignableFromNode;
import jdk.graal.compiler.nodes.java.DynamicNewArrayNode;
import jdk.graal.compiler.nodes.java.DynamicNewInstanceNode;
import jdk.graal.compiler.nodes.java.ExceptionObjectNode;
import jdk.graal.compiler.nodes.java.InstanceOfDynamicNode;
import jdk.graal.compiler.nodes.java.InstanceOfNode;
import jdk.graal.compiler.nodes.java.LoadFieldNode;
import jdk.graal.compiler.nodes.java.LoadIndexedNode;
import jdk.graal.compiler.nodes.java.NewArrayNode;
import jdk.graal.compiler.nodes.java.NewInstanceNode;
import jdk.graal.compiler.nodes.java.NewMultiArrayNode;
import jdk.graal.compiler.nodes.java.ReachabilityFenceNode;
import jdk.graal.compiler.nodes.java.StoreFieldNode;
import jdk.graal.compiler.nodes.java.StoreIndexedNode;
import jdk.graal.compiler.nodes.memory.ReadNode;
import jdk.graal.compiler.nodes.virtual.AllocatedObjectNode;
import jdk.graal.compiler.nodes.virtual.CommitAllocationNode;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.graal.compiler.replacements.nodes.ArrayEqualsNode;
import jdk.graal.compiler.replacements.nodes.BasicArrayCopyNode;
import jdk.graal.compiler.replacements.nodes.BinaryMathIntrinsicNode;
import jdk.graal.compiler.replacements.nodes.IdentityHashCodeNode;
import jdk.graal.compiler.replacements.nodes.ObjectClone;
import jdk.graal.compiler.replacements.nodes.UnaryMathIntrinsicNode;
import jdk.graal.compiler.word.WordCastNode;

public abstract class NodeLowerer {
    protected final CodeGenTool codeGenTool;

    public NodeLowerer(CodeGenTool codeGenTool) {
        this.codeGenTool = codeGenTool;
    }

    public void lowerStatement(Node node) {
        if (this.codeGenTool.declared(node)) {
            ResolvedVar resolvedVar = this.codeGenTool.getAllocatedVariable((ValueNode)node);
            this.lowerVarDeclPrefix(resolvedVar);
        }
        this.dispatch(node);
        this.codeGenTool.genResolvedVarDeclPostfix(this.nodeDebugInfo(node));
    }

    protected abstract void lowerVarDeclPrefix(ResolvedVar var1);

    public final void lowerValue(ValueNode node) {
        assert (this.isActiveValueNode(node)) : "Attempted to lower " + String.valueOf(node) + " which is not an active value node";
        ResolvedVar resolvedVar = this.codeGenTool.getAllocatedVariable(node);
        if (resolvedVar != null) {
            assert (resolvedVar.isDefinitionLowered()) : "Variable definition for node " + String.valueOf(node) + " was not lowered before use";
            this.lower(resolvedVar);
        } else {
            this.dispatch(node);
        }
    }

    protected void lower(ResolvedVar resolvedVar) {
        this.codeGenTool.genResolvedVarAccess(resolvedVar.getName());
    }

    protected void dispatch(Node node) {
        if (node instanceof CommitAllocationNode) {
            this.lower((CommitAllocationNode)node);
        } else if (node instanceof VirtualObjectNode) {
            this.lower((VirtualObjectNode)node);
        } else if (node instanceof AllocatedObjectNode) {
            this.lower((AllocatedObjectNode)node);
        } else if (node instanceof NegateNode) {
            this.lower((NegateNode)node);
        } else if (node instanceof UnwindNode) {
            this.lower((UnwindNode)node);
        } else if (node instanceof GuardPhiNode) {
            this.lowerValue(((GuardPhiNode)node).merge());
        } else if (node instanceof InvokeNode) {
            this.lower((InvokeNode)node);
        } else if (node instanceof InvokeWithExceptionNode) {
            this.lower((InvokeWithExceptionNode)node);
        } else if (node instanceof IsNullNode) {
            this.lower((IsNullNode)node);
        } else if (node instanceof ExceptionObjectNode) {
            this.lower((ExceptionObjectNode)node);
        } else if (node instanceof ValueProxyNode) {
            this.lowerValue(((ValueProxyNode)node).value());
        } else if (node instanceof ConstantNode) {
            this.lower((ConstantNode)node);
        } else if (node instanceof LoadIndexedNode) {
            this.lower((LoadIndexedNode)node);
        } else if (node instanceof NewArrayNode) {
            this.lower((NewArrayNode)node);
        } else if (node instanceof StoreIndexedNode) {
            this.lower((StoreIndexedNode)node);
        } else if (node instanceof ParameterNode) {
            this.lower((ParameterNode)node);
        } else if (node instanceof ConditionalNode) {
            this.lower((ConditionalNode)node);
        } else if (node instanceof BoxNode) {
            this.lower((BoxNode)node);
        } else if (node instanceof FloatConvertNode) {
            this.lower((FloatConvertNode)node);
        } else if (node instanceof ArrayLengthNode) {
            this.lower((ArrayLengthNode)node);
        } else if (node instanceof BasicArrayCopyNode) {
            this.lower((BasicArrayCopyNode)node);
        } else if (node instanceof IntegerTestNode) {
            this.lower((IntegerTestNode)node);
        } else if (node instanceof ReturnNode) {
            this.lower((ReturnNode)node);
        } else if (node instanceof ObjectEqualsNode) {
            this.lower((ObjectEqualsNode)node);
        } else if (node instanceof CompareNode) {
            this.lower((CompareNode)node);
        } else if (node instanceof DeadEndNode) {
            this.lower((DeadEndNode)node);
        } else if (node instanceof ShiftNode) {
            this.lower((ShiftNode)node);
        } else if (node instanceof SignExtendNode) {
            this.lower((SignExtendNode)node);
        } else if (node instanceof ZeroExtendNode) {
            this.lower((ZeroExtendNode)node);
        } else if (node instanceof NarrowNode) {
            this.lower((NarrowNode)node);
        } else if (node instanceof NotNode) {
            this.lower((NotNode)node);
        } else if (node instanceof SignumNode) {
            this.lower((SignumNode)node);
        } else if (node instanceof NewInstanceNode) {
            this.lower((NewInstanceNode)node);
        } else if (node instanceof LoadFieldNode) {
            this.lower((LoadFieldNode)node);
        } else if (node instanceof UnboxNode) {
            this.lower((UnboxNode)node);
        } else if (node instanceof ReinterpretNode) {
            this.lower((ReinterpretNode)node);
        } else if (node instanceof StoreFieldNode) {
            this.lower((StoreFieldNode)node);
        } else if (node instanceof ShortCircuitOrNode) {
            this.lower((ShortCircuitOrNode)node);
        } else if (node instanceof LogicNegationNode) {
            this.lower((LogicNegationNode)node);
        } else if (node instanceof WordCastNode) {
            this.lower((WordCastNode)node);
        } else if (node instanceof InstanceOfNode) {
            this.lower((InstanceOfNode)node);
        } else if (node instanceof InstanceOfDynamicNode) {
            this.lower((InstanceOfDynamicNode)node);
        } else if (node instanceof ArrayEqualsNode) {
            this.lower((ArrayEqualsNode)node);
        } else if (node instanceof NewMultiArrayNode) {
            this.lower((NewMultiArrayNode)node);
        } else if (node instanceof ObjectClone) {
            this.lower((ObjectClone)((Object)node));
        } else if (node instanceof LoadHubNode) {
            this.lower((LoadHubNode)node);
        } else if (node instanceof LoadArrayComponentHubNode) {
            this.lower((LoadArrayComponentHubNode)node);
        } else if (node instanceof EndNode) {
            this.lower((EndNode)node);
        } else if (node instanceof StateSplitProxyNode) {
            this.lower((StateSplitProxyNode)node);
        } else if (node instanceof JavaReadNode) {
            this.lower((JavaReadNode)node);
        } else if (node instanceof JavaWriteNode) {
            this.lower((JavaWriteNode)node);
        } else if (node instanceof ReadNode) {
            this.lower((ReadNode)node);
        } else if (node instanceof RawLoadNode) {
            this.lower((RawLoadNode)node);
        } else if (node instanceof RawStoreNode) {
            this.lower((RawStoreNode)node);
        } else if (node instanceof AbstractUnsafeCompareAndSwapNode) {
            this.lower((AbstractUnsafeCompareAndSwapNode)node);
        } else if (node instanceof AtomicReadAndWriteNode) {
            this.lower((AtomicReadAndWriteNode)node);
        } else if (node instanceof AtomicReadAndAddNode) {
            this.lower((AtomicReadAndAddNode)node);
        } else if (node instanceof DynamicNewArrayNode) {
            this.lower((DynamicNewArrayNode)node);
        } else if (node instanceof ObjectIsArrayNode) {
            this.lower((ObjectIsArrayNode)node);
        } else if (node instanceof ForeignCall) {
            this.lower((ForeignCall)((Object)node));
        } else if (node instanceof IntegerDivRemNode) {
            this.lower((IntegerDivRemNode)node);
        } else if (node instanceof BinaryArithmeticNode) {
            this.lower((BinaryArithmeticNode)node);
        } else if (node instanceof GetClassNode) {
            this.lower((GetClassNode)node);
        } else if (node instanceof PiNode) {
            this.lowerValue(((PiNode)node).getOriginalNode());
        } else if (node instanceof UnaryMathIntrinsicNode) {
            this.lower((UnaryMathIntrinsicNode)node);
        } else if (node instanceof BinaryMathIntrinsicNode) {
            this.lower((BinaryMathIntrinsicNode)node);
        } else if (node instanceof AbsNode) {
            this.lower((AbsNode)node);
        } else if (node instanceof SqrtNode) {
            this.lower((SqrtNode)node);
        } else if (node instanceof RoundNode) {
            this.lower((RoundNode)node);
        } else if (node instanceof BytecodeExceptionNode) {
            this.lower((BytecodeExceptionNode)node);
        } else if (node instanceof UnsafeMemoryStoreNode) {
            this.lower((UnsafeMemoryStoreNode)node);
        } else if (node instanceof UnsafeMemoryLoadNode) {
            this.lower((UnsafeMemoryLoadNode)node);
        } else if (node instanceof BlackholeNode) {
            this.lower((BlackholeNode)node);
        } else if (node instanceof ReachabilityFenceNode) {
            this.lower((ReachabilityFenceNode)node);
        } else if (node instanceof IdentityHashCodeNode) {
            this.lower((IdentityHashCodeNode)node);
        } else if (node instanceof ClassIsAssignableFromNode) {
            this.lower((ClassIsAssignableFromNode)node);
        } else if (node instanceof DynamicNewInstanceNode) {
            DynamicNewInstanceNode n = (DynamicNewInstanceNode)node;
            this.lower(n);
        } else if (!this.isIgnored(node)) {
            this.handleUnknownNodeType(node);
        }
    }

    public abstract boolean isIgnored(Node var1);

    protected abstract boolean isForbiddenNode(Node var1);

    protected abstract String reportForbiddenNode(Node var1);

    protected void handleUnknownNodeType(Node node) {
        throw GraalError.unimplemented("Could not lower node: " + String.valueOf(node));
    }

    protected abstract void lower(BlackholeNode var1);

    protected abstract void lower(ReachabilityFenceNode var1);

    protected abstract void lower(UnsafeMemoryLoadNode var1);

    protected abstract void lower(UnsafeMemoryStoreNode var1);

    protected abstract void lower(BytecodeExceptionNode var1);

    protected abstract void lower(RoundNode var1);

    protected abstract void lower(SqrtNode var1);

    protected abstract void lower(AbsNode var1);

    protected abstract void lower(UnaryMathIntrinsicNode var1);

    protected abstract void lower(BinaryMathIntrinsicNode var1);

    protected abstract void lower(GetClassNode var1);

    protected abstract void lower(BinaryArithmeticNode<?> var1);

    protected abstract void lower(IntegerDivRemNode var1);

    protected abstract void lower(ForeignCall var1);

    protected abstract void lower(ObjectIsArrayNode var1);

    protected abstract void lower(DynamicNewArrayNode var1);

    protected abstract void lower(AtomicReadAndWriteNode var1);

    protected abstract void lower(AtomicReadAndAddNode var1);

    protected abstract void lower(AbstractUnsafeCompareAndSwapNode var1);

    protected abstract void lower(RawStoreNode var1);

    protected abstract void lower(RawLoadNode var1);

    protected abstract void lower(ReadNode var1);

    protected abstract void lower(JavaWriteNode var1);

    protected abstract void lower(JavaReadNode var1);

    protected abstract void lower(StateSplitProxyNode var1);

    protected abstract void lower(EndNode var1);

    protected abstract void lower(LoadArrayComponentHubNode var1);

    protected abstract void lower(LoadHubNode var1);

    protected abstract void lower(ObjectClone var1);

    protected abstract void lower(NewMultiArrayNode var1);

    protected abstract void lower(ArrayEqualsNode var1);

    protected abstract void lower(InstanceOfDynamicNode var1);

    protected abstract void lower(InstanceOfNode var1);

    protected abstract void lower(WordCastNode var1);

    protected abstract void lower(ShortCircuitOrNode var1);

    protected abstract void lower(LogicNegationNode var1);

    protected abstract void lower(StoreFieldNode var1);

    protected abstract void lower(ReinterpretNode var1);

    protected abstract void lower(UnboxNode var1);

    protected abstract void lower(SignumNode var1);

    protected abstract void lower(LoadFieldNode var1);

    protected abstract void lower(NewInstanceNode var1);

    protected abstract void lower(DynamicNewInstanceNode var1);

    protected abstract void lower(NotNode var1);

    protected abstract void lower(NarrowNode var1);

    protected abstract void lower(ZeroExtendNode var1);

    protected abstract void lower(SignExtendNode var1);

    protected abstract void lower(ShiftNode<?> var1);

    protected abstract void lower(DeadEndNode var1);

    protected abstract void lower(CompareNode var1);

    protected abstract void lower(ObjectEqualsNode var1);

    protected abstract void lower(ReturnNode var1);

    protected abstract void lower(IntegerTestNode var1);

    protected abstract void lower(BasicArrayCopyNode var1);

    protected abstract void lower(ArrayLengthNode var1);

    protected abstract void lower(FloatConvertNode var1);

    protected abstract void lower(BoxNode var1);

    protected abstract void lower(ConditionalNode var1);

    protected abstract void lower(ParameterNode var1);

    protected abstract void lower(StoreIndexedNode var1);

    protected abstract void lower(NewArrayNode var1);

    protected abstract void lower(LoadIndexedNode var1);

    protected abstract void lower(ConstantNode var1);

    protected abstract void lower(ExceptionObjectNode var1);

    protected abstract void lower(IsNullNode var1);

    protected abstract void lower(Invoke var1);

    protected abstract void lower(UnwindNode var1);

    protected abstract void lower(NegateNode var1);

    protected abstract void lower(VirtualObjectNode var1);

    protected abstract void lower(CommitAllocationNode var1);

    protected abstract void lower(AllocatedObjectNode var1);

    protected abstract void lower(IdentityHashCodeNode var1);

    protected abstract void lower(ClassIsAssignableFromNode var1);

    public void lower(PhiNode node) {
        this.codeGenTool.genEmptyDeclaration(node);
    }

    public abstract NodeIterable<Node> actualUsages(ValueNode var1);

    public int actualUsageCount(Node node) {
        if (node instanceof ValueNode) {
            return this.actualUsages((ValueNode)node).count();
        }
        return 0;
    }

    public abstract boolean isActiveValueNode(ValueNode var1);

    public abstract boolean isTopLevelStatement(Node var1);

    public abstract String nodeDebugInfo(Node var1);
}

