/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hightiercodegen.irwalk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import jdk.graal.compiler.core.common.cfg.BlockMap;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeMap;
import jdk.graal.compiler.hightiercodegen.CodeGenTool;
import jdk.graal.compiler.hightiercodegen.irwalk.IRWalker;
import jdk.graal.compiler.hightiercodegen.reconstruction.ReconstructionData;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.LoopEndNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.extended.IntegerSwitchNode;
import jdk.graal.compiler.nodes.java.ExceptionObjectNode;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.PrimitiveConstant;

public class BasicBlockInterpreter
extends IRWalker {
    protected static final String switchControl = "control";
    private static final String excpname = "excp";
    private final HashMap<HIRBlock, Integer> blockLookup = new HashMap();
    private static final boolean inlineSuccessorBlock = true;

    public BasicBlockInterpreter(CodeGenTool codeGenTool, ControlFlowGraph cfg, BlockMap<List<Node>> blockToNodeMap, NodeMap<HIRBlock> nodeToBlockMap, ReconstructionData reconstructionData) {
        super(codeGenTool, cfg, blockToNodeMap, nodeToBlockMap, reconstructionData);
        for (HIRBlock b : cfg.getBlocks()) {
            this.blockLookup.put(b, b.getId());
        }
    }

    public final void genInvokeWithException(InvokeWithExceptionNode n) {
        this.codeGenTool.genTryBlock();
        this.lowerNode(n);
        int dispatchtarget = this.blockLookup.get(this.cfg.blockFor(n.next()));
        this.genDispatch(dispatchtarget);
        this.codeGenTool.genCatchBlockPrefix(excpname);
        ExceptionObjectNode eon = (ExceptionObjectNode)n.exceptionEdge();
        assert (eon != null) : "Exception object might never be null";
        String excpobjname = this.codeGenTool.getExceptionObjectId(eon);
        this.codeGenTool.genResolvedVarDeclPrefix(excpobjname);
        this.codeGenTool.getCodeBuffer().emitText(excpname);
        this.codeGenTool.genResolvedVarDeclPostfix(null);
        dispatchtarget = this.blockLookup.get(this.cfg.blockFor(n.exceptionEdge()));
        this.genDispatch(dispatchtarget);
        this.codeGenTool.genScopeEnd();
    }

    public final void genSwitch(IntegerSwitchNode switchNode) {
        ValueNode switchValue = switchNode.value();
        this.lowerForVerification(switchNode);
        this.codeGenTool.getCodeBuffer().emitSwitchHeaderLeft();
        this.codeGenTool.nodeLowerer().lowerValue(switchValue);
        this.codeGenTool.getCodeBuffer().emitSwitchHeaderRight();
        for (int i = 0; i < switchNode.keyCount(); ++i) {
            AbstractBeginNode succ = switchNode.keySuccessor(i);
            JavaConstant keyConstant = switchNode.keyAt(i);
            this.genSwitchCase(((PrimitiveConstant)keyConstant).asInt());
            this.genDispatch(this.blockLookup.get(this.cfg.blockFor(succ)));
            this.codeGenTool.genScopeEnd();
        }
        if (switchNode.defaultSuccessor() != null) {
            this.codeGenTool.genSwitchDefaultCase();
            this.genDispatch(this.blockLookup.get(this.cfg.blockFor(switchNode.defaultSuccessor())));
            this.codeGenTool.genScopeEnd();
        }
        this.codeGenTool.genScopeEnd();
    }

    public final void genIf(IfNode n) {
        assert (this.cfg.blockFor(n.trueSuccessor()) != null);
        assert (null != this.cfg.blockFor(n.falseSuccessor()));
        int trueBranchDispatch = this.blockLookup.get(this.cfg.blockFor(n.trueSuccessor()));
        int falseBranchDispatch = this.blockLookup.get(this.cfg.blockFor(n.falseSuccessor()));
        this.lowerForVerification(n);
        this.codeGenTool.genIfHeader(n.condition());
        this.genDispatch(trueBranchDispatch);
        this.codeGenTool.genElseHeader();
        this.genDispatch(falseBranchDispatch);
        this.codeGenTool.genScopeEnd();
    }

    protected void lowerFunction() {
        ArrayList<HIRBlock> blocks = new ArrayList<HIRBlock>();
        Collections.addAll(blocks, this.cfg.getBlocks());
        this.genHeader(this.blockLookup.get(this.cfg.getStartBlock()));
        this.codeGenTool.genWhileTrueHeader();
        this.codeGenTool.genSwitchHeader(switchControl);
        while (!blocks.isEmpty()) {
            HIRBlock currentBlock = (HIRBlock)blocks.get(0);
            if (this.blockHistory.blockVisited(currentBlock)) {
                blocks.remove(currentBlock);
                continue;
            }
            this.genSwitchCase(this.blockLookup.get(currentBlock));
            currentBlock = this.lowerBlock(currentBlock, blocks);
            int gotoTarget = -1;
            if (currentBlock.getSuccessorCount() > 0) {
                Integer ic = this.blockLookup.get(currentBlock.getFirstSuccessor());
                assert (ic != null);
                gotoTarget = ic;
            }
            this.genDispatch(gotoTarget);
            this.codeGenTool.genScopeEnd();
            this.blockHistory.visitBlock(currentBlock);
            blocks.remove(currentBlock);
        }
        this.codeGenTool.genSwitchDefaultCase();
        this.codeGenTool.genShouldNotReachHere("Default case of the basic block interpreter must not be reachable");
        this.codeGenTool.getCodeBuffer().emitInsEnd();
        this.codeGenTool.genLoopContinue();
        this.codeGenTool.genScopeEnd();
        this.codeGenTool.genScopeEnd();
        this.codeGenTool.genScopeEnd();
    }

    protected HIRBlock lowerBlock(HIRBlock b, List<HIRBlock> blocks) {
        boolean inlinedBlock;
        HIRBlock currentBlock = b;
        do {
            inlinedBlock = false;
            for (Node n : (List)this.blockToNodeMap.get(currentBlock)) {
                if (n instanceof IfNode) {
                    this.genIf((IfNode)n);
                    return currentBlock;
                }
                if (n instanceof IntegerSwitchNode) {
                    this.genSwitch((IntegerSwitchNode)n);
                    return currentBlock;
                }
                if (n instanceof InvokeWithExceptionNode) {
                    this.genInvokeWithException((InvokeWithExceptionNode)n);
                    return currentBlock;
                }
                this.lowerNode(n);
            }
            if (!BasicBlockInterpreter.inlineNextBlock(currentBlock)) continue;
            inlinedBlock = true;
            HIRBlock next = currentBlock.getFirstSuccessor();
            blocks.remove(currentBlock);
            this.blockHistory.visitBlock(currentBlock);
            currentBlock = next;
            this.codeGenTool.genComment("Inlined the basic block " + String.valueOf(currentBlock));
        } while (inlinedBlock);
        return currentBlock;
    }

    private static boolean inlineNextBlock(HIRBlock currentBlock) {
        return currentBlock.getSuccessorCount() > 0 && currentBlock.getFirstSuccessor().getPredecessorCount() == 1;
    }

    @Override
    protected boolean lowerNode(Node n) {
        this.verifier.visitNode(n, this.codeGenTool);
        if (n instanceof LoopBeginNode) {
            this.codeGenTool.genComment("Omitted the LoopBeginNode " + String.valueOf(n));
            return false;
        }
        if (n instanceof LoopExitNode) {
            this.codeGenTool.genComment("Omitted the LoopExitNode " + String.valueOf(n));
            return false;
        }
        if (n instanceof LoopEndNode) {
            this.codeGenTool.genComment("Loop End");
            this.lowerLoopEndResolver((LoopEndNode)n);
            return true;
        }
        return super.lowerNode(n);
    }

    public void lowerForVerification(Node n) {
        this.verifier.visitNode(n, this.codeGenTool);
    }

    @Override
    protected void lower(DebugContext debugContext) {
        if (this.cfg.getBlocks().length > 1) {
            this.lowerFunction();
        } else {
            this.lowerBlock(this.cfg.getStartBlock(), Arrays.asList(this.cfg.getBlocks()));
        }
    }

    private void genDispatch(int target) {
        this.codeGenTool.genResolvedVarAccess(switchControl);
        this.codeGenTool.genAssignment();
        this.codeGenTool.getCodeBuffer().emitIntLiteral(target);
        this.codeGenTool.genResolvedVarDeclPostfix(null);
        this.codeGenTool.genLoopContinue();
    }

    private void genSwitchCase(int caseVal) {
        this.codeGenTool.genSwitchCase(caseVal);
    }

    private void genHeader(int startCase) {
        this.codeGenTool.genResolvedVarDeclPrefix(switchControl);
        this.codeGenTool.getCodeBuffer().emitIntLiteral(startCase);
        this.codeGenTool.genResolvedVarDeclPostfix(null);
    }
}

