/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hightiercodegen.irwalk;

import java.util.List;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.hightiercodegen.CodeGenTool;
import jdk.graal.compiler.hightiercodegen.reconstruction.ReconstructionData;
import jdk.graal.compiler.nodes.MergeNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.vm.ci.common.JVMCIError;

public class IRWalkVerifier {
    public static final boolean BreakOnMultipleV = true;
    public static final boolean BreakOnNoV = true;
    public static final boolean CheckDuringVisit = true;
    private final List<Node> instructions;
    private final int[] visits;

    public IRWalkVerifier(List<Node> instructions) {
        this.instructions = instructions;
        this.visits = new int[instructions.size()];
    }

    public void visitNode(Node n, CodeGenTool codeGenTool) {
        int index = this.instructions.indexOf(n);
        assert (NumUtil.assertNonNegativeInt(index));
        int n2 = index;
        this.visits[n2] = this.visits[n2] + 1;
        if (this.visits[index] > 1) {
            if (n instanceof MergeNode || codeGenTool.nodeLowerer().isIgnored(n)) {
                return;
            }
            n.getDebug().dump(5, n.graph(), "Graph visited multiple times");
            JVMCIError.shouldNotReachHere((String)("Node " + String.valueOf(n) + " visited a second time [visit index:" + index + "]"));
        }
    }

    public void verify(StructuredGraph g, CodeGenTool codeGenTool, ReconstructionData reconstructionData) {
        for (int i = 0; i < this.visits.length; ++i) {
            if (codeGenTool.nodeLowerer().isIgnored(this.instructions.get(i))) continue;
            if (this.visits[i] == 0) {
                g.getDebug().dump(5, g, "Graph not visited");
                reconstructionData.debugDump(g.getDebug());
                System.out.println(codeGenTool.getCodeBuffer());
                throw GraalError.shouldNotReachHere("Node " + String.valueOf(this.instructions.get(i)) + " visited 0 times");
            }
            if (this.visits[i] <= 1) continue;
            g.getDebug().dump(5, g, "Graph not visited");
            reconstructionData.debugDump(g.getDebug());
            throw GraalError.shouldNotReachHere("Node " + String.valueOf(this.instructions.get(i)) + " visited " + this.visits[i] + " times");
        }
    }
}

