/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hightiercodegen.lowerer;

import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.hightiercodegen.CodeGenTool;
import jdk.graal.compiler.hightiercodegen.Emitter;
import jdk.graal.compiler.hightiercodegen.IEmitter;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.virtual.CommitAllocationNode;
import jdk.graal.compiler.nodes.virtual.VirtualArrayNode;
import jdk.graal.compiler.nodes.virtual.VirtualInstanceNode;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaField;

public class CommitAllocationLowerer {
    protected void lowerInstance(VirtualInstanceNode node, CodeGenTool codeGenTool) {
        assert (codeGenTool.declared(node)) : "variable for VirtualInstanceNode must be declared";
        codeGenTool.lowerValue(node);
        codeGenTool.genAssignment();
        codeGenTool.genNewInstance(node.type());
        codeGenTool.getCodeBuffer().emitInsEnd();
    }

    protected void lowerArray(VirtualArrayNode node, CodeGenTool codeGenTool) {
        assert (codeGenTool.declared(node)) : "variable for VirtualArrayNode must be declared";
        codeGenTool.lowerValue(node);
        codeGenTool.genAssignment();
        codeGenTool.genNewArray(node.type(), Emitter.of(node.entryCount()));
        codeGenTool.getCodeBuffer().emitInsEnd();
    }

    public static List<Materialization> computeMaterializations(CommitAllocationNode commit) {
        ArrayList<Materialization> mats = new ArrayList<Materialization>();
        int valindex = 0;
        for (int objIndex = 0; objIndex < commit.getVirtualObjects().size(); ++objIndex) {
            ArrayList<ValueNode> values = new ArrayList<ValueNode>();
            VirtualObjectNode virtual = commit.getVirtualObjects().get(objIndex);
            int entryCount = virtual.entryCount();
            boolean containsVirtual = false;
            for (int i = 0; i < entryCount; ++i) {
                ValueNode value = commit.getValues().get(valindex++);
                if (value instanceof VirtualObjectNode) {
                    containsVirtual = true;
                }
                values.add(value);
            }
            mats.add(new Materialization(virtual, values, containsVirtual));
        }
        return mats;
    }

    protected void lowerFieldAssignment(VirtualInstanceNode instanceNode, ResolvedJavaField field, ValueNode value, CodeGenTool codeGenTool) {
        codeGenTool.genPropertyAccess(Emitter.of(instanceNode), Emitter.of(field));
        codeGenTool.genAssignment();
        codeGenTool.lowerValue(value);
    }

    protected void lowerArrayElementAssignment(VirtualArrayNode array, int index, ValueNode value, CodeGenTool codeGenTool) {
        codeGenTool.genArrayStore((IEmitter)Emitter.of(index), array, value);
    }

    public void lower(CommitAllocationNode commit, CodeGenTool codeGenTool) {
        VirtualObjectNode virtual;
        List<Materialization> mats = CommitAllocationLowerer.computeMaterializations(commit);
        for (Materialization materialization : mats) {
            virtual = materialization.object;
            if (virtual instanceof VirtualInstanceNode) {
                this.lowerInstance((VirtualInstanceNode)virtual, codeGenTool);
                continue;
            }
            this.lowerArray((VirtualArrayNode)virtual, codeGenTool);
        }
        for (Materialization mat : mats) {
            virtual = mat.object;
            for (int propertyNum = 0; propertyNum < mat.values.size(); ++propertyNum) {
                JavaConstant javaConstant;
                ValueNode value = mat.values.get(propertyNum);
                if (value == null || JavaConstant.NULL_POINTER.equals((Object)value.asJavaConstant())) continue;
                if (virtual instanceof VirtualInstanceNode) {
                    VirtualInstanceNode instanceNode = (VirtualInstanceNode)virtual;
                    ResolvedJavaField field = instanceNode.field(propertyNum);
                    this.lowerFieldAssignment(instanceNode, field, value, codeGenTool);
                    codeGenTool.genResolvedVarDeclPostfix("Materialize virtual object property assignment");
                    continue;
                }
                if (value.isJavaConstant() && (javaConstant = value.asJavaConstant()).isDefaultForKind()) continue;
                this.lowerArrayElementAssignment((VirtualArrayNode)virtual, propertyNum, value, codeGenTool);
                codeGenTool.genResolvedVarDeclPostfix("Materialize virtual array assignment");
            }
        }
    }

    static class Materialization {
        public final VirtualObjectNode object;
        public final List<ValueNode> values;
        public final boolean containsVirtual;

        Materialization(VirtualObjectNode object, List<ValueNode> values, boolean containsVirtual) {
            this.object = object;
            this.values = values;
            this.containsVirtual = containsVirtual;
        }
    }
}

