/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hightiercodegen.variables;

import java.util.HashMap;
import jdk.graal.compiler.hightiercodegen.variables.ResolvedVar;
import jdk.graal.compiler.nodes.ValueNode;

public final class VariableMap {
    public static final String LOCAL_PREFIX = "l";
    private int count = 0;
    private final HashMap<ValueNode, ResolvedVar> resolvedVars = new HashMap();

    public ResolvedVar getVarByNode(ValueNode n) {
        assert (n != null);
        return this.resolvedVars.get(n);
    }

    public ResolvedVar allocate(ValueNode n) {
        assert (!this.resolvedVars.containsKey(n)) : "already allocated for " + String.valueOf(n);
        ResolvedVar var = new ResolvedVar(n);
        var.birth(LOCAL_PREFIX + this.count);
        this.resolvedVars.put(n, var);
        ++this.count;
        return var;
    }

    public String toString() {
        return "Variable count: " + this.resolvedVars.size() + "\n" + String.valueOf(this.resolvedVars);
    }
}

