/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import jdk.graal.compiler.core.common.CancellationBailoutException;
import jdk.graal.compiler.core.phases.fuzzing.FuzzedSuites;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hotspot.CompilationTask;
import jdk.graal.compiler.hotspot.HotSpotGraalCompiler;
import jdk.graal.compiler.hotspot.meta.HotSpotFuzzedSuitesProvider;
import jdk.vm.ci.hotspot.HotSpotCompilationRequest;
import jdk.vm.ci.hotspot.HotSpotCompilationRequestResult;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;

public class CompileTheWorldFuzzedSuitesCompilationTask
extends CompilationTask {
    public CompileTheWorldFuzzedSuitesCompilationTask(HotSpotJVMCIRuntime jvmciRuntime, HotSpotGraalCompiler compiler, HotSpotCompilationRequest request, boolean useProfilingInfo, boolean installAsDefault) {
        super(jvmciRuntime, compiler, request, useProfilingInfo, installAsDefault);
    }

    public CompileTheWorldFuzzedSuitesCompilationTask(HotSpotJVMCIRuntime jvmciRuntime, HotSpotGraalCompiler compiler, HotSpotCompilationRequest request, boolean useProfilingInfo, boolean shouldRetainLocalVariables, boolean installAsDefault) {
        super(jvmciRuntime, compiler, request, useProfilingInfo, shouldRetainLocalVariables, installAsDefault);
    }

    @Override
    public HotSpotCompilationRequestResult runCompilation(DebugContext debug) {
        return this.runCompilation(debug, new HotSpotFuzzedCompilationWrapper());
    }

    private final class HotSpotFuzzedCompilationWrapper
    extends CompilationTask.HotSpotCompilationWrapper {
        private HotSpotFuzzedCompilationWrapper() {
        }

        @Override
        protected HotSpotCompilationRequestResult handleFailure(DebugContext initialDebug, Throwable cause) {
            if (!(cause instanceof CancellationBailoutException)) {
                String dumpPath = initialDebug.getDumpPath("", false);
                HotSpotFuzzedSuitesProvider suitesProvider = (HotSpotFuzzedSuitesProvider)CompileTheWorldFuzzedSuitesCompilationTask.this.compiler.getGraalRuntime().getHostBackend().getProviders().getSuites();
                FuzzedSuites phasePlan = suitesProvider.getLastSuitesForThread(initialDebug.getOptions());
                phasePlan.saveFuzzedSuites(dumpPath);
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try (PrintStream ps = new PrintStream(baos);){
                        ps.printf("CompileTheWorld : %s error compiling method: %s%n%n", cause.getClass(), this.toString());
                        ps.printf("Command to retry:%n", new Object[0]);
                        ps.printf("mx gate --extra-vm-argument='-DCompileTheWorld.LoadPhasePlan=%s.phaseplan' --extra-vm-argument='-DCompileTheWorld.MethodFilter=%s' --extra-vm-argument='-Djdk.graal.CompilerConfiguration=%s' --tags ctw%n%n", dumpPath, CompileTheWorldFuzzedSuitesCompilationTask.this.getMethod().format("%H.%n"), CompileTheWorldFuzzedSuitesCompilationTask.this.compiler.getGraalRuntime().getCompilerConfigurationName());
                        ps.printf("Failure:%n%s%n%n", cause.toString());
                        ps.printf("%s%n%n", phasePlan.toString());
                        ps.printf("The stack trace:%n", new Object[0]);
                        cause.printStackTrace(ps);
                    }
                    Files.write(Paths.get(dumpPath + "_failure.log", new String[0]), baos.toByteArray(), new OpenOption[0]);
                }
                catch (IOException e) {
                    GraalError.shouldNotReachHere(e, "Error saving log of failed phase plan to " + dumpPath + "_failure.log");
                }
            }
            return (HotSpotCompilationRequestResult)super.handleFailure(initialDebug, cause);
        }
    }
}

