/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfigAccess;
import jdk.graal.compiler.hotspot.HotSpotGraalRuntime;
import jdk.graal.compiler.hotspot.HotSpotMarkId;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.hotspot.HotSpotVMConfigStore;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class GraalHotSpotVMConfig
extends GraalHotSpotVMConfigAccess {
    public static final GraalHotSpotVMConfig INJECTED_VMCONFIG = null;
    public static final MetaAccessProvider INJECTED_METAACCESS = null;
    public static final OptionValues INJECTED_OPTIONVALUES = null;
    private final CompressEncoding oopEncoding;
    private final CompressEncoding klassEncoding;
    private final String markWord = "markWord";
    public final HotSpotGraalRuntime.HotSpotGC gc = this.getSelectedGC();
    public final boolean xcompMode = (Boolean)this.access.getFlag("UseInterpreter", Boolean.class) == false;
    public final boolean ropProtection = (Boolean)this.access.getFieldValue("VM_Version::_rop_protection", Boolean.class, "bool", (Object)false);
    public final boolean cAssertions = this.getConstant("ASSERT", Boolean.class);
    public final int codeEntryAlignment = this.getFlag("CodeEntryAlignment", Integer.class);
    public final boolean verifyOops = this.getFlag("VerifyOops", Boolean.class);
    public final boolean dontCompileHugeMethods = this.getFlag("DontCompileHugeMethods", Boolean.class);
    public final int hugeMethodLimit = this.getFlag("HugeMethodLimit", Integer.class);
    public final boolean printInlining = this.getFlag("PrintInlining", Boolean.class);
    public final boolean inline = this.getFlag("Inline", Boolean.class);
    public final int lockingMode = this.getFlag("LockingMode", Integer.class);
    public final int lockingModeMonitor = this.getConstant("LockingMode::LM_MONITOR", Integer.class, 0, JDK >= 22);
    public final int lockingModeStack = this.getConstant("LockingMode::LM_LEGACY", Integer.class, 1, JDK >= 22);
    public final int lockingModeLightweight = this.getConstant("LockingMode::LM_LIGHTWEIGHT", Integer.class, 2, JDK >= 22);
    public final boolean foldStableValues = this.getFlag("FoldStableValues", Boolean.class);
    public final int maxVectorSize = this.getFlag("MaxVectorSize", Integer.class);
    public final boolean verifyBeforeGC = this.getFlag("VerifyBeforeGC", Boolean.class);
    public final boolean verifyAfterGC = this.getFlag("VerifyAfterGC", Boolean.class);
    public final boolean useTLAB = this.getFlag("UseTLAB", Boolean.class);
    public final boolean usePopCountInstruction = this.getFlag("UsePopCountInstruction", Boolean.class);
    public final boolean useUnalignedAccesses = this.getFlag("UseUnalignedAccesses", Boolean.class);
    public final boolean useFMAIntrinsics = this.getFlag("UseFMA", Boolean.class);
    public final boolean useVectorizedMismatchIntrinsic = this.getFlag("UseVectorizedMismatchIntrinsic", Boolean.class);
    public final boolean useCharacterCompareIntrinsics = this.getFlag("UseCharacterCompareIntrinsics", Boolean.class);
    public final int useAVX3Threshold = this.getFlag("AVX3Threshold", Integer.class, 4096, this.osArch.equals("amd64"));
    public final String onSpinWaitInst = this.getFlag("OnSpinWaitInst", String.class, "none", this.osArch.equals("aarch64"));
    public final int onSpinWaitInstCount = this.getFlag("OnSpinWaitInstCount", Integer.class, 0, this.osArch.equals("aarch64"));
    public final boolean preserveFramePointer = this.getFlag("PreserveFramePointer", Boolean.class) != false || this.ropProtection;
    public final int diagnoseSyncOnValueBasedClasses = this.getFlag("DiagnoseSyncOnValueBasedClasses", Integer.class);
    public final int allocatePrefetchStyle = this.getFlag("AllocatePrefetchStyle", Integer.class);
    public final int allocatePrefetchInstr = this.getFlag("AllocatePrefetchInstr", Integer.class);
    public final int allocatePrefetchLines = this.getFlag("AllocatePrefetchLines", Integer.class);
    public final int allocateInstancePrefetchLines = this.getFlag("AllocateInstancePrefetchLines", Integer.class);
    public final int allocatePrefetchStepSize = this.getFlag("AllocatePrefetchStepSize", Integer.class);
    public final int allocatePrefetchDistance = this.getFlag("AllocatePrefetchDistance", Integer.class);
    private final long universeCollectedHeap = this.getFieldValue("CompilerToVM::Data::Universe_collectedHeap", Long.class, "CollectedHeap*");
    private final int collectedHeapTotalCollectionsOffset = this.getFieldOffset("CollectedHeap::_total_collections", Integer.class, "unsigned int");
    public final boolean useDeferredInitBarriers = this.getFlag("ReduceInitialCardMarks", Boolean.class);
    public final boolean useCompressedOops = this.getFlag("UseCompressedOops", Boolean.class);
    public final boolean useCompressedClassPointers = this.getFlag("UseCompressedClassPointers", Boolean.class);
    public final long narrowOopBase = this.getFieldValue("CompilerToVM::Data::Universe_narrow_oop_base", Long.class, "address");
    public final int narrowOopShift = this.getFieldValue("CompilerToVM::Data::Universe_narrow_oop_shift", Integer.class, "int");
    public final int objectAlignment = this.getFlag("ObjectAlignmentInBytes", Integer.class);
    public final int narrowKlassSize = this.getFieldValue("CompilerToVM::Data::sizeof_narrowKlass", Integer.class, "int");
    public final long narrowKlassBase = this.getFieldValue("CompilerToVM::Data::Universe_narrow_klass_base", Long.class, "address");
    public final int narrowKlassShift = this.getFieldValue("CompilerToVM::Data::Universe_narrow_klass_shift", Integer.class, "int");
    public final int logKlassAlignment = this.getConstant("LogKlassAlignmentInBytes", Integer.class);
    public final int stackShadowPages = this.getFlag("StackShadowPages", Integer.class);
    public final int vmPageSize = this.getFieldValue("CompilerToVM::Data::vm_page_size", Integer.class, "size_t");
    public final int softwarePrefetchHintDistance = this.getFlag("SoftwarePrefetchHintDistance", Integer.class, -1, "aarch64".equals(this.osArch));
    public final int markOffset = this.getFieldOffset("oopDesc::_mark", Integer.class, "markWord");
    public final int hubOffset = this.getFieldOffset("oopDesc::_metadata._klass", Integer.class, "Klass*");
    public final int superCheckOffsetOffset = this.getFieldOffset("Klass::_super_check_offset", Integer.class, "juint");
    public final int secondarySuperCacheOffset = this.getFieldOffset("Klass::_secondary_super_cache", Integer.class, "Klass*");
    public final int secondarySupersOffset = this.getFieldOffset("Klass::_secondary_supers", Integer.class, "Array<Klass*>*");
    public final int classMirrorOffset = this.getFieldOffset("Klass::_java_mirror", Integer.class, "OopHandle");
    public final int klassSuperKlassOffset = this.getFieldOffset("Klass::_super", Integer.class, "Klass*");
    public final int klassModifierFlagsOffset = this.getFieldOffset("Klass::_modifier_flags", Integer.class, "jint");
    public final int klassAccessFlagsOffset = this.getFieldOffset("Klass::_access_flags", Integer.class, "AccessFlags");
    public final int klassLayoutHelperOffset = this.getFieldOffset("Klass::_layout_helper", Integer.class, "jint");
    public final int klassLayoutHelperNeutralValue = this.getConstant("Klass::_lh_neutral_value", Integer.class);
    public final int layoutHelperLog2ElementSizeShift = this.getConstant("Klass::_lh_log2_element_size_shift", Integer.class);
    public final int layoutHelperLog2ElementSizeMask = this.getConstant("Klass::_lh_log2_element_size_mask", Integer.class);
    public final int layoutHelperHeaderSizeShift = this.getConstant("Klass::_lh_header_size_shift", Integer.class);
    public final int layoutHelperHeaderSizeMask = this.getConstant("Klass::_lh_header_size_mask", Integer.class);
    public final int instanceKlassInitStateOffset = this.getFieldOffset("InstanceKlass::_init_state", Integer.class, "InstanceKlass::ClassState");
    public final int instanceKlassInitThreadOffset = this.getFieldOffset("InstanceKlass::_init_thread", Integer.class, "JavaThread*");
    public final int instanceKlassStateBeingInitialized = this.getConstant("InstanceKlass::being_initialized", Integer.class);
    public final int instanceKlassStateFullyInitialized = this.getConstant("InstanceKlass::fully_initialized", Integer.class);
    public final int arrayOopDescSize = this.getFieldValue("CompilerToVM::Data::sizeof_arrayOopDesc", Integer.class, "int");
    public final int metaspaceArrayLengthOffset = this.getFieldOffset("Array<Klass*>::_length", Integer.class, "int");
    public final int metaspaceArrayBaseOffset = this.getFieldOffset("Array<Klass*>::_data[0]", Integer.class, "Klass*");
    public final int arrayClassElementOffset = this.getFieldOffset("ObjArrayKlass::_element_klass", Integer.class, "Klass*");
    public final int jvmAccHasFinalizer = this.getConstant("JVM_ACC_HAS_FINALIZER", Integer.class);
    public final int jvmAccWrittenFlags = this.getConstant("JVM_ACC_WRITTEN_FLAGS", Integer.class);
    public final int jvmAccIsHiddenClass = this.getConstant("JVM_ACC_IS_HIDDEN_CLASS", Integer.class);
    public final int jvmAccIsValueBasedClass = this.verifyConstant("JVM_ACC_IS_VALUE_BASED_CLASS", Integer.class, 0x8000000);
    public final int jvmciCompileStateCanPostOnExceptionsOffset = this.getFieldOffset("JVMCICompileState::_jvmti_can_post_on_exceptions", Integer.class, "jbyte");
    public final int jvmciCompileStateCanPopFrameOffset = this.getFieldOffset("JVMCICompileState::_jvmti_can_pop_frame", Integer.class, "jbyte");
    public final int jvmciCompileStateCanAccessLocalVariablesOffset = this.getFieldOffset("JVMCICompileState::_jvmti_can_access_local_variables", Integer.class, "jbyte");
    public final int threadTlabOffset = this.getFieldOffset("Thread::_tlab", Integer.class, "ThreadLocalAllocBuffer");
    public final int javaThreadAnchorOffset = this.getFieldOffset("JavaThread::_anchor", Integer.class, "JavaFrameAnchor");
    public final int javaThreadShouldPostOnExceptionsFlagOffset = this.getFieldOffset("JavaThread::_should_post_on_exceptions_flag", Integer.class, "int");
    public final int threadCurrentThreadObjectOffset = this.getFieldOffset("JavaThread::_vthread", Integer.class, "OopHandle");
    public final boolean doJVMTIVirtualThreadTransitions = this.getFlag("DoJVMTIVirtualThreadTransitions", Boolean.class);
    public final int threadCarrierThreadObjectOffset = this.getFieldOffset("JavaThread::_threadObj", Integer.class, "OopHandle");
    public final int threadScopedValueCacheOffset = this.getFieldOffset("JavaThread::_scopedValueCache", Integer.class, "OopHandle");
    public final int threadIsInVTMSTransitionOffset = this.getFieldOffset("JavaThread::_is_in_VTMS_transition", Integer.class, "bool");
    public final int threadIsInTmpVTMSTransitionOffset = this.getFieldOffset("JavaThread::_is_in_tmp_VTMS_transition", Integer.class, "bool");
    public final int threadIsDisableSuspendOffset = this.getFieldOffset("JavaThread::_is_disable_suspend", Integer.class, "bool", -1, JDK >= 22);
    public final int javaLangThreadJFREpochOffset = this.getFieldValue("java_lang_Thread::_jfr_epoch_offset", Integer.class, "int");
    public final int javaLangThreadTIDOffset = this.getFieldValue("java_lang_Thread::_tid_offset", Integer.class, "int");
    public final int javaLangThreadIsInVTMSTransitonOffset = this.getFieldValue("java_lang_Thread::_jvmti_is_in_VTMS_transition_offset", Integer.class, "int");
    public final long virtualThreadVTMSNotifyJvmtiEvents = this.getFieldAddress("JvmtiVTMSTransitionDisabler::_VTMS_notify_jvmti_events", "bool");
    public final int threadJFRThreadLocalOffset = this.getFieldOffset("Thread::_jfr_thread_local", Integer.class, "JfrThreadLocal");
    public final int jfrThreadLocalVthreadIDOffset = this.getFieldOffset("JfrThreadLocal::_vthread_id", Integer.class, "traceid");
    public final int jfrThreadLocalVthreadEpochOffset = this.getFieldOffset("JfrThreadLocal::_vthread_epoch", Integer.class, "u2");
    public final int jfrThreadLocalVthreadExcludedOffset = this.getFieldOffset("JfrThreadLocal::_vthread_excluded", Integer.class, "bool");
    public final int jfrThreadLocalVthreadOffset = this.getFieldOffset("JfrThreadLocal::_vthread", Integer.class, "bool");
    public final int osThreadOffset = this.getFieldOffset("JavaThread::_osthread", Integer.class, "OSThread*");
    public final int threadObjectResultOffset = this.getFieldOffset("JavaThread::_vm_result", Integer.class, "oop");
    public final int jvmciCountersThreadOffset = this.getFieldOffset("JavaThread::_jvmci_counters", Integer.class, "jlong*");
    public final int jvmciReserved0Offset = this.getFieldOffset("JavaThread::_jvmci_reserved0", Integer.class, "jlong");
    public final int jvmciReservedReference0Offset = this.getFieldOffset("JavaThread::_jvmci_reserved_oop0", Integer.class, "oop");
    public final int doingUnsafeAccessOffset = this.getFieldOffset("JavaThread::_doing_unsafe_access", Integer.class, "bool");
    public final int javaThreadReservedStackActivationOffset = this.getFieldOffset("JavaThread::_stack_overflow_state._reserved_stack_activation", Integer.class, "address");
    public final int jniEnvironmentOffset = this.getFieldOffset("JavaThread::_jni_environment", Integer.class, "JNIEnv");
    public final int threadExceptionOopOffset = this.getFieldOffset("JavaThread::_exception_oop", Integer.class, "oop");
    public final int threadExceptionPcOffset = this.getFieldOffset("JavaThread::_exception_pc", Integer.class, "address");
    public final int pendingExceptionOffset = this.getFieldOffset("ThreadShadow::_pending_exception", Integer.class, "oop");
    public final int pendingDeoptimizationOffset = this.getFieldOffset("JavaThread::_pending_deoptimization", Integer.class, "int");
    public final int pendingTransferToInterpreterOffset = this.getFieldOffset("JavaThread::_pending_transfer_to_interpreter", Integer.class, "bool");
    private final int javaFrameAnchorLastJavaSpOffset = this.getFieldOffset("JavaFrameAnchor::_last_Java_sp", Integer.class, "intptr_t*");
    private final int javaFrameAnchorLastJavaPcOffset = this.getFieldOffset("JavaFrameAnchor::_last_Java_pc", Integer.class, "address");
    public final int pendingFailedSpeculationOffset = this.getFieldOffset("JavaThread::_pending_failed_speculation", Integer.class, "jlong");
    public final int frameInterpreterFrameSenderSpOffset = this.getConstant("frame::interpreter_frame_sender_sp_offset", Integer.class, 0, this.osArch.equals("amd64"));
    public final int frameInterpreterFrameLastSpOffset = this.getConstant("frame::interpreter_frame_last_sp_offset", Integer.class, 0, this.osArch.equals("amd64"));
    public final int lockMaskInPlace = this.getConstant("markWord::lock_mask_in_place", Integer.class);
    public final int ageMaskInPlace = this.getConstant("markWord::age_mask_in_place", Integer.class);
    public final int unlockedMask = this.getConstant("markWord::unlocked_value", Integer.class);
    public final int monitorMask = this.getConstant("markWord::monitor_value", Integer.class);
    public final int objectMonitorOwner = this.getFieldOffset("ObjectMonitor::_owner", Integer.class, null);
    public final int objectMonitorRecursions = this.getFieldOffset("ObjectMonitor::_recursions", Integer.class, "intptr_t");
    public final int objectMonitorCxq = this.getFieldOffset("ObjectMonitor::_cxq", Integer.class, "ObjectWaiter*");
    public final int objectMonitorEntryList = this.getFieldOffset("ObjectMonitor::_EntryList", Integer.class, "ObjectWaiter*");
    public final int objectMonitorSucc = this.getFieldOffset("ObjectMonitor::_succ", Integer.class, "JavaThread*");
    public final long objectMonitorAnonymousOwner = this.getConstant("ObjectMonitor::ANONYMOUS_OWNER", Long.class, 1L, JDK >= 22);
    public final int markWordNoHashInPlace = this.getConstant("markWord::no_hash_in_place", Integer.class);
    public final int markWordNoLockInPlace = this.getConstant("markWord::no_lock_in_place", Integer.class);
    public final int identityHashCodeShift = this.getConstant("markWord::hash_shift", Integer.class);
    public final int uninitializedIdentityHashCodeValue = this.getConstant("markWord::no_hash", Integer.class);
    public final int methodCompiledEntryOffset = this.getFieldOffset("Method::_from_compiled_entry", Integer.class, "address");
    public final int invocationCounterOffset = this.getFieldOffset("MethodCounters::_invocation_counter", Integer.class, "InvocationCounter");
    public final int backedgeCounterOffset = this.getFieldOffset("MethodCounters::_backedge_counter", Integer.class, "InvocationCounter");
    public final int invocationCounterIncrement = this.getConstant("InvocationCounter::count_increment", Integer.class);
    public final int invocationCounterShift = this.getConstant("InvocationCounter::count_shift", Integer.class);
    public final int compilationLevelFullOptimization = this.getConstant("CompLevel_full_optimization", Integer.class);
    public final int heapWordSize = this.getConstant("HeapWordSize", Integer.class);
    public final long nonOopBits = this.getFieldValue("CompilerToVM::Data::Universe_non_oop_bits", Long.class, "void*");
    public final long verifyOopCounterAddress = this.getFieldAddress("StubRoutines::_verify_oop_count", "jint");
    public final long verifyOopMask = this.getFieldValue("CompilerToVM::Data::Universe_verify_oop_mask", Long.class, "uintptr_t");
    public final long verifyOopBits = this.getFieldValue("CompilerToVM::Data::Universe_verify_oop_bits", Long.class, "uintptr_t");
    public final int logOfHRGrainBytes = this.getFieldValue("HeapRegion::LogOfHRGrainBytes", Integer.class, JDK >= 22 ? "uint" : "int");
    public final int cardtableShift = this.getFieldValue("CompilerToVM::Data::cardtable_shift", Integer.class, "int");
    public final long cardtableStartAddress = this.getFieldValue("CompilerToVM::Data::cardtable_start_address", Long.class, "CardTable::CardValue*");
    public final int maxOopMapStackOffset = this.getFieldValue("CompilerToVM::Data::_max_oop_map_stack_offset", Integer.class, "int");
    public final byte dirtyCardValue = this.getConstant("CardTable::dirty_card", Byte.class);
    public final byte g1YoungCardValue = this.getConstant("G1CardTable::g1_young_gen", Byte.class);
    public final int g1SATBQueueMarkingActiveOffset = this.getConstant("G1ThreadLocalData::satb_mark_queue_active_offset", Integer.class);
    public final int g1SATBQueueIndexOffset = this.getConstant("G1ThreadLocalData::satb_mark_queue_index_offset", Integer.class);
    public final int g1SATBQueueBufferOffset = this.getConstant("G1ThreadLocalData::satb_mark_queue_buffer_offset", Integer.class);
    public final int g1CardQueueIndexOffset = this.getConstant("G1ThreadLocalData::dirty_card_queue_index_offset", Integer.class);
    public final int g1CardQueueBufferOffset = this.getConstant("G1ThreadLocalData::dirty_card_queue_buffer_offset", Integer.class);
    public final int klassOffset = this.getFieldValue("java_lang_Class::_klass_offset", Integer.class, "int");
    public final int arrayKlassOffset = this.getFieldValue("java_lang_Class::_array_klass_offset", Integer.class, "int");
    public final int basicLockSize = this.getFieldValue("CompilerToVM::Data::sizeof_BasicLock", Integer.class, "int");
    public final int basicLockDisplacedHeaderOffset = this.getFieldOffset("BasicLock::_displaced_header", Integer.class, "markWord");
    public final int threadPollingPageOffset = this.getFieldOffset("JavaThread::_poll_data", Integer.class, "SafepointMechanism::ThreadData") + this.getFieldOffset("SafepointMechanism::ThreadData::_polling_page", Integer.class, "volatile uintptr_t");
    public final int threadPollingWordOffset = this.getFieldOffset("JavaThread::_poll_data", Integer.class, "SafepointMechanism::ThreadData") + this.getFieldOffset("SafepointMechanism::ThreadData::_polling_word", Integer.class, "volatile uintptr_t");
    public final int savedExceptionPCOffset = this.getFieldOffset("JavaThread::_saved_exception_pc", Integer.class, "address");
    private final int threadLocalAllocBufferEndOffset = this.getFieldOffset("ThreadLocalAllocBuffer::_end", Integer.class, "HeapWord*");
    private final int threadLocalAllocBufferTopOffset = this.getFieldOffset("ThreadLocalAllocBuffer::_top", Integer.class, "HeapWord*");
    public final int zvaLength = (Integer)this.access.getFieldValue("VM_Version::_zva_length", Integer.class, "int", (Object)0);
    public final long inlineCacheMissStub = this.getFieldValue("CompilerToVM::Data::SharedRuntime_ic_miss_stub", Long.class, "address");
    public final long deoptBlobUnpack = this.getFieldValue("CompilerToVM::Data::SharedRuntime_deopt_blob_unpack", Long.class, "address");
    public final long deoptBlobUnpackWithExceptionInTLS = this.getFieldValue("CompilerToVM::Data::SharedRuntime_deopt_blob_unpack_with_exception_in_tls", Long.class, "address");
    public final long pollingPageReturnHandler = this.getFieldValue("CompilerToVM::Data::SharedRuntime_polling_page_return_handler", Long.class, "address");
    public final long deoptBlobUncommonTrap = this.getFieldValue("CompilerToVM::Data::SharedRuntime_deopt_blob_uncommon_trap", Long.class, "address");
    public final long updateBytesCRC32Stub = this.getFieldValue("StubRoutines::_updateBytesCRC32", Long.class, "address");
    public final long crcTableAddress = this.getFieldValue("StubRoutines::_crc_table_adr", Long.class, "address");
    public final long md5ImplCompressMultiBlock = this.getFieldValue("StubRoutines::_md5_implCompressMB", Long.class, "address");
    public final long sha1ImplCompressMultiBlock = this.getFieldValue("StubRoutines::_sha1_implCompressMB", Long.class, "address");
    public final long sha256ImplCompressMultiBlock = this.getFieldValue("StubRoutines::_sha256_implCompressMB", Long.class, "address");
    public final long sha512ImplCompressMultiBlock = this.getFieldValue("StubRoutines::_sha512_implCompressMB", Long.class, "address");
    public final long sha3ImplCompressMultiBlock = this.getFieldValue("StubRoutines::_sha3_implCompressMB", Long.class, "address");
    public final long base64EncodeBlock = this.getFieldValue("StubRoutines::_base64_encodeBlock", Long.class, "address");
    public final long base64DecodeBlock = this.getFieldValue("StubRoutines::_base64_decodeBlock", Long.class, "address");
    public final long updateBytesCRC32C = this.getFieldValue("StubRoutines::_updateBytesCRC32C", Long.class, "address");
    public final long updateBytesAdler32 = this.getFieldValue("StubRoutines::_updateBytesAdler32", Long.class, "address");
    public final long montgomeryMultiply = this.getFieldValue("StubRoutines::_montgomeryMultiply", Long.class, "address");
    public final long montgomerySquare = this.getFieldValue("StubRoutines::_montgomerySquare", Long.class, "address");
    public final long bigIntegerLeftShiftWorker = this.getFieldValue("StubRoutines::_bigIntegerLeftShiftWorker", Long.class, "address");
    public final long bigIntegerRightShiftWorker = this.getFieldValue("StubRoutines::_bigIntegerRightShiftWorker", Long.class, "address");
    public final long electronicCodeBookEncrypt = this.getFieldValue("StubRoutines::_electronicCodeBook_encryptAESCrypt", Long.class, "address");
    public final long electronicCodeBookDecrypt = this.getFieldValue("StubRoutines::_electronicCodeBook_decryptAESCrypt", Long.class, "address");
    public final long galoisCounterModeCrypt = this.getFieldValue("StubRoutines::_galoisCounterMode_AESCrypt", Long.class, "address");
    public final long poly1305ProcessBlocks = this.getFieldValue("StubRoutines::_poly1305_processBlocks", Long.class, "address");
    public final long chacha20Block = this.getFieldValue("StubRoutines::_chacha20Block", Long.class, "address");
    public final long throwDelayedStackOverflowErrorEntry = this.getFieldValue("StubRoutines::_throw_delayed_StackOverflowError_entry", Long.class, "address");
    public final long jbyteArraycopy = this.getFieldValue("StubRoutines::_jbyte_arraycopy", Long.class, "address");
    public final long jshortArraycopy = this.getFieldValue("StubRoutines::_jshort_arraycopy", Long.class, "address");
    public final long jintArraycopy = this.getFieldValue("StubRoutines::_jint_arraycopy", Long.class, "address");
    public final long jlongArraycopy = this.getFieldValue("StubRoutines::_jlong_arraycopy", Long.class, "address");
    public final long oopArraycopy = this.getFieldValue("StubRoutines::_oop_arraycopy", Long.class, "address");
    public final long oopArraycopyUninit = this.getFieldValue("StubRoutines::_oop_arraycopy_uninit", Long.class, "address");
    public final long jbyteDisjointArraycopy = this.getFieldValue("StubRoutines::_jbyte_disjoint_arraycopy", Long.class, "address");
    public final long jshortDisjointArraycopy = this.getFieldValue("StubRoutines::_jshort_disjoint_arraycopy", Long.class, "address");
    public final long jintDisjointArraycopy = this.getFieldValue("StubRoutines::_jint_disjoint_arraycopy", Long.class, "address");
    public final long jlongDisjointArraycopy = this.getFieldValue("StubRoutines::_jlong_disjoint_arraycopy", Long.class, "address");
    public final long oopDisjointArraycopy = this.getFieldValue("StubRoutines::_oop_disjoint_arraycopy", Long.class, "address");
    public final long oopDisjointArraycopyUninit = this.getFieldValue("StubRoutines::_oop_disjoint_arraycopy_uninit", Long.class, "address");
    public final long jbyteAlignedArraycopy = this.getFieldValue("StubRoutines::_arrayof_jbyte_arraycopy", Long.class, "address");
    public final long jshortAlignedArraycopy = this.getFieldValue("StubRoutines::_arrayof_jshort_arraycopy", Long.class, "address");
    public final long jintAlignedArraycopy = this.getFieldValue("StubRoutines::_arrayof_jint_arraycopy", Long.class, "address");
    public final long jlongAlignedArraycopy = this.getFieldValue("StubRoutines::_arrayof_jlong_arraycopy", Long.class, "address");
    public final long oopAlignedArraycopy = this.getFieldValue("StubRoutines::_arrayof_oop_arraycopy", Long.class, "address");
    public final long oopAlignedArraycopyUninit = this.getFieldValue("StubRoutines::_arrayof_oop_arraycopy_uninit", Long.class, "address");
    public final long jbyteAlignedDisjointArraycopy = this.getFieldValue("StubRoutines::_arrayof_jbyte_disjoint_arraycopy", Long.class, "address");
    public final long jshortAlignedDisjointArraycopy = this.getFieldValue("StubRoutines::_arrayof_jshort_disjoint_arraycopy", Long.class, "address");
    public final long jintAlignedDisjointArraycopy = this.getFieldValue("StubRoutines::_arrayof_jint_disjoint_arraycopy", Long.class, "address");
    public final long jlongAlignedDisjointArraycopy = this.getFieldValue("StubRoutines::_arrayof_jlong_disjoint_arraycopy", Long.class, "address");
    public final long oopAlignedDisjointArraycopy = this.getFieldValue("StubRoutines::_arrayof_oop_disjoint_arraycopy", Long.class, "address");
    public final long oopAlignedDisjointArraycopyUninit = this.getFieldValue("StubRoutines::_arrayof_oop_disjoint_arraycopy_uninit", Long.class, "address");
    public final long checkcastArraycopy = this.getFieldValue("StubRoutines::_checkcast_arraycopy", Long.class, "address");
    public final long checkcastArraycopyUninit = this.getFieldValue("StubRoutines::_checkcast_arraycopy_uninit", Long.class, "address");
    public final long unsafeArraycopy = this.getFieldValue("StubRoutines::_unsafe_arraycopy", Long.class, "address");
    public final long genericArraycopy = this.getFieldValue("StubRoutines::_generic_arraycopy", Long.class, "address");
    public final long newInstanceAddress = this.getAddress("JVMCIRuntime::new_instance");
    public final long newArrayAddress = this.getAddress("JVMCIRuntime::new_array");
    public final long newMultiArrayAddress = this.getAddress("JVMCIRuntime::new_multi_array");
    public final long dynamicNewInstanceAddress = this.getAddress("JVMCIRuntime::dynamic_new_instance");
    public final long newInstanceOrNullAddress = this.getAddress("JVMCIRuntime::new_instance_or_null");
    public final long newArrayOrNullAddress = this.getAddress("JVMCIRuntime::new_array_or_null");
    public final long newMultiArrayOrNullAddress = this.getAddress("JVMCIRuntime::new_multi_array_or_null");
    public final long dynamicNewInstanceOrNullAddress = this.getAddress("JVMCIRuntime::dynamic_new_instance_or_null");
    public final long invokeJavaMethodAddress = this.getAddress("JVMCIRuntime::invoke_static_method_one_arg");
    public final long vmMessageAddress = this.getAddress("JVMCIRuntime::vm_message");
    public final long identityHashCodeAddress = this.getAddress("JVMCIRuntime::identity_hash_code");
    public final long exceptionHandlerForPcAddress = this.getAddress("JVMCIRuntime::exception_handler_for_pc");
    public final long monitorenterAddress = this.getAddress("JVMCIRuntime::monitorenter");
    public final long monitorexitAddress = this.getAddress("JVMCIRuntime::monitorexit");
    public final long notifyAddress = this.getAddress("JVMCIRuntime::object_notify");
    public final long notifyAllAddress = this.getAddress("JVMCIRuntime::object_notifyAll");
    public final boolean continuationsEnabled = this.getFieldValue("CompilerToVM::Data::continuations_enabled", Boolean.class, "bool");
    public final int threadDisarmedOffset = this.getFieldValue("CompilerToVM::Data::thread_disarmed_guard_value_offset", Integer.class, "int");
    public final long nmethodEntryBarrier = this.getFieldValue("CompilerToVM::Data::nmethod_entry_barrier", Long.class, "address");
    public final int threadAddressBadMaskOffset = this.getFieldValue("CompilerToVM::Data::thread_address_bad_mask_offset", Integer.class, "int");
    public final long zBarrierSetRuntimeLoadBarrierOnOopFieldPreloaded = this.getZGCAddressField("CompilerToVM::Data::ZBarrierSetRuntime_load_barrier_on_oop_field_preloaded");
    public final long zBarrierSetRuntimeLoadBarrierOnWeakOopFieldPreloaded = this.getZGCAddressField("CompilerToVM::Data::ZBarrierSetRuntime_load_barrier_on_weak_oop_field_preloaded");
    public final long zBarrierSetRuntimeWeakLoadBarrierOnWeakOopFieldPreloaded = this.getZGCAddressField("CompilerToVM::Data::ZBarrierSetRuntime_weak_load_barrier_on_weak_oop_field_preloaded");
    public final long zBarrierSetRuntimeWeakLoadBarrierOnPhantomOopFieldPreloaded = this.getZGCAddressField("CompilerToVM::Data::ZBarrierSetRuntime_weak_load_barrier_on_phantom_oop_field_preloaded");
    public final long zBarrierSetRuntimeLoadBarrierOnOopArray = this.getZGCAddressField("CompilerToVM::Data::ZBarrierSetRuntime_load_barrier_on_oop_array");
    public final Boolean nmethodEntryBarrierConcurrentPatch;
    public final int threadHeldMonitorCountOffset;
    public final int threadLockStackOffset;
    public final int lockStackTopOffset;
    public final int lockStackEndOffset;
    public final long throwAndPostJvmtiExceptionAddress;
    public final long throwKlassExternalNameExceptionAddress;
    public final long throwClassCastExceptionAddress;
    public final long logPrimitiveAddress;
    public final long logObjectAddress;
    public final long logPrintfAddress;
    public final long vmErrorAddress;
    public final long loadAndClearExceptionAddress;
    public final long writeBarrierPreAddress;
    public final long writeBarrierPostAddress;
    public final long validateObject;
    public final long testDeoptimizeCallInt;
    public final long registerFinalizerAddress;
    public final long exceptionHandlerForReturnAddressAddress;
    public final long osrMigrationEndAddress;
    public final long enableStackReservedZoneAddress;
    public final long javaTimeMillisAddress;
    public final long javaTimeNanosAddress;
    public final long arithmeticSinAddress;
    public final long arithmeticCosAddress;
    public final long arithmeticTanAddress;
    public final long arithmeticExpAddress;
    public final long arithmeticLogAddress;
    public final long arithmeticLog10Address;
    public final long arithmeticPowAddress;
    public final long fremAddress;
    public final long dremAddress;
    public final long jvmtiVThreadStart;
    public final long jvmtiVThreadEnd;
    public final long jvmtiVThreadMount;
    public final long jvmtiVThreadUnmount;
    public final int jvmciCountersSize;
    public final boolean deoptimizationSupportLargeAccessByteArrayVirtualization;
    public final int VMINTRINSIC_FIRST_MH_SIG_POLY;
    public final int VMINTRINSIC_LAST_MH_SIG_POLY;
    public final int VMINTRINSIC_INVOKE_GENERIC;
    public final int VMINTRINSIC_COMPILED_LAMBDA_FORM;
    public final boolean CPU_HAS_INTEL_JCC_ERRATUM;

    GraalHotSpotVMConfig(HotSpotVMConfigStore store) {
        super(store);
        Integer patchingType;
        Boolean patchConcurrent = null;
        if (this.osArch.equals("aarch64") && this.nmethodEntryBarrier != 0L && (patchingType = this.getFieldValue("CompilerToVM::Data::BarrierSetAssembler_nmethod_patching_type", Integer.class, "int")) != null) {
            int stw = this.getConstant("NMethodPatchingType::stw_instruction_and_data_patch", Integer.class);
            int conc = this.getConstant("NMethodPatchingType::conc_data_patch", Integer.class);
            if (patchingType == stw) {
                patchConcurrent = false;
            } else if (patchingType == conc) {
                patchConcurrent = true;
            } else {
                throw new IllegalArgumentException("unsupported barrier sequence " + patchingType);
            }
        }
        this.nmethodEntryBarrierConcurrentPatch = patchConcurrent;
        this.threadHeldMonitorCountOffset = this.getFieldOffset("JavaThread::_held_monitor_count", Integer.class, JDK >= 22 ? "intx" : "int64_t");
        this.threadLockStackOffset = this.getFieldOffset("JavaThread::_lock_stack", Integer.class, "LockStack", -1, JDK >= 22);
        this.lockStackTopOffset = this.getFieldOffset("LockStack::_top", Integer.class, "uint32_t", -1, JDK >= 22);
        this.lockStackEndOffset = this.getConstant("LockStack::_end_offset", Integer.class, -1, JDK >= 22);
        this.throwAndPostJvmtiExceptionAddress = this.getAddress("JVMCIRuntime::throw_and_post_jvmti_exception");
        this.throwKlassExternalNameExceptionAddress = this.getAddress("JVMCIRuntime::throw_klass_external_name_exception");
        this.throwClassCastExceptionAddress = this.getAddress("JVMCIRuntime::throw_class_cast_exception");
        this.logPrimitiveAddress = this.getAddress("JVMCIRuntime::log_primitive");
        this.logObjectAddress = this.getAddress("JVMCIRuntime::log_object");
        this.logPrintfAddress = this.getAddress("JVMCIRuntime::log_printf");
        this.vmErrorAddress = this.getAddress("JVMCIRuntime::vm_error");
        this.loadAndClearExceptionAddress = this.getAddress("JVMCIRuntime::load_and_clear_exception");
        this.writeBarrierPreAddress = this.getAddress("JVMCIRuntime::write_barrier_pre");
        this.writeBarrierPostAddress = this.getAddress("JVMCIRuntime::write_barrier_post");
        this.validateObject = this.getAddress("JVMCIRuntime::validate_object");
        this.testDeoptimizeCallInt = this.getAddress("JVMCIRuntime::test_deoptimize_call_int");
        this.registerFinalizerAddress = this.getAddress("SharedRuntime::register_finalizer");
        this.exceptionHandlerForReturnAddressAddress = this.getAddress("SharedRuntime::exception_handler_for_return_address");
        this.osrMigrationEndAddress = this.getAddress("SharedRuntime::OSR_migration_end");
        this.enableStackReservedZoneAddress = this.getAddress("SharedRuntime::enable_stack_reserved_zone");
        this.javaTimeMillisAddress = this.getAddress("os::javaTimeMillis");
        this.javaTimeNanosAddress = this.getAddress("os::javaTimeNanos");
        this.arithmeticSinAddress = this.getFieldValue("CompilerToVM::Data::dsin", Long.class, "address");
        this.arithmeticCosAddress = this.getFieldValue("CompilerToVM::Data::dcos", Long.class, "address");
        this.arithmeticTanAddress = this.getFieldValue("CompilerToVM::Data::dtan", Long.class, "address");
        this.arithmeticExpAddress = this.getFieldValue("CompilerToVM::Data::dexp", Long.class, "address");
        this.arithmeticLogAddress = this.getFieldValue("CompilerToVM::Data::dlog", Long.class, "address");
        this.arithmeticLog10Address = this.getFieldValue("CompilerToVM::Data::dlog10", Long.class, "address");
        this.arithmeticPowAddress = this.getFieldValue("CompilerToVM::Data::dpow", Long.class, "address");
        this.fremAddress = this.getAddress("SharedRuntime::frem");
        this.dremAddress = this.getAddress("SharedRuntime::drem");
        this.jvmtiVThreadStart = this.getAddress("SharedRuntime::notify_jvmti_vthread_start");
        this.jvmtiVThreadEnd = this.getAddress("SharedRuntime::notify_jvmti_vthread_end");
        this.jvmtiVThreadMount = this.getAddress("SharedRuntime::notify_jvmti_vthread_mount");
        this.jvmtiVThreadUnmount = this.getAddress("SharedRuntime::notify_jvmti_vthread_unmount");
        this.jvmciCountersSize = this.getFlag("JVMCICounterSize", Integer.class);
        this.deoptimizationSupportLargeAccessByteArrayVirtualization = this.getConstant("Deoptimization::_support_large_access_byte_array_virtualization", Boolean.class);
        this.VMINTRINSIC_FIRST_MH_SIG_POLY = this.getConstant("vmIntrinsics::FIRST_MH_SIG_POLY", Integer.class);
        this.VMINTRINSIC_LAST_MH_SIG_POLY = this.getConstant("vmIntrinsics::LAST_MH_SIG_POLY", Integer.class);
        this.VMINTRINSIC_INVOKE_GENERIC = this.getConstant("vmIntrinsics::_invokeGeneric", Integer.class);
        this.VMINTRINSIC_COMPILED_LAMBDA_FORM = this.getConstant("vmIntrinsics::_compiledLambdaForm", Integer.class);
        this.CPU_HAS_INTEL_JCC_ERRATUM = this.getFieldValue("VM_Version::_has_intel_jcc_erratum", Boolean.class, "bool", true, "amd64".equals(this.osArch));
        assert (this.narrowKlassShift <= this.logKlassAlignment) : Assertions.errorMessageContext("narrowKlassShift", this.narrowKlassShift, "logKlassAlignment", this.logKlassAlignment);
        int logMinObjAlignment = this.logMinObjAlignment();
        assert (this.narrowOopShift <= logMinObjAlignment) : Assertions.errorMessageContext("narrowOopShift", this.narrowOopShift, "logMinObjAlignment", logMinObjAlignment);
        this.oopEncoding = new CompressEncoding(this.narrowOopBase, this.narrowOopShift);
        this.klassEncoding = new CompressEncoding(this.narrowKlassBase, this.narrowKlassShift);
        assert (this.check());
        this.reportErrors();
        this.populateMarkConstants();
    }

    public CompressEncoding getOopEncoding() {
        return this.oopEncoding;
    }

    public CompressEncoding getKlassEncoding() {
        return this.klassEncoding;
    }

    public boolean useG1GC() {
        return this.gc == HotSpotGraalRuntime.HotSpotGC.G1;
    }

    private HotSpotGraalRuntime.HotSpotGC getSelectedGC() throws GraalError {
        HotSpotGraalRuntime.HotSpotGC selected = null;
        for (HotSpotGraalRuntime.HotSpotGC value : HotSpotGraalRuntime.HotSpotGC.values()) {
            if (!value.isSelected(this)) continue;
            if (!value.supported) {
                throw new GraalError(value.name() + " garbage collector is not supported by Graal");
            }
            if (selected != null) {
                throw new GraalError("Multiple garbage collectors selected: " + String.valueOf((Object)selected) + " " + String.valueOf((Object)value));
            }
            selected = value;
        }
        if (selected == null) {
            selected = HotSpotGraalRuntime.HotSpotGC.Serial;
        }
        return selected;
    }

    public boolean inlineNotify() {
        return this.notifyAddress != 0L;
    }

    public boolean inlineNotifyAll() {
        return this.notifyAllAddress != 0L;
    }

    public long gcTotalCollectionsAddress() {
        return this.universeCollectedHeap + (long)this.collectedHeapTotalCollectionsOffset;
    }

    public final int logMinObjAlignment() {
        return (int)(Math.log(this.objectAlignment) / Math.log(2.0));
    }

    public final int arrayOopDescLengthOffset() {
        return this.useCompressedClassPointers ? this.hubOffset + this.narrowKlassSize : this.arrayOopDescSize;
    }

    public boolean requiresReservedStackCheck(List<ResolvedJavaMethod> methods) {
        if (this.enableStackReservedZoneAddress != 0L && methods != null) {
            for (ResolvedJavaMethod method : methods) {
                if (!(method instanceof HotSpotResolvedJavaMethod) || !((HotSpotResolvedJavaMethod)method).hasReservedStackAccess()) continue;
                return true;
            }
        }
        return false;
    }

    public int threadLastJavaSpOffset() {
        return this.javaThreadAnchorOffset + this.javaFrameAnchorLastJavaSpOffset;
    }

    public int threadLastJavaPcOffset() {
        return this.javaThreadAnchorOffset + this.javaFrameAnchorLastJavaPcOffset;
    }

    public int threadLastJavaFpOffset() {
        assert (this.osArch.equals("aarch64") || this.osArch.equals("amd64"));
        return this.javaThreadAnchorOffset + this.getFieldOffset("JavaFrameAnchor::_last_Java_fp", Integer.class, "intptr_t*");
    }

    public long defaultPrototypeMarkWord() {
        return this.markWordNoHashInPlace | this.markWordNoLockInPlace;
    }

    public int threadTlabEndOffset() {
        return this.threadTlabOffset + this.threadLocalAllocBufferEndOffset;
    }

    public int threadTlabTopOffset() {
        return this.threadTlabOffset + this.threadLocalAllocBufferTopOffset;
    }

    public boolean areNullAllocationStubsAvailable() {
        return this.newInstanceOrNullAddress != 0L;
    }

    private boolean checkNullAllocationStubs() {
        if (this.newInstanceOrNullAddress == 0L) {
            assert (this.newArrayOrNullAddress == 0L) : this.newArrayOrNullAddress;
            assert (this.newMultiArrayOrNullAddress == 0L) : this.newMultiArrayOrNullAddress;
            assert (this.dynamicNewInstanceOrNullAddress == 0L) : this.dynamicNewInstanceAddress;
        } else {
            assert (this.newArrayOrNullAddress != 0L);
            assert (this.newMultiArrayOrNullAddress != 0L);
            assert (this.dynamicNewInstanceOrNullAddress != 0L);
        }
        return true;
    }

    private long getZGCAddressField(String name) {
        long address = this.getFieldValue(name, Long.class, "address");
        GraalError.guarantee(this.gc != HotSpotGraalRuntime.HotSpotGC.Z || address != 0L, "Unexpected null value for %s", (Object)name);
        return address;
    }

    public boolean supportJVMTIVThreadNotification() {
        return this.jvmtiVThreadStart != 0L && this.jvmtiVThreadEnd != 0L && this.jvmtiVThreadMount != 0L && this.jvmtiVThreadUnmount != 0L;
    }

    private void populateMarkConstants() {
        Map constants = this.getStore().getConstants();
        for (HotSpotMarkId markId : HotSpotMarkId.values()) {
            String key = "CodeInstaller::" + markId.name();
            Long result = (Long)constants.get(key);
            if (result == null) {
                if (markId == HotSpotMarkId.ENTRY_BARRIER_PATCH) continue;
                GraalHotSpotVMConfigAccess.reportError("Unsupported Mark " + String.valueOf(markId));
            }
            markId.setValue(result.intValue());
        }
    }

    protected boolean check() {
        for (Field f : this.getClass().getDeclaredFields()) {
            int modifiers = f.getModifiers();
            if (Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers)) assert (Modifier.isFinal(modifiers)) : "field should be final: " + String.valueOf(f);
        }
        assert (this.codeEntryAlignment > 0) : this.codeEntryAlignment;
        assert (this.checkNullAllocationStubs());
        return true;
    }

    public boolean isMethodHandleCall(HotSpotResolvedJavaMethod targetMethod) {
        int intrinsicId = targetMethod.intrinsicId();
        return intrinsicId >= this.VMINTRINSIC_FIRST_MH_SIG_POLY && intrinsicId <= this.VMINTRINSIC_LAST_MH_SIG_POLY && intrinsicId != this.VMINTRINSIC_INVOKE_GENERIC || intrinsicId == this.VMINTRINSIC_COMPILED_LAMBDA_FORM;
    }

    public boolean supportsMethodHandleDeoptimizationEntry() {
        return HotSpotMarkId.DEOPT_MH_HANDLER_ENTRY.isAvailable() && this.VMINTRINSIC_FIRST_MH_SIG_POLY != -1 && this.VMINTRINSIC_LAST_MH_SIG_POLY != -1 && this.VMINTRINSIC_INVOKE_GENERIC != -1 && this.VMINTRINSIC_COMPILED_LAMBDA_FORM != -1;
    }
}

