/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot;

import jdk.graal.compiler.hotspot.HotSpotGraalServices;
import jdk.graal.compiler.java.BytecodeParser;
import jdk.graal.compiler.java.GraphBuilderPhase;
import jdk.graal.compiler.nodes.DeoptimizeNode;
import jdk.graal.compiler.nodes.FixedGuardNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.IntrinsicContext;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class HotSpotBytecodeParser
extends BytecodeParser {
    protected HotSpotBytecodeParser(GraphBuilderPhase.Instance graphBuilderInstance, StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext) {
        super(graphBuilderInstance, graph, parent, method, entryBCI, intrinsicContext);
    }

    @Override
    protected Object lookupConstant(int cpi, int opcode, boolean allowBootstrapMethodInvocation) {
        try {
            return super.lookupConstant(cpi, opcode, allowBootstrapMethodInvocation);
        }
        catch (BootstrapMethodError e) {
            DeoptimizeNode deopt = this.append(new DeoptimizeNode(DeoptimizationAction.None, DeoptimizationReason.RuntimeConstraint));
            deopt.updateNodeSourcePosition(() -> this.createBytecodePosition());
            return e;
        }
    }

    @Override
    public GuardingNode intrinsicRangeCheck(LogicNode condition, boolean negated) {
        return HotSpotBytecodeParser.doIntrinsicRangeCheck(this, condition, negated);
    }

    public static FixedGuardNode doIntrinsicRangeCheck(GraphBuilderContext context, LogicNode condition, boolean negated) {
        return context.add(new FixedGuardNode(condition, DeoptimizationReason.BoundsCheckException, DeoptimizationAction.None, !negated));
    }

    @Override
    protected boolean mustClearNonLiveLocalsAtOSREntry() {
        return !HotSpotGraalServices.hasGetOopMapAt();
    }
}

