/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot;

import java.util.ArrayList;
import jdk.graal.compiler.bytecode.Bytecodes;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.gen.DebugInfoBuilder;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.GraalGraphError;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.hotspot.HotSpotLIRGenerator;
import jdk.graal.compiler.hotspot.HotSpotLockStack;
import jdk.graal.compiler.hotspot.meta.DefaultHotSpotLoweringProvider;
import jdk.graal.compiler.lir.VirtualStackSlot;
import jdk.graal.compiler.nodes.DeoptimizeNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.FullInfopointNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.ForeignCall;
import jdk.graal.compiler.nodes.spi.NodeValueMap;
import jdk.graal.compiler.nodes.spi.NodeWithState;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.code.StackLockValue;
import jdk.vm.ci.code.VirtualObject;
import jdk.vm.ci.hotspot.HotSpotCodeCacheProvider;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaValue;
import jdk.vm.ci.meta.MetaUtil;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class HotSpotDebugInfoBuilder
extends DebugInfoBuilder {
    private final HotSpotLockStack lockStack;
    private int maxInterpreterFrameSize;
    private HotSpotCodeCacheProvider codeCacheProvider;

    public HotSpotDebugInfoBuilder(NodeValueMap nodeValueMap, HotSpotLockStack lockStack, HotSpotLIRGenerator gen) {
        super(nodeValueMap, gen.getProviders().getMetaAccessExtensionProvider(), gen.getResult().getLIR().getDebug());
        this.lockStack = lockStack;
        this.codeCacheProvider = gen.getProviders().getCodeCache();
    }

    public HotSpotLockStack lockStack() {
        return this.lockStack;
    }

    public int maxInterpreterFrameSize() {
        return this.maxInterpreterFrameSize;
    }

    @Override
    protected JavaValue computeLockValue(FrameState state, int lockIndex) {
        boolean eliminated;
        int lockDepth = lockIndex;
        if (state.outerFrameState() != null) {
            lockDepth += state.outerFrameState().nestedLockDepth();
        }
        VirtualStackSlot slot = this.lockStack.makeLockSlot(lockDepth);
        ValueNode lock = state.lockAt(lockIndex);
        JavaValue object = this.toJavaValue(lock);
        boolean bl = eliminated = object instanceof VirtualObject || state.monitorIdAt(lockIndex).isEliminated();
        assert (state.monitorIdAt(lockIndex).getLockDepth() == lockDepth) : Assertions.errorMessage(state, lockIndex, state.monitorIdAt(lockIndex), lockDepth);
        return new StackLockValue(object, (AllocatableValue)slot, eliminated);
    }

    @Override
    protected void verifyFrameState(NodeWithState node, FrameState topState) {
        ForeignCall call;
        ForeignCallDescriptor descriptor;
        if (node instanceof FullInfopointNode) {
            return;
        }
        for (FrameState current = topState; current != null; current = current.outerFrameState()) {
            assert (current.getMethod() instanceof HotSpotResolvedJavaMethod) : current;
        }
        if (node instanceof ForeignCall && DefaultHotSpotLoweringProvider.RuntimeCalls.runtimeCalls.containsValue((descriptor = (call = (ForeignCall)node).getDescriptor()).getSignature())) {
            GraalError.guarantee(topState.getStackState() == FrameState.StackState.BeforePop && topState.bci >= 0 && topState.stackSize() == 0, "invalid state %s for bytecode exception %s", (Object)topState, (Object)descriptor.getSignature());
            GraalError.guarantee(!topState.getStackState().duringCall, "must be not duringCall to set reexecute bit");
            return;
        }
        if (topState.bci >= 0) {
            ResolvedJavaMethod m = topState.getMethod();
            int opcode = m.getCode()[topState.bci] & 0xFF;
            int stackEffect = Bytecodes.stackEffectOf(opcode);
            switch (topState.getStackState()) {
                case BeforePop: {
                    if (opcode == 182 || opcode == 185) {
                        GraalError.guarantee(topState.stackSize() > 0, "expected non-empty stack: %s", (Object)topState);
                        break;
                    }
                    if (stackEffect >= 0) break;
                    GraalError.guarantee(topState.stackSize() >= -stackEffect, "opcode %d (%s) stack effect %d: expected at least %d stack depth : %s", (Object)opcode, (Object)Bytecodes.nameOf(opcode), (Object)stackEffect, (Object)(-stackEffect), (Object)topState);
                    break;
                }
                case AfterPop: {
                    GraalError.guarantee(!this.shouldReexecute(opcode), "hotspot says this must deopt with reexecute: %s %s", (Object)Bytecodes.nameOf(opcode), (Object)topState);
                    break;
                }
                case Rethrow: {
                    GraalError.guarantee(topState.stackSize() == 1, "rethrow frame states should have a single value on the top of stack: %s", (Object)topState);
                }
            }
            if (node instanceof DeoptimizeNode) {
                GraalError.guarantee(topState.getStackState() != FrameState.StackState.AfterPop || stackEffect >= 0, "must be executable state %S", (Object)topState);
            }
        }
    }

    boolean shouldReexecute(int code) {
        switch (code) {
            case 83: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 170: 
            case 171: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 191: 
            case 198: 
            case 199: 
            case 200: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected BytecodeFrame computeFrameForState(NodeWithState node, FrameState state) {
        if (BytecodeFrame.isPlaceholderBci((int)state.bci) && state.bci != -2) {
            this.raiseInvalidFrameStateError(state);
        }
        BytecodeFrame result = super.computeFrameForState(node, state);
        this.maxInterpreterFrameSize = Math.max(this.maxInterpreterFrameSize, this.codeCacheProvider.interpreterFrameSize(result));
        return result;
    }

    protected void raiseInvalidFrameStateError(FrameState state) throws GraalGraphError {
        NodeSourcePosition sourcePosition = state.getNodeSourcePosition();
        ArrayList<String> context = new ArrayList<String>();
        ResolvedJavaMethod replacementMethodWithProblematicSideEffect = null;
        if (sourcePosition != null) {
            for (NodeSourcePosition pos = sourcePosition; pos != null; pos = pos.getCaller()) {
                StringBuilder sb = new StringBuilder("parsing ");
                ResolvedJavaMethod method = pos.getMethod();
                MetaUtil.appendLocation((StringBuilder)sb, (ResolvedJavaMethod)method, (int)pos.getBCI());
                if (pos.isSubstitution()) {
                    replacementMethodWithProblematicSideEffect = method;
                }
                context.add(sb.toString());
            }
        }
        String message = "Invalid frame state " + String.valueOf(state);
        if (replacementMethodWithProblematicSideEffect != null) {
            message = message + " associated with a side effect in " + replacementMethodWithProblematicSideEffect.format("%H.%n(%p)") + " at a position that cannot be deoptimized to";
        }
        GraalGraphError error = new GraalGraphError(message, new Object[0]);
        for (String c : context) {
            error.addContext(c);
        }
        throw error;
    }
}

