/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot;

import java.io.PrintStream;
import jdk.graal.compiler.debug.MethodFilter;
import jdk.graal.compiler.hotspot.CompilerConfigurationFactory;
import jdk.graal.compiler.hotspot.HotSpotGraalCompiler;
import jdk.graal.compiler.hotspot.HotSpotGraalJVMCIServiceLocator;
import jdk.graal.compiler.hotspot.HotSpotGraalOptionValues;
import jdk.graal.compiler.hotspot.HotSpotGraalRuntime;
import jdk.graal.compiler.hotspot.HotSpotGraalServices;
import jdk.graal.compiler.hotspot.IsGraalPredicate;
import jdk.graal.compiler.hotspot.JVMCIVersionCheck;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.options.OptionsParser;
import jdk.vm.ci.common.InitTimer;
import jdk.vm.ci.hotspot.HotSpotJVMCICompilerFactory;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.runtime.JVMCIRuntime;
import jdk.vm.ci.services.Services;

public final class HotSpotGraalCompilerFactory
extends HotSpotJVMCICompilerFactory {
    private static MethodFilter graalCompileOnlyFilter;
    private static boolean compileGraalWithC1Only;
    private IsGraalPredicate isGraalPredicate;
    private final HotSpotGraalJVMCIServiceLocator locator;
    private OptionValues options;
    private IllegalArgumentException optionsFailure;
    private volatile boolean initialized;
    static final /* synthetic */ boolean $assertionsDisabled;

    HotSpotGraalCompilerFactory(HotSpotGraalJVMCIServiceLocator locator) {
        this.locator = locator;
    }

    public String getCompilerName() {
        return "graal";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInitialized() {
        if (!this.initialized) {
            HotSpotGraalCompilerFactory hotSpotGraalCompilerFactory = this;
            synchronized (hotSpotGraalCompilerFactory) {
                if (!this.initialized) {
                    this.initialize();
                    this.initialized = true;
                }
            }
        }
    }

    public void onSelection() {
        if (Services.IS_IN_NATIVE_IMAGE) {
            this.initialize();
            this.initialized = true;
        }
    }

    private void initialize() {
        JVMCIVersionCheck.check(Services.getSavedProperties(), false, null);
        if (!$assertionsDisabled && this.options != null) {
            throw new AssertionError((Object)("cannot select " + String.valueOf(((Object)((Object)this)).getClass()) + " service more than once"));
        }
        try {
            this.options = HotSpotGraalOptionValues.defaultOptions();
        }
        catch (IllegalArgumentException e) {
            this.optionsFailure = e;
            return;
        }
        HotSpotGraalCompilerFactory.initializeGraalCompilePolicyFields(this.options);
        IsGraalPredicate isGraalPredicate = this.isGraalPredicate = compileGraalWithC1Only ? new IsGraalPredicate() : null;
        if (this.isGraalPredicate != null && this.isGraalPredicate.getCompilationLevelAdjustment() != HotSpotJVMCICompilerFactory.CompilationLevelAdjustment.None) {
            this.adjustCompilationLevelInternal(Object.class, HotSpotJVMCICompilerFactory.CompilationLevel.FullOptimization);
            this.adjustCompilationLevelInternal(Object.class, HotSpotJVMCICompilerFactory.CompilationLevel.Simple);
        }
        if (Services.IS_BUILDING_NATIVE_IMAGE) {
            Options.CompileGraalWithC1Only.getName();
        }
    }

    private static void initializeGraalCompilePolicyFields(OptionValues options) {
        compileGraalWithC1Only = Options.CompileGraalWithC1Only.getValue(options) != false && !Services.IS_IN_NATIVE_IMAGE;
        String optionValue = Options.GraalCompileOnly.getValue(options);
        if (optionValue != null) {
            MethodFilter filter = MethodFilter.parse(optionValue);
            if (filter.matchesNothing()) {
                filter = null;
            }
            graalCompileOnlyFilter = filter;
        }
    }

    public void printProperties(PrintStream out) {
        this.ensureInitialized();
        out.println("[Graal properties]");
        if (this.optionsFailure != null) {
            System.err.printf("Error parsing Graal options: %s%n", this.optionsFailure.getMessage());
            return;
        }
        this.options.printHelp(OptionsParser.getOptionsLoader(), out, "jdk.graal.");
    }

    public HotSpotGraalCompiler createCompiler(JVMCIRuntime runtime) {
        this.ensureInitialized();
        HotSpotJVMCIRuntime hsRuntime = (HotSpotJVMCIRuntime)runtime;
        if (this.optionsFailure != null) {
            System.err.printf("Error parsing Graal options: %s%nError: A fatal exception has occurred. Program will exit.%n", this.optionsFailure.getMessage());
            HotSpotGraalServices.exit(1, hsRuntime);
        }
        CompilerConfigurationFactory factory = CompilerConfigurationFactory.selectFactory(null, this.options, hsRuntime);
        if (this.isGraalPredicate != null) {
            this.isGraalPredicate.onCompilerConfigurationFactorySelection(hsRuntime, factory);
        }
        HotSpotGraalCompiler compiler = HotSpotGraalCompilerFactory.createCompiler("VM", runtime, this.options, factory);
        this.locator.onCompilerCreation(compiler);
        return compiler;
    }

    public static HotSpotGraalCompiler createCompiler(String runtimeNameQualifier, JVMCIRuntime runtime, OptionValues options, CompilerConfigurationFactory compilerConfigurationFactory) {
        HotSpotJVMCIRuntime jvmciRuntime = (HotSpotJVMCIRuntime)runtime;
        try (InitTimer t = InitTimer.timer((String)"HotSpotGraalRuntime.<init>");){
            HotSpotGraalRuntime graalRuntime = new HotSpotGraalRuntime(runtimeNameQualifier, jvmciRuntime, compilerConfigurationFactory, options);
            HotSpotGraalCompiler hotSpotGraalCompiler = new HotSpotGraalCompiler(jvmciRuntime, graalRuntime, graalRuntime.getOptions());
            return hotSpotGraalCompiler;
        }
    }

    public HotSpotJVMCICompilerFactory.CompilationLevelAdjustment getCompilationLevelAdjustment() {
        return this.isGraalPredicate != null ? this.isGraalPredicate.getCompilationLevelAdjustment() : HotSpotJVMCICompilerFactory.CompilationLevelAdjustment.None;
    }

    public HotSpotJVMCICompilerFactory.CompilationLevel adjustCompilationLevel(Object declaringClassObject, String name, String signature, boolean isOsr, HotSpotJVMCICompilerFactory.CompilationLevel level) {
        Class declaringClass = (Class)declaringClassObject;
        return this.adjustCompilationLevelInternal(declaringClass, level);
    }

    private HotSpotJVMCICompilerFactory.CompilationLevel adjustCompilationLevelInternal(Class<?> declaringClass, HotSpotJVMCICompilerFactory.CompilationLevel level) {
        if (!$assertionsDisabled && this.isGraalPredicate == null) {
            throw new AssertionError();
        }
        if (level.ordinal() > HotSpotJVMCICompilerFactory.CompilationLevel.Simple.ordinal() && this.isGraalPredicate.apply(declaringClass)) {
            return HotSpotJVMCICompilerFactory.CompilationLevel.Simple;
        }
        return level;
    }

    static boolean shouldExclude(HotSpotResolvedJavaMethod method) {
        if (graalCompileOnlyFilter != null) {
            Signature signature;
            String name;
            String javaClassName = method.getDeclaringClass().toJavaName();
            return !graalCompileOnlyFilter.matches(javaClassName, name = method.getName(), signature = method.getSignature());
        }
        return false;
    }

    static {
        boolean bl = $assertionsDisabled = !HotSpotGraalCompilerFactory.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !Services.class.getName().equals("jdk.vm.ci.services.Services")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !HotSpotGraalCompilerFactory.class.getName().equals("jdk.graal.compiler.hotspot.HotSpotGraalCompilerFactory")) {
            throw new AssertionError();
        }
    }

    static class Options {
        public static final OptionKey<Boolean> CompileGraalWithC1Only = new OptionKey<Boolean>(true);
        public static final OptionKey<String> GraalCompileOnly = new OptionKey<Object>(null);

        Options() {
        }
    }
}

