/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot;

import jdk.graal.compiler.hotspot.HotSpotGraalCompiler;
import jdk.graal.compiler.hotspot.HotSpotGraalCompilerFactory;
import jdk.graal.compiler.hotspot.HotSpotGraalRuntime;
import jdk.graal.compiler.hotspot.HotSpotGraalVMEventListener;
import jdk.graal.compiler.serviceprovider.ServiceProvider;
import jdk.vm.ci.common.NativeImageReinitialize;
import jdk.vm.ci.hotspot.HotSpotVMEventListener;
import jdk.vm.ci.runtime.JVMCICompilerFactory;
import jdk.vm.ci.services.JVMCIServiceLocator;

@ServiceProvider(value=JVMCIServiceLocator.class)
public final class HotSpotGraalJVMCIServiceLocator
extends JVMCIServiceLocator {
    public <T> T getProvider(Class<T> service) {
        return Shared.SINGLETON.getProvider(service, this);
    }

    void onCompilerCreation(HotSpotGraalCompiler compiler) {
        Shared.SINGLETON.onCompilerCreation(compiler);
    }

    private static final class Shared {
        static final Shared SINGLETON = new Shared();
        @NativeImageReinitialize
        private HotSpotGraalRuntime graalRuntime;
        @NativeImageReinitialize
        private HotSpotGraalVMEventListener vmEventListener;

        private Shared() {
        }

        <T> T getProvider(Class<T> service, HotSpotGraalJVMCIServiceLocator locator) {
            if (service == JVMCICompilerFactory.class) {
                return service.cast((Object)new HotSpotGraalCompilerFactory(locator));
            }
            if (service == HotSpotVMEventListener.class) {
                if (this.graalRuntime != null) {
                    return service.cast(new HotSpotGraalVMEventListener(this.graalRuntime));
                }
                if (this.vmEventListener == null) {
                    this.vmEventListener = new HotSpotGraalVMEventListener(null);
                }
                return service.cast(this.vmEventListener);
            }
            return null;
        }

        void onCompilerCreation(HotSpotGraalCompiler compiler) {
            assert (this.graalRuntime == null) : "only expect a single JVMCICompiler to be created";
            this.graalRuntime = (HotSpotGraalRuntime)compiler.getGraalRuntime();
            if (this.vmEventListener != null) {
                this.vmEventListener.setRuntime(this.graalRuntime);
            }
        }
    }
}

