/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot;

import java.util.Collections;
import java.util.List;
import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.alloc.RegisterAllocationConfig;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.gen.LIRGenerationProvider;
import jdk.graal.compiler.debug.DebugHandlersFactory;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.HotSpotBackend;
import jdk.graal.compiler.hotspot.HotSpotGraalRuntimeProvider;
import jdk.graal.compiler.hotspot.HotSpotLIRGenerationResult;
import jdk.graal.compiler.hotspot.HotSpotReferenceMapBuilder;
import jdk.graal.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import jdk.graal.compiler.hotspot.meta.HotSpotForeignCallsProviderImpl;
import jdk.graal.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import jdk.graal.compiler.hotspot.meta.HotSpotLoweringProvider;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.hotspot.stubs.Stub;
import jdk.graal.compiler.lir.LIR;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.framemap.FrameMapBuilder;
import jdk.graal.compiler.lir.framemap.ReferenceMapBuilder;
import jdk.graal.compiler.lir.gen.LIRGenerationResult;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.printer.GraalDebugHandlersFactory;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.common.InitTimer;
import jdk.vm.ci.hotspot.HotSpotCallingConventionType;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public abstract class HotSpotHostBackend
extends HotSpotBackend
implements LIRGenerationProvider {
    public static final HotSpotForeignCallDescriptor DEOPT_BLOB_UNPACK = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "deopt_blob()->unpack()", Void.TYPE, new Class[0]);
    public static final HotSpotForeignCallDescriptor DEOPT_BLOB_UNPACK_WITH_EXCEPTION_IN_TLS = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "deopt_blob()->unpack_with_exception_in_tls()", Void.TYPE, new Class[0]);
    public static final HotSpotForeignCallDescriptor DEOPT_BLOB_UNCOMMON_TRAP = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "deopt_blob()->uncommon_trap()", Void.TYPE, new Class[0]);
    public static final HotSpotForeignCallDescriptor ENABLE_STACK_RESERVED_ZONE = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "enableStackReservedZoneEntry", Void.TYPE, Word.class);
    public static final HotSpotForeignCallDescriptor THROW_DELAYED_STACKOVERFLOW_ERROR = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "throwDelayedStackoverflowError", Void.TYPE, new Class[0]);
    public static final HotSpotForeignCallDescriptor POLLING_PAGE_RETURN_HANDLER = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "polling_page_return_handler_blob()", Void.TYPE, new Class[0]);
    protected final GraalHotSpotVMConfig config;

    public HotSpotHostBackend(GraalHotSpotVMConfig config, HotSpotGraalRuntimeProvider runtime, HotSpotProviders providers) {
        super(runtime, providers);
        this.config = config;
    }

    @Override
    public void completeInitialization(HotSpotJVMCIRuntime jvmciRuntime, OptionValues options) {
        HotSpotProviders providers = this.getProviders();
        HotSpotHostForeignCallsProvider foreignCalls = providers.getForeignCalls();
        HotSpotLoweringProvider lowerer = (HotSpotLoweringProvider)providers.getLowerer();
        try (InitTimer st = InitTimer.timer((String)"foreignCalls.initialize");){
            foreignCalls.initialize(providers, options);
        }
        st = InitTimer.timer((String)"lowerer.initialize");
        try {
            List<DebugHandlersFactory> factories = Collections.singletonList(new GraalDebugHandlersFactory(providers.getSnippetReflection()));
            lowerer.initialize(options, factories, providers, this.config);
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
        providers.getReplacements().closeSnippetRegistration();
        providers.getReplacements().getGraphBuilderPlugins().getInvocationPlugins().maybePrintIntrinsics(options);
    }

    protected CallingConvention makeCallingConvention(StructuredGraph graph, Stub stub) {
        if (stub != null) {
            return stub.getLinkage().getIncomingCallingConvention();
        }
        CallingConvention cc = CodeUtil.getCallingConvention((CodeCacheProvider)this.getCodeCache(), (CallingConvention.Type)HotSpotCallingConventionType.JavaCallee, (ResolvedJavaMethod)graph.method(), (ValueKindFactory)this);
        if (graph.getEntryBCI() != -1) {
            JavaType[] parameterTypes = new JavaType[]{this.getMetaAccess().lookupJavaType(Long.TYPE)};
            CallingConvention tmp = this.getCodeCache().getRegisterConfig().getCallingConvention((CallingConvention.Type)HotSpotCallingConventionType.JavaCallee, (JavaType)this.getMetaAccess().lookupJavaType(Void.TYPE), parameterTypes, (ValueKindFactory)this);
            cc = new CallingConvention(cc.getStackSize(), cc.getReturn(), new AllocatableValue[]{tmp.getArgument(0)});
        }
        return cc;
    }

    public void emitStackOverflowCheck(CompilationResultBuilder crb) {
        int bangOffset;
        int bangEnd;
        int pageSize = this.config.vmPageSize;
        int bangEndSafe = bangEnd = NumUtil.roundUp(this.config.stackShadowPages * 4 * 1024, pageSize);
        int frameSize = Math.max(crb.frameMap.frameSize(), crb.compilationResult.getMaxInterpreterFrameSize());
        if (frameSize > pageSize) {
            bangEnd += frameSize;
        }
        if ((bangOffset = bangEndSafe) <= bangEnd) {
            crb.blockComment("[stack overflow check]");
        }
        while (bangOffset <= bangEnd) {
            this.bangStackWithOffset(crb, bangOffset);
            bangOffset += pageSize;
        }
    }

    protected abstract void bangStackWithOffset(CompilationResultBuilder var1, int var2);

    @Override
    public ReferenceMapBuilder newReferenceMapBuilder(int totalFrameSize) {
        int uncompressedReferenceSize = this.getTarget().arch.getPlatformKind(JavaKind.Object).getSizeInBytes();
        return new HotSpotReferenceMapBuilder(totalFrameSize, this.config.maxOopMapStackOffset, uncompressedReferenceSize);
    }

    @Override
    public LIRGenerationResult newLIRGenerationResult(CompilationIdentifier compilationId, LIR lir, RegisterAllocationConfig registerAllocationConfig, StructuredGraph graph, Object stub) {
        return new HotSpotLIRGenerationResult(compilationId, lir, this.newFrameMapBuilder(registerAllocationConfig.getRegisterConfig()), registerAllocationConfig, this.makeCallingConvention(graph, (Stub)stub), stub, this.config.requiresReservedStackCheck(graph.getMethods()));
    }

    protected abstract FrameMapBuilder newFrameMapBuilder(RegisterConfig var1);
}

