/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot;

import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import jdk.graal.compiler.hotspot.HotSpotReplacementsImpl;
import jdk.graal.compiler.hotspot.SnippetObjectConstant;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.SpeculationLog;
import jdk.vm.ci.services.Services;

public class HotSpotSnippetMetaAccessProvider
implements MetaAccessProvider {
    private final MetaAccessProvider delegate;

    public HotSpotSnippetMetaAccessProvider(MetaAccessProvider delegate) {
        this.delegate = delegate;
    }

    public ResolvedJavaType lookupJavaType(Class<?> clazz) {
        ResolvedJavaType type;
        if (Services.IS_IN_NATIVE_IMAGE && (type = HotSpotReplacementsImpl.getEncodedSnippets().lookupSnippetType(clazz)) != null) {
            return type;
        }
        return this.delegate.lookupJavaType(clazz);
    }

    public ResolvedJavaMethod lookupJavaMethod(Executable reflectionMethod) {
        return this.delegate.lookupJavaMethod(reflectionMethod);
    }

    public ResolvedJavaField lookupJavaField(Field reflectionField) {
        return this.delegate.lookupJavaField(reflectionField);
    }

    public ResolvedJavaType lookupJavaType(JavaConstant constant) {
        if (constant instanceof SnippetObjectConstant) {
            SnippetObjectConstant objectConstant = (SnippetObjectConstant)constant;
            Class<?> clazz = objectConstant.asObject(Object.class).getClass();
            return this.lookupJavaType(clazz);
        }
        return this.delegate.lookupJavaType(constant);
    }

    public long getMemorySize(JavaConstant constant) {
        return this.delegate.getMemorySize(constant);
    }

    public Signature parseMethodDescriptor(String methodDescriptor) {
        return this.delegate.parseMethodDescriptor(methodDescriptor);
    }

    public JavaConstant encodeDeoptActionAndReason(DeoptimizationAction action, DeoptimizationReason reason, int debugId) {
        return this.delegate.encodeDeoptActionAndReason(action, reason, debugId);
    }

    public JavaConstant encodeSpeculation(SpeculationLog.Speculation speculation) {
        return this.delegate.encodeSpeculation(speculation);
    }

    public SpeculationLog.Speculation decodeSpeculation(JavaConstant constant, SpeculationLog speculationLog) {
        return this.delegate.decodeSpeculation(constant, speculationLog);
    }

    public DeoptimizationReason decodeDeoptReason(JavaConstant constant) {
        return this.delegate.decodeDeoptReason(constant);
    }

    public DeoptimizationAction decodeDeoptAction(JavaConstant constant) {
        return this.delegate.decodeDeoptAction(constant);
    }

    public int decodeDebugId(JavaConstant constant) {
        return this.delegate.decodeDebugId(constant);
    }

    public int getArrayBaseOffset(JavaKind elementKind) {
        return this.delegate.getArrayBaseOffset(elementKind);
    }

    public int getArrayIndexScale(JavaKind elementKind) {
        return this.delegate.getArrayIndexScale(elementKind);
    }
}

