/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot;

import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JVMCIVersionCheck {
    public static final String DEFAULT_VENDOR_ENTRY = "*";
    private static final Map<String, Map<String, Version>> JVMCI_MIN_VERSIONS = Map.of("21", Map.of("*", new Version(23, 1, 26)), "22", Map.of("Oracle Corporation", new Version("22.0.2+9", 1), "*", new Version("22.0.2+9", 1)));
    private static final int NA = 0;
    private static final int JAVA_MIN_RELEASE = 21;
    public static final String OPEN_LABSJDK_RELEASE_URL_PATTERN = "https://github.com/graalvm/labs-openjdk-*/releases";
    private final String javaSpecVersion;
    private final String vmVersion;
    private final Map<String, String> props;

    private void failVersionCheck(boolean exit, String reason, Object ... args) {
        Formatter errorMessage = new Formatter().format(reason, args);
        String javaHome = this.props.get("java.home");
        String vmName = this.props.get("java.vm.name");
        errorMessage.format("Set the JVMCI_VERSION_CHECK environment variable to \"ignore\" to suppress ", new Object[0]);
        errorMessage.format("this error or to \"warn\" to emit a warning and continue execution.%n", new Object[0]);
        errorMessage.format("Currently used Java home directory is %s.%n", javaHome);
        errorMessage.format("Currently used VM configuration is: %s%n", vmName);
        if (this.vmVersion.contains("-jvmci-")) {
            errorMessage.format("Download the latest Labs OpenJDK from https://github.com/graalvm/labs-openjdk-*/releases", new Object[0]);
        } else {
            errorMessage.format("Download JDK %s or later.", 21);
        }
        String value = System.getenv("JVMCI_VERSION_CHECK");
        if ("warn".equals(value)) {
            System.err.println(errorMessage.toString());
        } else {
            if ("ignore".equals(value)) {
                return;
            }
            if (exit) {
                System.err.println(errorMessage.toString());
                System.exit(-1);
            } else {
                throw new InternalError(errorMessage.toString());
            }
        }
    }

    private JVMCIVersionCheck(Map<String, String> props, String javaSpecVersion, String vmVersion) {
        this.props = props;
        this.javaSpecVersion = javaSpecVersion;
        this.vmVersion = vmVersion;
    }

    private static String getRequiredProperty(Map<String, String> props, String name) {
        return Objects.requireNonNull(props.get(name), "missing required property: " + name);
    }

    public static Version getMinVersion(Map<String, String> props, Map<String, Map<String, Version>> jvmciMinVersions) {
        String javaSpecVersion = JVMCIVersionCheck.getRequiredProperty(props, "java.specification.version");
        String javaVmVendor = JVMCIVersionCheck.getRequiredProperty(props, "java.vm.vendor");
        Map versionMap = jvmciMinVersions.getOrDefault(javaSpecVersion, Map.of());
        return versionMap.getOrDefault(javaVmVendor, (Version)versionMap.get(DEFAULT_VENDOR_ENTRY));
    }

    static void check(Map<String, String> props, boolean exitOnFailure, PrintFormat format) {
        JVMCIVersionCheck.check(props, exitOnFailure, format, JVMCI_MIN_VERSIONS);
    }

    public static void check(Map<String, String> props, boolean exitOnFailure, PrintFormat format, Map<String, Map<String, Version>> jvmciMinVersions) {
        String javaSpecVersion = JVMCIVersionCheck.getRequiredProperty(props, "java.specification.version");
        String javaVmVersion = JVMCIVersionCheck.getRequiredProperty(props, "java.vm.version");
        JVMCIVersionCheck checker = new JVMCIVersionCheck(props, javaSpecVersion, javaVmVersion);
        checker.run(exitOnFailure, JVMCIVersionCheck.getMinVersion(props, jvmciMinVersions), format);
    }

    private void run(boolean exitOnFailure, Version minVersion, PrintFormat format) {
        if (this.javaSpecVersion.compareTo(Integer.toString(21)) < 0) {
            this.failVersionCheck(exitOnFailure, "Graal requires JDK 21 or later.%n", new Object[0]);
        } else {
            if (this.vmVersion.contains("SNAPSHOT")) {
                return;
            }
            if (this.vmVersion.contains("internal")) {
                return;
            }
            if (this.vmVersion.contains("-jvmci-")) {
                Version v;
                if (minVersion == null) {
                    this.failVersionCheck(exitOnFailure, "No minimum JVMCI version specified for JDK version %s.%n", this.javaSpecVersion);
                }
                if ((v = Version.parse(this.vmVersion)) != null) {
                    if (format != null) {
                        System.out.println(v.printFormat(format));
                    }
                    if (v.isLessThan(minVersion)) {
                        this.failVersionCheck(exitOnFailure, "The VM does not support the minimum JVMCI API version required by Graal: %s < %s.%n", v, minVersion);
                    }
                    return;
                }
                this.failVersionCheck(exitOnFailure, "The VM does not support the minimum JVMCI API version required by Graal.%nCannot read JVMCI version from java.vm.version property: %s.%n", this.vmVersion);
            }
        }
    }

    public static void main(String[] args) {
        Properties sprops = System.getProperties();
        HashMap<String, String> props = new HashMap<String, String>(sprops.size());
        for (String name : sprops.stringPropertyNames()) {
            props.put(name, sprops.getProperty(name));
        }
        PrintFormat format = PrintFormat.TUPLE;
        boolean minVersion = false;
        for (String arg : args) {
            if (arg.equals("--as-tag")) {
                format = PrintFormat.AS_TAG;
                continue;
            }
            if (arg.equals("--min-version")) {
                minVersion = true;
                continue;
            }
            throw new IllegalArgumentException("Unknown argument: " + arg);
        }
        if (minVersion) {
            String javaSpecVersion = (String)props.get("java.specification.version");
            Version v = JVMCIVersionCheck.getMinVersion(props, JVMCI_MIN_VERSIONS);
            if (v == null) {
                System.out.printf("No minimum JVMCI version specified for JDK version %s.%n", javaSpecVersion);
            } else {
                System.out.println(v.printFormat(format));
            }
        } else {
            JVMCIVersionCheck.check(props, true, format);
        }
    }

    public static class Version {
        private final Runtime.Version jdkVersion;
        private final int jvmciMajor;
        private final int jvmciMinor;
        private final int jvmciBuild;
        private final boolean legacy;
        public static final String AS_TAG_FORMAT_22_AND_LATER = "%s-jvmci-b%02d";
        public static final String AS_TAG_FORMAT_21_AND_EARLIER = "jvmci-%d.%d-b%02d";

        static Version parse(String vmVersion) {
            Matcher m = Pattern.compile("(.+)-jvmci(-(\\d+)\\.(\\d+))?-b(\\d+).*").matcher(vmVersion);
            if (m.matches()) {
                try {
                    if (m.group(3) == null) {
                        assert (m.group(4) == null) : "if jvmciMajor is null jvmciMinor must also be null";
                        String jdkVersion = m.group(1);
                        int jvmciBuild = Integer.parseInt(m.group(5));
                        return new Version(jdkVersion, jvmciBuild);
                    }
                    int jvmciMajor = Integer.parseInt(m.group(3));
                    int jvmciMinor = Integer.parseInt(m.group(4));
                    int jvmciBuild = Integer.parseInt(m.group(5));
                    return new Version(jvmciMajor, jvmciMinor, jvmciBuild);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }

        public Version(String jdkVersionString, int jvmciBuild) {
            this(jdkVersionString, 0, 0, jvmciBuild, false);
        }

        public Version(int jvmciMajor, int jvmciMinor, int jvmciBuild) {
            this("21", jvmciMajor, jvmciMinor, jvmciBuild, true);
        }

        private Version(String jdkVersionString, int jvmciMajor, int jvmciMinor, int jvmciBuild, boolean legacy) {
            this(Runtime.Version.parse(jdkVersionString), jvmciMajor, jvmciMinor, jvmciBuild, legacy);
        }

        private Version(Runtime.Version jdkVersion, int jvmciMajor, int jvmciMinor, int jvmciBuild, boolean legacy) {
            this.jdkVersion = jdkVersion;
            this.jvmciMajor = jvmciMajor;
            this.jvmciMinor = jvmciMinor;
            this.jvmciBuild = jvmciBuild;
            this.legacy = legacy;
        }

        boolean isGreaterThan(Version other) {
            if (!this.isLessThan(other)) {
                return !this.equals(other);
            }
            return false;
        }

        public boolean isLessThan(Version other) {
            if (this.legacy && !other.legacy) {
                return true;
            }
            if (this.legacy == other.legacy) {
                int compareTo;
                int n = compareTo = this.legacy ? 0 : this.jdkVersion.compareTo(other.jdkVersion);
                if (compareTo < 0) {
                    return true;
                }
                if (compareTo == 0) {
                    if (this.jvmciMajor < other.jvmciMajor) {
                        return true;
                    }
                    if (this.jvmciMajor == other.jvmciMajor) {
                        if (this.jvmciMinor < other.jvmciMinor) {
                            return true;
                        }
                        if (this.jvmciMinor == other.jvmciMinor && this.jvmciBuild < other.jvmciBuild) {
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Version) {
                Version that = (Version)obj;
                return this.jdkVersion.equals(that.jdkVersion) && this.jvmciMajor == that.jvmciMajor && this.jvmciMinor == that.jvmciMinor && this.jvmciBuild == that.jvmciBuild;
            }
            return false;
        }

        public int hashCode() {
            return this.jdkVersion.hashCode() ^ this.jvmciMajor ^ this.jvmciMinor ^ this.jvmciBuild;
        }

        public String toString() {
            if (!this.legacy) {
                return String.format(AS_TAG_FORMAT_22_AND_LATER, this.jdkVersion, this.jvmciBuild);
            }
            return String.format(AS_TAG_FORMAT_21_AND_EARLIER, this.jvmciMajor, this.jvmciMinor, this.jvmciBuild);
        }

        public String printFormat(PrintFormat format) {
            return switch (format.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> String.format("%s,%d,%d,%d", this.jdkVersion, this.jvmciMajor, this.jvmciMinor, this.jvmciBuild);
                case 1 -> this.toString();
            };
        }
    }

    static enum PrintFormat {
        TUPLE,
        AS_TAG;

    }
}

