/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.aarch64;

import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.aarch64.AArch64Assembler;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.StandardOp;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.hotspot.HotSpotConstant;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.Value;

public class AArch64HotSpotMove {
    public static void decodeKlassPointer(AArch64MacroAssembler masm, Register result, Register ptr, CompressEncoding encoding) {
        try (AArch64MacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
            Register scratch = sc.getRegister();
            if (encoding.hasBase() || encoding.getShift() != 0) {
                masm.mov(scratch, encoding.getBase());
                masm.add(64, result, scratch, ptr, AArch64Assembler.ExtendType.UXTX, encoding.getShift());
            }
        }
    }

    public static class UncompressPointer
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<UncompressPointer> TYPE = LIRInstructionClass.create(UncompressPointer.class);
        private final CompressEncoding encoding;
        private final boolean nonNull;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue input;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        protected AllocatableValue baseRegister;

        public UncompressPointer(AllocatableValue result, AllocatableValue input, AllocatableValue baseRegister, CompressEncoding encoding, boolean nonNull) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.result = result;
            this.input = input;
            this.baseRegister = baseRegister;
            this.encoding = encoding;
            this.nonNull = nonNull;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            Register inputRegister = ValueUtil.asRegister((Value)this.input);
            Register resultRegister = ValueUtil.asRegister((Value)this.result);
            Register base = this.encoding.hasBase() ? ValueUtil.asRegister((Value)this.baseRegister) : null;
            UncompressPointer.emitUncompressCode(masm, inputRegister, resultRegister, base, this.encoding.getShift(), this.nonNull);
        }

        public static void emitUncompressCode(AArch64MacroAssembler masm, Register inputRegister, Register resReg, Register baseReg, int shift, boolean nonNull) {
            if (baseReg == null) {
                if (shift != 0) {
                    masm.lsl(64, resReg, inputRegister, shift);
                } else if (!resReg.equals((Object)inputRegister)) {
                    masm.mov(64, resReg, inputRegister);
                }
                return;
            }
            if (nonNull) {
                masm.add(64, resReg, baseReg, inputRegister, AArch64Assembler.ShiftType.LSL, shift);
            } else {
                Label done = new Label();
                if (!resReg.equals((Object)inputRegister)) {
                    masm.mov(32, resReg, inputRegister);
                }
                masm.cbz(32, resReg, done);
                masm.add(64, resReg, baseReg, resReg, AArch64Assembler.ShiftType.LSL, shift);
                masm.bind(done);
            }
        }
    }

    public static class CompressPointer
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<CompressPointer> TYPE = LIRInstructionClass.create(CompressPointer.class);
        private final CompressEncoding encoding;
        private final boolean nonNull;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue input;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        protected AllocatableValue baseRegister;

        public CompressPointer(AllocatableValue result, AllocatableValue input, AllocatableValue baseRegister, CompressEncoding encoding, boolean nonNull) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.result = result;
            this.input = input;
            this.baseRegister = baseRegister;
            this.encoding = encoding;
            this.nonNull = nonNull;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            Register base;
            Register resultRegister = ValueUtil.asRegister((Value)this.result);
            Register ptr = ValueUtil.asRegister((Value)this.input);
            Register register = base = ValueUtil.isRegister((Value)this.baseRegister) ? ValueUtil.asRegister((Value)this.baseRegister) : AArch64.zr;
            if (!this.encoding.hasBase()) {
                if (this.encoding.hasShift()) {
                    masm.lsr(64, resultRegister, ptr, this.encoding.getShift());
                } else {
                    masm.mov(64, resultRegister, ptr);
                }
            } else if (this.nonNull) {
                masm.sub(64, resultRegister, ptr, base);
                if (this.encoding.hasShift()) {
                    masm.lsr(64, resultRegister, resultRegister, this.encoding.getShift());
                }
            } else {
                masm.compare(64, ptr, 0);
                masm.csel(64, resultRegister, ptr, base, AArch64Assembler.ConditionFlag.NE);
                masm.sub(64, resultRegister, resultRegister, base);
                if (this.encoding.hasShift()) {
                    masm.lsr(64, resultRegister, resultRegister, this.encoding.getShift());
                }
            }
        }
    }

    public static class LoadHotSpotObjectConstantInline
    extends AArch64LIRInstruction
    implements StandardOp.LoadConstantOp {
        public static final LIRInstructionClass<LoadHotSpotObjectConstantInline> TYPE = LIRInstructionClass.create(LoadHotSpotObjectConstantInline.class);
        private HotSpotConstant constant;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        AllocatableValue result;

        public LoadHotSpotObjectConstantInline(HotSpotConstant constant, AllocatableValue result) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.constant = constant;
            this.result = result;
        }

        @Override
        protected void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            crb.recordInlineDataInCode((Constant)this.constant);
            if (this.constant.isCompressed()) {
                masm.movNarrowAddress(ValueUtil.asRegister((Value)this.result), 0L);
            } else {
                masm.movNativeAddress(ValueUtil.asRegister((Value)this.result), 0L);
            }
        }

        @Override
        public AllocatableValue getResult() {
            return this.result;
        }

        @Override
        public Constant getConstant() {
            return this.constant;
        }
    }
}

